/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.teamz.fileagent.internal.extensions.impl.DataSetInformation;
import com.ibm.teamz.fileagent.internal.extensions.impl.IDataSetInformation;
import com.ibm.teamz.fileagent.internal.extensions.impl.MVSStorageManager;
import com.ibm.teamz.fileagent.internal.extensions.impl.MemberInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DataSetInformationCache {
    private static DataSetInformationCache instance;
    private final Map<DataSetLocation, IDataSetInformation> dataSetInformationMap = Collections.synchronizedMap(new HashMap());
    private static boolean active;

    static {
        String id = System.getProperty("eclipse.application");
        active = !"com.ibm.team.rtc.cli.infrastructure.id1".equals(id);
    }

    private DataSetInformationCache() {
    }

    public static synchronized DataSetInformationCache getInstance() {
        if (instance == null) {
            instance = new DataSetInformationCache();
        }
        return instance;
    }

    public final IDataSetInformation get(DataSetLocation location) {
        return this.dataSetInformationMap.get(location);
    }

    public final Map<DataSetLocation, IDataSetInformation> getMap() {
        return this.dataSetInformationMap;
    }

    public final boolean isActive() {
        return active;
    }

    public final synchronized IDataSetInformation put(DataSetLocation location, IDataSetInformation datasetInformation) {
        return this.isActive() ? this.dataSetInformationMap.put(location, datasetInformation) : null;
    }

    public final synchronized IDataSetInformation put(IDataSetDefinition dsdef, DataSetLocation location, IShareableInternal shareable, IDebugger dbg) {
        DataSetInformation datasetInformation = !MVSStorageManager.SIMULATION_ENABLED ? new DataSetInformation(dbg) : new DataSetInformation(dbg, shareable);
        try {
            datasetInformation.setDatasetExists(true);
            datasetInformation.setDatasetDefinition(dsdef);
            datasetInformation.setDatasetLocation(location);
            datasetInformation.setDatasetPDSInfo();
            datasetInformation.setDatasetMemberMap();
            datasetInformation.setTeamRepository((ITeamRepository)dsdef.getOrigin());
            datasetInformation.setProjectAreaHandle(dsdef.getProjectArea());
            datasetInformation.setConfiguration();
            if (this.isActive()) {
                this.dataSetInformationMap.put(location, datasetInformation);
            }
        }
        catch (Exception e) {
            datasetInformation = null;
        }
        return datasetInformation;
    }

    public final synchronized IDataSetInformation put(IDataSetDefinition dsdef, DataSetLocation location, IShareableInternal shareable, MemberInfo memberInfo, IDebugger dbg) {
        DataSetInformation datasetInformation = !MVSStorageManager.SIMULATION_ENABLED ? new DataSetInformation(dbg) : new DataSetInformation(dbg, shareable);
        try {
            datasetInformation.setDatasetExists(true);
            datasetInformation.setDatasetDefinition(dsdef);
            datasetInformation.setDatasetLocation(location);
            datasetInformation.setDatasetPDSInfo();
            datasetInformation.updateMemberMap(memberInfo);
            datasetInformation.setTeamRepository((ITeamRepository)dsdef.getOrigin());
            datasetInformation.setProjectAreaHandle(dsdef.getProjectArea());
            datasetInformation.setConfiguration();
            if (this.isActive()) {
                this.dataSetInformationMap.put(location, datasetInformation);
            }
        }
        catch (Exception e) {
            datasetInformation = null;
        }
        return datasetInformation;
    }
}

