/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.jzos.PdsDirectory;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.internal.common.client.EnterpriseConfigurationCache;
import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.build.ant.zos.utils.JzosUtility;
import com.ibm.teamz.fileagent.PDSUtility;
import com.ibm.teamz.fileagent.importz.PDSInfo;
import com.ibm.teamz.fileagent.importz.PDSManagerException;
import com.ibm.teamz.fileagent.internal.extensions.impl.IDataSetInformation;
import com.ibm.teamz.fileagent.internal.extensions.impl.MVSStorageManager;
import com.ibm.teamz.fileagent.internal.extensions.impl.MemberInfo;
import com.ibm.teamz.fileagent.internal.extensions.impl.PDSMemberInfo;
import com.ibm.teamz.fileagent.internal.extensions.impl.SimulatedZFileInterface;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZFileInterface;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DataSetInformation
implements IDataSetInformation {
    private static final String cls = DataSetInformation.class.getSimpleName();
    private final IDebugger dbg;
    private boolean datasetExists = false;
    private boolean datasetIsNew = false;
    private boolean datasetMapped = false;
    private DataSetLocation datasetLocation;
    private IDataSetDefinition datasetDefinition;
    private IEnterpriseConfiguration configuration;
    private IProjectAreaHandle projectAreaHandle;
    private IShareableInternal shareable;
    private ITeamRepository repository;
    private PDSInfo datasetPDSInfo;
    private final Set<String> datasetMembers = Collections.synchronizedSet(new HashSet());
    private Map<String, MemberInfo> datasetMemberMap = Collections.synchronizedMap(new HashMap());

    private static boolean isSimulatedModeOn() {
        return MVSStorageManager.SIMULATION_ENABLED;
    }

    public DataSetInformation() {
        this((IDebugger)new Debugger(DataSetInformation.class));
    }

    public DataSetInformation(IDebugger dbg, IShareableInternal shareable) {
        this(dbg);
        this.shareable = shareable;
    }

    public DataSetInformation(IDebugger dbg) {
        this.dbg = dbg;
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{cls, LogField.valueOf((boolean)DataSetInformation.isSimulatedModeOn())});
        }
    }

    @Override
    public IEnterpriseConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration() {
        try {
            this.configuration = EnterpriseConfigurationCache.getInstance().fetch(this.repository, this.projectAreaHandle);
        }
        catch (TeamRepositoryException e) {
            this.configuration = EnterpriseConfigurationCache.getInstance().createDefault(this.projectAreaHandle);
        }
    }

    @Override
    public void setConfiguration(ITeamRepository repository, IProjectAreaHandle projectAreaHandle) {
        try {
            this.configuration = EnterpriseConfigurationCache.getInstance().fetch(repository, projectAreaHandle);
        }
        catch (TeamRepositoryException e) {
            this.configuration = EnterpriseConfigurationCache.getInstance().createDefault(projectAreaHandle);
        }
    }

    @Override
    public final boolean isDatasetExists() {
        return this.datasetExists;
    }

    @Override
    public final void setDatasetExists(boolean datasetExists) {
        this.datasetExists = datasetExists;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), LogField.valueOf((boolean)datasetExists)});
        }
    }

    @Override
    public final boolean isDatasetIsNew() {
        return this.datasetIsNew;
    }

    @Override
    public final void setDatasetIsNew(boolean datasetIsNew) {
        this.datasetIsNew = datasetIsNew;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), LogField.valueOf((boolean)datasetIsNew)});
        }
    }

    @Override
    public final boolean isDatasetMapped() {
        return this.datasetMapped;
    }

    @Override
    public final void setDatasetMapped(boolean datasetMapped) {
        this.datasetMapped = datasetMapped;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), LogField.valueOf((boolean)datasetMapped)});
        }
    }

    @Override
    public final IDataSetDefinition getDatasetDefinition() {
        return this.datasetDefinition;
    }

    @Override
    public final boolean hasDatasetDefinition() {
        return this.datasetDefinition != null;
    }

    @Override
    public final void setDatasetDefinition(IDataSetDefinition datasetDefinition) {
        this.datasetDefinition = datasetDefinition;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), LogField.valueOf((IItem)datasetDefinition)});
        }
    }

    @Override
    public final DataSetLocation getDatasetLocation() {
        return this.datasetLocation;
    }

    @Override
    public final boolean hasDatasetLocation() {
        return this.datasetLocation != null;
    }

    @Override
    public final void setDatasetLocation(DataSetLocation datasetLocation) {
        this.datasetLocation = datasetLocation;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), LogField.valueOf((Object)datasetLocation)});
        }
    }

    @Override
    public final PDSInfo getDatasetPDSInfo() {
        return this.datasetPDSInfo;
    }

    @Override
    public final boolean hasDatasetPDSInfo() {
        return this.datasetPDSInfo != null;
    }

    @Override
    public final void setDatasetPDSInfo(PDSInfo datasetPDSInfo) {
        this.datasetPDSInfo = datasetPDSInfo;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), LogField.nonNull((Object)datasetPDSInfo)});
        }
    }

    @Override
    public final void setDatasetPDSInfo() throws PDSManagerException {
        if (this.datasetPDSInfo == null && this.datasetExists && this.datasetLocation != null) {
            this.datasetPDSInfo = !DataSetInformation.isSimulatedModeOn() ? PDSUtility.getPDSCharacteristics(this.datasetLocation.getDatasetName(), false) : new PDSInfo();
        }
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), LogField.nonNull((Object)this.datasetPDSInfo)});
        }
    }

    @Override
    public final Set<String> getDatasetMembers() {
        return this.datasetMembers;
    }

    @Override
    public final Map<String, MemberInfo> getDatasetMemberMap() {
        return this.datasetMemberMap;
    }

    @Override
    public final void setDatasetMemberMap(Map<String, MemberInfo> datasetMemberMap) {
        this.datasetMemberMap = datasetMemberMap;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), LogField.valueOf(datasetMemberMap)});
        }
    }

    @Override
    public final void setDatasetMemberMap() throws IOException {
        if (this.datasetMemberMap.isEmpty() && this.datasetExists && !this.datasetIsNew && this.datasetLocation != null) {
            block16: {
                if (!DataSetInformation.isSimulatedModeOn()) {
                    PdsDirectory pdsDirectory = null;
                    try {
                        try {
                            pdsDirectory = new PdsDirectory(JzosUtility.getSlashSlashQuotedDSN((String)this.datasetLocation.getDatasetName()));
                            for (PdsDirectory.MemberInfo pdsMemberInfo : pdsDirectory) {
                                if (pdsMemberInfo.getStatistics() != null) {
                                    PDSMemberInfo memberInfo = new PDSMemberInfo(pdsMemberInfo, this.dbg);
                                    this.datasetMemberMap.put(((MemberInfo)memberInfo).getName(), memberInfo);
                                }
                                this.datasetMembers.add(pdsMemberInfo.getName());
                            }
                        }
                        catch (Exception e) {
                            if (this.dbg.isDebug()) {
                                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), e.getLocalizedMessage()});
                            }
                            if (pdsDirectory == null) break block16;
                            pdsDirectory.close();
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (pdsDirectory != null) {
                            pdsDirectory.close();
                        }
                        throw throwable;
                    }
                    if (pdsDirectory != null) {
                        pdsDirectory.close();
                    }
                } else {
                    ZFileInterface memberZFile = (ZFileInterface)this.shareable.getFileStorage().getAdapter(ZFileInterface.class);
                    if (memberZFile == null) {
                        throw new IOException("Invalid member name: " + this.shareable.getFullPath());
                    }
                    SimulatedZFileInterface simulatedZFile = (SimulatedZFileInterface)memberZFile;
                    HashSet<MemberInfo> memberInfos = simulatedZFile.getMemberInfos();
                    for (MemberInfo memberInfo : memberInfos) {
                        this.datasetMemberMap.put(memberInfo.getName(), memberInfo);
                        this.datasetMembers.add(memberInfo.getName());
                    }
                }
            }
            this.setDatasetMapped(true);
        }
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), LogField.valueOf(this.datasetMemberMap)});
        }
    }

    @Override
    public IProjectAreaHandle getProjectAreaHandle() {
        return this.projectAreaHandle;
    }

    @Override
    public void setProjectAreaHandle(IProjectAreaHandle projectAreaHandle) {
        this.projectAreaHandle = projectAreaHandle;
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return this.repository;
    }

    @Override
    public void setTeamRepository(ITeamRepository repository) {
        this.repository = repository;
    }

    @Override
    public final boolean isMemberMapped(String member) {
        if (this.isDatasetExists() && this.isDatasetMapped()) {
            return this.getDatasetMemberMap().containsKey(member);
        }
        return false;
    }

    @Override
    public final boolean memberExists(String member) {
        if (this.isDatasetExists() && this.isDatasetMapped()) {
            return this.datasetMembers.contains(member);
        }
        return false;
    }

    @Override
    public final void updateMemberMap(MemberInfo memberInfo) {
        this.datasetMemberMap.put(memberInfo.getName(), memberInfo);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new MethodName(){}.getName(), LogField.valueOf(this.datasetMemberMap)});
        }
    }
}

