/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.teamz.fileagent.internal.extensions.impl.PseudoSOSIInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;

public class ConvertToPseudoSOSIInputStream
extends PseudoSOSIInputStream {
    private boolean mustReturnSO = false;
    private boolean mustReturnSIbis = false;

    public ConvertToPseudoSOSIInputStream(InputStream in) throws UnsupportedEncodingException {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            throw new IOException("InputStreamReader is closed");
        }
        if (this.mustReturnSO) {
            this.mustReturnSO = false;
            return this.SO;
        }
        if (this.mustReturnSIbis) {
            this.mustReturnSIbis = false;
            return this.SIbis;
        }
        if (!this.pendingByte) {
            this.lastByte = this.in.read();
            this.pendingByte = true;
        }
        if (this.lastByte == this.SO) {
            this.pendingByte = false;
            this.mustReturnSO = true;
            return this.SObis;
        }
        if (this.lastByte == this.SI) {
            this.pendingByte = false;
            this.mustReturnSIbis = true;
            return this.SI;
        }
        this.pendingByte = false;
        return this.lastByte;
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buffer.length || len < 0 || off + len > buffer.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (len <= 2) {
            int b = this.read();
            if (b == -1) {
                return -1;
            }
            buffer[off] = (byte)b;
            return 1;
        }
        if (this.in == null) {
            throw new IOException("InputStreamReader is closed");
        }
        int bytesReturned = 0;
        if (this.mustReturnSO || this.mustReturnSIbis) {
            if (this.mustReturnSO) {
                this.mustReturnSO = false;
                buffer[off++] = (byte)this.SO;
            } else if (this.mustReturnSIbis) {
                this.mustReturnSIbis = false;
                buffer[off++] = (byte)this.SIbis;
            }
            ++bytesReturned;
            if (--len < 2) {
                return bytesReturned;
            }
        }
        int j = off + (len /= 2);
        int toProcess = 0;
        int toRead = len;
        if (this.pendingByte) {
            this.pendingByte = false;
            buffer[j] = (byte)this.lastByte;
            --toRead;
            ++bytesReturned;
            ++toProcess;
        }
        InterruptedIOException iioe = null;
        try {
            len = this.in.read(buffer, j + toProcess, toRead);
            if (len == -1) {
                if (toProcess == 0) {
                    return bytesReturned == 0 ? -1 : bytesReturned;
                }
                byte b = buffer[j];
                if (b == (byte)this.SO) {
                    buffer[off++] = (byte)this.SObis;
                    ++bytesReturned;
                } else if (b == (byte)this.SI) {
                    buffer[off++] = b;
                    ++bytesReturned;
                    b = (byte)this.SIbis;
                }
                buffer[off++] = b;
                return bytesReturned;
            }
        }
        catch (InterruptedIOException e) {
            len = e.bytesTransferred;
            iioe = e;
        }
        bytesReturned += len;
        toProcess += len;
        while (toProcess-- > 0) {
            int b;
            if ((b = buffer[j++]) == this.SI) {
                if (toProcess > 0) {
                    buffer[off++] = b;
                    buffer[off++] = (byte)this.SIbis;
                    ++bytesReturned;
                    continue;
                }
                this.pendingByte = true;
                this.lastByte = b;
                --bytesReturned;
                continue;
            }
            if (b == (byte)this.SO) {
                buffer[off++] = (byte)this.SObis;
                ++bytesReturned;
                buffer[off++] = b;
                continue;
            }
            buffer[off++] = b;
        }
        if (iioe != null) {
            iioe.bytesTransferred = bytesReturned;
            throw iioe;
        }
        if (bytesReturned == 0) {
            int b = this.read();
            if (b == -1) {
                return -1;
            }
            buffer[off] = (byte)b;
            return 1;
        }
        return bytesReturned;
    }

    public int readNEWBON(byte[] buffer, int off, int len) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buffer.length || len < 0 || off + len > buffer.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (len <= 2) {
            int b = this.read();
            if (b == -1) {
                return -1;
            }
            buffer[off] = (byte)b;
            return 1;
        }
        if (this.in == null) {
            throw new IOException("InputStreamReader is closed");
        }
        int bytesReturned = 0;
        if (this.mustReturnSO || this.mustReturnSIbis) {
            if (this.mustReturnSO) {
                this.mustReturnSO = false;
                buffer[off++] = (byte)this.SO;
            } else if (this.mustReturnSIbis) {
                this.mustReturnSIbis = false;
                buffer[off++] = (byte)this.SIbis;
            }
            ++bytesReturned;
            if (--len < 2) {
                return bytesReturned;
            }
        }
        int j = off + (len /= 2);
        int toProcess = 0;
        int toRead = len;
        if (this.pendingByte) {
            this.pendingByte = false;
            buffer[j] = (byte)this.lastByte;
            --toRead;
            ++bytesReturned;
            ++toProcess;
        }
        InterruptedIOException iioe = null;
        try {
            len = this.in.read(buffer, j + toProcess, toRead);
            if (len == -1) {
                if (toProcess == 0) {
                    return bytesReturned == 0 ? -1 : bytesReturned;
                }
                byte b = buffer[j];
                if (b == (byte)this.SO) {
                    buffer[off++] = (byte)this.SObis;
                    ++bytesReturned;
                } else if (b == (byte)this.SI) {
                    buffer[off++] = b;
                    ++bytesReturned;
                    b = (byte)this.SIbis;
                }
                buffer[off++] = b;
                return bytesReturned;
            }
        }
        catch (InterruptedIOException e) {
            len = e.bytesTransferred;
            iioe = e;
        }
        bytesReturned += len;
        toProcess += len;
        while (toProcess-- > 0) {
            int b;
            if ((b = buffer[j++]) == this.SI) {
                if (toProcess > 0) {
                    buffer[off++] = b;
                    buffer[off++] = (byte)this.SIbis;
                    ++bytesReturned;
                    continue;
                }
                this.pendingByte = true;
                this.lastByte = b;
                --bytesReturned;
                continue;
            }
            if (b == (byte)this.SO) {
                buffer[off++] = (byte)this.SObis;
                ++bytesReturned;
                buffer[off++] = b;
                continue;
            }
            buffer[off++] = b;
        }
        if (iioe != null) {
            iioe.bytesTransferred = bytesReturned;
            throw iioe;
        }
        if (bytesReturned == 0) {
            int b = this.read();
            if (b == -1) {
                return -1;
            }
            buffer[off] = (byte)b;
            return 1;
        }
        return bytesReturned;
    }
}

