/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.binary.zos;

import com.ibm.jzos.Exec;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.Zutility;
import com.ibm.teamz.fileagent.internal.binary.BinaryConverterException;
import com.ibm.teamz.fileagent.internal.binary.IBynaryConverter;
import com.ibm.teamz.fileagent.internal.binary.zos.messages.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ZosBinaryConverter
implements IBynaryConverter {
    private static Log LOG = LogFactory.getLog(ZosBinaryConverter.class);
    static final String ERROR_LABEL = "ERROR";
    static final String OK_LABEL = "OK";
    static final String LOG_SUFFIX = "LOG";
    static final String XMIT_SUFFIX = "XMIT";
    static final String XMIT_REXX_FILE = "blzxmit.rexx";
    static final String PREFIX_RECEIVE_FILE = "BinTrec";
    static final String RECEIVE_REXX_SCRIPT = "SCM.RECEIVE";
    static final String PREFIX_LOGFILE = "BinT";
    private static final Log logger = LogFactory.getLog(ZosBinaryConverter.class);
    private static final String SCRIPT_PATH_PROPERTY = "fileagent.script.path";
    private static final String SCRIPTS_FOLDER = "scripts";

    private static String getPluginLocation(String pluginName) {
        try {
            return ZosBinaryConverter.getBundleLocation(pluginName);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String getBundleLocation(String pluginName) throws IOException {
        URL resolvedUrl;
        URL entry;
        Bundle bundle = Platform.getBundle((String)pluginName);
        if (bundle != null && (entry = bundle.getEntry("/")) != null && (resolvedUrl = FileLocator.resolve((URL)entry)).getProtocol().equals("file")) {
            String path = resolvedUrl.getPath();
            return path;
        }
        return null;
    }

    private String getBlzxmitRexxFile() throws BinaryConverterException, IOException {
        String plugLocation = null;
        plugLocation = ZosBinaryConverter.getPluginLocation("com.ibm.teamz.fileagent");
        if (plugLocation != null) {
            StringBuffer pathRexxFile = new StringBuffer();
            pathRexxFile.append(plugLocation);
            pathRexxFile.append(File.separator);
            pathRexxFile.append(SCRIPTS_FOLDER);
            pathRexxFile.append(File.separator);
            pathRexxFile.append(XMIT_REXX_FILE);
            String rexxFile = pathRexxFile.toString();
            logger.debug((Object)("rexx file=" + rexxFile));
            File f = new File(rexxFile);
            if (f.exists() && f.isFile()) {
                logger.debug((Object)(String.valueOf(f.getCanonicalPath()) + " retrieved"));
                return f.getCanonicalPath();
            }
        }
        return this.retrieveBlzxmitRexxFile();
    }

    private String retrieveBlzxmitRexxFile() throws BinaryConverterException, IOException {
        String cmdPath = System.getProperty(SCRIPT_PATH_PROPERTY, "");
        if (cmdPath == null || cmdPath.length() == 0) {
            cmdPath = "./";
        } else if (cmdPath.length() > 0 && !cmdPath.endsWith("/")) {
            cmdPath = String.valueOf(cmdPath) + "/";
        }
        logger.debug((Object)("SCRIPT_DIR:" + cmdPath));
        StringBuffer pathRexxFile = new StringBuffer();
        pathRexxFile.append(cmdPath);
        pathRexxFile.append(XMIT_REXX_FILE);
        String rexxFile = pathRexxFile.toString();
        logger.debug((Object)("rexx file=" + rexxFile));
        File f = new File(rexxFile);
        if (f.exists() && f.isFile()) {
            logger.debug((Object)(String.valueOf(f.getCanonicalPath()) + " Already created"));
            return f.getCanonicalPath();
        }
        rexxFile = f.getCanonicalPath();
        this.createBlzxmitRexxFile(rexxFile);
        if (this.setExecutable(f) != 0) {
            logger.debug((Object)("File: " + rexxFile + " cannot be set as executable, verify if it is, if not manually set it!"));
        }
        return rexxFile;
    }

    private void createBlzxmitRexxFile(String rexxFile) throws IOException {
        logger.debug((Object)("generate rexx file=" + rexxFile));
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(rexxFile)));
        out.println("/*                               REXX                                */");
        out.println("/*********************************************************************/");
        out.println("/*                                                                   */");
        out.println("/* Licensed Materials - Property of IBM                              */");
        out.println("/* Copyright IBM Corporation 2011, 2013. All Rights Reserved.        */");
        out.println("/*                                                                   */");
        out.println("/* Note to U.S. Government Users Restricted Rights:                  */");
        out.println("/* Use, duplication or disclosure restricted by GSA ADP Schedule     */");
        out.println("/* Contract with IBM Corp.                                           */");
        out.println("/*                                                                   */");
        out.println("/*********************************************************************/");
        out.println("/*                                                                   */");
        out.println("/*                                                                   */");
        out.println("/* NAME := BLZXMIT                                                   */");
        out.println("/*                                                                   */");
        out.println("/* DESCRIPTIVE NAME := EWM XMIT a load module to a sequential dsn    */");
        out.println("/*                                                                   */");
        out.println("/* FUNCTION := This module creates an IEBCOPY XMIT data set from a   */");
        out.println("/*             load module member. It also removes the timestamp to  */");
        out.println("/*             stop hasmmap errors.                                  */");
        out.println("/*                                                                   */");
        out.println("/* OUTPUT := None                                                    */");
        out.println("/*                                                                   */");
        out.println("/* Change History                                                    */");
        out.println("/*                                                                   */");
        out.println("/* Who   When     What                                               */");
        out.println("/* ----- -------- -------------------------------------------------- */");
        out.println("/* LD    12/08/13 Initial version                                    */");
        out.println("/*                                                                   */");
        out.println("/*********************************************************************/");
        out.println("/*                                                                   */");
        out.println("/* XMIT file format is documented in                                 */");
        out.println("/* TSO/E customization (SA22-7783-xx)                                */");
        out.println("/* chapter 'Customizing TRANSMIT and RECEIVE',                       */");
        out.println("/* section 'Text Units and Text Unit Pointer Lists' and              */");
        out.println("/* section 'Format of Transmitted Data'                              */");
        out.println("/*                                                                   */");
        out.println("/* An XMIT file (80-byte lines) consists of control & data records.  */");
        out.println("/* A record is stored in 1 or more segments (max 255 bytes).         */");
        out.println("/* Within each segment, information is stored as a text unit.        */");
        out.println("/*                                                                   */");
        out.println("/* ----+----1----+----2----+----3----+----4----+----5----+----6----+ */");
        out.println("/*   INMR01             MVS040      ONNO      MVS040      ONNO       */");
        out.println("/* 5ECDDDFF0400005110000DEEFFF110000DDDD100000DEEFFF100000DDDD120000 */");
        out.println("/* 6095490102010100101064520400201046556010106452040020104655604010E */");
        out.println("/* |||     | | | |                                                   */");
        out.println("/* |||     | | | +-> text unit - data                                */");
        out.println("/* |||     | | +---> text unit - length                              */");
        out.println("/* |||     | +-----> text unit - # length/data pairs                 */");
        out.println("/* |||     +-------> text unit - type                                */");
        out.println("/* ||+-> record type                                                 */");
        out.println("/* |+--> Segment & record flags                                      */");
        out.println("/* +---> segment length                                              */");
        out.println("/*                                                                   */");
        out.println("/*===================================================================*/");
        out.println("/* user variables....................................................*/");
        out.println("  parse arg da' 'logfile");
        out.println("  parse arg dsn '(' member ')'");
        out.println("");
        out.println("  Call OUTTRAP stem.");
        out.println("  XmitDsn = dsn\".\"member\".XMIT\"");
        out.println("  cmd = \"xmit \"MVSVAR(SYSNAME)\".\"USERID()\" da ('\"da\"')");
        out.println("         outda('\"XmitDsn\"') NOLOG\"");
        out.println("  address tso cmd");
        out.println("  If rc <> 0 Then");
        out.println("  Do");
        out.println("    Call lineout logfile,\"ERROR\",1");
        out.println("    Do xmit = 1 to stem.0");
        out.println("      Call lineout logfile, stem.xmit");
        out.println("    End");
        out.println("  End");
        out.println("  Else");
        out.println("  Do");
        out.println("    /*-1-*/                    /* Timestamp replacement value        */");
        out.println("    XmitDate='##############'");
        out.println("");
        out.println("    /*-2-*/                                      /* temporary DD name */");
        out.println("    LongTime = TIME('L')");
        out.println("    Parse var LongTime hh':'mm':'ss'.'msecs");
        out.println("    DDname='$$'msecs");
        out.println("");
        out.println("    /* system code. */");
        out.println("");
        out.println("    /* drop Lines. */");
        out.println("    parse value ReadXmit(DDname XmitDsn) with rc error1 error2");
        out.println("    If rc <> 0 Then");
        out.println("    Do");
        out.println("      Call lineout logfile,\"ERROR\",1");
        out.println("      Call lineout logfile,error1");
        out.println("      Call lineout logfile,error2");
        out.println("    End");
        out.println("    Else");
        out.println("    Do");
        out.println("      Call UpdateSegment(XmitDate)");
        out.println("");
        out.println("      parse value WriteSegment(DDname) with rc error1");
        out.println("      If rc <> 0 Then");
        out.println("      Do");
        out.println("        Call lineout logfile,\"ERROR\",1");
        out.println("        Call lineout logfile,error1");
        out.println("      End");
        out.println("      Else");
        out.println("      Do");
        out.println("        /* all is OK! */");
        out.println("        Call lineout logfile,\"OK\",1");
        out.println("      End");
        out.println("    End");
        out.println("  End");
        out.println("");
        out.println("  XX = OUTTRAP('OFF')");
        out.println("  call lineout  /* close the logfile */");
        out.println("");
        out.println("return rc");
        out.println("");
        out.println("/*===================================================================*/");
        out.println("ReadXmit: PROCEDURE EXPOSE Lines. /* read first lines of file        */");
        out.println("/* -input-                                                           */");
        out.println("/* DDname: DD name to use for file allocation                        */");
        out.println("/* Dsn   : DSN to allocate                                           */");
        out.println("/*                                                                   */");
        out.println("/* -output-                                                          */");
        out.println("/* (Lines., contains first lines of XMIT file)                       */");
        out.println("/* (DDname, is now an allocated file)                                */");
        out.println("/*===================================================================*/");
        out.println("  Arg DDname Dsn");
        out.println("");
        out.println("  QuoteDsn = \"'\"Dsn\"'\"");
        out.println("  error1=\"\"");
        out.println("  error2=\"\"");
        out.println("");
        out.println("  cRC = BPXWDYN(\"alloc dd(\"DDname\") da(\"QuoteDsn\") shr\")");
        out.println("  If cRC > 0 Then");
        out.println("  Do");
        out.println("    error1=\">> ERROR: ALLOCATE ended with rc\" cRC");
        out.println("    error2=\">>       \" Dsn");
        out.println("    Say error1");
        out.println("    Say error2");
        out.println("    Rc = BPXWDYN(\"free FILE(\"DDname\")\")");
        out.println("    return 12 error1 error2");
        out.println("  End    /* allocate error */");
        out.println("");
        out.println("  Address MVS \"EXECIO 4 DISKR\" DDname \"(STEM Lines. FINIS\"");
        out.println("  cRC = rc                    /* 4 80-byte lines cover the (max) 263 */");
        out.println("  If cRC > 0 Then             /* bytes needed for 2 segment headers  */");
        out.println("  Do");
        out.println("    error1=\">> ERROR: EXECIO (read) ended with rc\" cRC");
        out.println("    error2=\">>       \" Dsn");
        out.println("    Say error1");
        out.println("    Say error2");
        out.println("    Rc = BPXWDYN(\"free FILE(\"DDname\")\")");
        out.println("    return 12 error1 error2");
        out.println("  End    /* read error */");
        out.println("");
        out.println("Return 0 error1 error2  /* ReadXmit */");
        out.println("");
        out.println("");
        out.println("/*===================================================================*/");
        out.println("UpdateSegment: PROCEDURE EXPOSE Lines. /* update 1st XMIT Segment   */");
        out.println("/* -input-                                                           */");
        out.println("/* XmitDate : new default date                                       */");
        out.println("/* (Lines., included with expose)                                    */");
        out.println("/*                                                                   */");
        out.println("/* -output-                                                          */");
        out.println("/* (Lines., selected data fields have been updated)                  */");
        out.println("/*===================================================================*/");
        out.println("  Arg XmitDate");
        out.println("");
        out.println("  INMDATE = '1024'x                              /* TIMESTAMP        */");
        out.println("");
        out.println("  Stream = ''                   /* string all 80-byte lines together */");
        out.println("  Do T = 1 to Lines.0");
        out.println("    Stream = Stream || Lines.T");
        out.println("  End    /* loop */");
        out.println("");
        out.println("  sFlags = substr(Stream,2,1)                       /* segment flags */");
        out.println("  If bitand(sFlags,'40'x) <> '40'x Then    /* 40x -> last segment    */");
        out.println("  Do");
        out.println("    Say \">> WARNING: header record spans multiple segments,\"");
        out.println("    Say \"            but only the first one is updated\"");
        out.println("  End    /* multi segment */");
        out.println("");
        out.println("  sLength=c2d(left(Stream,1))                     /* Segment length */");
        out.println("  Ptr=9                                        /* skip record header */");
        out.println("");
        out.println("  Do while Ptr < sLength      /* read all text units in this segment */");
        out.println("    parse value GetTextUnit(Ptr) with Ptr uType uLength uPair .");
        out.println("");
        out.println("    If uPair > 1 Then                      /* multi-data text unit ? */");
        out.println("    Do");
        out.println("      Do T = 1 to uPair                     /* skip to next TextUnit */");
        out.println("        Ptr=Ptr + 2 + c2d(substr(Stream,Ptr,2))");
        out.println("      End    /* loop */");
        out.println("    End    /* uPair > 1 */");
        out.println("    Else");
        out.println("    Do                               /* only 1 or 0 length/data pair */");
        out.println("      Select                         /* act upon selected unit types */");
        out.println("        When uType = INMDATE Then");
        out.println("          Stream=overlay(XmitDate,Stream,Ptr,uLength)");
        out.println("        Otherwise");
        out.println("          nop");
        out.println("      End    /* select */");
        out.println("");
        out.println("      Ptr=Ptr+uLength                        /* go to next text unit */");
        out.println("    End    /* uPair = 0/1 */");
        out.println("  End    /* Do while */");
        out.println("");
        out.println("  Do T = 1 to Lines.0           /* put updates back in 80-byte lines */");
        out.println("    Lines.T = substr(Stream,(T-1)*80+1,80)");
        out.println("  End    /* loop */");
        out.println("Return    /* UpdateSegment */");
        out.println("");
        out.println("");
        out.println("/*===================================================================*/");
        out.println("GetTextUnit: PROCEDURE EXPOSE Stream /* get info on next text unit   */");
        out.println("/* -input-                                                           */");
        out.println("/* Ptr: starting point of text unit                                  */");
        out.println("/* (Stream, included with expose)                                    */");
        out.println("/*                                                                   */");
        out.println("/* -output-                                                          */");
        out.println("/* Ptr    : starting point of data inside this unit If uPair <= 1,   */");
        out.println("/*          otherwise starting point of length/data pairs            */");
        out.println("/* uType  : type of data inside this unit                            */");
        out.println("/* uLength: length of actual data inside this unit If uPair <= 1,    */");
        out.println("/*          otherwise length of first length/data pair               */");
        out.println("/* uPair  : # of length/data pairs                                   */");
        out.println("/*                                                                   */");
        out.println("/*       ONNO  DDNAME  $$XMIT$$                                      */");
        out.println("/* 000000DDDD00CCDCDC0055EDCE55                                      */");
        out.println("/* 02030465560644514508BB7493BB                                      */");
        out.println("/* | |(1)|  (2)     (3)                                              */");
        out.println("/* | | | |                                                           */");
        out.println("/* | | | +-> position of Ptr If uPair <= 1                           */");
        out.println("/* | | +---> uLength (= 4), position of Ptr If uPair > 1             */");
        out.println("/* | +-----> uPair  (= 3)                                            */");
        out.println("/* +-------> uType  (= 0002x)                                        */");
        out.println("/*===================================================================*/");
        out.println("  Arg Ptr");
        out.println("");
        out.println("  uType = substr(Stream,Ptr,2)                               /* type */");
        out.println("  If uType = '0000'x Then    /* INMR02 records start with a dummy    */");
        out.println("    uPair = 0                /* 0000 0001. This is NOT documented !! */");
        out.println("  Else");
        out.println("    uPair = c2d(substr(Stream,Ptr+2,2))    /* # of length/data pairs */");
        out.println("  Select");
        out.println("    When uPair = 0 Then");
        out.println("    Do                                          /* empty text unit ? */");
        out.println("      uLength = 0");
        out.println("      Ptr = Ptr + 4");
        out.println("    End    /* empty text unit */");
        out.println("    When uPair = 1 Then");
        out.println("    Do                                        /* 1 length/data pairs */");
        out.println("      uLength = c2d(substr(Stream,Ptr+4,2))");
        out.println("      Ptr = Ptr + 6");
        out.println("    End    /* 1 length/data pair */");
        out.println("    Otherwise                          /* multiple length/data pairs */");
        out.println("    Do                                        /* 1 length/data pairs */");
        out.println("      uLength=c2d(substr(Stream,Ptr+4,2)) /* shows length of 1st one */");
        out.println("      Ptr = Ptr + 4");
        out.println("    End");
        out.println("  /* leave further processing to caller */");
        out.println("  End    /* select */");
        out.println("Return Ptr uType uLength uPair    /* GetTextUnit */");
        out.println("");
        out.println("");
        out.println("/*===================================================================*/");
        out.println("WriteSegment: PROCEDURE EXPOSE Lines. /* save updates                */");
        out.println("/* -input-                                                           */");
        out.println("/* DDname: DD name by which the XMIT file is allocated               */");
        out.println("/* (Lines., included with expose)                                    */");
        out.println("/*                                                                   */");
        out.println("/* -output-                                                          */");
        out.println("/* (DDname, file is updated and freed)                               */");
        out.println("/*===================================================================*/");
        out.println("  Arg DDname");
        out.println("");
        out.println("  error1=\"\"");
        out.println("  error2=\"\"");
        out.println("");
        out.println("  Do T = 1 to Lines.0");
        out.println("                                          /* position on correct line */");
        out.println("    Address MVS \"EXECIO 1 DISKRU\" DDname \"(SKIP\"");
        out.println("    cRC = rc");
        out.println("    If cRC > 0 Then");
        out.println("    Do");
        out.println("      error1=\">> ERROR: EXECIO (positioning on line\" T\") ended with rc\" cRC");
        out.println("      Say error1");
        out.println("      Address MVS \"EXECIO 0 DISKRU\" DDname \"(FINIS\"");
        out.println("      Rc = BPXWDYN(\"free FILE(\"DDname\")\")");
        out.println("      Return 12 error1");
        out.println("    End    /* positioning error */");
        out.println("");
        out.println("    push Lines.T                               /* write 80-byte line */");
        out.println("    Address MVS \"EXECIO 1 DISKW\" DDname");
        out.println("    cRC = rc");
        out.println("    If cRC > 0 Then");
        out.println("    Do");
        out.println("      error1=\">> ERROR: EXECIO (writing line\" T\") ended with rc\" cRC");
        out.println("      Say error1");
        out.println("      Address MVS \"EXECIO 0 DISKRU\" DDname \"(FINIS\"");
        out.println("      Rc = BPXWDYN(\"free FILE(\"DDname\")\")");
        out.println("      Return 12 error1");
        out.println("    End    /* write error */");
        out.println("  End    /* loop */");
        out.println("");
        out.println("  Address MVS \"EXECIO 0 DISKRU\" DDname \"(FINIS\"    /* close file */");
        out.println("  cRC = rc");
        out.println("  If cRC > 0 Then");
        out.println("  Do");
        out.println("    error1=\">> ERROR: EXECIO (close) ended with rc\" cRC");
        out.println("    Say error1");
        out.println("    Rc = BPXWDYN(\"free FILE(\"DDname\")\")");
        out.println("    Return 12 error1");
        out.println("  End    /* close error */");
        out.println("");
        out.println("  Address TSO \"FREE FILE(\"DDname\")\"");
        out.println("Return 0 error1  /* WriteSegment */");
        out.flush();
        out.close();
        logger.debug((Object)("file: " + rexxFile + " generated"));
    }

    private int setExecutable(File f) throws BinaryConverterException {
        String setExecCmd = null;
        try {
            setExecCmd = "chmod 0777 " + f.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BinaryConverterException(NLS.bind((String)Messages.IO_ERROR, (Object)e.getMessage()));
        }
        return this.startCmd(setExecCmd);
    }

    private String getXmitCommand(String da, String logFile) throws BinaryConverterException {
        String rexxFile;
        try {
            rexxFile = this.getBlzxmitRexxFile();
        }
        catch (IOException e) {
            throw new BinaryConverterException(NLS.bind((String)Messages.CANNOT_CREATE_SCRIPT, (Object)XMIT_REXX_FILE, (Object)e.getMessage()));
        }
        String cmd = String.valueOf(rexxFile) + " " + da + " " + logFile;
        logger.debug((Object)("Command: " + cmd));
        return cmd;
    }

    private String createInputXml(String iSpfRexxFile, String dsn, String xmitFile, String logFile) throws BinaryConverterException {
        StringBuffer sb = new StringBuffer();
        logger.info((Object)"createInputXml :");
        sb.append("<?xml version=\\\"1.0\\\"?>\n");
        sb.append("<ISPF-INPUT>\n");
        sb.append("<SERVICE-REQUEST>\n");
        sb.append("<service>ISPF</service>\n");
        sb.append("<session>NONE</session>\n");
        sb.append("<command>EXEC '" + iSpfRexxFile + "' '" + dsn + " " + xmitFile + " " + logFile + "'</command>\n");
        sb.append("</SERVICE-REQUEST>");
        sb.append("</ISPF-INPUT>\n");
        return sb.toString();
    }

    private String createShellScript(String RexxFile) throws BinaryConverterException {
        File shFile = null;
        try {
            shFile = File.createTempFile(PREFIX_RECEIVE_FILE, ".sh");
        }
        catch (IOException e2) {
            throw new BinaryConverterException(e2);
        }
        String file = shFile.getAbsolutePath();
        logger.debug((Object)("createShellScript=" + file));
        try {
            File f = new File(file);
            file = f.getCanonicalPath();
            logger.debug((Object)("Really create=" + file));
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                out.println("export PATH=:/bin:/usr/lpp/internet/sbin:/usr/lpp/ispf/bin");
                out.println("export CGI_ISPCONF=/etc/ispf");
                out.println("echo \"" + RexxFile + "\" | ISPZXML");
                out.flush();
                out.close();
            }
            catch (IOException e) {
                throw new BinaryConverterException(NLS.bind((String)Messages.CANNOT_CREATE_SHELLSCRIPT, (Object)file));
            }
            File f2 = new File(f.getCanonicalPath());
            if (f2.exists() && f2.isFile()) {
                logger.debug((Object)("Creation done=" + f2.getCanonicalFile()));
            }
            this.setExecutable(f);
            return file;
        }
        catch (IOException e) {
            throw new BinaryConverterException(NLS.bind((String)Messages.IO_ERROR, (Object)e.getMessage()));
        }
    }

    private void writeLine(ZFile zFile, String line) throws ZFileException, UnsupportedEncodingException {
        int lrecl = zFile.getLrecl();
        byte[] recBuf = new byte[lrecl];
        byte[] b = line.getBytes(Zutility.getDefaultPlatformEncoding());
        int len = b.length > lrecl ? lrecl : b.length;
        System.arraycopy(b, 0, recBuf, 0, len);
        int i = len;
        while (i < lrecl) {
            recBuf[i] = 64;
            ++i;
        }
        zFile.write(recBuf, 0, lrecl);
    }

    private String createIspfRexxFile() throws BinaryConverterException {
        String output = ZFile.getSlashSlashQuotedDSN((String)RECEIVE_REXX_SCRIPT);
        String ret = ZFile.getFullyQualifiedDSN((String)RECEIVE_REXX_SCRIPT);
        try {
            if (ZFile.dsExists((String)output)) {
                logger.info((Object)(String.valueOf(output) + " already created"));
                return ret;
            }
        }
        catch (ZFileException e1) {
            throw new BinaryConverterException(NLS.bind((String)Messages.CANNOT_CREATE_REXX_SCRIPT, (Object)output));
        }
        logger.info((Object)("Create CreateIspfRexxFile: " + output));
        try {
            ZFile zFileOut = new ZFile(output, "wb,type=record,recfm=fb,lrecl=80,noseek");
            this.writeLine(zFileOut, "/* rexx */");
            this.writeLine(zFileOut, "parse arg dsn' 'xmitfile' 'logfile");
            this.writeLine(zFileOut, "x = PROMPT('ON')");
            this.writeLine(zFileOut, "x = OUTTRAP('STEM.')");
            this.writeLine(zFileOut, "Queue \" DATASET('\"dsn\"')\"");
            this.writeLine(zFileOut, "cmd = \"receive inda('\"xmitfile\"') NONAMES\"");
            this.writeLine(zFileOut, "address TSO cmd  ");
            this.writeLine(zFileOut, "If rc <> 0 Then ");
            this.writeLine(zFileOut, "Do");
            this.writeLine(zFileOut, "line1.0=1");
            this.writeLine(zFileOut, "line1.1=\"ERROR\"");
            this.writeLine(zFileOut, "Address syscall \"writefile (logfile) 777 line1. 0\"");
            this.writeLine(zFileOut, "  Do xmit = 1 to stem.0");
            this.writeLine(zFileOut, "Address syscall \"writefile (logfile) 777 stem. 1\"");
            this.writeLine(zFileOut, "  End ");
            this.writeLine(zFileOut, "End ");
            this.writeLine(zFileOut, "Else");
            this.writeLine(zFileOut, "Do");
            this.writeLine(zFileOut, "line1.0=1");
            this.writeLine(zFileOut, "line1.1=\"OK\"");
            this.writeLine(zFileOut, "Address syscall \"writefile (logfile) 777 line1. 0\"");
            this.writeLine(zFileOut, "End");
            this.writeLine(zFileOut, "x = OUTTRAP('OFF')");
            zFileOut.flush();
            zFileOut.close();
        }
        catch (UnsupportedEncodingException e) {
            throw new BinaryConverterException(NLS.bind((String)Messages.NO_ENCODING, (Object)e.getMessage()));
        }
        catch (ZFileException e) {
            throw new BinaryConverterException(NLS.bind((String)Messages.DS_WRITE_ERROR, (Object)e.getMessage()));
        }
        return ret;
    }

    private String getReceiveCommand(String da, String xmitFile, String logFile) throws BinaryConverterException {
        String iSpfRexxFile = this.createIspfRexxFile();
        String iXmlFile = this.createInputXml(iSpfRexxFile, da, xmitFile, logFile);
        String cmdPath = this.createShellScript(iXmlFile);
        return cmdPath;
    }

    private static String[] getEnvironment() {
        Properties p = ZUtil.getEnvironment();
        p.put("_BPX_SHAREAS", "YES");
        p.put("_BPX_SPAWN_SCRIPT", "YES");
        String[] environ = new String[p.size()];
        int i = 0;
        for (String string : p.keySet()) {
            environ[i++] = String.valueOf(string) + "=" + p.getProperty(string);
        }
        return environ;
    }

    private static String ussFile(String path) {
        StringBuffer sb = new StringBuffer();
        if (path.endsWith(")")) {
            sb.append(path.replace('(', '.').replace(')', '.'));
        } else {
            sb.append(path.replace('(', '.'));
            sb.append('.');
        }
        return sb.toString();
    }

    public static String getGeneratedFile(String path) {
        StringBuffer sb = new StringBuffer();
        sb.append(ZosBinaryConverter.ussFile(path));
        sb.append(XMIT_SUFFIX);
        return sb.toString();
    }

    private String getLogFile() throws BinaryConverterException {
        File logFile = null;
        try {
            logFile = File.createTempFile(PREFIX_LOGFILE, ".log");
        }
        catch (IOException e2) {
            throw new BinaryConverterException(e2);
        }
        logger.debug((Object)("Create logFile: " + logFile.getAbsolutePath()));
        return logFile.getAbsolutePath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkLogFile(String path) throws BinaryConverterException {
        logger.debug((Object)("checkLogFile :" + path));
        BufferedReader logFile = null;
        boolean bSucceed = false;
        try {
            logFile = new BufferedReader(new FileReader(path));
            logger.debug((Object)("checkLogFile :" + path + " -> OK"));
            String line = null;
            line = logFile.readLine();
            logger.debug((Object)("checkLogFile :" + path + " -> Lecture OK"));
            if (line == null) throw new BinaryConverterException(NLS.bind((String)Messages.EMPTY_LOGFILE, (Object)path));
            if (line.equals(ERROR_LABEL)) {
                StringBuffer error_msg = new StringBuffer();
                String error_line = null;
                while ((error_line = logFile.readLine()) != null) {
                    error_msg.append(error_line);
                    error_msg.append(System.getProperty("line.separator"));
                }
                throw new BinaryConverterException(NLS.bind((String)Messages.ERROR_LOGFILE, (Object)error_msg));
            }
            if (line.equals(OK_LABEL)) {
                bSucceed = true;
                return true;
            }
            try {
                throw new BinaryConverterException(NLS.bind((String)Messages.INVALID_CONTENT_LOGFILE, (Object)path));
            }
            catch (FileNotFoundException e) {
                throw new BinaryConverterException(NLS.bind((String)Messages.LOG_FILE_NOT_FOUND, (Object)path));
            }
            catch (IOException e) {
                throw new BinaryConverterException(NLS.bind((String)Messages.IO_ERROR, (Object)path, (Object)e.getMessage()));
            }
        }
        finally {
            block15: {
                if (logFile != null) {
                    try {
                        logFile.close();
                    }
                    catch (IOException e) {
                        logger.debug((Object)("checkLogFile :" + path + " -> Error during close"));
                        if (!bSucceed) break block15;
                        throw new BinaryConverterException(NLS.bind((String)Messages.IO_ERROR, (Object)path, (Object)e.getMessage()));
                    }
                }
            }
        }
    }

    private int startCmd(String cmd) throws BinaryConverterException {
        logger.debug((Object)("Command=" + cmd));
        StringTokenizer st = new StringTokenizer(cmd);
        String[] cmdArgs = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArgs[i++] = st.nextToken();
        }
        logger.debug((Object)("1:" + cmdArgs[0]));
        Exec exec = new Exec(cmdArgs, ZosBinaryConverter.getEnvironment());
        exec.setTimeout(300000);
        try {
            exec.run();
        }
        catch (IOException e) {
            logger.debug((Object)("startCmd IOException :" + e.getMessage()));
            throw new BinaryConverterException(NLS.bind((String)Messages.CANNOT_EXECUTE, (Object)cmd, (Object)e.getMessage()));
        }
        String line = null;
        try {
            while ((line = exec.readLine()) != null) {
                logger.debug((Object)(">> " + line));
            }
        }
        catch (IOException e) {
            logger.debug((Object)("startCmd exec.readLine IOException :" + e.getMessage()));
        }
        int ret = exec.getReturnCode();
        logger.debug((Object)("Return code: " + ret));
        return ret;
    }

    @Override
    public String hostToScm(String path) throws BinaryConverterException {
        if (this.isNotMember(path)) {
            throw new BinaryConverterException(NLS.bind((String)Messages.NOT_A_MEMBER, (Object)path));
        }
        String logFile = this.getLogFile();
        String cmd = this.getXmitCommand(path, logFile);
        this.startCmd(cmd);
        this.checkLogFile(logFile);
        this.cleanUp(logFile);
        return ZosBinaryConverter.getGeneratedFile(path);
    }

    private void cleanUp(String filename) {
        logger.debug((Object)("Delete :" + filename));
        new File(filename).delete();
    }

    private boolean isNotMember(String path) {
        return !path.endsWith(")") || !path.contains("(");
    }

    @Override
    public void scmToHost(String xmitFile) throws BinaryConverterException {
        if (!xmitFile.toUpperCase().endsWith(XMIT_SUFFIX)) {
            throw new BinaryConverterException(NLS.bind((String)Messages.INVALID_XMIT_FILENAME, (Object)xmitFile));
        }
        String s = xmitFile.substring(0, xmitFile.length() - (XMIT_SUFFIX.length() + 1));
        String s2 = s.substring(0, s.lastIndexOf(46));
        this.scmToHost(xmitFile, s2);
    }

    @Override
    public void scmToHost(String xmitFile, String dsn) throws BinaryConverterException {
        String cmd;
        String logFile;
        block7: {
            logger.debug((Object)("scmToHost xmitFile:" + xmitFile + " dsn " + dsn));
            StringBuffer sb = new StringBuffer(String.valueOf('\'') + xmitFile + '\'');
            logger.debug((Object)("Check :" + sb.toString()));
            try {
                if (!ZFile.dsExists((String)sb.toString())) {
                    String msg = NLS.bind((String)Messages.FILE_NOT_FOUND, (Object)xmitFile);
                    LogUtility.logTrace((Log)LOG, null, (String[])new String[]{msg});
                    throw new BinaryConverterException(msg);
                }
            }
            catch (ZFileException e) {
                String msg = NLS.bind((String)Messages.INVALID_XMIT_FILENAME, (Object)xmitFile);
                LogUtility.logTrace((Log)LOG, null, (String[])new String[]{msg});
                throw new BinaryConverterException(msg, e);
            }
            logFile = this.getLogFile();
            cmd = this.getReceiveCommand(dsn, xmitFile, logFile);
            try {
                this.startCmd(cmd);
            }
            catch (BinaryConverterException e) {
                if (!e.getMessage().contains("EDC5129I")) break block7;
                this.startCmd("sh " + cmd);
            }
        }
        StringTokenizer st = new StringTokenizer(cmd);
        String[] cmdArgs = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArgs[i++] = st.nextToken();
        }
        if (this.checkLogFile(logFile)) {
            logger.debug((Object)("scmToHost Cleanup: " + cmdArgs[0] + "," + logFile));
            this.cleanUp(cmdArgs[0]);
            this.cleanUp(logFile);
        }
    }

    @Override
    public void removeConvertedFile(String path) throws BinaryConverterException {
    }
}

