/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.fileagent.IConnection;
import com.ibm.teamz.fileagent.core.RepositoryUtility;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.utility.InternalRepoUtility;
import com.ibm.teamz.fileagent.operations.ConnectionInfo;
import org.eclipse.osgi.util.NLS;

public class Connection
implements IConnection {
    private ConnectionInfo fConnectionInfo;
    private ITeamRepository fTeamRepository;

    public Connection(ConnectionInfo connectionInfo) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ILLEGAL_ARG, (Object)"null", (Object)"ConnectionInfo"));
        }
        this.fConnectionInfo = connectionInfo;
    }

    public Connection(ITeamRepository teamRepository) {
        if (teamRepository == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ILLEGAL_ARG, (Object)"null", (Object)"ITeamRepository"));
        }
        this.fTeamRepository = teamRepository;
    }

    @Override
    public ITeamRepository getLoggedTeamrepository() throws FileAgentRepositoryException {
        if (this.fConnectionInfo != null) {
            this.fTeamRepository = RepositoryUtility.login(this.fConnectionInfo);
        } else if (!this.fTeamRepository.loggedIn()) {
            InternalRepoUtility.login(this.fTeamRepository);
        }
        return this.fTeamRepository;
    }

    @Override
    public String getJazzRepositoryUri() {
        if (this.fConnectionInfo != null) {
            return this.fConnectionInfo.getJazzRepositoryUri();
        }
        return this.fTeamRepository.getRepositoryURI();
    }

    @Override
    public String getUserId() {
        if (this.fConnectionInfo != null) {
            return this.fConnectionInfo.getUserId();
        }
        return this.fTeamRepository.getUserId();
    }
}

