/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.importz;

import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.CatalogSearchField;
import com.ibm.jzos.DSCB;
import com.ibm.jzos.FileFactory;
import com.ibm.jzos.Format1DSCB;
import com.ibm.jzos.Format8DSCB;
import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingConstants;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.teamz.fileagent.importz.IPDSManager;
import com.ibm.teamz.fileagent.importz.PDSInfo;
import com.ibm.teamz.fileagent.importz.PDSManagerException;
import com.ibm.teamz.fileagent.importz.PDSMemberInfo;
import com.ibm.teamz.fileagent.internal.importz.SCMOperationMgr;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class PDSManager
implements IPDSManager {
    private static final boolean log = false;
    private static boolean isNLCheckingWanted = false;
    public static final boolean CHECKING_NEW_LINE_IN_MEMBER_FORBIDDEN = System.getProperty("scmee.checking.newline.in.member.forbidden") != null;
    private ArrayList<IStatus> invalidDatasetStatuses;

    public static boolean isNLCheckingAllowed() {
        return !CHECKING_NEW_LINE_IN_MEMBER_FORBIDDEN;
    }

    public static boolean isNLCheckingWanted() {
        return isNLCheckingWanted;
    }

    public static boolean setNLCheckingWanted(boolean isNLCheckingWanted) {
        boolean oldValue = PDSManager.isNLCheckingWanted;
        PDSManager.isNLCheckingWanted = isNLCheckingWanted;
        return oldValue;
    }

    public static final void log(String s) {
    }

    public ArrayList<IStatus> getInvalidDatasetStatuses() {
        if (this.invalidDatasetStatuses == null) {
            this.invalidDatasetStatuses = new ArrayList();
        }
        return this.invalidDatasetStatuses;
    }

    @Override
    public void loadContent(ITeamRepository repo, IWorkspaceConnection wks, IComponentHandle component, String zosProjectName, String zFldName, PDSMemberInfo mbr, String extens) throws IOException, TeamRepositoryException {
        SCMOperationMgr mgr = new SCMOperationMgr(repo, wks, component, zosProjectName, zFldName);
        String content = this.retrieveContent(mbr);
        ByteArrayOutputStream bos = null;
        boolean success = false;
        try {
            bos = this.retrieveBytesFromContent(content);
            String mbrName = mbr.getName();
            int period = mbrName.indexOf(".");
            if (period <= -1) {
                StringBuffer bf = new StringBuffer();
                bf.append(mbrName);
                bf.append(extens);
                mbrName = bf.toString();
                mbr.setMbrName(mbrName);
            }
            mgr.commitPDSMember(mbr, bos);
            success = true;
        }
        finally {
            block10: {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        if (!success) break block10;
                        success = false;
                        throw e;
                    }
                }
            }
        }
    }

    public void loadContent(ITeamRepository repo, IWorkspaceConnection wks, IComponentHandle component, String zosProjectName, String zFldName, PDSMemberInfo mbr, String extens, String zFileName, UUID csUuid) throws IOException, TeamRepositoryException {
        SCMOperationMgr mgr = new SCMOperationMgr(repo, wks, component, zosProjectName, zFldName);
        String content = this.retrieveContent(mbr);
        ByteArrayOutputStream bos = null;
        boolean success = false;
        try {
            bos = this.retrieveBytesFromContent(content);
            String mbrName = mbr.getName();
            int period = mbrName.indexOf(".");
            if (period <= -1) {
                StringBuffer bf = new StringBuffer();
                bf.append(mbrName);
                bf.append(extens);
                mbrName = bf.toString();
                mbr.setMbrName(mbrName);
            }
            mgr.commitPDSMember(mbr, bos, zFileName, csUuid);
            success = true;
        }
        finally {
            block10: {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        if (!success) break block10;
                        success = false;
                        throw e;
                    }
                }
            }
        }
    }

    @Override
    public List<PDSInfo> listDataSets(String criteria) throws PDSManagerException {
        int start;
        String ch;
        this.invalidDatasetStatuses = new ArrayList();
        int ind = criteria.indexOf("**");
        if (ind > -1 && !".".equals(ch = criteria.substring(start = ind - 1, ind))) {
            String msg = Messages.ZIMPORT_INV_SRCH_CRITERIA;
            throw new PDSManagerException(msg);
        }
        ArrayList<PDSInfo> dSets = new ArrayList<PDSInfo>();
        CatalogSearch catSearch = new CatalogSearch(criteria);
        catSearch.addFieldName("ENTNAME");
        catSearch.addFieldName("NAME");
        catSearch.addFieldName("ENTYPE");
        catSearch.addFieldName("NVSMATTR");
        catSearch.addFieldName("VOLSER");
        catSearch.addFieldName("STORCLAS");
        catSearch.addFieldName("DATACLAS");
        catSearch.addFieldName("MGMTCLAS");
        catSearch.search();
        while (catSearch.hasNext()) {
            CatalogSearch.Entry entry = (CatalogSearch.Entry)catSearch.next();
            if (!entry.isDatasetEntry()) continue;
            PDSInfo pds = new PDSInfo();
            CatalogSearchField field = entry.getField("ENTNAME");
            String dsn = field.getFString().trim();
            String hlq = "";
            int ind2 = criteria.indexOf(".");
            if (ind2 > -1) {
                hlq = dsn.substring(0, ind2);
            }
            String shortDSname = this.removeDefaultHLQ(dsn, hlq);
            pds.setDSName(shortDSname);
            pds.setHLQ(hlq);
            field = entry.getField("ENTYPE");
            String entype = field.getFString();
            field = entry.getField("VOLSER");
            String vol = field.getFString();
            pds.setVolume(vol);
            field = entry.getField("STORCLAS");
            String storage = field.getVString();
            pds.setStorageClass(storage);
            field = entry.getField("DATACLAS");
            String dtacls = field.getVString();
            field = entry.getField("MGMTCLAS");
            String mgtcls = field.getVString();
            StringBuffer bf = new StringBuffer();
            bf.append("'");
            bf.append(dsn);
            bf.append("'");
            String qdsn = bf.toString();
            String msg = "";
            int dsorg = 0;
            String recfm = "";
            if ("A".equals(entype)) {
                try {
                    Format1DSCB dscb = ZFile.obtainDSN((String)qdsn, (String)vol);
                    Format8DSCB dscb8 = null;
                    if (dscb == null) {
                        DSCB[] controlBlocks;
                        DSCB[] dSCBArray = controlBlocks = ZFile.readDSCBChain((String)qdsn, (String)vol);
                        int n = controlBlocks.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DSCB controlBlock = dSCBArray[n2];
                            if (controlBlock instanceof Format8DSCB) {
                                dscb8 = (Format8DSCB)controlBlock;
                            } else if (controlBlock instanceof Format1DSCB) {
                                dscb = (Format1DSCB)controlBlock;
                            }
                            ++n2;
                        }
                    }
                    if (dscb == null && dscb8 == null) {
                        throw new RcException(Messages.ZIMPORT_INV_VOL_DSCB_2, 8);
                    }
                    int blksize = dscb != null ? dscb.getDS1BLKL() : dscb8.getDS1BLKL();
                    pds.setBlksize(blksize);
                    int lrecl = dscb != null ? dscb.getDS1LRECL() : dscb8.getDS1LRECL();
                    pds.setLrecl(lrecl);
                    int format = dscb != null ? dscb.getDS1RECFM() : dscb8.getDS1RECFM();
                    recfm = this.retrieveRecfm(format);
                    pds.setRecfm(recfm);
                    int space = dscb != null ? dscb.getDS1SCAL1() : dscb8.getDS1SCAL1();
                    pds.setSpaceUnit(this.retrieveSpace(space));
                    int sqty = dscb != null ? dscb.getDS1SCAL3() : dscb8.getDS1SCAL3();
                    pds.setSecondary(sqty);
                    dsorg = dscb != null ? dscb.getDS1DSORG() : dscb8.getDS1DSORG();
                }
                catch (RcException rce) {
                    String reason = "";
                    int rc = rce.getRc();
                    if (rc == 4) {
                        reason = Messages.ZIMPORT_VOL_NOT_MOUNTED;
                    } else if (rc == 8) {
                        reason = Messages.ZIMPORT_INV_VOL_DSCB_2;
                    }
                    msg = NLS.bind((String)Messages.ZIMPORT_DTSET_SKIP, (Object[])new Object[]{rc, reason, dsn});
                    this.invalidDatasetStatuses.add((IStatus)new Status(4, "com.ibm.teamz.fileagent", msg));
                }
            }
            if (!"".equals(msg)) continue;
            if ("A".equals(entype) && dsorg == 512) {
                dSets.add(pds);
                PDSManager.log(pds.displayString());
                continue;
            }
            if (!"X".equals(entype)) continue;
            field = entry.getField("NAME");
            String realTargeted = field.getFString().trim();
            if (realTargeted != null && realTargeted.length() > 0) {
                pds.setRelated(this.removeDefaultHLQ(realTargeted, hlq));
                pds.getRelatedInfo();
            }
            dSets.add(pds);
            PDSManager.log(pds.displayString());
        }
        return dSets;
    }

    @Override
    public List<PDSMemberInfo> listMembers(PDSInfo pds) throws IOException {
        ArrayList<PDSMemberInfo> members = new ArrayList<PDSMemberInfo>();
        ArrayList<String> mbrsLst = new ArrayList<String>();
        String pdsname = pds.getQuoteDSName();
        String hlq = pds.getHLQ();
        String name = "";
        name = pdsname.replaceFirst("//'", "");
        name = name.replaceFirst("'", "");
        String dsn = this.removeDefaultHLQ(name, hlq);
        PdsDirectory dir = null;
        boolean success = false;
        try {
            dir = new PdsDirectory(pdsname);
            for (PdsDirectory.MemberInfo info : dir) {
                String mbrName = info.getName();
                mbrsLst.add(mbrName);
            }
            success = true;
        }
        finally {
            block11: {
                if (dir != null) {
                    try {
                        dir.close();
                    }
                    catch (IOException e) {
                        if (!success) break block11;
                        success = false;
                        throw e;
                    }
                }
            }
        }
        for (String member : mbrsLst) {
            PDSMemberInfo mbr = new PDSMemberInfo();
            mbr.setMbrName(member);
            mbr.setDataSetName(dsn);
            mbr.setPDSInfo(pds);
            members.add(mbr);
        }
        return members;
    }

    private String removeDefaultHLQ(String dsn, String defaultHLQ) {
        StringBuffer bf = new StringBuffer();
        bf.append(defaultHLQ);
        bf.append(".");
        return dsn.replaceFirst(bf.toString(), "");
    }

    private String retrieveBufferForJazzSCM(BufferedReader in) throws IOException {
        BufferedReader inputReader = in;
        StringBuffer buffer = new StringBuffer();
        String line = "";
        boolean success = false;
        try {
            while ((line = inputReader.readLine()) != null) {
                buffer.append(line);
                buffer.append('\n');
            }
            success = true;
        }
        finally {
            block10: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        if (!success) break block10;
                        success = false;
                        throw e;
                    }
                }
            }
        }
        String inString = buffer.toString();
        return inString;
    }

    private String retrieveInputStreamForJazzSCM(InputStream input) throws IOException {
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(input));
        StringBuffer buffer = new StringBuffer();
        String line = "";
        boolean success = false;
        try {
            while ((line = inputReader.readLine()) != null) {
                buffer.append(line);
                buffer.append('\n');
            }
            success = true;
        }
        finally {
            block10: {
                if (inputReader != null) {
                    try {
                        inputReader.close();
                    }
                    catch (IOException e) {
                        if (!success) break block10;
                        success = false;
                        throw e;
                    }
                }
            }
        }
        String inString = buffer.toString();
        return inString;
    }

    private String retrieveRecfm(int format) {
        String recfm = "";
        if (format == 128) {
            recfm = MappingConstants.RECORD_FORMAT_FIXED;
        }
        if (format == 144) {
            recfm = MappingConstants.RECORD_FORMAT_FB;
        }
        if (format == 132) {
            recfm = MappingConstants.RECORD_FORMAT_FA;
        }
        if (format == 130) {
            recfm = MappingConstants.RECORD_FORMAT_FM;
        }
        if (format == 148) {
            recfm = MappingConstants.RECORD_FORMAT_FBA;
        }
        if (format == 146) {
            recfm = MappingConstants.RECORD_FORMAT_FBM;
        }
        if (format == 64) {
            recfm = MappingConstants.RECORD_FORMAT_VARIABLE;
        }
        if (format == 80) {
            recfm = MappingConstants.RECORD_FORMAT_VB;
        }
        if (format == 68) {
            recfm = MappingConstants.RECORD_FORMAT_VA;
        }
        if (format == 66) {
            recfm = MappingConstants.RECORD_FORMAT_VM;
        }
        if (format == 84) {
            recfm = MappingConstants.RECORD_FORMAT_VBA;
        }
        if (format == 82) {
            recfm = MappingConstants.RECORD_FORMAT_VBM;
        }
        if (format == 192) {
            recfm = MappingConstants.RECORD_FORMAT_UNDEFINED;
        }
        return recfm;
    }

    private String retrieveSpace(int unit) {
        String space = "";
        space = unit == 192 ? "cyls" : (unit == 128 ? "trks" : "blks");
        return space;
    }

    public static String retrieveEncoding() {
        String encoding = "";
        String zLang = System.getenv("ZLANG");
        encoding = zLang != null && zLang.length() > 0 ? zLang : FileFactory.getDefaultZFileEncoding();
        return encoding;
    }

    private String retrieveContent(PDSMemberInfo mbr) throws IOException {
        PDSInfo pds = mbr.getPDSInfo();
        String content = "";
        String recfm = pds.getRecfm();
        String pdsname = pds.getQuoteDSName();
        String name = "";
        name = pdsname.replaceFirst("//'", "");
        name = name.replaceFirst("'", "");
        StringBuffer bf = new StringBuffer();
        bf.append(name);
        bf.append("(");
        bf.append(mbr.getName());
        bf.append(")");
        String fullMbrName = bf.toString();
        StringBuffer bf2 = new StringBuffer();
        bf2.append("//'");
        bf2.append(fullMbrName);
        bf2.append("'");
        String mName = bf2.toString();
        BufferedReader br = null;
        BufferedInputStream bis = null;
        boolean success = false;
        try {
            if (!"U".equals(recfm)) {
                String encoding = PDSManager.retrieveEncoding();
                br = FileFactory.newBufferedReader((String)mName, (String)encoding);
                content = this.retrieveBufferForJazzSCM(br);
            } else {
                bis = FileFactory.newBufferedInputStream((String)mName);
                content = this.retrieveInputStreamForJazzSCM(bis);
            }
            success = true;
        }
        finally {
            block17: {
                block16: {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            if (!success) break block16;
                            success = false;
                            throw e;
                        }
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        if (!success) break block17;
                        success = false;
                        throw e;
                    }
                }
            }
        }
        return content;
    }

    private ByteArrayOutputStream retrieveBytesFromContent(String content) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.write((String)content, (OutputStream)bos, (String)"UTF-8");
        return bos;
    }
}

