/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.core;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.utility.InternalRepoUtility;
import com.ibm.teamz.fileagent.internal.utility.PasswordHelper;
import com.ibm.teamz.fileagent.operations.ConnectionInfo;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class RepositoryUtility {
    public static boolean fromZos = true;

    static {
        new RepositoryUtility();
    }

    private RepositoryUtility() {
    }

    public static ITeamRepository login(ConnectionInfo connInfo) throws FileAgentRepositoryException {
        ITeamRepository repo = InternalRepoUtility.getTeamRepository(connInfo.getJazzRepositoryUri(), connInfo.getUserId(), connInfo.getClearPassword(), connInfo.getCertificateFile(), connInfo.getSmartCard(), connInfo.getKerberos());
        InternalRepoUtility.login(repo);
        return repo;
    }

    public static ITeamRepository login(String uri, String username, String password) throws FileAgentRepositoryException {
        ITeamRepository repo = null;
        try {
            password = PasswordHelper.getClearPassword(password);
        }
        catch (GeneralSecurityException e) {
            throw new FileAgentRepositoryException(Messages.INVALID_PASSWORD, e);
        }
        repo = InternalRepoUtility.getTeamRepository(uri, username, password, null, null, null);
        InternalRepoUtility.login(repo);
        return repo;
    }

    public static ITeamRepository login(String uri, String username, String password, String certificateFile) throws FileAgentRepositoryException {
        ITeamRepository repo = null;
        try {
            password = PasswordHelper.getClearPassword(password);
        }
        catch (GeneralSecurityException e) {
            throw new FileAgentRepositoryException(Messages.INVALID_PASSWORD, e);
        }
        repo = InternalRepoUtility.getTeamRepository(uri, username, password, certificateFile, null, null);
        InternalRepoUtility.login(repo);
        return repo;
    }

    public static ITeamRepository login(String uri, String username, String password, String certificateFile, String smartCard) throws FileAgentRepositoryException {
        ITeamRepository repo = null;
        try {
            password = PasswordHelper.getClearPassword(password);
        }
        catch (GeneralSecurityException e) {
            throw new FileAgentRepositoryException(Messages.INVALID_PASSWORD, e);
        }
        repo = InternalRepoUtility.getTeamRepository(uri, username, password, certificateFile, smartCard, null);
        InternalRepoUtility.login(repo);
        return repo;
    }

    public static ITeamRepository login(String uri, String username, String password, String certificateFile, String smartCard, String kerberos) throws FileAgentRepositoryException {
        ITeamRepository repo = null;
        try {
            password = PasswordHelper.getClearPassword(password);
        }
        catch (GeneralSecurityException e) {
            throw new FileAgentRepositoryException(Messages.INVALID_PASSWORD, e);
        }
        repo = InternalRepoUtility.getTeamRepository(uri, username, password, certificateFile, smartCard, kerberos);
        InternalRepoUtility.login(repo);
        return repo;
    }

    public static IComponentHandle getComponentHandleFromStringUUID(String componentId, ITeamRepository repository) throws FileAgentRepositoryException {
        UUID componentUuid = null;
        try {
            componentUuid = UUID.valueOf((String)componentId);
        }
        catch (IllegalArgumentException exception) {
            throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_INVALID_COMPONENT_UUID, (Object)componentId), exception);
        }
        return RepositoryUtility.getComponentHandleFromUUID(componentUuid, repository);
    }

    public static IComponentHandle getComponentHandleFromUUID(UUID componentUuid, ITeamRepository repository) throws FileAgentRepositoryException {
        IComponentHandle compH = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUuid, null);
        return compH;
    }

    public static List<IComponentHandle> getComponentHandlesFromSelector(String selector, ITeamRepository repository) throws FileAgentRepositoryException {
        List<Object> componentHandles = new ArrayList<IComponentHandle>();
        try {
            UUID uuid = UUID.valueOf((String)selector);
            componentHandles.add(RepositoryUtility.getComponentHandleFromUUID(uuid, repository));
            return componentHandles;
        }
        catch (IllegalArgumentException uuid) {
            IComponentSearchCriteria criteria = IComponentSearchCriteria.FACTORY.newInstance().setExactName(selector);
            try {
                componentHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).findComponents(criteria, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (TeamRepositoryException e) {
                throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_COULD_NOT_FIND_COMPONENT, (Object)selector), e);
            }
            return componentHandles;
        }
    }

    public static IWorkspace getWorkspaceFromName(String workspaceName, ITeamRepository repository) throws FileAgentRepositoryException {
        ArrayList<IWorkspace> workspaces;
        block8: {
            try {
                UUID.valueOf((String)workspaceName);
                return RepositoryUtility.getWorkspaceFromUUID(workspaceName, repository);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ArrayList workspaceHandles = new ArrayList();
                IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setExactName(workspaceName);
                try {
                    List foundWorkspaceHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).findWorkspaces(criteria, Integer.MAX_VALUE, null);
                    workspaceHandles.addAll(foundWorkspaceHandles);
                }
                catch (TeamRepositoryException e) {
                    throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_COULD_NOT_FIND_WORKSPACE, (Object)workspaceName), e);
                }
                workspaces = new ArrayList<IWorkspace>();
                if (workspaceHandles.size() <= 0) break block8;
                try {
                    List fetchedWorkspaces = repository.itemManager().fetchCompleteItems(workspaceHandles, 0, null);
                    for (IWorkspace workspace : fetchedWorkspaces) {
                        if (workspace == null || !workspace.isStream()) continue;
                        workspaces.add(workspace);
                    }
                }
                catch (TeamRepositoryException e) {
                    throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_COULD_NOT_FIND_WORKSPACE, (Object)workspaceName), e);
                }
            }
        }
        if (workspaces.size() > 0) {
            return (IWorkspace)workspaces.get(0);
        }
        return null;
    }

    public static IWorkspace getWorkspaceFromUUID(String workspaceUUID, ITeamRepository repository) throws FileAgentRepositoryException {
        UUID workspaceUuid = null;
        try {
            workspaceUuid = UUID.valueOf((String)workspaceUUID);
        }
        catch (IllegalArgumentException exception) {
            throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_INVALID_WORKSPACE_UUID, (Object)workspaceUUID), exception);
        }
        return RepositoryUtility.getWorkspaceFromUUID(workspaceUuid, repository);
    }

    public static IWorkspace getWorkspaceFromUUID(UUID workspaceUuid, ITeamRepository repository) throws FileAgentRepositoryException {
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
        IItem item = null;
        try {
            item = repository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamRepositoryException e) {
            throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_MISSING_WORKSPACE, (Object)workspaceUuid.toString()), e);
        }
        if (!(item instanceof IWorkspace)) {
            throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_WRONG_TYPE_WORKSPACE, (Object)workspaceUuid.toString(), (Object)item.getItemType().getName()));
        }
        return (IWorkspace)item;
    }

    public static IComponentHandle getComponentHandleFromUUID(String componentUUID, IWorkspaceConnection wksConnection) {
        List components = null;
        try {
            components = wksConnection.getComponents();
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        IComponentHandle ich = null;
        UUID compUUID = UUID.valueOf((String)componentUUID);
        for (IComponentHandle comp : components) {
            if (!comp.getItemId().equals((Object)compUUID)) continue;
            ich = comp;
            break;
        }
        return ich;
    }

    public static IFileItemHandle getFileItemHandleFromUUID(String fileId, String stateId, ITeamRepository repository) throws TeamRepositoryException {
        UUID fileUUID = UUID.valueOf((String)fileId);
        IFileItemHandle filehandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repository, fileUUID, null);
        IVersionable versionable = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).versionableManager().fetchCompleteState((IVersionableHandle)filehandle, null);
        IItemHandle ith = versionable.getItemHandle();
        if (ith instanceof IFileItemHandle) {
            return (IFileItemHandle)ith;
        }
        return null;
    }
}

