/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent;

import com.ibm.jzos.ZUtil;
import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teamz.fileagent.internal.extensions.impl.MVSStorageManager;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.operations.LoadOperationDilemmaHandler;
import com.ibm.teamz.fileagent.internal.xml.OperationListParser;
import com.ibm.teamz.fileagent.macrooperations.IMacroOperation;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class Zutility {
    public static void zload2(ITeamRepository repository, IWorkspaceHandle workspaceHandle, String ussPrefix, String mvsPrefix, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection wsToLoad = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(workspaceHandle, monitor);
        Zutility.zload2(repository, wsToLoad, ussPrefix, mvsPrefix, monitor);
    }

    public static void zload2(ITeamRepository repository, IWorkspaceConnection workspaceConnection, String ussPrefix, String mvsPrefix, IProgressMonitor monitor) throws TeamRepositoryException {
        List components = repository.itemManager().fetchCompleteItems(workspaceConnection.getComponents(), 1, monitor);
        Zutility.zload2(repository, workspaceConnection, components, ussPrefix, mvsPrefix, monitor);
    }

    public static void zload2(ITeamRepository repository, IWorkspaceConnection workspaceConnection, List<IComponent> components, String ussPrefix, String mvsPrefix, IProgressMonitor monitor) throws TeamRepositoryException {
        Zutility.zload2(repository, workspaceConnection, components, ussPrefix, mvsPrefix, false, monitor);
    }

    public static void zload2(ITeamRepository repository, IWorkspaceConnection workspaceConnection, List<IComponent> components, String ussPrefix, String mvsPrefix, boolean bDeregister, IProgressMonitor monitor) throws TeamRepositoryException {
        if (mvsPrefix != null && mvsPrefix.trim().length() > 0) {
            Zutility.zloadOnMVS(workspaceConnection, components, mvsPrefix, bDeregister, monitor);
        }
        if (ussPrefix != null && ussPrefix.trim().length() > 0) {
            Zutility.zloadOnUSS(true, workspaceConnection, components, ussPrefix, bDeregister, monitor);
        }
    }

    public static void zloadOnUSS(boolean filtered, IWorkspaceConnection workspaceConnection, List<IComponent> components, String ussPrefix, IProgressMonitor monitor) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        Zutility.zloadOnUSS(filtered, workspaceConnection, components, ussPrefix, false, monitor);
    }

    public static void zloadOnUSS(boolean filtered, IWorkspaceConnection workspaceConnection, List<IComponent> components, String ussPrefix, boolean bDeregister, IProgressMonitor monitor) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException(Messages.Zutility_0);
        }
        if (components.isEmpty()) {
            throw new IllegalArgumentException(Messages.Zutility_1);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ILoadOperation loadOp = null;
        PathLocation path = new PathLocation(ussPrefix);
        path = (PathLocation)path.getCanonicalForm();
        ISandbox hfsSandbox = FileSystemCore.getSharingManager().getSandbox((ILocation)path, false);
        try {
            loadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)new LoadOperationDilemmaHandler());
            if (filtered) {
                ILoadFilter filter = LoadFilter.exclude((String[])new String[]{"zOSsrc", ".zOSbin", "zOSout"});
                loadOp.setLoadFilter(filter);
            }
            for (IComponent component : components) {
                loadOp.requestLoad(hfsSandbox, null, workspaceConnection, (IComponentHandle)component, workspaceConnection.configuration((IComponentHandle)component).childEntries(component.getRootFolder(), null).values());
            }
            loadOp.run((IProgressMonitor)progress.newChild(99));
        }
        finally {
            if (bDeregister) {
                FileSystemCore.getSharingManager().deregister(hfsSandbox, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static void zloadOnMVS(IWorkspaceConnection workspaceConnection, List<IComponent> components, String mvsPrefix, IProgressMonitor monitor) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        Zutility.zloadOnMVS(workspaceConnection, components, mvsPrefix, false, monitor);
    }

    public static void zloadOnMVS(IWorkspaceConnection workspaceConnection, List<IComponent> components, String mvsPrefix, boolean bDeregister, IProgressMonitor monitor) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException(Messages.Zutility_0);
        }
        if (components.isEmpty()) {
            throw new IllegalArgumentException(Messages.Zutility_1);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ILoadOperation loadOp = null;
        ISandbox mvsSandbox = FileSystemCore.getSharingManager().getSandbox((ILocation)new DataSetLocation(mvsPrefix), false);
        try {
            loadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)new LoadOperationDilemmaHandler());
            for (IComponent component : components) {
                loadOp.requestLoad(mvsSandbox, null, workspaceConnection, (IComponentHandle)component, workspaceConnection.configuration((IComponentHandle)component).childEntries(component.getRootFolder(), null).values());
            }
            loadOp.run((IProgressMonitor)progress.newChild(99));
        }
        finally {
            if (bDeregister) {
                FileSystemCore.getSharingManager().deregister(mvsSandbox, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static void zloadxml(String jazzServerUri, String userId, String password, String operationListFile, IProgressMonitor monitor) throws Exception {
        OperationListParser parser = new OperationListParser(jazzServerUri, userId, password, null, null, null);
        IMacroOperation operation = parser.createMacroOperation(operationListFile);
        Zutility.runMacroOperation(operation, monitor);
    }

    public static void zloadxml(ITeamRepository repository, String operationListFile, IProgressMonitor monitor) throws Exception {
        OperationListParser parser = new OperationListParser(repository);
        IMacroOperation operation = parser.createMacroOperation(operationListFile);
        Zutility.runMacroOperation(operation, monitor);
    }

    public static void zloadxml(String jazzServerUri, String userId, String password, InputStream operationListStream, IProgressMonitor monitor) throws Exception {
        OperationListParser parser = new OperationListParser(jazzServerUri, userId, password, null, null, null);
        IMacroOperation operation = parser.createMacroOperation(operationListStream);
        Zutility.runMacroOperation(operation, monitor);
    }

    public static void zloadxml(ITeamRepository repository, InputStream operationListStream, IProgressMonitor monitor) throws Exception {
        OperationListParser parser = new OperationListParser(repository);
        IMacroOperation operation = parser.createMacroOperation(operationListStream);
        Zutility.runMacroOperation(operation, monitor);
    }

    private static void runMacroOperation(IMacroOperation operation, IProgressMonitor monitor) throws Exception {
        operation.run(monitor);
    }

    public static String getDefaultPlatformEncoding() {
        if (MVSStorageManager.SIMULATION_ENABLED) {
            return "IBM-1047";
        }
        return ZUtil.getDefaultPlatformEncoding();
    }
}

