/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent;

import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.CatalogSearchField;
import com.ibm.jzos.DSCB;
import com.ibm.jzos.Format1DSCB;
import com.ibm.jzos.Format8DSCB;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingConstants;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.teamz.fileagent.importz.PDSInfo;
import com.ibm.teamz.fileagent.importz.PDSManagerException;
import com.ibm.teamz.fileagent.internal.messages.Messages;

public class PDSUtility {
    private static final String QuotedDsn = "//'%1$s'";

    private PDSUtility() {
    }

    public static boolean isPDSExists(String name) {
        boolean isExist = false;
        try {
            isExist = ZFile.dsExists((String)String.format(QuotedDsn, name));
        }
        catch (ZFileException e) {
            isExist = false;
        }
        return isExist;
    }

    public static PDSInfo getPDSCharacteristics(String pdsname) throws PDSManagerException {
        return PDSUtility.getPDSCharacteristics(pdsname, true);
    }

    public static PDSInfo getPDSCharacteristics(String pdsname, boolean doDSCB) throws PDSManagerException {
        PDSInfo pdsInfo = new PDSInfo();
        CatalogSearch catSearch = PDSUtility.doCatalogSearch(pdsname);
        while (catSearch.hasNext()) {
            CatalogSearch.Entry entry = (CatalogSearch.Entry)catSearch.next();
            if (!entry.isDatasetEntry()) continue;
            PDSInfo pds = new PDSInfo();
            CatalogSearchField field = entry.getField("ENTNAME");
            String dsn = field.getFString().trim();
            String hlq = "";
            int ind2 = pdsname.indexOf(".");
            if (ind2 > -1) {
                hlq = dsn.substring(0, ind2);
            }
            String shortDSname = PDSUtility.removeDefaultHLQ(dsn, hlq);
            pds.setDSName(shortDSname);
            pds.setHLQ(hlq);
            field = entry.getField("ENTYPE");
            String entype = field.getFString();
            field = entry.getField("VOLSER");
            String vol = field.getFString();
            pds.setVolume(vol);
            field = entry.getField("STORCLAS");
            String storage = field.getVString();
            pds.setStorageClass(storage);
            field = entry.getField("DATACLAS");
            String dtacls = field.getVString();
            pds.setDataClass(dtacls);
            field = entry.getField("MGMTCLAS");
            String mgtcls = field.getVString();
            pds.setManagementClass(mgtcls);
            field = entry.getField("PRIMSPAC");
            int primary = field.getInt();
            pds.setPrimary(primary);
            StringBuffer bf = new StringBuffer();
            bf.append("'");
            bf.append(dsn);
            bf.append("'");
            String qdsn = bf.toString();
            if ("A".equals(entype) && doDSCB) {
                try {
                    Format1DSCB dscb = ZFile.obtainDSN((String)qdsn, (String)vol);
                    Format8DSCB dscb8 = null;
                    if (dscb == null) {
                        DSCB[] controlBlocks;
                        DSCB[] dSCBArray = controlBlocks = ZFile.readDSCBChain((String)qdsn, (String)vol);
                        int n = controlBlocks.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DSCB controlBlock = dSCBArray[n2];
                            if (controlBlock instanceof Format8DSCB) {
                                dscb8 = (Format8DSCB)controlBlock;
                            } else if (controlBlock instanceof Format1DSCB) {
                                dscb = (Format1DSCB)controlBlock;
                            }
                            ++n2;
                        }
                    }
                    if (dscb == null && dscb8 == null) {
                        throw new RcException(Messages.ZIMPORT_INV_VOL_DSCB_2, 8);
                    }
                    int blksize = dscb != null ? dscb.getDS1BLKL() : dscb8.getDS1BLKL();
                    pds.setBlksize(blksize);
                    int lrecl = dscb != null ? dscb.getDS1LRECL() : dscb8.getDS1LRECL();
                    pds.setLrecl(lrecl);
                    int recfm = dscb != null ? dscb.getDS1RECFM() : dscb8.getDS1RECFM();
                    pds.setRecfm(PDSUtility.convertRecfm(recfm));
                    int space = dscb != null ? dscb.getDS1SCAL1() : dscb8.getDS1SCAL1();
                    pds.setSpaceUnit(PDSUtility.convertSpaceUnit(space));
                    int secondary = dscb != null ? dscb.getDS1SCAL3() : dscb8.getDS1SCAL3();
                    pds.setSecondary(secondary);
                    int dsorg = dscb != null ? dscb.getDS1DSORG() : dscb8.getDS1DSORG();
                    pds.setDsorg(PDSUtility.convertDsorg(dsorg));
                }
                catch (RcException rce) {
                    int rc = rce.getRc();
                    String reason = rc == 4 ? Messages.ZIMPORT_VOL_NOT_MOUNTED : (rc == 8 ? Messages.ZIMPORT_INV_VOL_DSCB_2 : "");
                    String msg = NLS.bind((String)Messages.ZIMPORT_DTSET_SKIP, (Object)rc, (Object[])new Object[]{reason, dsn});
                    throw new PDSManagerException(msg);
                }
                pdsInfo = pds;
                continue;
            }
            if ("X".equals(entype) && doDSCB) {
                field = entry.getField("NAME");
                String realTargeted = field.getFString().trim();
                if (realTargeted != null && realTargeted.length() > 0) {
                    pds.setRelated(PDSUtility.removeDefaultHLQ(realTargeted, hlq));
                    pds.getRelatedInfo();
                }
                pdsInfo = pds;
                continue;
            }
            pdsInfo = pds;
            pdsInfo.setDSCB(doDSCB);
        }
        return pdsInfo;
    }

    private static CatalogSearch doCatalogSearch(String pdsname) {
        CatalogSearch catSearch = new CatalogSearch(pdsname);
        catSearch.addFieldName("ENTNAME");
        catSearch.addFieldName("NAME");
        catSearch.addFieldName("ENTYPE");
        catSearch.addFieldName("NVSMATTR");
        catSearch.addFieldName("VOLSER");
        catSearch.addFieldName("STORCLAS");
        catSearch.addFieldName("DATACLAS");
        catSearch.addFieldName("MGMTCLAS");
        catSearch.addFieldName("PRIMSPAC");
        catSearch.search();
        return catSearch;
    }

    private static String convertDsorg(int dsorg) {
        String result = (dsorg & 0x200) != 0 ? "PO" : ((dsorg & 0x4000) != 0 ? "PS" : ((dsorg & 0x4000) != 0 ? "PS" : ((dsorg & 8) != 0 ? "VSAM" : "UNK")));
        return result;
    }

    private static String convertRecfm(int recfm) {
        String result;
        switch (recfm) {
            case 128: {
                result = MappingConstants.RECORD_FORMAT_FIXED;
                break;
            }
            case 144: {
                result = MappingConstants.RECORD_FORMAT_FB;
                break;
            }
            case 132: {
                result = MappingConstants.RECORD_FORMAT_FA;
                break;
            }
            case 130: {
                result = MappingConstants.RECORD_FORMAT_FM;
                break;
            }
            case 148: {
                result = MappingConstants.RECORD_FORMAT_FBA;
                break;
            }
            case 146: {
                result = MappingConstants.RECORD_FORMAT_FBM;
                break;
            }
            case 64: {
                result = MappingConstants.RECORD_FORMAT_VARIABLE;
                break;
            }
            case 80: {
                result = MappingConstants.RECORD_FORMAT_VB;
                break;
            }
            case 68: {
                result = MappingConstants.RECORD_FORMAT_VA;
                break;
            }
            case 66: {
                result = MappingConstants.RECORD_FORMAT_VM;
                break;
            }
            case 84: {
                result = MappingConstants.RECORD_FORMAT_VBA;
                break;
            }
            case 82: {
                result = MappingConstants.RECORD_FORMAT_VBM;
                break;
            }
            case 192: {
                result = MappingConstants.RECORD_FORMAT_UNDEFINED;
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private static String convertSpaceUnit(int space) {
        String result;
        switch (space) {
            case 192: {
                result = "cyls";
                break;
            }
            case 128: {
                result = "trks";
                break;
            }
            default: {
                result = "blks";
            }
        }
        return result;
    }

    private static String removeDefaultHLQ(String dsn, String defaultHLQ) {
        StringBuffer bf = new StringBuffer();
        bf.append(defaultHLQ);
        bf.append(".");
        return dsn.replaceFirst(bf.toString(), "");
    }
}

