/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.rseminer;

import com.ibm.teamz.fileagent.ExecuteXMLFileCapacity;
import com.ibm.teamz.fileagent.miner.IFileAgentMiner;
import com.ibm.teamz.fileagent.miner.IFileAgentMinerConstant;
import com.ibm.teamz.internal.fileagent.miner.nls.Messages;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.dstore.core.model.ByteStreamHandler;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.xml.sax.SAXParseException;

public class FileAgentByteStreamHandler
extends ByteStreamHandler
implements IFileAgentMinerConstant {
    private static final Log logger = LogFactory.getLog(FileAgentByteStreamHandler.class);
    private IFileAgentMiner _miner;

    static {
        ExecuteXMLFileCapacity.SCMEE = true;
    }

    public String getId() {
        return "com.ibm.teamz.common.fileagent.FileAgentByteStreamHandler";
    }

    public FileAgentByteStreamHandler(DataStore dataStore, DataElement log) {
        super(dataStore, log);
    }

    public IFileAgentMiner getMiner() {
        return this._miner;
    }

    public void setMiner(IFileAgentMiner miner) {
        this._miner = miner;
    }

    public void receiveBytes(String remotePath, byte[] buffer, int size, boolean binary) {
        logger.debug((Object)("ByteStreamHandler receiveBytes " + remotePath));
        String[] params = remotePath.split("@");
        String URI = params[0];
        String userId = this.getMiner().getUser(URI);
        String password = this.getMiner().getPasswd(URI);
        DataElement status = null;
        try {
            logger.debug((Object)("ByteStreamHandler receiveBytes URI=" + URI + "user" + userId + " pwd " + password));
            status = this.findStatusFor(remotePath);
            if (status == null) {
                logger.debug((Object)("upload status object not found for " + remotePath));
                logger.debug((Object)("log parent element name " + this._log.getParent().getAttribute(2)));
                logger.debug((Object)("log element name " + this._log.getAttribute(2)));
                int i = 0;
                while (i < this._log.getNestedSize()) {
                    DataElement target = this._log.get(i);
                    logger.debug((Object)("log child element name " + i + "= " + target.getAttribute(2) + " current value " + target.getAttribute(3)));
                    ++i;
                }
                throw new Exception(Messages.InvalidRSEConnection2);
            }
            logger.debug((Object)("calling File Agent for " + remotePath + "size= " + size + "buf.length=" + buffer.length));
            ExecuteXMLFileCapacity.executeXMLFileCapacity((String)URI, (String)userId, (String)password, (InputStream)new ByteArrayInputStream(buffer, 0, size), (boolean)true);
            status.setAttribute(4, "success");
            logger.debug((Object)("File Agent processed successfully " + remotePath));
            this._dataStore.refresh(status.getParent());
        }
        catch (SAXParseException e) {
            try {
                String filePath = "X" + params[1] + ".xml";
                FileOutputStream stream = new FileOutputStream(filePath);
                ((OutputStream)stream).write(buffer);
                ((OutputStream)stream).close();
                logger.error((Object)("SAX Error parsing: " + filePath + " line number= " + e.getLineNumber() + " column number= " + e.getColumnNumber()));
                this.reportFailureStatus(status, e);
            }
            catch (Exception e2) {
                this.reportFailureStatus(status, e2);
            }
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
            logger.debug((Object)("File Agent Exception " + t.getMessage() + " for " + remotePath));
            this.reportFailureStatus(status, t);
        }
    }

    private void reportFailureStatus(DataElement status, Throwable t) {
        if (status != null) {
            status.setAttribute(4, "failed");
            String error = t.toString();
            if (t.getCause() != null) {
                error = String.valueOf(error) + ":" + t.getCause().toString();
            }
            status.setAttribute(3, error);
            this._dataStore.refresh(status.getParent());
        }
    }
}

