/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.connection;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.internal.connection.ConnectionParameters;
import com.ibm.teamz.rseminer.FileAgentMiner;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager {
    private static final Log logger = LogFactory.getLog(FileAgentMiner.class);
    private static HashMap connections = new HashMap();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void init(String path) throws FileNotFoundException {
        logger.debug((Object)("Load config file : " + path));
        BufferedReader in = new BufferedReader(new FileReader(path));
        try {
            while (true) {
                String line;
                if ((line = in.readLine()) == null) {
                    in.close();
                    break;
                }
                logger.debug((Object)("Line " + line));
                if (!line.contains(",")) continue;
                String[] temp = line.split(",");
                Matcher matcher = null;
                Pattern pattern = Pattern.compile("(http(s{0,1})://)([^/:]+)((:[0-9]*){0,1}(/.*){0,1})");
                matcher = pattern.matcher(temp[0]);
                if (matcher.matches()) {
                    String protocol = matcher.group(1);
                    String host = matcher.group(3);
                    String end = matcher.group(4);
                    try {
                        InetAddress myself = InetAddress.getByName(host);
                        String hostAddress = String.valueOf(protocol) + myself.getHostAddress() + end;
                        connections.put(hostAddress, new ConnectionParameters(hostAddress, temp[1], temp[2]));
                        logger.debug((Object)("Add " + hostAddress + " user: " + temp[1]));
                        hostAddress = String.valueOf(protocol) + myself.getHostName() + end;
                        connections.put(hostAddress, new ConnectionParameters(hostAddress, temp[1], temp[2]));
                        logger.debug((Object)("Add " + hostAddress + " user: " + temp[1]));
                    }
                    catch (Exception e) {
                        connections.put(temp[0], new ConnectionParameters(temp[0], temp[1], temp[2]));
                        logger.debug((Object)("Add " + temp[0] + " user: " + temp[1]));
                    }
                    continue;
                }
                connections.put(temp[0], new ConnectionParameters(temp[0], temp[1], temp[2]));
                logger.debug((Object)("Add " + temp[0] + " user: " + temp[1]));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.debug((Object)("Load config file : " + path + " done"));
    }

    public static ITeamRepository getIteamConnection(String URL) throws FileAgentRepositoryException {
        logger.debug((Object)("getIteamConnection:" + URL));
        ConnectionParameters connexion = (ConnectionParameters)connections.get(URL);
        if (connexion != null) {
            return connexion.getITeamConnection();
        }
        return null;
    }

    public static boolean checkIteamRepository(String URL) {
        logger.debug((Object)("checkIteamRepository:" + URL));
        ConnectionParameters connexion = (ConnectionParameters)connections.get(URL);
        return connexion != null;
    }

    public static String getUser(String URL) {
        ConnectionParameters connexion = (ConnectionParameters)connections.get(URL);
        if (connexion != null) {
            return connexion.getUser();
        }
        return null;
    }

    public static String getPasswd(String URL) {
        ConnectionParameters connexion = (ConnectionParameters)connections.get(URL);
        if (connexion != null) {
            return connexion.getPasswd();
        }
        return null;
    }
}

