/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal.zcomponents;

import com.ibm.team.enterprise.common.common.AntzBuildNature;
import com.ibm.team.enterprise.common.common.RdzLocalNature;
import com.ibm.team.enterprise.common.common.ZComponentException;
import com.ibm.team.enterprise.common.common.ZComponentNature;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.util.VersionedContentManagerByteArrayInputStreamPovider;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.teamz.client.ZComponentFactory;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class IspfZComponentFactory {
    private static UpdateDilemmaHandler getNoVerifyDilemmaHandler() {
        return new UpdateDilemmaHandler(){

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return new OutOfSyncDilemmaHandler(){

                    public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                        return 0;
                    }

                    public boolean willIgnoreAllSharesOutOfSync() {
                        return true;
                    }
                };
            }
        };
    }

    private static IFileItem createXmlFile(ITeamRepository fTeamRepository, IFolder parent, String filename) throws TeamRepositoryException {
        byte[] bytes;
        try {
            bytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project name=\"SAMPLE\" default=\"all\" xmlns:antz=\"antlib:com.ibm.team.enterprise.zos.build.ant\" \n\txmlns:rsel=\"antlib:org.apache.tools.ant.types.resources.selectors\">\n\t<description>EWM EE sample build</description>\n\n\t<taskdef name=\"startBuildActivity\"\n\t\t classname=\"com.ibm.team.build.ant.task.StartBuildActivityTask\" />\n\t<taskdef name=\"artifactFilePublisher\"\n\t\t classname=\"com.ibm.team.build.ant.task.ArtifactFilePublisherTask\" />\n\n\t<import file=\"${team.enterprise.scm.fetchDestination}/macrodefs.xml\"/>\n\n\t<!-- Compile all source files with data set names that -->\t<!-- do not end with 'LINK'. The sample script assumes -->\t<!-- data sets that ends in 'LINK' are link-edit input -->\t<!-- files.                                            -->\t<target name=\"compile\" description=\"Compile\">\n\t\t<startBuildActivity label=\"Compile\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:not>\n\t\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t\t</rsel:not>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t   \n\t<!-- Link-Edit -->\n\t<target name=\"linkedit\" description=\"Link-Edit\">\n\t\t<startBuildActivity label=\"Link-Edit\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t\n\t<!-- Build -->\n\t<target name=\"all\" depends=\"compile,linkedit\" description=\"Build\"/>\n\t\n</project>\n".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            bytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project name=\"SAMPLE\" default=\"all\" xmlns:antz=\"antlib:com.ibm.team.enterprise.zos.build.ant\" \n\txmlns:rsel=\"antlib:org.apache.tools.ant.types.resources.selectors\">\n\t<description>EWM EE sample build</description>\n\n\t<taskdef name=\"startBuildActivity\"\n\t\t classname=\"com.ibm.team.build.ant.task.StartBuildActivityTask\" />\n\t<taskdef name=\"artifactFilePublisher\"\n\t\t classname=\"com.ibm.team.build.ant.task.ArtifactFilePublisherTask\" />\n\n\t<import file=\"${team.enterprise.scm.fetchDestination}/macrodefs.xml\"/>\n\n\t<!-- Compile all source files with data set names that -->\t<!-- do not end with 'LINK'. The sample script assumes -->\t<!-- data sets that ends in 'LINK' are link-edit input -->\t<!-- files.                                            -->\t<target name=\"compile\" description=\"Compile\">\n\t\t<startBuildActivity label=\"Compile\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:not>\n\t\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t\t</rsel:not>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t   \n\t<!-- Link-Edit -->\n\t<target name=\"linkedit\" description=\"Link-Edit\">\n\t\t<startBuildActivity label=\"Link-Edit\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t\n\t<!-- Build -->\n\t<target name=\"all\" depends=\"compile,linkedit\" description=\"Build\"/>\n\t\n</project>\n".getBytes();
        }
        VersionedContentManagerByteArrayInputStreamPovider inStream = new VersionedContentManagerByteArrayInputStreamPovider(bytes);
        IFileContent fileContent = FileSystemCore.getContentManager((ITeamRepository)fTeamRepository).storeContent("UTF-8", FileLineDelimiter.LINE_DELIMITER_NONE, (AbstractVersionedContentManagerInputStreamProvider)inStream, null, null);
        IFileItem file = (IFileItem)IFileItem.ITEM_TYPE.createItem();
        file.setName(filename);
        file.setParent((IFolderHandle)parent);
        file.setContent(fileContent);
        file.setFileTimestamp(new Date());
        file.setContentType("application/xml");
        return file;
    }

    private static String getProjectXMLContents(String projectName, List<String> natures) {
        StringBuffer blockNature = new StringBuffer();
        blockNature.append("\t<natures>\n");
        for (String n : natures) {
            blockNature.append("\t\t<nature>");
            blockNature.append(n);
            blockNature.append("</nature>\n");
        }
        blockNature.append("\t</natures>\n");
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>" + projectName + "</name>\n" + "\t<comment></comment>\n" + "\t<projects>\n" + "\t</projects>\n" + "\t<buildSpec>\n" + "\t</buildSpec>\n" + blockNature.toString() + "</projectDescription>\n";
        return contents;
    }

    private static IFileItem createXMLProjectFile(ITeamRepository repo, String projectName, List<String> natures, String filename, IFolder parent) throws TeamRepositoryException {
        byte[] bytes;
        try {
            bytes = IspfZComponentFactory.getProjectXMLContents(projectName, natures).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            bytes = IspfZComponentFactory.getProjectXMLContents(projectName, natures).getBytes();
        }
        VersionedContentManagerByteArrayInputStreamPovider inStream = new VersionedContentManagerByteArrayInputStreamPovider(bytes);
        IFileContent fileContent = FileSystemCore.getContentManager((ITeamRepository)repo).storeContent("UTF-8", FileLineDelimiter.LINE_DELIMITER_NONE, (AbstractVersionedContentManagerInputStreamProvider)inStream, null, null);
        IFileItem file = (IFileItem)IFileItem.ITEM_TYPE.createItem();
        file.setName(filename);
        file.setParent((IFolderHandle)parent);
        file.setContent(fileContent);
        file.setFileTimestamp(new Date());
        file.setContentType("application/xml");
        return file;
    }

    private static IFolder createFolder(IFolder parent, String name) {
        IFolder folder = (IFolder)IFolder.ITEM_TYPE.createItem();
        folder.setParent((IFolderHandle)parent);
        folder.setName(name);
        return folder;
    }

    public static boolean isZfolderExist(IWorkspaceConnection wksConnection, IComponentHandle m_comp, String zProjectName, String zFolderName, IProgressMonitor monitor) throws ZComponentException, TeamRepositoryException {
        IConfiguration config = wksConnection.configuration(m_comp);
        IFolderHandle zFolderHandle = null;
        zFolderHandle = (IFolderHandle)config.resolvePath(config.rootFolderHandle(monitor), new String[]{zProjectName, "zOSsrc", zFolderName}, monitor);
        return zFolderHandle != null;
    }

    public static void createZFolder(ITeamRepository repo, IWorkspaceConnection wksConnection, IComponentHandle m_comp, String zProjectName, String dsdfuuid, String zFolderName, IProgressMonitor monitor) throws ZComponentException, TeamRepositoryException {
        wksConnection.refresh(monitor);
        IChangeSetHandle changeSet = wksConnection.getCurrentChangeSet(m_comp);
        IConfiguration config = wksConnection.configuration(m_comp);
        ZComponentFactory.validateFolderName((String)zFolderName);
        IFolderHandle zFolderHandle = null;
        zFolderHandle = (IFolderHandle)config.resolvePath(config.rootFolderHandle(monitor), new String[]{zProjectName, "zOSsrc", zFolderName}, monitor);
        if (zFolderHandle == null) {
            IFolder zOSsrcFolder = null;
            ArrayList<IWorkspaceConnection.ISaveOp> col = new ArrayList<IWorkspaceConnection.ISaveOp>();
            IWorkspaceConnection.IConfigurationOpFactory icof = wksConnection.configurationOpFactory();
            IFolderHandle zOSsrcFolderHandle = null;
            zOSsrcFolderHandle = (IFolderHandle)config.resolvePath(config.rootFolderHandle(monitor), new String[]{zProjectName, "zOSsrc"}, monitor);
            zOSsrcFolder = (IFolder)config.fetchCompleteItem((IVersionableHandle)zOSsrcFolderHandle, monitor);
            IFolder folder = (IFolder)IFolder.ITEM_TYPE.createItem();
            folder.setParent((IFolderHandle)zOSsrcFolder);
            folder.setName(zFolderName);
            if (dsdfuuid != null) {
                folder.setUserProperty("team.enterprise.resource.definition", dsdfuuid);
            }
            col.add(icof.save((IVersionable)folder));
            if (changeSet == null) {
                changeSet = wksConnection.createChangeSet(m_comp, monitor);
                wksConnection.setCurrentChangeSet(changeSet, monitor);
            }
            IUpdateReport updateReport = wksConnection.commit(changeSet, col, monitor);
            UpdateDilemmaHandler noVerifyInSync = IspfZComponentFactory.getNoVerifyDilemmaHandler();
            UpdateOperation updateOperation = new UpdateOperation(wksConnection, Collections.singletonList(updateReport), 3, noVerifyInSync, null);
            updateOperation.run(monitor);
        }
    }

    public static void createZComponentProject(ITeamRepository repo, IWorkspaceConnection wksConnection, IComponentHandle m_comp, String zProjectName, IProgressMonitor monitor) throws TeamRepositoryException, ZComponentException {
        ArrayList<IWorkspaceConnection.ISaveOp> col = new ArrayList<IWorkspaceConnection.ISaveOp>();
        IConfiguration config = wksConnection.configuration(m_comp);
        ArrayList<String> natures = new ArrayList<String>();
        natures.add(AntzBuildNature.ID);
        natures.add(ZComponentNature.ID);
        natures.add(RdzLocalNature.ID);
        ZComponentFactory.validateProjectName((String)zProjectName);
        IFolder rootFolder = (IFolder)config.completeRootFolder(null).getWorkingCopy();
        IFolder zprojectFolder = IspfZComponentFactory.createFolder(rootFolder, zProjectName);
        IFolder zOsFolder = IspfZComponentFactory.createFolder(zprojectFolder, "zOSsrc");
        IFileItem projectFile = IspfZComponentFactory.createXMLProjectFile(repo, zProjectName, natures, ".project", zprojectFolder);
        IFileItem xmlFile = IspfZComponentFactory.createXmlFile(repo, zprojectFolder, "build.xml");
        IWorkspaceConnection.IConfigurationOpFactory icof = wksConnection.configurationOpFactory();
        col.add(icof.save((IVersionable)zprojectFolder));
        col.add(icof.save((IVersionable)zOsFolder));
        col.add(icof.save((IVersionable)projectFile));
        col.add(icof.save((IVersionable)xmlFile));
        IChangeSetHandle changeSet = wksConnection.getCurrentChangeSet(m_comp);
        if (changeSet == null) {
            changeSet = wksConnection.createChangeSet(m_comp, monitor);
            wksConnection.setCurrentChangeSet(changeSet, monitor);
        }
        IUpdateReport updateReport = wksConnection.commit(changeSet, col, monitor);
        UpdateDilemmaHandler noVerifyInSync = IspfZComponentFactory.getNoVerifyDilemmaHandler();
        UpdateOperation updateOperation = new UpdateOperation(wksConnection, Collections.singletonList(updateReport), 3, noVerifyInSync, null);
        updateOperation.run(monitor);
    }
}

