/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal.util;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.teamz.daemon.client.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class Flow {
    private static List<IWorkspace> findFlows(ITeamRepository repo, IProjectAreaHandle projectarea, String namePattern, int flowType, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea;
        ArrayList<IWorkspace> streams = new ArrayList();
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(flowType);
        if (namePattern != null && namePattern.length() > 0) {
            criteria.setPartialName(namePattern);
        }
        if (projectarea != null && (projectArea = (IProjectArea)repo.itemManager().fetchPartialItem((IItemHandle)projectarea, 0, Collections.singletonList(ProcessCommon.getPropertyName(IProjectArea.class, (String)"teamAreaHierarchy")), monitor)) != null) {
            criteria.getFilterByOwnerOptional().add(projectArea);
            List teamAreas = projectArea.getTeamAreas();
            int numTeamAreas = teamAreas == null ? 0 : teamAreas.size();
            int i = 0;
            while (i < numTeamAreas) {
                ITeamArea teamArea = (ITeamArea)repo.itemManager().fetchPartialItem((IItemHandle)teamAreas.get(i), 1, Collections.singletonList(ProcessCommon.getPropertyName(ITeamArea.class, (String)"archived")), monitor);
                if (!teamArea.isArchived()) {
                    criteria.getFilterByOwnerOptional().add(teamArea);
                }
                ++i;
            }
        }
        streams = repo.itemManager().fetchPartialItems(SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findWorkspaces(criteria, Integer.MAX_VALUE, null), 0, Arrays.asList(IWorkspace.NAME_PROPERTY, IWorkspace.STREAM_PROPERTY, IWorkspace.ITEM_ID_PROPERTY), monitor);
        return streams;
    }

    public static List<IWorkspace> findStreams(ITeamRepository repo, IProjectAreaHandle projectarea, String pattern, IProgressMonitor monitor) throws TeamRepositoryException {
        return Flow.findFlows(repo, projectarea, pattern, 1, monitor);
    }

    public static List<IWorkspace> findWorkspaces(ITeamRepository repo, IProjectAreaHandle projectarea, String pattern, IProgressMonitor monitor) throws TeamRepositoryException {
        return Flow.findFlows(repo, projectarea, pattern, 2, monitor);
    }

    private static IFlowEntry getFlowEntry(IWorkspaceConnection sourceWorkspace) {
        return sourceWorkspace.getFlowTable().getCurrentAcceptFlow();
    }

    private static IFlowEntry getDefaultFlowEntry(IWorkspaceConnection sourceWorkspace) {
        return sourceWorkspace.getFlowTable().getDefaultAcceptFlow();
    }

    public static IWorkspaceHandle getFlowTarget(ITeamRepository repo, IWorkspaceConnection sourceWorkspace) throws TeamRepositoryException {
        return Flow.getFlowTarget(repo, sourceWorkspace, true);
    }

    public static IWorkspaceHandle getDefaultFlowTarget(ITeamRepository repo, IWorkspaceConnection sourceWorkspace) throws TeamRepositoryException {
        return Flow.getFlowTarget(repo, sourceWorkspace, false);
    }

    public static IWorkspaceHandle getFlowTarget(ITeamRepository repo, IWorkspaceConnection sourceWorkspace, Boolean current) throws TeamRepositoryException {
        IFlowEntry entry = null;
        entry = current != false ? Flow.getFlowEntry(sourceWorkspace) : Flow.getDefaultFlowEntry(sourceWorkspace);
        IWorkspaceHandle flowTargetHandle = null;
        if (entry != null) {
            if (entry.getRemoteRepositoryIdentifier() != null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.ZFilesystemRestClient_DISTRIBUTED_SCM_NOT_SUPPORTED, (Object[])new String[]{sourceWorkspace.getName(), entry.getRemoteRepositoryURI()}));
            }
            if (entry.getFlowNode() instanceof IWorkspaceHandle) {
                flowTargetHandle = (IWorkspaceHandle)entry.getFlowNode();
            }
        }
        return flowTargetHandle;
    }

    public static List<IFlowNodeHandle> getFlowTargets(ITeamRepository repo, IWorkspaceConnection sourceWorkspace) throws TeamRepositoryException {
        ArrayList<IFlowNodeHandle> result = new ArrayList<IFlowNodeHandle>();
        for (IFlowEntry entry : sourceWorkspace.getFlowTable().acceptSources()) {
            IFlowNodeHandle flowNode = entry.getFlowNode();
            result.add(flowNode);
        }
        return result;
    }

    public static List<IComponentHandle> getExcludedComponents(ITeamRepository repo, IWorkspaceConnection wsConn, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceHandle flowTargetHandle = Flow.getFlowTarget(repo, wsConn);
        IWorkspaceConnection collaboration = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(flowTargetHandle, monitor);
        collaboration.refresh(monitor);
        IFlowTable flowTable = wsConn.getFlowTable();
        ArrayList<IComponentHandle> excludedComp = new ArrayList<IComponentHandle>();
        IWorkspace node = collaboration.getResolvedWorkspace();
        Collection componentScopes = flowTable.getComponentScopes((IFlowNodeHandle)node);
        HashSet<UUID> selectedItemIds = new HashSet<UUID>();
        for (IComponentHandle handle : componentScopes) {
            selectedItemIds.add(handle.getItemId());
        }
        if (selectedItemIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        collaboration.getComponents();
        for (IComponentHandle componentHandle : collaboration.getComponents()) {
            IComponent comp = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 1, monitor);
            if (selectedItemIds.contains(comp.getItemId())) continue;
            excludedComp.add(componentHandle);
        }
        return excludedComp;
    }

    public static List<IComponentHandle> getIncludedComponents(ITeamRepository repo, IWorkspaceConnection wsConn, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceHandle flowTargetHandle = Flow.getFlowTarget(repo, wsConn);
        IWorkspaceConnection collaboration = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(flowTargetHandle, monitor);
        collaboration.refresh(monitor);
        IFlowTable flowTable = wsConn.getFlowTable();
        ArrayList<IComponentHandle> includedComp = new ArrayList<IComponentHandle>();
        IWorkspace node = collaboration.getResolvedWorkspace();
        Collection componentScopes = flowTable.getComponentScopes((IFlowNodeHandle)node);
        if (componentScopes.isEmpty()) {
            return collaboration.getComponents();
        }
        for (IComponentHandle handle : componentScopes) {
            includedComp.add(handle);
        }
        return includedComp;
    }

    public static IWorkspace getWorkspaceStream(IWorkspaceHandle workspaceHandle, ITeamRepository repo) throws TeamRepositoryException {
        IWorkspace flowTarget;
        IWorkspaceHandle flowTargetHandle;
        UUID defaultFlow;
        IWorkspace workspace = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, null);
        if (workspace.isStream()) {
            return workspace;
        }
        IWorkspace stream = null;
        Workspace ws = (Workspace)workspace;
        CurrentFlows flows = ws.getCurrentFlows();
        if (flows != null && (defaultFlow = flows.getDefaultAcceptFlow()) != null && (flowTargetHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(defaultFlow, null)) != null && (flowTarget = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)flowTargetHandle, 0, null)).isStream()) {
            stream = flowTarget;
        }
        return stream;
    }
}

