/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal.handlers;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxShare;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;

public class ZShareDilemmaHandler
extends ShareDilemmaHandler {
    private static Log LOG = LogFactory.getLog(ZShareDilemmaHandler.class);
    private Collection<IEncodingUploadFailure> failedEncoded;
    private static ZShareDilemmaHandler instance;

    private ZShareDilemmaHandler() {
    }

    public static ZShareDilemmaHandler getInstance() {
        if (instance == null) {
            instance = new ZShareDilemmaHandler();
        }
        return instance;
    }

    public int multipleSandboxesForConfigurations(Collection<? extends IMultipleSandboxShare> multipleSandboxesForShares) {
        return 0;
    }

    public void linkWarnings(boolean anyBrokenLinks, boolean anyNonInteroperableLinks, IShareable[] shareables, String[] targets, Boolean[] directoryLinks, Boolean[] broken, Boolean[] nonInteroperable) {
        int num = targets.length;
        int i = 0;
        while (i < num) {
            if (broken[i].booleanValue() && LOG.isInfoEnabled()) {
                LOG.info((Object)(String.valueOf(targets[i]) + " is broken link"));
            }
            if (nonInteroperable[i].booleanValue() && LOG.isInfoEnabled()) {
                LOG.info((Object)(String.valueOf(targets[i]) + " is non-operable link"));
            }
            ++i;
        }
    }

    public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemException {
        return 0;
    }

    public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedUploads, IProgressMonitor monitor) {
        int failuresHandled = 0;
        this.failedEncoded = new ArrayList<IEncodingUploadFailure>();
        for (IEncodingUploadFailure iEncodingUploadFailure : failedUploads) {
            if ((iEncodingUploadFailure.isUnknownEncoding() || iEncodingUploadFailure.isMalformedContent()) && !iEncodingUploadFailure.getEncoding().equals(iEncodingUploadFailure.getOriginalEncoding()) && iEncodingUploadFailure.getOriginalEncoding() != null) {
                try {
                    if (Charset.isSupported(iEncodingUploadFailure.getOriginalEncoding())) {
                        iEncodingUploadFailure.setAlternativeEncoding(iEncodingUploadFailure.getOriginalEncoding());
                        ++failuresHandled;
                        continue;
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    // empty catch block
                }
            }
            if (iEncodingUploadFailure.isAtomicCommit()) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(String.valueOf(iEncodingUploadFailure.getStatus().getMessage()) + " : " + iEncodingUploadFailure.getShareable().getFullPath().toOSString()));
            }
            iEncodingUploadFailure.setSkipFailure(true);
            ++failuresHandled;
            this.failedEncoded.add(iEncodingUploadFailure);
        }
        if (failuresHandled != 0) {
            return 0;
        }
        return 2;
    }

    public Collection<IEncodingUploadFailure> getFailedEncoded() {
        return this.failedEncoded;
    }

    public void setFailedEncoded(Collection<IEncodingUploadFailure> failedEncoded) {
        this.failedEncoded = failedEncoded;
    }
}

