/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal.handlers;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;

public class ZCommitDilemmaHandler
extends CommitDilemmaHandler {
    private static Log LOG = LogFactory.getLog(ZCommitDilemmaHandler.class);
    private Collection<IShareable> inaccessibleForUpdate;
    private Collection<IShareable> siblingSharesToAdd;
    private Collection<IEncodingUploadFailure> failedEncoded;
    private static ZCommitDilemmaHandler instance;

    public static ZCommitDilemmaHandler getDefault() {
        if (instance == null) {
            instance = new ZCommitDilemmaHandler();
        }
        return instance;
    }

    public void linkWarnings(boolean anyBrokenLinks, boolean anyNonInteroperableLinks, IShareable[] shareables, String[] targets, Boolean[] directoryLinks, Boolean[] broken, Boolean[] nonInteroperable) {
        int num = targets.length;
        int i = 0;
        while (i < num) {
            if (broken[i].booleanValue() && LOG.isInfoEnabled()) {
                LOG.info((Object)(String.valueOf(targets[i]) + " is broken link"));
            }
            if (nonInteroperable[i].booleanValue() && LOG.isInfoEnabled()) {
                LOG.info((Object)(String.valueOf(targets[i]) + " is non-operable link"));
            }
            ++i;
        }
    }

    public int predecessorContentDeletedErrors(Collection<IShareable> failedUploads) {
        return 0;
    }

    public int inaccessibleForUpdate(Collection<IShareable> shareables) {
        this.inaccessibleForUpdate = shareables;
        for (IShareable shareable : shareables) {
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)shareable.getFullPath().toOSString());
        }
        return 1;
    }

    public Collection<IShareable> getInaccessibleForUpdate() {
        return this.inaccessibleForUpdate;
    }

    public int siblingSharesToAdd(Collection<IShareable> shareables) {
        this.siblingSharesToAdd = shareables;
        return 1;
    }

    public Collection<IShareable> getsiblingSharesToAdd() {
        return this.siblingSharesToAdd;
    }

    public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemException {
        return 0;
    }

    public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedUploads, IProgressMonitor monitor) {
        int failuresHandled = 0;
        this.failedEncoded = new ArrayList<IEncodingUploadFailure>();
        for (IEncodingUploadFailure iEncodingUploadFailure : failedUploads) {
            if ((iEncodingUploadFailure.isUnknownEncoding() || iEncodingUploadFailure.isMalformedContent()) && !iEncodingUploadFailure.getEncoding().equals(iEncodingUploadFailure.getOriginalEncoding()) && iEncodingUploadFailure.getOriginalEncoding() != null) {
                try {
                    if (Charset.isSupported(iEncodingUploadFailure.getOriginalEncoding())) {
                        iEncodingUploadFailure.setAlternativeEncoding(iEncodingUploadFailure.getOriginalEncoding());
                        ++failuresHandled;
                        continue;
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    // empty catch block
                }
            }
            if (iEncodingUploadFailure.isAtomicCommit()) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(String.valueOf(iEncodingUploadFailure.getStatus().getMessage()) + " : " + iEncodingUploadFailure.getShareable().getFullPath().toOSString()));
            }
            iEncodingUploadFailure.setSkipFailure(true);
            ++failuresHandled;
            this.failedEncoded.add(iEncodingUploadFailure);
        }
        if (failuresHandled != 0) {
            return 0;
        }
        return 2;
    }

    public Collection<IEncodingUploadFailure> getFailedEncoded() {
        return this.failedEncoded;
    }

    public void setFailedEncoded(Collection<IEncodingUploadFailure> failedEncoded) {
        this.failedEncoded = failedEncoded;
    }
}

