/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal.handlers;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HandlerUtil {
    static List<String> getUncheckedInChangePaths(Map<ConfigurationFacade, Collection<ILocalChange>> changeMap) {
        ArrayList<String> localChangePaths = new ArrayList<String>();
        Collection<Collection<ILocalChange>> allChanges = changeMap.values();
        if (allChanges != null) {
            for (Collection<ILocalChange> configChanges : allChanges) {
                if (configChanges == null) continue;
                for (ILocalChange thisChange : configChanges) {
                    String sandbox = thisChange.getSandboxRoot().toOSString();
                    IRelativeLocation path = thisChange.getPath();
                    if (sandbox.startsWith("/")) {
                        localChangePaths.add(path.toPath().toOSString());
                        continue;
                    }
                    if (path.segmentCount() != 2) continue;
                    localChangePaths.add(String.valueOf(path.segment(0)) + '(' + path.segment(1) + ')');
                }
            }
        }
        return localChangePaths;
    }
}

