/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal;

import com.ibm.jzos.PdsDirectory;
import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.client.ITeamBuildRequestClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.common.model.query.IBaseBuildResultQueryModel;
import com.ibm.team.build.internal.common.helper.PropertyHelper;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.impl.WorkItemBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.Visibility;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaWorkItem;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.common.common.LocalPropertyTable;
import com.ibm.team.enterprise.common.common.ZComponentException;
import com.ibm.team.enterprise.scmee.common.IThreadOwner;
import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.Constants;
import com.ibm.team.enterprise.systemdefinition.common.validation.SystemDefinitionValidationException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IApplyAcceptedOperation;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IMarkAsMergedOperation;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILockOperation;
import com.ibm.team.filesystem.client.operations.IMetadataRepairOperation;
import com.ibm.team.filesystem.client.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IUnlockOperation;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.process.internal.common.advice.impl.ParticipantReportImpl;
import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.ObfuscationHelper;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.client.internal.FlowNodeConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.changenodes.ChangeSetStatesUtil;
import com.ibm.team.scm.common.changenodes.IChangeNode;
import com.ibm.team.scm.common.dto.IAccessGroupScope;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import com.ibm.team.scm.common.dto.IVersionableLock;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ItemProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.SelectClause;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.StatusVariable;
import com.ibm.team.workitem.common.internal.model.Severity;
import com.ibm.team.workitem.common.internal.model.WorkItemType;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.TagsAttributeType;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.IResolvedResult;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.teamz.daemon.client.internal.AcceptException;
import com.ibm.teamz.daemon.client.internal.CorruptionListener;
import com.ibm.teamz.daemon.client.internal.DaemonUtils;
import com.ibm.teamz.daemon.client.internal.EnterpriseRequestDialogOption;
import com.ibm.teamz.daemon.client.internal.ISPFLoadOperation;
import com.ibm.teamz.daemon.client.internal.ISPFSession;
import com.ibm.teamz.daemon.client.internal.IZFilesystemRestClient;
import com.ibm.teamz.daemon.client.internal.TextFileLoader;
import com.ibm.teamz.daemon.client.internal.ZosScmPaths;
import com.ibm.teamz.daemon.client.internal.handlers.IChangeChangesetHistoryDilemmaHandler;
import com.ibm.teamz.daemon.client.internal.handlers.UssLoadDilemmahandler;
import com.ibm.teamz.daemon.client.internal.handlers.ZCommitDilemmaHandler;
import com.ibm.teamz.daemon.client.internal.handlers.ZDeliverDilemmaHandler;
import com.ibm.teamz.daemon.client.internal.handlers.ZDiscardDilemmaHandler;
import com.ibm.teamz.daemon.client.internal.handlers.ZLoadDilemmaHandler;
import com.ibm.teamz.daemon.client.internal.handlers.ZMoveFoldersDilemmaHandler;
import com.ibm.teamz.daemon.client.internal.handlers.ZShareDilemmaHandler;
import com.ibm.teamz.daemon.client.internal.handlers.ZUnshareDilemmaHandler;
import com.ibm.teamz.daemon.client.internal.handlers.ZWorkspaceUpdateDilemmaHandler;
import com.ibm.teamz.daemon.client.internal.nls.Messages;
import com.ibm.teamz.daemon.client.internal.parms.ParmsAccept;
import com.ibm.teamz.daemon.client.internal.parms.ParmsAddContentBuildableSubset;
import com.ibm.teamz.daemon.client.internal.parms.ParmsAllAssociatedWI;
import com.ibm.teamz.daemon.client.internal.parms.ParmsArtefact;
import com.ibm.teamz.daemon.client.internal.parms.ParmsAssociateWI;
import com.ibm.teamz.daemon.client.internal.parms.ParmsBlank;
import com.ibm.teamz.daemon.client.internal.parms.ParmsBuildableSubset;
import com.ibm.teamz.daemon.client.internal.parms.ParmsChangeChangeset;
import com.ibm.teamz.daemon.client.internal.parms.ParmsChangeFlow;
import com.ibm.teamz.daemon.client.internal.parms.ParmsChangeProperties;
import com.ibm.teamz.daemon.client.internal.parms.ParmsChangesetDetails;
import com.ibm.teamz.daemon.client.internal.parms.ParmsCheckin;
import com.ibm.teamz.daemon.client.internal.parms.ParmsCollaboration;
import com.ibm.teamz.daemon.client.internal.parms.ParmsCompleteChangeSet;
import com.ibm.teamz.daemon.client.internal.parms.ParmsCreateBuildableSubsetWorkItem;
import com.ibm.teamz.daemon.client.internal.parms.ParmsCreateComponent;
import com.ibm.teamz.daemon.client.internal.parms.ParmsCreateRepositoryWorkspace;
import com.ibm.teamz.daemon.client.internal.parms.ParmsCreateStream;
import com.ibm.teamz.daemon.client.internal.parms.ParmsCreateWorkItem;
import com.ibm.teamz.daemon.client.internal.parms.ParmsDeleteRepositoryWorkspace;
import com.ibm.teamz.daemon.client.internal.parms.ParmsDeliver;
import com.ibm.teamz.daemon.client.internal.parms.ParmsDiscard;
import com.ibm.teamz.daemon.client.internal.parms.ParmsEditRepositoryWorkspace;
import com.ibm.teamz.daemon.client.internal.parms.ParmsEnvVariable;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetActiveChangesets;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetBaselines;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetBuildDefinitions;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetBuildProperties;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetBuildResults;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetBuildableSubsets;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetChangeSetCheckinHistory;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetComponentHistory;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetComponentScope;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetComponents;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetConflicts;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetCurrentStream;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetFileExtension;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetFlows;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetHistory;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetLoadedConfigurations;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetMatchingDSDefs;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetMatchingZFolders;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetMemberMetadata;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetMemberStatus;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetPendingChanges;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetPropertiesVisibilities;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetRepositoryWorkspaces;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetUnsharedMembers;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetWorkspaceDetails;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetZArtefacts;
import com.ibm.teamz.daemon.client.internal.parms.ParmsGetZComponentProject;
import com.ibm.teamz.daemon.client.internal.parms.ParmsLoadz;
import com.ibm.teamz.daemon.client.internal.parms.ParmsLoadzFromChangeset;
import com.ibm.teamz.daemon.client.internal.parms.ParmsLoadzFromCheckinHistory;
import com.ibm.teamz.daemon.client.internal.parms.ParmsLoadzUuid;
import com.ibm.teamz.daemon.client.internal.parms.ParmsLock;
import com.ibm.teamz.daemon.client.internal.parms.ParmsLogLoad;
import com.ibm.teamz.daemon.client.internal.parms.ParmsLogin;
import com.ibm.teamz.daemon.client.internal.parms.ParmsMemberChanged;
import com.ibm.teamz.daemon.client.internal.parms.ParmsOwnerBuildableSubset;
import com.ibm.teamz.daemon.client.internal.parms.ParmsRemoveBuildableSubsetWorkitem;
import com.ibm.teamz.daemon.client.internal.parms.ParmsRename;
import com.ibm.teamz.daemon.client.internal.parms.ParmsRepairMetadata;
import com.ibm.teamz.daemon.client.internal.parms.ParmsRequestBuild;
import com.ibm.teamz.daemon.client.internal.parms.ParmsResolveConflict;
import com.ibm.teamz.daemon.client.internal.parms.ParmsSetComponentScope;
import com.ibm.teamz.daemon.client.internal.parms.ParmsSetProjectArea;
import com.ibm.teamz.daemon.client.internal.parms.ParmsShare;
import com.ibm.teamz.daemon.client.internal.parms.ParmsShareLike;
import com.ibm.teamz.daemon.client.internal.parms.ParmsUndo;
import com.ibm.teamz.daemon.client.internal.parms.ParmsUnload;
import com.ibm.teamz.daemon.client.internal.parms.ParmsUpdateContentBuildableSubset;
import com.ibm.teamz.daemon.client.internal.parms.ParmsWorkitem;
import com.ibm.teamz.daemon.client.internal.parms.ParmsZFolderShare;
import com.ibm.teamz.daemon.client.internal.util.Flow;
import com.ibm.teamz.daemon.client.internal.util.ZosScmUtils;
import com.ibm.teamz.daemon.client.internal.zcomponents.IspfZComponentFactory;
import com.ibm.teamz.daemon.common.model.workspace.AdvisorReportDTO;
import com.ibm.teamz.daemon.common.model.workspace.BuildDefinitionDTO;
import com.ibm.teamz.daemon.common.model.workspace.BuildPropertiesDTO;
import com.ibm.teamz.daemon.common.model.workspace.BuildResultDTO;
import com.ibm.teamz.daemon.common.model.workspace.ChangeDTO;
import com.ibm.teamz.daemon.common.model.workspace.ChangesetDTO;
import com.ibm.teamz.daemon.common.model.workspace.ChangesetHistoryDTO;
import com.ibm.teamz.daemon.common.model.workspace.ComponentHistoryDTO;
import com.ibm.teamz.daemon.common.model.workspace.ComponentScopeDTO;
import com.ibm.teamz.daemon.common.model.workspace.ConflictDTO;
import com.ibm.teamz.daemon.common.model.workspace.ContributionLogsDTO;
import com.ibm.teamz.daemon.common.model.workspace.DeliverResultDTO;
import com.ibm.teamz.daemon.common.model.workspace.GetActiveChangesetsDTO;
import com.ibm.teamz.daemon.common.model.workspace.GetUsersWorkspacesDTO;
import com.ibm.teamz.daemon.common.model.workspace.HistoryDTO;
import com.ibm.teamz.daemon.common.model.workspace.LoginResponseDTO;
import com.ibm.teamz.daemon.common.model.workspace.MemberMetadataDTO;
import com.ibm.teamz.daemon.common.model.workspace.MemberStatusDTO;
import com.ibm.teamz.daemon.common.model.workspace.NamedItemDTO;
import com.ibm.teamz.daemon.common.model.workspace.PendingChangeDTO;
import com.ibm.teamz.daemon.common.model.workspace.PropertyDTO;
import com.ibm.teamz.daemon.common.model.workspace.SandboxesReportDTO;
import com.ibm.teamz.daemon.common.model.workspace.SubsetContentDTO;
import com.ibm.teamz.daemon.common.model.workspace.SubsetCriteriaDTO;
import com.ibm.teamz.daemon.common.model.workspace.SubsetDTO;
import com.ibm.teamz.daemon.common.model.workspace.UnresolvedDTO;
import com.ibm.teamz.daemon.common.model.workspace.UserDTO;
import com.ibm.teamz.daemon.common.model.workspace.WarningDTO;
import com.ibm.teamz.daemon.common.model.workspace.WorkitemDTO;
import com.ibm.teamz.daemon.common.model.workspace.WorkspaceDetailsDTO;
import com.ibm.teamz.daemon.common.model.workspace.ZFilesystemRestClientDTOcoreFactory;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.fileagent.PDSUtility;
import com.ibm.teamz.fileagent.importz.PDSInfo;
import com.ibm.teamz.fileagent.importz.PDSManagerException;
import com.ibm.teamz.fileagent.internal.extensions.impl.ThreadOwner;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZFileInterface;
import com.ibm.teamz.impersonation.CoreJNI;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.logging.LogManager;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ZFilesystemRestClient
implements IZFilesystemRestClient {
    private static final String DEFAULT_USER_VARIABLE_PREFIX = "team.enterprise.default.var.";
    private static final CorruptionListener corruptionListener;
    private static final String APPL_ID;
    private static final String SPECIAL_CHARACTERS = "[]{}\"";
    private static Log LOG;
    private static boolean ispfLoad;
    private static final String NO_LOAD_OPTIMIZATION_PROPERTY = "team.entreprise.noISPFloadOptimisation";
    private final String TYPE_FILE = "F";
    private final String TYPE_SYMBOL_LINK = "S";
    private final String TYPE_FOLDER = "D";

    static {
        LOG = LogFactory.getLog(ZFilesystemRestClient.class);
        String applID = System.getProperty("com.ibm.teamz.daemon.appl.id");
        APPL_ID = applID != null ? applID : "BLZAPPL";
        String filePath = System.getProperty("java.util.logging.config.file");
        if (filePath != null && filePath.length() > 0) {
            try {
                LogManager.getLogManager().readConfiguration(new FileInputStream(filePath));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Daemon starting with application ID: " + APPL_ID));
        }
        corruptionListener = new CorruptionListener();
        ((SharingManager)FileSystemCore.getSharingManager()).addListener((ICorruptCopyFileAreaListener)corruptionListener);
        if (System.getProperty("rtcz.no.optimize") != null) {
            SCMPlatform.setMaxContentThreads((int)0);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Running single-threaded.");
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Running multi-threaded.");
        }
        ispfLoad = true;
        if (System.getProperty(NO_LOAD_OPTIMIZATION_PROPERTY) != null) {
            ispfLoad = false;
        }
    }

    private boolean isUserJazzAdmin(ITeamRepository repository, IProgressMonitor monitor) {
        boolean result = false;
        try {
            ProcessClientService processClient = (ProcessClientService)repository.getClientLibrary(IProcessItemService.class);
            result = processClient.assertPermission("JazzAdmins", monitor);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    protected static ISPFSession getSession(String clientKey) throws NotLoggedInException {
        ISPFSession session = ISPFSession.getSession(clientKey);
        if (session != null) {
            return session;
        }
        throw new NotLoggedInException();
    }

    protected static final IWorkspaceConnection getWorkspaceConnection(ITeamRepository repo, String wsUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        return ZFilesystemRestClient.getWorkspaceConnection(repo, (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)wsUUID), null), monitor);
    }

    protected static final IWorkspaceConnection getWorkspaceConnection(ITeamRepository repo, IWorkspaceHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(handle, monitor);
        wsConn.refresh(monitor);
        return wsConn;
    }

    protected void switchAuth(String userID, String passTicket) throws Exception {
        this.switchAuth(userID, passTicket, null);
    }

    protected void switchAuth(String userID, String passTicket, String clientKey) throws Exception {
        int secrc;
        userID = userID.toUpperCase();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("switchAuth: userID=" + userID + ",passTicket=" + passTicket + ",APPL_ID=" + APPL_ID));
        }
        if ((secrc = CoreJNI.pThreadSecurity((String)userID, (String)passTicket, (String)APPL_ID, (boolean)true)) != 0) {
            throw new Exception("ThreadSecurity error: rc=" + secrc);
        }
        if (clientKey != null) {
            this.setBuildProperties(clientKey);
        }
    }

    protected void unSwitchAuth(String userID, String passTicket) throws Exception {
        this.unSwitchAuth(userID, passTicket, null);
    }

    protected void unSwitchAuth(String userID, String passTicket, String clientKey) throws Exception {
        int secrc;
        if (clientKey != null) {
            this.clearBuildProperties(clientKey);
        }
        userID = userID.toUpperCase();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("unSwitchAuth: userID=" + userID + ",passTicket=" + passTicket + ",APPL_ID=" + APPL_ID));
        }
        if ((secrc = CoreJNI.pThreadSecurity((String)userID, (String)passTicket, (String)APPL_ID, (boolean)false)) != 0) {
            throw new Exception("ThreadSecurity error: rc=" + secrc);
        }
    }

    protected void setBuildProperties(String clientKey) {
        block13: {
            String propertiesFile = ISPFSession.getSession(clientKey).getPropertiesFile();
            if (propertiesFile == null || propertiesFile.length() == 0) {
                return;
            }
            File propertiesFileFile = new File(propertiesFile);
            FileInputStream buildPropertiesStream = null;
            Properties properties = new Properties();
            try {
                try {
                    buildPropertiesStream = new FileInputStream(propertiesFileFile);
                    properties.load(buildPropertiesStream);
                    LocalPropertyTable.get().set(properties);
                    ISPFSession.getSession(clientKey).setProperties(properties);
                }
                catch (IOException e) {
                    LOG.error((Object)NLS.bind((String)Messages.ZFilesystemRestClient_FILE_READ_ERROR, (Object)propertiesFile));
                    if (buildPropertiesStream == null) break block13;
                    try {
                        ((InputStream)buildPropertiesStream).close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (buildPropertiesStream != null) {
                    try {
                        ((InputStream)buildPropertiesStream).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected void clearBuildProperties(String clientKey) {
        LocalPropertyTable.get().remove();
        ISPFSession.getSession(clientKey).setProperties(null);
    }

    @Override
    public String postSetProjectArea(ParmsSetProjectArea parms, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea pa;
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        try {
            pa = (IProjectArea)session.getLoggedInRepository().itemManager().fetchPartialItem(IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.projectAreaUUID), null), 0, Collections.singletonList("name"), monitor);
        }
        catch (ItemNotFoundException ex) {
            pa = null;
        }
        if (pa == null) {
            return null;
        }
        session.setProjectArea((IProjectAreaHandle)pa);
        return pa.getName();
    }

    private final String makePath(List<INameItemPair> niPairs) {
        StringBuilder buf = new StringBuilder();
        for (INameItemPair niPair : niPairs) {
            String name = niPair.getName();
            if (name == null) continue;
            buf.append("/" + name);
        }
        return buf.toString();
    }

    @Override
    public String getComponentIdChangesetDetails(ParmsChangesetDetails parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        IChangeSet cs = (IChangeSet)repo.itemManager().fetchPartialItem(IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null), 0, Arrays.asList(IChangeSet.COMPONENT_PROPERTY), monitor);
        return cs.getComponent().getItemId().getUuidValue();
    }

    @Override
    public void postChangeChangesetComment(ParmsChangeChangeset parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        IChangeSetHandle csHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null);
        SCMPlatform.getWorkspaceManager((ITeamRepository)repo).setComment(csHandle, parms.comment == null ? "" : parms.comment, monitor);
    }

    private String getType(IVersionable before) {
        if (before instanceof IFileItem) {
            return "F";
        }
        if (before instanceof ISymbolicLink) {
            return "S";
        }
        return "D";
    }

    @Override
    public ChangeDTO[] getChangesetDetails(ParmsChangesetDetails parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        IVersionableManager vManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager();
        IChangeSet cs = (IChangeSet)repo.itemManager().fetchPartialItem(IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null), 0, Arrays.asList(IChangeSet.CHANGES_PROPERTY, IChangeSet.COMPONENT_PROPERTY), monitor);
        IWorkspaceConnection conn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.workspaceID, monitor);
        conn.refresh(monitor);
        IConfiguration config = conn.configuration(cs.getComponent());
        ArrayList<IVersionableHandle> affectedVersionables = new ArrayList<IVersionableHandle>();
        List changes = cs.changes();
        int numChanges = changes == null ? 0 : changes.size();
        ChangeDTO[] result = new ChangeDTO[numChanges];
        int i = 0;
        while (i < numChanges) {
            IChange thisChange = (IChange)changes.get(i);
            int kind = thisChange.kind();
            result[i] = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createChangeDTO();
            result[i].setKind(kind);
            affectedVersionables.add(thisChange.item());
            ZosScmPaths lrp = ZosScmUtils.getFullPaths(repo, thisChange.item(), config, monitor);
            result[i].setFileItemId(thisChange.item().getItemId().getUuidValue());
            if (kind == 16) {
                IVersionable before = vManager.fetchPartialState(thisChange.beforeState(), Arrays.asList(IVersionable.PARENT_PROPERTY, IVersionable.NAME_PROPERTY), monitor);
                ZosScmPaths beforeLpr = ZosScmUtils.getFullPaths(repo, (IVersionableHandle)before, config, monitor);
                String sBefore = beforeLpr.getScmPath();
                result[i].setBeforeScmPath(sBefore);
                result[i].setBeforeZosPath(beforeLpr.getZosPath());
                result[i].setDescription(sBefore);
                result[i].setType(this.getType(before));
            } else if (kind == 1) {
                IVersionable after = vManager.fetchPartialState(thisChange.afterState(), Arrays.asList(IVersionable.PARENT_PROPERTY, IVersionable.NAME_PROPERTY), monitor);
                ZosScmPaths afterLpr = ZosScmUtils.getFullPaths(repo, (IVersionableHandle)after, config, monitor);
                String afterScmPath = afterLpr.getScmPath();
                result[i].setAfterScmPath(afterScmPath);
                result[i].setAfterZosPath(afterLpr.getZosPath());
                result[i].setDescription(afterScmPath);
                result[i].setType(this.getType(after));
            } else {
                String afterScmPath = lrp.getScmPath();
                result[i].setAfterScmPath(afterScmPath);
                result[i].setAfterZosPath(lrp.getZosPath());
                result[i].setDescription(afterScmPath);
                boolean reparented = (kind & 8) != 0;
                boolean renamed = (kind & 4) != 0;
                IVersionable before = vManager.fetchPartialState(thisChange.beforeState(), Arrays.asList(IVersionable.PARENT_PROPERTY, IVersionable.NAME_PROPERTY), monitor);
                result[i].setType(this.getType(before));
                if (reparented || renamed) {
                    ZosScmPaths beforeLpr = ZosScmUtils.getFullPaths(repo, (IVersionableHandle)before, config, monitor);
                    IVersionable after = vManager.fetchPartialState(thisChange.afterState(), Arrays.asList(IVersionable.PARENT_PROPERTY, IVersionable.NAME_PROPERTY), monitor);
                    ZosScmPaths afterLpr = ZosScmUtils.getFullPaths(repo, (IVersionableHandle)after, config, monitor);
                    afterScmPath = afterLpr.getScmPath();
                    result[i].setAfterScmPath(afterScmPath);
                    result[i].setAfterZosPath(afterLpr.getZosPath());
                    result[i].setType(this.getType(before));
                    result[i].setBeforeScmPath(beforeLpr.getScmPath());
                    result[i].setBeforeZosPath(beforeLpr.getZosPath());
                    if (afterScmPath == null) {
                        List rept = config.determineAncestorsInHistory(Collections.singletonList(before.getParent()), monitor);
                        afterScmPath = this.makePath(((IAncestorReport)rept.get(0)).getNameItemPairs());
                        result[i].setAfterScmPath(afterScmPath);
                    }
                    String descr = renamed ? String.valueOf(afterScmPath) + " " + NLS.bind((String)Messages.ZFilesystemRestClient_VERSIONABLE_RENAMED, (Object)before.getName()) : String.valueOf(afterScmPath) + " " + NLS.bind((String)Messages.ZFilesystemRestClient_VERSIONABLE_MOVED, (Object)result[i].getBeforeScmPath());
                    result[i].setDescription(descr);
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public String[] getMatchingZFolders(ParmsGetMatchingZFolders parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ArrayList<String> result = new ArrayList<String>();
        String shareRoot = ZFilesystemRestClient.findShareRoot(parms.dsName, session);
        if (shareRoot != null && parms.dsName.startsWith(shareRoot)) {
            IConfiguration config;
            IVersionableHandle zOSSrcHandle;
            String relativeName = parms.dsName.substring(shareRoot.length());
            if (relativeName.length() > 0 && relativeName.charAt(0) == '.') {
                relativeName = relativeName.substring(1);
            }
            if ((zOSSrcHandle = (config = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.rwsUUID, monitor).configuration((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.compUUID), null))).resolvePath(config.rootFolderHandle(monitor), new String[]{parms.projName, "zOSsrc"}, monitor)) instanceof IFolderHandle) {
                Map zFoldersMap = config.childEntries((IFolderHandle)zOSSrcHandle, monitor);
                for (Map.Entry thisZFld : zFoldersMap.entrySet()) {
                    IDataSetDefinition dsdef;
                    String dsDefUUID;
                    if (!(thisZFld.getValue() instanceof IFolderHandle)) continue;
                    IFolder zFld = (IFolder)config.fetchCompleteItem((IVersionableHandle)thisZFld.getValue(), monitor);
                    Map fldrProps = zFld.getUserProperties();
                    String string = dsDefUUID = fldrProps == null ? null : (String)fldrProps.get("team.enterprise.resource.definition");
                    if (dsDefUUID == null || dsDefUUID.length() <= 0 || !relativeName.equals((dsdef = com.ibm.team.enterprise.systemdefinition.client.util.DataSetDefinition.get((ITeamRepository)repo, (String)dsDefUUID, (IProgressMonitor)monitor)).getDsName())) continue;
                    result.add((String)thisZFld.getKey());
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean isBuildableFile(IVersionable v, ITeamRepository repo) throws IllegalArgumentException, TeamRepositoryException, IOException {
        String langDefUUID = (String)v.getUserProperties().get("team.enterprise.language.definition");
        return this.isBuildableFileWork(langDefUUID, v.getName(), repo);
    }

    private boolean isBuildableFileWork(String langDefUUID, String fileName, ITeamRepository repo) throws TeamRepositoryException, IOException {
        ILanguageDefinition ld = null;
        ISystemDefinitionModelClient sysDefClient = com.ibm.team.enterprise.systemdefinition.client.ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repo);
        if (langDefUUID == null || langDefUUID.trim().equals("")) {
            if (!fileName.equals("")) {
                ld = sysDefClient.getDefaultLanguageDefinition(fileName, null);
            }
        } else {
            ld = (ILanguageDefinition)sysDefClient.findSystemDefinition(langDefUUID, null, ILanguageDefinition.ITEM_TYPE, (IProgressMonitor)new NullProgressMonitor());
        }
        if (ld == null) {
            return false;
        }
        return ld.getTranslators() != null && ld.getTranslators().size() > 0;
    }

    private List<SubsetContentDTO> getAllFilesFromBuild(ISPFSession session, ITeamRepository repo, String compUUID, IConfiguration configuration, IFolderHandle parent, String prefix, String[] folders, int indent, IProgressMonitor monitor) throws TeamRepositoryException, IllegalArgumentException, IOException {
        ArrayList<SubsetContentDTO> listResult = new ArrayList<SubsetContentDTO>();
        Map children = parent == null ? configuration.childEntriesForRoot(null) : configuration.childEntries(parent, null);
        if (children != null) {
            for (String name : children.keySet()) {
                IVersionable thisVer;
                if (indent >= 0 && indent < folders.length && !name.matches(folders[indent])) continue;
                IVersionableHandle item = (IVersionableHandle)children.get(name);
                if (item instanceof IFolderHandle) {
                    if (indent < 0) {
                        listResult.addAll(this.getAllFilesFromBuild(session, repo, compUUID, configuration, (IFolderHandle)item, String.valueOf(prefix) + "/" + name, folders, -1, monitor));
                        continue;
                    }
                    listResult.addAll(this.getAllFilesFromBuild(session, repo, compUUID, configuration, (IFolderHandle)item, String.valueOf(prefix) + "/" + name, folders, indent + 1, monitor));
                    continue;
                }
                if (indent < folders.length - 1 || !this.isBuildableFile(thisVer = configuration.fetchCompleteItem(item, null), repo)) continue;
                SubsetContentDTO result = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createSubsetContentDTO();
                result.setItemId(thisVer.getItemId().getUuidValue());
                String fullPath = String.valueOf(prefix) + "/" + name;
                result.setPath(fullPath);
                result.setCompId(compUUID);
                listResult.add(result);
            }
        }
        return listResult;
    }

    private List<String> getAllFiles(ITeamRepository repo, IConfiguration configuration, IFolderHandle parent, String prefix, String[] folders, int indent) throws TeamRepositoryException, IllegalArgumentException, IOException {
        ArrayList<String> listResult = new ArrayList<String>();
        Map children = parent == null ? configuration.childEntriesForRoot(null) : configuration.childEntries(parent, null);
        if (children != null) {
            for (String name : children.keySet()) {
                if (indent >= 0 && indent < folders.length && !name.matches(folders[indent])) continue;
                IVersionableHandle item = (IVersionableHandle)children.get(name);
                if (item instanceof IFolderHandle) {
                    if (indent < 0) {
                        listResult.addAll(this.getAllFiles(repo, configuration, (IFolderHandle)item, String.valueOf(prefix) + "/" + name, folders, -1));
                        continue;
                    }
                    listResult.addAll(this.getAllFiles(repo, configuration, (IFolderHandle)item, String.valueOf(prefix) + "/" + name, folders, indent + 1));
                    continue;
                }
                if (indent < folders.length - 1) continue;
                listResult.add(String.valueOf(prefix) + "/" + name);
            }
        }
        return listResult;
    }

    private String ispf2Regexp(String input) {
        String result = "^";
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case '*': {
                    result = String.valueOf(result) + ".*";
                    break;
                }
                case '%': {
                    result = String.valueOf(result) + '.';
                    break;
                }
                default: {
                    result = String.valueOf(result) + c;
                }
            }
            ++i;
        }
        result = String.valueOf(result) + '$';
        return result;
    }

    @Override
    public SubsetContentDTO[] getZArtefactsFromBuild(ParmsGetZArtefacts parms, IProgressMonitor monitor) throws IOException, FileSystemException, TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        String globpath = parms.pattern;
        String path = this.ispf2Regexp(globpath);
        String[] folders = path.split("/");
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ArrayList<SubsetContentDTO> result = new ArrayList<SubsetContentDTO>();
        String rwsUUID = this.getWorkspaceIdFromBuild(repo, parms.rwsUUID, monitor);
        IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)rwsUUID), null);
        IComponentHandle compHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.compUUID), null);
        IConfiguration config = ZFilesystemRestClient.getWorkspaceConnection(repo, wsHandle, monitor).configuration(compHandle);
        Map rootKidsMap = config.childEntries(config.rootFolderHandle(monitor), monitor);
        for (Map.Entry thisKid : rootKidsMap.entrySet()) {
            IVersionableHandle childVerHandle = (IVersionableHandle)thisKid.getValue();
            if (path == null || path.length() == 0 || folders.length == 0) {
                result.addAll(this.getAllFilesFromBuild(session, repo, parms.compUUID, config, (IFolderHandle)childVerHandle, (String)thisKid.getKey(), folders, -1, monitor));
                continue;
            }
            if (!((String)thisKid.getKey()).matches(folders[0])) continue;
            result.addAll(this.getAllFilesFromBuild(session, repo, parms.compUUID, config, (IFolderHandle)childVerHandle, (String)thisKid.getKey(), folders, 1, monitor));
        }
        return result.toArray(new SubsetContentDTO[result.size()]);
    }

    @Override
    public String[] getZArtefacts(ParmsGetZArtefacts parms, IProgressMonitor monitor) throws IOException, FileSystemException, TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        String globpath = parms.pattern;
        String path = this.ispf2Regexp(globpath);
        String[] folders = path.split("/");
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        ArrayList<String> result = new ArrayList<String>();
        String rwsUUID = parms.rwsUUID;
        IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)rwsUUID), null);
        IComponentHandle compHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.compUUID), null);
        IConfiguration config = ZFilesystemRestClient.getWorkspaceConnection(repo, wsHandle, monitor).configuration(compHandle);
        Map rootKidsMap = config.childEntries(config.rootFolderHandle(monitor), monitor);
        for (Map.Entry thisKid : rootKidsMap.entrySet()) {
            IVersionableHandle childVerHandle = (IVersionableHandle)thisKid.getValue();
            if (path == null || path.length() == 0 || folders.length == 0) {
                result.addAll(this.getAllFiles(repo, config, (IFolderHandle)childVerHandle, (String)thisKid.getKey(), folders, -1));
                continue;
            }
            if (!((String)thisKid.getKey()).matches(folders[0])) continue;
            result.addAll(this.getAllFiles(repo, config, (IFolderHandle)childVerHandle, (String)thisKid.getKey(), folders, 1));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getZComponentProjects(ParmsGetZComponentProject parms, IProgressMonitor monitor) throws IOException, FileSystemException, TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        ArrayList<String> result = new ArrayList<String>();
        IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.rwsUUID), null);
        IComponentHandle compHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.compUUID), null);
        IConfiguration config = ZFilesystemRestClient.getWorkspaceConnection(repo, wsHandle, monitor).configuration(compHandle);
        Map rootKidsMap = config.childEntries(config.rootFolderHandle(monitor), monitor);
        for (Map.Entry thisKid : rootKidsMap.entrySet()) {
            result.add((String)thisKid.getKey());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public NamedItemDTO[] getProjectAreas(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        List projectAreas = ((IProcessItemService)repo.getClientLibrary(IProcessItemService.class)).findAllProjectAreas(new ArrayList(), monitor);
        projectAreas = repo.itemManager().fetchPartialItems(projectAreas, 1, Arrays.asList("name", "archived"), monitor);
        int numPAs = projectAreas == null ? 0 : projectAreas.size();
        ArrayList<NamedItemDTO> result = new ArrayList<NamedItemDTO>();
        int i = 0;
        while (i < numPAs) {
            IProjectArea thisPA = (IProjectArea)projectAreas.get(i);
            if (!thisPA.isArchived()) {
                NamedItemDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
                thisDTO.setItemId(thisPA.getItemId().getUuidValue());
                thisDTO.setName(thisPA.getName());
                result.add(thisDTO);
            }
            ++i;
        }
        return result.toArray(new NamedItemDTO[result.size()]);
    }

    private IDataSetDefinition createDataSetDefinition(ITeamRepository repo, String fullDSName, String relativeName, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException, PDSManagerException {
        return ZFilesystemRestClient.doCreateDSDef(repo, relativeName, projectArea, PDSUtility.getPDSCharacteristics((String)fullDSName));
    }

    protected static IDataSetDefinition doCreateDSDef(ITeamRepository repo, String relativeName, IProjectAreaHandle projectArea, PDSInfo pdsInfo) throws TeamRepositoryException {
        ISystemDefinitionModelClient client = com.ibm.team.enterprise.systemdefinition.client.ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repo);
        DataSetDefinition dsdef = ModelFactory.eINSTANCE.createDataSetDefinition();
        dsdef.setUsageType(0);
        dsdef.setProjectArea(projectArea);
        dsdef.setDsName(relativeName);
        dsdef.setRecordLength(Integer.toString(pdsInfo.getLrecl()));
        dsdef.setBlockSize(Integer.toString(pdsInfo.getBlksize()));
        dsdef.setRecordFormat(pdsInfo.getRecfm());
        dsdef.setPrimaryQuantity(Integer.toString(pdsInfo.getPrimary()));
        dsdef.setSecondaryQuantity(Integer.toString(pdsInfo.getSecondary()));
        dsdef.setSpaceUnits(pdsInfo.getSpaceUnit());
        dsdef.setDirectoryBlocks("0");
        dsdef.setStorageClass(pdsInfo.getStorageClass());
        dsdef.setDsType(0);
        dsdef.setDescription(NLS.bind((String)Messages.ZFilesystemRestClient_DATASET_DEFINITION_DESCRIPTION, (Object)(String.valueOf(pdsInfo.getHLQ()) + '.' + pdsInfo.getDSName())));
        dsdef.setPrefixDSN(true);
        String name = relativeName;
        int suffix = 2;
        DataSetDefinition savedDSDef = null;
        while (savedDSDef == null) {
            try {
                dsdef.setName(name);
                client.saveSystemDefinition((ISystemDefinition)dsdef, null);
                savedDSDef = dsdef;
            }
            catch (SystemDefinitionValidationException ex) {
                if (suffix < 9999) {
                    name = String.valueOf(relativeName) + "(" + suffix + ")";
                    ++suffix;
                    continue;
                }
                throw ex;
            }
        }
        return (IDataSetDefinition)dsdef.getAdapter(IDataSetDefinition.class);
    }

    private static List<ChangesetDTO> convertChangeSets(ISPFSession session, List<IChangeSetHandle> csHandles, Set<String> potentialConflictUUIDs, boolean reverseOrder, IVersionableHandle versionable, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = session.getLoggedInRepository();
        List changesets = repo.itemManager().fetchPartialItems(csHandles, 0, Arrays.asList(IChangeSet.CONTEXT_ID_PROPERTY, IChangeSet.COMPONENT_PROPERTY, IChangeSet.COMMENT_PROPERTY, IChangeSet.AUTHOR_PROPERTY, IChangeSet.LAST_CHANGED_DATE_PROPERTY, IChangeSet.CHANGES_PROPERTY, IChangeSet.ACTIVE_PROPERTY), monitor);
        int numChangesets = changesets == null ? 0 : changesets.size();
        ArrayList<ChangesetDTO> result = new ArrayList<ChangesetDTO>();
        Map<UUID, Summary> summaries = ZFilesystemRestClient.getSummaries(repo, changesets, monitor);
        int i = 0;
        while (i < numChangesets) {
            ChangesetDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createChangesetDTO();
            int index = reverseOrder ? numChangesets - 1 - i : i;
            IChangeSet thisCS = (IChangeSet)changesets.get(index);
            thisDTO.setItemId(thisCS.getItemId().getUuidValue());
            thisDTO.setAuthor(((IContributor)repo.itemManager().fetchPartialItem((IItemHandle)thisCS.getAuthor(), 0, Collections.singletonList(IContributor.NAME_PROPERTY), monitor)).getName());
            thisDTO.setCreationDate(session.getDateFormat().format(thisCS.getLastChangeDate()));
            thisDTO.setICreationDate(thisCS.getLastChangeDate().getTime());
            thisDTO.setHasConflicts(ZFilesystemRestClient.hasConflicts(thisCS, potentialConflictUUIDs));
            IComponent curComponent = (IComponent)repo.itemManager().fetchPartialItem((IItemHandle)thisCS.getComponent(), 0, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
            thisDTO.setComponentName(curComponent.getName());
            thisDTO.setComponentId(curComponent.getItemId().getUuidValue());
            Summary s = summaries.get(thisCS.getItemId());
            thisDTO.setIsActive(thisCS.isActive());
            if (s != null) {
                thisDTO.setSummary(s.summary);
                thisDTO.setComment(s.comment);
            }
            if (versionable != null) {
                List changes = thisCS.changes();
                for (IChange change : changes) {
                    if (!change.item().getItemId().equals((Object)versionable.getItemId())) continue;
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                    IVersionableIdentifier versionableIdentifier = wm.getVersionableIdentifiers(new IVersionableHandle[]{change.afterState()}, null)[0];
                    if (versionableIdentifier == null) break;
                    thisDTO.setVersionId(versionableIdentifier.getShortVersionId());
                    break;
                }
            }
            result.add(thisDTO);
            ++i;
        }
        return result;
    }

    @Override
    public WorkspaceDetailsDTO[] getFlows(ParmsGetFlows parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        List<Object> streams = new ArrayList();
        ArrayList<WorkspaceDetailsDTO> result = new ArrayList<WorkspaceDetailsDTO>();
        if (parms.type.equals("STREAM") || parms.type.equals("BOTH")) {
            streams = Flow.findStreams(repo, null, parms.pattern, monitor);
        }
        if (parms.type.equals("WORKSPACE") || parms.type.equals("BOTH")) {
            streams.addAll(Flow.findWorkspaces(repo, null, parms.pattern, monitor));
        }
        int numStreams = streams == null ? 0 : streams.size();
        int i = 0;
        while (i < numStreams) {
            IWorkspace thisStream = (IWorkspace)streams.get(i);
            WorkspaceDetailsDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
            thisDTO.setItemId(thisStream.getItemId().getUuidValue());
            thisDTO.setName(thisStream.getName());
            thisDTO.setStream(thisStream.isStream());
            result.add(thisDTO);
            ++i;
        }
        return result.toArray(new WorkspaceDetailsDTO[result.size()]);
    }

    @Override
    public void postAddCollaboration(ParmsEditRepositoryWorkspace parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection local = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUID, monitor);
        IWorkspaceConnection remote = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.flowTargetUUID, monitor);
        FlowTableUtil.addCollaboration((IWorkspaceConnection)local, (IWorkspaceConnection)remote, (IProgressMonitor)monitor);
    }

    @Override
    public void postRemoveCollaboration(ParmsEditRepositoryWorkspace parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection local = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUID, monitor);
        IWorkspaceConnection remote = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.flowTargetUUID, monitor);
        FlowTableUtil.removeCollaboration((IWorkspaceConnection)local, (IWorkspaceConnection)remote, (IProgressMonitor)monitor);
    }

    @Override
    public WorkspaceDetailsDTO[] getCollaborations(ParmsEditRepositoryWorkspace parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ArrayList<WorkspaceDetailsDTO> result = new ArrayList<WorkspaceDetailsDTO>();
        IWorkspaceConnection local = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUID, monitor);
        IFlowTable flowTable = local.getFlowTable();
        IWorkspaceHandle cFlow = Flow.getFlowTarget(repo, local);
        IWorkspaceHandle dFlow = Flow.getDefaultFlowTarget(repo, local);
        for (IFlowEntry entry : flowTable.acceptSources()) {
            IWorkspaceHandle flow = (IWorkspaceHandle)entry.getFlowNode();
            IWorkspace thisFlow = (IWorkspace)repo.itemManager().fetchPartialItem((IItemHandle)flow, 0, Arrays.asList(IWorkspace.NAME_PROPERTY, IWorkspace.STREAM_PROPERTY, IWorkspace.ITEM_ID_PROPERTY), monitor);
            WorkspaceDetailsDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
            thisDTO.setItemId(thisFlow.getItemId().getUuidValue());
            thisDTO.setName(thisFlow.getName());
            thisDTO.setStream(thisFlow.isStream());
            thisDTO.setIsCurrent(thisFlow.sameItemId((IItemHandle)cFlow));
            thisDTO.setIsDefault(thisFlow.sameItemId((IItemHandle)dFlow));
            result.add(thisDTO);
        }
        return result.toArray(new WorkspaceDetailsDTO[result.size()]);
    }

    @Override
    public WorkspaceDetailsDTO[] getStreams(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ArrayList<WorkspaceDetailsDTO> result = new ArrayList<WorkspaceDetailsDTO>();
        List<IWorkspace> streams = Flow.findStreams(repo, session.getProjectArea(), "*", monitor);
        int numStreams = streams == null ? 0 : streams.size();
        int i = 0;
        while (i < numStreams) {
            IWorkspace thisStream = streams.get(i);
            WorkspaceDetailsDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
            thisDTO.setItemId(thisStream.getItemId().getUuidValue());
            thisDTO.setName(thisStream.getName());
            thisDTO.setStream(true);
            result.add(thisDTO);
            ++i;
        }
        return result.toArray(new WorkspaceDetailsDTO[result.size()]);
    }

    @Override
    public WorkspaceDetailsDTO getCurrentStream(ParmsGetCurrentStream parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUID, monitor);
        IWorkspaceHandle flowTarget = Flow.getFlowTarget(repo, wsConn, true);
        IWorkspaceConnection thisStream = ZFilesystemRestClient.getWorkspaceConnection(repo, flowTarget, monitor);
        WorkspaceDetailsDTO result = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
        result.setItemId(flowTarget.getItemId().getUuidValue());
        result.setName(thisStream.getName());
        result.setStream(true);
        return result;
    }

    @Override
    public void postEditRepositoryWorkspace(ParmsEditRepositoryWorkspace parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection connection = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUID, monitor);
        IPrivateScope scope = null;
        if ("private".equals(parms.visibility)) {
            scope = IReadScope.FACTORY.createPrivateScope();
            connection.setOwnerAndVisibility(IScmService.NOOP_OWNER, (IReadScope)scope, monitor);
        } else if ("public".equals(parms.visibility)) {
            scope = IReadScope.FACTORY.createPublicScope();
            connection.setOwnerAndVisibility(IScmService.NOOP_OWNER, (IReadScope)scope, monitor);
        } else {
            IContributorDeferringScope cds = IReadScope.FACTORY.createContributorDeferringScope();
            cds.setScope((IAuditableHandle)session.getProjectArea());
            connection.setOwnerAndVisibility((IAuditableHandle)repo.loggedInContributor(), (IReadScope)cds, null);
        }
        connection.setName(parms.name, monitor);
        connection.setDescription(parms.description, monitor);
    }

    @Override
    public String postCreateComponent(ParmsCreateComponent parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceManager wsMan = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.workspaceUUID, monitor);
        IComponent component = wsMan.createComponent(parms.name, (IAuditableHandle)repo.loggedInContributor(), monitor);
        IFlowNodeConnection.IComponentAdditionOp componentOps = wsConn.componentOpFactory().addComponent((IComponentHandle)component, false);
        wsConn.applyComponentOperations(Collections.singletonList(componentOps), monitor);
        IWorkspaceHandle streamHandle = Flow.getFlowTarget(repo, wsConn);
        if (streamHandle != null) {
            IWorkspaceConnection thisStream = ZFilesystemRestClient.getWorkspaceConnection(repo, streamHandle, monitor);
            thisStream.applyComponentOperations(Collections.singletonList(componentOps), monitor);
        }
        return component.getItemId().getUuidValue();
    }

    @Override
    public void postRemoveComponent(ParmsCollaboration parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.rwsUUID, monitor);
        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.compUUID), null);
        wsConn.applyComponentOperations(Collections.singletonList(wsConn.componentOpFactory().removeComponent(componentHandle, false)), false, null);
    }

    @Override
    public void postAddComponent(ParmsCollaboration parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.rwsUUID, monitor);
        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.compUUID), null);
        IWorkspaceHandle workspace = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.rwsUUID), null);
        IScmService scmService = (IScmService)((IClientLibraryContext)repo).getServiceInterface(IScmService.class);
        IBaselineHandle baseline = null;
        if (parms.baselineUUID != null) {
            baseline = (IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.baselineUUID), null);
            IBaselineConnection seed = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(baseline, monitor);
            wsConn.applyComponentOperations(Collections.singletonList(wsConn.componentOpFactory().addComponent(componentHandle, (IConnection)seed, false)), false, null);
        } else {
            IWorkspaceHandle streamHandle = Flow.getFlowTarget(repo, wsConn);
            scmService.addComponentFromWorkspace(workspace, componentHandle, streamHandle, false, null, null, null);
        }
    }

    @Override
    public String postCreateRepositoryWorkspace(ParmsCreateRepositoryWorkspace parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection flowTarget = parms.flowTargetUUID != null ? ZFilesystemRestClient.getWorkspaceConnection(repo, parms.flowTargetUUID, monitor) : null;
        IWorkspaceConnection newWS = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createWorkspace((IContributorHandle)repo.loggedInContributor(), parms.name, parms.description, flowTarget, null, monitor);
        IPrivateScope scope = null;
        if ("private".equals(parms.visibility)) {
            scope = IReadScope.FACTORY.createPrivateScope();
            newWS.setOwnerAndVisibility(IScmService.NOOP_OWNER, (IReadScope)scope, monitor);
        } else if ("public".equals(parms.visibility)) {
            scope = IReadScope.FACTORY.createPublicScope();
            newWS.setOwnerAndVisibility(IScmService.NOOP_OWNER, (IReadScope)scope, monitor);
        } else {
            IContributorDeferringScope cds = IReadScope.FACTORY.createContributorDeferringScope();
            cds.setScope((IAuditableHandle)session.getProjectArea());
            newWS.setOwnerAndVisibility((IAuditableHandle)repo.loggedInContributor(), (IReadScope)cds, null);
        }
        if (parms.flowTargetUUID != null) {
            IWorkspaceConnection streamConnection = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.flowTargetUUID, monitor);
            int numComponents = parms.components == null ? 0 : parms.components.length;
            ArrayList<IFlowNodeConnection.IComponentAdditionOp> addOps = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
            int i = 0;
            while (i < numComponents) {
                addOps.add(newWS.componentOpFactory().addComponent((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.components[i]), null), (IConnection)streamConnection, false));
                ++i;
            }
            newWS.applyComponentOperations(addOps, monitor);
        }
        return newWS.getResolvedWorkspace().getItemId().getUuidValue();
    }

    @Override
    public void postChangeFlowTarget(ParmsChangeFlow parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUID, monitor);
        IFlowTable flowTable = wsConn.getFlowTable().getWorkingCopy();
        if (parms.flowTargetUUID == null) {
            flowTable.unsetCurrentAcceptFlow();
            flowTable.unsetCurrentDeliverFlow();
        } else {
            IWorkspaceHandle target = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.flowTargetUUID), null);
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (parms.componentUUID != null) {
                IFlowEntry deliverEntry;
                IComponentHandle component = (IComponentHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.componentUUID), null);
                if (acceptEntry != null) {
                    flowTable.setCurrent(acceptEntry, component);
                }
                if ((deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target)) != null) {
                    flowTable.setCurrent(deliverEntry, component);
                }
            } else {
                IFlowEntry deliverEntry;
                if (acceptEntry != null) {
                    flowTable.setCurrent(acceptEntry);
                }
                if ((deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target)) != null) {
                    flowTable.setCurrent(deliverEntry);
                }
            }
        }
        wsConn.setFlowTable(flowTable, null);
    }

    @Override
    public String postCreateStream(ParmsCreateStream parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IProjectArea ipa = (IProjectArea)repo.itemManager().fetchPartialItem(IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.projectAreaUUID), null), 1, Collections.singletonList("name"), monitor);
        IWorkspaceConnection newStream = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createStream((IProcessAreaHandle)ipa, parms.name, "", null);
        return newStream.getResolvedWorkspace().getItemId().getUuidValue();
    }

    @Override
    public void postDeleteRepositoryWorkspace(ParmsDeleteRepositoryWorkspace parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        this.postUnload(new ParmsUnload(parms.passTicket, parms.clientKey, parms.rwsUUID, false), monitor);
        SCMPlatform.getWorkspaceManager((ITeamRepository)repo).deleteWorkspace((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.rwsUUID), null), monitor);
    }

    @Override
    public void postCancelDeliver(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ZFilesystemRestClient.getSession(parms.clientKey).setPendingDeliver(null);
    }

    @Override
    public void postCompleteChangeSet(ParmsCompleteChangeSet parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUID, monitor);
        int numCS = parms.changesetID == null ? 0 : parms.changesetID.length;
        ArrayList<IChangeSetHandle> csHandles = new ArrayList<IChangeSetHandle>(numCS);
        int i = 0;
        while (i < numCS) {
            csHandles.add((IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID[i]), null));
            ++i;
        }
        wsConn.ensureClosed(csHandles, monitor);
    }

    @Override
    public DeliverResultDTO postReRunDeliver(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        DeliverResultDTO result = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createDeliverResultDTO();
        IOperationReport oldReport = session.getPendingDeliver();
        if (oldReport != null) {
            session.setPendingDeliver(null);
            AdvisableOperation op = oldReport.getOperation();
            ITeamRepository repo = session.getLoggedInRepository();
            IProcessItemService service = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
            IClientProcess process = service.getClientProcess(op.getProcessArea(), monitor);
            try {
                process.reAdviseAndExecute(op, oldReport, monitor);
                result.setSuccess(true);
            }
            catch (TeamOperationCanceledException ex) {
                result.setSuccess(false);
                result.setMessage(ex.getMessage());
                IOperationReport newReport = ex.getReport();
                result.getReports().addAll(ZFilesystemRestClient.parseOperationReport(newReport));
                session.setPendingDeliver(newReport);
            }
        }
        return result;
    }

    @Override
    public DeliverResultDTO postDeliver(ParmsDeliver parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        int numCS = parms.changesetID == null ? 0 : parms.changesetID.length;
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>(numCS);
        int i = 0;
        while (i < numCS) {
            changeSets.add((IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID[i]), null));
            ++i;
        }
        int numBL = parms.baselineID == null ? 0 : parms.baselineID.length;
        ArrayList<IBaselineHandle> baselines = new ArrayList<IBaselineHandle>(numBL);
        int i2 = 0;
        while (i2 < numBL) {
            baselines.add((IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.baselineID[i2]), null));
            ++i2;
        }
        IWorkspaceConnection sourceConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.sourceWSUUID, monitor);
        IDeliverOperation deliverOperation = IOperationFactory.instance.getDeliverOperation((DeliverDilemmaHandler)ZDeliverDilemmaHandler.getInstance());
        deliverOperation.setPopulateUpdateReport(false);
        deliverOperation.deliver(sourceConn, SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(Flow.getFlowTarget(repo, sourceConn), monitor), ZFilesystemRestClient.getReport(repo, (IWorkspaceHandle)sourceConn.getResolvedWorkspace(), monitor), baselines, changeSets, new ArrayList());
        DeliverResultDTO result = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createDeliverResultDTO();
        try {
            ZFilesystemRestClient.runOp((IFileSystemOperation)deliverOperation, monitor);
            result.setSuccess(true);
        }
        catch (TeamOperationCanceledException ex) {
            result.setSuccess(false);
            result.setMessage(ex.getMessage());
            IOperationReport report = ex.getReport();
            result.getReports().addAll(ZFilesystemRestClient.parseOperationReport(report));
            session.setPendingDeliver(report);
        }
        return result;
    }

    private static List<AdvisorReportDTO> parseParticipantReport(IParticipantReport report) {
        ArrayList<AdvisorReportDTO> result = new ArrayList<AdvisorReportDTO>();
        if (report.getSeverity() == 4) {
            AdvisorReportDTO dto = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createAdvisorReportDTO();
            boolean overrulable = report.isOverrulable();
            dto.setIsOverrulable(overrulable);
            if (overrulable && report instanceof ParticipantReportImpl) {
                ((ParticipantReportImpl)report).setRequestOverrule(true);
            }
            String desc = "";
            IReportInfo[] infos = report.getInfos();
            if (infos != null) {
                int i = 0;
                while (i < infos.length && desc.length() == 0) {
                    String thisDesc = infos[i].getDescription();
                    if (thisDesc != null && thisDesc.trim().length() > 0) {
                        desc = thisDesc;
                    }
                    ++i;
                }
            }
            dto.setMessage(desc);
            result.add(dto);
        }
        return result;
    }

    private static List<AdvisorReportDTO> parseOperationReport(IOperationReport report) {
        ArrayList<AdvisorReportDTO> result = new ArrayList<AdvisorReportDTO>();
        if (report.getSeverity() == 4) {
            IOperationReport[] opReports;
            int n;
            IParticipantReport[] participantReports = report.getParticipantReports();
            if (participantReports != null) {
                IParticipantReport[] iParticipantReportArray = participantReports;
                n = participantReports.length;
                int n2 = 0;
                while (n2 < n) {
                    IParticipantReport pRept = iParticipantReportArray[n2];
                    result.addAll(ZFilesystemRestClient.parseParticipantReport(pRept));
                    ++n2;
                }
            }
            if ((opReports = report.getOperationReports()) != null) {
                IOperationReport[] iOperationReportArray = opReports;
                int n3 = opReports.length;
                n = 0;
                while (n < n3) {
                    IOperationReport opRept = iOperationReportArray[n];
                    result.addAll(ZFilesystemRestClient.parseOperationReport(opRept));
                    ++n;
                }
            }
        }
        return result;
    }

    @Override
    public void postAssociateWI(ParmsAssociateWI parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        ZFilesystemRestClient.doWIAssociation(repo, parms.workItem, (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null), ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUID, monitor), monitor);
    }

    @Override
    public void postDissociateWI(ParmsAssociateWI parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null);
        IFileSystemWorkItemManager manager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        ProviderFactory providerFactory = (ProviderFactory)repo.getClientLibrary(ProviderFactory.class);
        List links = ChangeSetLinks.findLinks((ProviderFactory)providerFactory, (IChangeSetHandle)changeSetHandle, (String[])new String[]{"com.ibm.team.filesystem.workitems.change_set"}, (IProgressMonitor)monitor);
        ILink linkToRemove = null;
        IWorkItem workItemHandle = ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).findWorkItemById(Integer.parseInt(parms.workItem), IWorkItem.SMALL_PROFILE, monitor);
        if (workItemHandle == null) {
            throw new ItemNotFoundException(NLS.bind((String)Messages.ZFilesystemRestClient_WORK_ITEM_NOT_FOUND, (Object)parms.workItem));
        }
        for (ILink link : links) {
            IItemHandle refHandle;
            IReference targetRef = link.getTargetRef();
            if (!targetRef.isItemReference() || !((refHandle = ((IItemReference)targetRef).getReferencedItem()) instanceof IWorkItemHandle) || !refHandle.sameItemId((IItemHandle)workItemHandle)) continue;
            linkToRemove = link;
        }
        manager.deleteLinks(Collections.singletonList(linkToRemove), monitor);
    }

    @Override
    public WorkitemDTO[] getAllAssociatedWI(ParmsAllAssociatedWI parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ArrayList<WorkitemDTO> result = new ArrayList<WorkitemDTO>();
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null);
        IProjectAreaHandle pa = session.getProjectArea();
        IWorkItemClient wiClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        ProviderFactory providerFactory = (ProviderFactory)repo.getClientLibrary(ProviderFactory.class);
        List links = ChangeSetLinks.findLinks((ProviderFactory)providerFactory, (IChangeSetHandle)changeSetHandle, (String[])new String[]{"com.ibm.team.filesystem.workitems.change_set"}, (IProgressMonitor)monitor);
        for (ILink link : links) {
            IItemHandle refHandle;
            IReference targetRef = link.getTargetRef();
            if (!targetRef.isItemReference() || !((refHandle = ((IItemReference)targetRef).getReferencedItem()) instanceof IWorkItemHandle)) continue;
            IWorkItem thisWI = (IWorkItem)repo.itemManager().fetchPartialItem(refHandle, 1, Arrays.asList(IWorkItem.ID_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.STATE_PROPERTY, IWorkItem.TYPE_PROPERTY), null);
            WorkitemDTO workitemDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkitemDTO();
            workitemDTO.setItemId(Integer.toString(thisWI.getId()));
            workitemDTO.setSummary(thisWI.getHTMLSummary().getPlainText());
            workitemDTO.setType(thisWI.getWorkItemType());
            String stateName = "";
            try {
                Identifier state = null;
                state = thisWI.getState2();
                IWorkflowInfo workflowInfo = wiClient.getWorkflow(thisWI.getWorkItemType(), pa, monitor);
                stateName = workflowInfo.getStateName(state);
            }
            catch (Exception exception) {
                // empty catch block
            }
            workitemDTO.setStatus(stateName);
            result.add(workitemDTO);
        }
        return result.toArray(new WorkitemDTO[result.size()]);
    }

    @Override
    public void postDiscard(ParmsDiscard parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        int numCS = parms.changesetID == null ? 0 : parms.changesetID.length;
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>(numCS);
        int i = 0;
        while (i < numCS) {
            changeSets.add((IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID[i]), null));
            ++i;
        }
        ZDiscardDilemmaHandler handler = new ZDiscardDilemmaHandler();
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        IDiscardOperation op = IOperationFactory.instance.getDiscardOperation((DiscardDilemmaHandler)handler);
        op.discard(ZFilesystemRestClient.getWorkspaceConnection(session.getLoggedInRepository(), parms.wsUUID, monitor), changeSets);
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            ZFilesystemRestClient.runChangeChangesetHistoryOp((IFileSystemOperation)op, handler, monitor);
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public UnresolvedDTO[] getUnresolved(ParmsLoadz parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceHandle targetWSHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.workspaceUUID), null);
        ArrayList<UnresolvedDTO> result = new ArrayList<UnresolvedDTO>();
        int numSandbox = 0;
        ISandbox mvsSandbox = parms.mvsPrefix == null ? null : this.getSandbox(parms.mvsPrefix);
        ++numSandbox;
        ISandbox hfsSandbox = parms.hfsDestination == null ? null : this.getSandbox(parms.hfsDestination);
        ISandbox[] sandboxes = new ISandbox[++numSandbox];
        numSandbox = 0;
        if (mvsSandbox != null) {
            sandboxes[numSandbox++] = mvsSandbox;
        }
        if (hfsSandbox != null) {
            sandboxes[numSandbox] = hfsSandbox;
        }
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.workspaceUUID, monitor);
            LocalChangeManager lcm = LocalChangeManager.getInstance();
            lcm.refreshChanges(sandboxes, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, monitor);
            List components = repo.itemManager().fetchPartialItems(Flow.getIncludedComponents(repo, wsConn, monitor), 1, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
            ILocalChange[] mvsChanges = null;
            ILocalChange[] hfsChanges = null;
            for (IComponent comp : components) {
                String sPath;
                IRelativeLocation path;
                UnresolvedDTO unresolvedDTO;
                ILocalChange change;
                int n;
                int n2;
                ILocalChange[] iLocalChangeArray;
                String root;
                if (mvsSandbox != null) {
                    lcm.syncPendingChanges((IContextHandle)targetWSHandle, (IComponentHandle)comp, mvsSandbox, monitor);
                    mvsChanges = lcm.getPendingChanges((IContextHandle)targetWSHandle, (IComponentHandle)comp, mvsSandbox);
                    root = String.valueOf(mvsSandbox.getRoot().toOSString()) + '.';
                    iLocalChangeArray = mvsChanges;
                    n2 = mvsChanges.length;
                    n = 0;
                    while (n < n2) {
                        change = iLocalChangeArray[n];
                        unresolvedDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createUnresolvedDTO();
                        path = change.getPath();
                        sPath = String.valueOf(root) + path.segment(0) + '(' + path.segment(1) + ')';
                        unresolvedDTO.setPath(sPath);
                        unresolvedDTO.setType(change.getType());
                        result.add(unresolvedDTO);
                        ++n;
                    }
                }
                if (hfsSandbox == null) continue;
                lcm.syncPendingChanges((IContextHandle)targetWSHandle, (IComponentHandle)comp, mvsSandbox, monitor);
                hfsChanges = lcm.getPendingChanges((IContextHandle)targetWSHandle, (IComponentHandle)comp, hfsSandbox);
                root = hfsSandbox.getRoot().toOSString();
                iLocalChangeArray = hfsChanges;
                n2 = hfsChanges.length;
                n = 0;
                while (n < n2) {
                    change = iLocalChangeArray[n];
                    unresolvedDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createUnresolvedDTO();
                    path = change.getPath();
                    sPath = String.valueOf(root) + path.toPath().toOSString();
                    unresolvedDTO.setPath(sPath);
                    unresolvedDTO.setType(change.getType());
                    result.add(unresolvedDTO);
                    ++n;
                }
            }
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        return result.toArray(new UnresolvedDTO[result.size()]);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void postCheckinAll(ParmsLoadz parms, IProgressMonitor monitor) throws Exception {
        block13: {
            block14: {
                if (ZFilesystemRestClient.LOG.isDebugEnabled()) {
                    ZFilesystemRestClient.LOG.debug((Object)parms);
                }
                session = ZFilesystemRestClient.getSession(parms.clientKey);
                repo = session.getLoggedInRepository();
                targetWSHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.workspaceUUID), null);
                numSandbox = 0;
                mvsSandbox = parms.mvsPrefix == null ? null : this.getSandbox(parms.mvsPrefix);
                ++numSandbox;
                hfsSandbox = parms.hfsDestination == null ? null : this.getSandbox(parms.hfsDestination);
                sandboxes = new ISandbox[++numSandbox];
                numSandbox = 0;
                if (mvsSandbox != null) {
                    sandboxes[numSandbox++] = mvsSandbox;
                }
                if (hfsSandbox != null) {
                    sandboxes[numSandbox] = hfsSandbox;
                }
                this.switchAuth(session.getMVSID(), parms.passTicket);
                try {
                    wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.workspaceUUID, monitor);
                    lcm = LocalChangeManager.getInstance();
                    lcm.refreshChanges(sandboxes, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, monitor);
                    components = repo.itemManager().fetchPartialItems(Flow.getIncludedComponents(repo, wsConn, monitor), 1, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
                    mvsChanges = null;
                    hfsChanges = null;
                    allChanges = new ArrayList<ILocalChange>();
                    for (IComponent comp : components) {
                        if (mvsSandbox != null) {
                            lcm.syncPendingChanges((IContextHandle)targetWSHandle, (IComponentHandle)comp, mvsSandbox, monitor);
                            var21_26 = mvsChanges = lcm.getPendingChanges((IContextHandle)targetWSHandle, (IComponentHandle)comp, mvsSandbox);
                            var20_25 = mvsChanges.length;
                            var19_23 = 0;
                            while (var19_23 < var20_25) {
                                change = var21_26[var19_23];
                                allChanges.add(change);
                                ++var19_23;
                            }
                        }
                        if (hfsSandbox == null) continue;
                        lcm.syncPendingChanges((IContextHandle)targetWSHandle, (IComponentHandle)comp, mvsSandbox, monitor);
                        var21_26 = hfsChanges = lcm.getPendingChanges((IContextHandle)targetWSHandle, (IComponentHandle)comp, hfsSandbox);
                        var20_25 = hfsChanges.length;
                        var19_23 = 0;
                        while (var19_23 < var20_25) {
                            change = var21_26[var19_23];
                            allChanges.add(change);
                            ++var19_23;
                        }
                    }
                    if (allChanges.size() > 0) {
                        checkinOperation = IOperationFactory.instance.getCheckinOperation((CommitDilemmaHandler)ZCommitDilemmaHandler.getDefault(), ZFilesystemRestClient.getRepositoryResolver(repo));
                        changes = allChanges.toArray(new ILocalChange[allChanges.size()]);
                        csHandle = parms.changesetID == null ? null : (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null);
                        workItem = null;
                        if (parms.workItem != null && csHandle != null) {
                            workItem = ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).findWorkItemById(Integer.parseInt(parms.workItem), IWorkItem.SMALL_PROFILE, monitor);
                            if (workItem == null) {
                                throw new ItemNotFoundException(NLS.bind((String)Messages.ZFilesystemRestClient_WORK_ITEM_NOT_FOUND, (Object)parms.workItem));
                            }
                            ZFilesystemRestClient.doWIAssociation(repo, workItem, csHandle, wsConn, monitor);
                        }
                        checkinOperation.requestCheckin(changes, csHandle, parms.comment == null ? "" : parms.comment, monitor);
                        ZFilesystemRestClient.runCheckinOp((IFileSystemOperation)checkinOperation, ZCommitDilemmaHandler.getDefault(), monitor);
                    }
                    break block13;
                }
                catch (Exception e) {
                    this.unSwitchAuth(session.getMVSID(), parms.passTicket);
                    if (ZCommitDilemmaHandler.getDefault().getFailedEncoded().size() <= 0) break block14;
                    error = new StringBuilder();
                    ** for (failure : ZCommitDilemmaHandler.getDefault().getFailedEncoded())
                }
lbl-1000:
                // 1 sources

                {
                    error.append(failure.getStatus().getMessage());
                    error.append("\n");
                    continue;
                }
lbl72:
                // 1 sources

                throw new Exception(error.toString());
            }
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public WarningDTO postAccept(ParmsAccept parms, IProgressMonitor monitor) throws Exception {
        int numBL;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceUpdateOperation op = IOperationFactory.instance.getWorkspaceUpdateOperation((WorkspaceUpdateDilemmaHandler)ZWorkspaceUpdateDilemmaHandler.getDefault());
        ZWorkspaceUpdateDilemmaHandler.getDefault().setPermitsUncheckedIn(parms.getPermitsUnchecked());
        IWorkspaceHandle targetWSHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.wsUUID), null);
        IWorkspaceConnection targetWSConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(targetWSHandle, monitor);
        WarningDTO warning = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWarningDTO();
        int numCS = parms.changesetID == null ? 0 : parms.changesetID.length;
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>(numCS);
        int i = 0;
        while (i < numCS) {
            changeSets.add((IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID[i]), null));
            ++i;
        }
        op.acceptChangeSets(targetWSConn, repo, changeSets);
        int n = numBL = parms.baselineID == null ? 0 : parms.baselineID.length;
        if (numBL > 0) {
            ArrayList<IBaselineHandle> baselines = new ArrayList<IBaselineHandle>(numBL);
            int i2 = 0;
            while (i2 < numBL) {
                baselines.add((IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.baselineID[i2]), null));
                ++i2;
            }
            op.accept(targetWSConn, SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(Flow.getFlowTarget(repo, targetWSConn), monitor), ZFilesystemRestClient.getReport(repo, targetWSHandle, monitor), baselines, new ArrayList(), new ArrayList());
        }
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            ZFilesystemRestClient.runChangeChangesetHistoryOp((IFileSystemOperation)op, ZWorkspaceUpdateDilemmaHandler.getDefault(), monitor);
        }
        catch (AcceptException e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            warning.setStatus(-1);
            warning.setMessage(e.getMessage());
            return warning;
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        warning.setStatus(targetWSConn.conflictReport().conflicts().size());
        return warning;
    }

    private static void doWIAssociation(ITeamRepository repo, IWorkItem workItem, IChangeSetHandle csHandle, IWorkspaceConnection wsConn, IProgressMonitor monitor) throws TeamRepositoryException {
        IFileSystemWorkItemManager wiManager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        wiManager.createLink((IWorkspaceHandle)wsConn.getResolvedWorkspace(), csHandle, new IWorkItemHandle[]{workItem}, monitor);
    }

    private static void doWIAssociation(ITeamRepository repo, String wiNumber, IChangeSetHandle csHandle, IWorkspaceConnection wsConn, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItem workItem = ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).findWorkItemById(Integer.parseInt(wiNumber), IWorkItem.SMALL_PROFILE, monitor);
        if (workItem == null) {
            throw new ItemNotFoundException(NLS.bind((String)Messages.ZFilesystemRestClient_WORK_ITEM_NOT_FOUND, (Object)wiNumber));
        }
        IFileSystemWorkItemManager wiManager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        wiManager.createLink((IWorkspaceHandle)wsConn.getResolvedWorkspace(), csHandle, new IWorkItemHandle[]{workItem}, monitor);
    }

    private List<ILocalChange> getAllLocalDeletions(ISandbox sandbox, IProgressMonitor monitor) throws FileSystemException {
        ArrayList<ILocalChange> allLocalDeletions = new ArrayList<ILocalChange>();
        ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
        lcm.refreshChanges(new ISandbox[]{sandbox}, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, monitor);
        Collection configDescriptors = sandbox.allLoadedConfigurations(monitor);
        for (LoadedConfigurationDescriptor descriptor : configDescriptors) {
            ILocalChange[] changes;
            lcm.syncPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, sandbox, monitor);
            ILocalChange[] iLocalChangeArray = changes = lcm.getPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, sandbox);
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange thisChange = iLocalChangeArray[n2];
                if (thisChange.isType(4)) {
                    allLocalDeletions.add(thisChange);
                }
                ++n2;
            }
        }
        return allLocalDeletions;
    }

    @Override
    public void postCheckin(ParmsCheckin parms, IProgressMonitor monitor) throws Exception {
        int numMembers;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        int n = numMembers = parms.members == null ? 0 : parms.members.length;
        if (numMembers == 0) {
            return;
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        if (parms.newCS.booleanValue()) {
            IWorkItem workItem = null;
            if (parms.workItem != null && (workItem = ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).findWorkItemById(Integer.parseInt(parms.workItem), IWorkItem.SMALL_PROFILE, monitor)) == null) {
                throw new ItemNotFoundException(NLS.bind((String)Messages.ZFilesystemRestClient_WORK_ITEM_NOT_FOUND, (Object)parms.workItem));
            }
            ISharingDescriptor descriptor = ZFilesystemRestClient.findShareable(parms.members[0], session).getShare(monitor).getSharingDescriptor();
            IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, (IWorkspaceHandle)descriptor.getConnectionHandle(), monitor);
            IChangeSetHandle csHandle = wsConn.createChangeSet(descriptor.getComponent(), parms.comment == null ? "" : parms.comment, true, monitor);
            if (parms.workItem != null) {
                ZFilesystemRestClient.doWIAssociation(repo, workItem, csHandle, wsConn, monitor);
            }
            parms.changesetID = csHandle.getItemId().getUuidValue();
        }
        IChangeSetHandle csHandle = parms.changesetID == null ? null : (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null);
        ICheckinOperation checkinOperation = IOperationFactory.instance.getCheckinOperation((CommitDilemmaHandler)ZCommitDilemmaHandler.getDefault(), ZFilesystemRestClient.getRepositoryResolver(repo));
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            ArrayList<IShareable> shareables = new ArrayList<IShareable>();
            ArrayList<String> possibleDeletions = new ArrayList<String>();
            ArrayList<ILocalChange> deletions = new ArrayList<ILocalChange>();
            int i = 0;
            while (i < numMembers) {
                IShareable thisShareable = ZFilesystemRestClient.findShareable(parms.members[i], session);
                if (thisShareable != null) {
                    if (thisShareable.exists(monitor)) {
                        shareables.add(thisShareable);
                    } else {
                        possibleDeletions.add(parms.members[i]);
                    }
                }
                ++i;
            }
            checkinOperation.requestCheckin(shareables.toArray(new IShareable[shareables.size()]), csHandle, parms.comment, monitor);
            if (possibleDeletions.size() > 0) {
                ISandbox sandbox = this.getSandbox(ZFilesystemRestClient.findShareRoot((String)possibleDeletions.get(0), session));
                ILocation root = sandbox.getRoot();
                List<ILocalChange> allLocalDeletions = this.getAllLocalDeletions(sandbox, monitor);
                for (String possibleDeletion : possibleDeletions) {
                    ILocalChange matchingDel = null;
                    int numLocalDels = allLocalDeletions == null ? 0 : allLocalDeletions.size();
                    int i2 = 0;
                    while (i2 < numLocalDels && matchingDel == null) {
                        ILocalChange thisDel = allLocalDeletions.get(i2);
                        IRelativeLocation origPath = thisDel.getOriginalPath();
                        if (root.append(origPath = origPath.getParent().append(this.getActualMemberName(origPath))).toOSString().equals(possibleDeletion)) {
                            allLocalDeletions.remove(i2);
                            matchingDel = thisDel;
                        }
                        ++i2;
                    }
                    if (matchingDel == null) continue;
                    deletions.add(matchingDel);
                }
            }
            if (deletions.size() > 0) {
                checkinOperation.requestCheckin(deletions.toArray(new ILocalChange[deletions.size()]), csHandle, parms.comment, monitor);
            }
            ZFilesystemRestClient.runCheckinOp((IFileSystemOperation)checkinOperation, ZCommitDilemmaHandler.getDefault(), monitor);
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public void postLock(ParmsLock parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ILockOperation lockOperation = IOperationFactory.instance.getLockOperation(null);
        int numMembers = parms.members == null ? 0 : parms.members.length;
        int i = 0;
        while (i < numMembers) {
            IShareable shareable = ZFilesystemRestClient.findShareable(parms.members[i], session);
            ISharingDescriptor descriptor = shareable.getShare(monitor).getSharingDescriptor();
            IWorkspaceHandle flowTarget = Flow.getFlowTarget(repo, ZFilesystemRestClient.getWorkspaceConnection(repo, (IWorkspaceHandle)descriptor.getConnectionHandle(), monitor));
            if (flowTarget != null) {
                lockOperation.lock(SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(flowTarget, monitor), descriptor.getComponent(), shareable.getVersionable(monitor));
            }
            ++i;
        }
        lockOperation.run(monitor);
    }

    @Override
    public void postUnlock(ParmsLock parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IUnlockOperation unlockOperation = IOperationFactory.instance.getUnlockOperation(null);
        int numMembers = parms.members == null ? 0 : parms.members.length;
        int i = 0;
        while (i < numMembers) {
            IShareable shareable = ZFilesystemRestClient.findShareable(parms.members[i], session);
            ISharingDescriptor descriptor = shareable.getShare(monitor).getSharingDescriptor();
            IWorkspaceHandle flowTarget = Flow.getFlowTarget(repo, ZFilesystemRestClient.getWorkspaceConnection(repo, (IWorkspaceHandle)descriptor.getConnectionHandle(), monitor));
            if (flowTarget != null) {
                unlockOperation.unlock(SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(flowTarget, monitor), descriptor.getComponent(), shareable.getVersionable(monitor), (IContributorHandle)repo.loggedInContributor());
            }
            ++i;
        }
        unlockOperation.run(monitor);
    }

    @Override
    public String[] postShare(ParmsShare parms, IProgressMonitor monitor) throws ZComponentException, FileAgentRepositoryException, TeamRepositoryException, PDSManagerException, Exception {
        ArrayList<String> csUUIDs;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.workspaceUUID, monitor);
        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.componentUUID), null);
        IChangeSetHandle csHandle = null;
        if (parms.changesetID != null && parms.changesetID.length() > 0) {
            csHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null);
        }
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            ArrayList<ISandbox> sandboxesToRemove;
            IConfiguration config;
            IShareOperation shareOp;
            block41: {
                if (parms.createProject.booleanValue()) {
                    if (!parms.hfs.booleanValue()) {
                        IspfZComponentFactory.createZComponentProject(repo, wsConn, componentHandle, parms.projectName, monitor);
                        if (csHandle == null) {
                            csHandle = wsConn.getCurrentChangeSet(componentHandle);
                        }
                        SCMPlatform.getWorkspaceManager((ITeamRepository)repo).setComment(csHandle, parms.comment == null ? Messages.ZFilesystemRestClient_SHARE_PROJECTS : parms.comment, monitor);
                    } else if (csHandle == null) {
                        csHandle = wsConn.createChangeSet(componentHandle, parms.comment == null ? Messages.ZFilesystemRestClient_SHARE_PROJECTS : parms.comment, true, monitor);
                    }
                } else if (csHandle == null) {
                    csHandle = wsConn.createChangeSet(componentHandle, parms.comment == null ? "" : parms.comment, true, monitor);
                }
                if (parms.workItem != null && parms.workItem.length() > 0) {
                    ZFilesystemRestClient.doWIAssociation(repo, parms.workItem, csHandle, wsConn, monitor);
                }
                shareOp = IOperationFactory.instance.getShareOperation((ShareDilemmaHandler)ZShareDilemmaHandler.getInstance());
                config = wsConn.configuration(componentHandle);
                sandboxesToRemove = new ArrayList<ISandbox>();
                int numFolders = parms.zFolders == null ? 0 : parms.zFolders.length;
                int i = 0;
                while (i < numFolders) {
                    ParmsZFolderShare pzs = parms.zFolders[i];
                    if (parms.hfs.booleanValue()) {
                        int numMembers = pzs.getFiles() == null ? 0 : pzs.getFiles().length;
                        int j = 0;
                        while (j < numMembers) {
                            ArrayList<PathLocation> toShare = new ArrayList<PathLocation>();
                            if (parms.createProject.booleanValue()) {
                                this.createEclipseProject(pzs.getName(), pzs.getFiles()[j]);
                            }
                            toShare.add(new PathLocation(String.valueOf(pzs.getName()) + '/' + pzs.getFiles()[j]));
                            shareOp.share(wsConn, csHandle, componentHandle, toShare, false, monitor);
                            ++j;
                        }
                    } else {
                        String relativePath;
                        boolean inExistingSandbox;
                        String sandboxRoot = ZFilesystemRestClient.findShareRoot(pzs.getName(), session);
                        if (!IspfZComponentFactory.isZfolderExist(wsConn, componentHandle, parms.projectName, pzs.getFolderName(), monitor)) {
                            String dsdefUUID;
                            if (pzs.dsdefUUID == null) {
                                String relativeDSName = pzs.getName();
                                if (sandboxRoot != null && relativeDSName.startsWith(sandboxRoot) && (relativeDSName = relativeDSName.substring(sandboxRoot.length())).length() > 0 && relativeDSName.charAt(0) == '.') {
                                    relativeDSName = relativeDSName.substring(1);
                                }
                                IDataSetDefinition createdDSDef = this.createDataSetDefinition(repo, pzs.getName(), relativeDSName, session.getProjectArea(), monitor);
                                dsdefUUID = createdDSDef.getItemId().getUuidValue();
                            } else {
                                dsdefUUID = pzs.dsdefUUID;
                            }
                            IspfZComponentFactory.createZFolder(repo, wsConn, componentHandle, parms.projectName, dsdefUUID, pzs.getFolderName(), monitor);
                        }
                        int numMembers = pzs.getFiles() == null ? 0 : pzs.getFiles().length;
                        ArrayList<RelativeLocation> locations = new ArrayList<RelativeLocation>();
                        boolean bl = inExistingSandbox = sandboxRoot != null;
                        if (!inExistingSandbox) {
                            sandboxRoot = pzs.getName();
                        }
                        ISandbox sandbox = this.getSandbox(sandboxRoot);
                        if (!inExistingSandbox) {
                            sandboxesToRemove.add(sandbox);
                        }
                        if ((relativePath = pzs.getName().substring(sandboxRoot.length())).length() > 0 && relativePath.charAt(0) == '.') {
                            relativePath = relativePath.substring(1);
                        }
                        int j = 0;
                        while (j < numMembers) {
                            if (relativePath.length() > 0) {
                                locations.add(new RelativeLocation(new String[]{relativePath, pzs.getFiles()[j]}));
                            } else {
                                locations.add(new RelativeLocation(new String[]{pzs.getFiles()[j]}));
                            }
                            ++j;
                        }
                        IFolderHandle ifh = null;
                        ifh = (IFolderHandle)config.resolvePath(config.rootFolderHandle(monitor), new String[]{parms.projectName, "zOSsrc", pzs.getFolderName()}, monitor);
                        shareOp.share(wsConn, csHandle, componentHandle, ifh, new String[]{}, sandbox, locations, pzs.getRemoteNames() == null ? null : Arrays.asList(pzs.getRemoteNames()), false, null, monitor);
                        for (IRelativeLocation iRelativeLocation : locations) {
                            shareOp.assignFileProperties(sandbox.getRoot().append(iRelativeLocation), parms.binary != false ? FileLineDelimiter.LINE_DELIMITER_NONE : FileLineDelimiter.LINE_DELIMITER_PLATFORM, parms.binary != false ? "application/unknown" : "text/plain", monitor);
                        }
                    }
                    ++i;
                }
                try {
                    ZFilesystemRestClient.runOp((IFileSystemOperation)shareOp, monitor);
                }
                catch (Exception e) {
                    if ((!(e instanceof FileSystemStatusException) || ZShareDilemmaHandler.getInstance().getFailedEncoded() != null) && ZShareDilemmaHandler.getInstance().getFailedEncoded().size() > 0) break block41;
                    throw e;
                }
            }
            for (ISandbox sandbox : sandboxesToRemove) {
                FileSystemCore.getSharingManager().deregister(sandbox, monitor);
            }
            csUUIDs = new ArrayList<String>();
            Collection commitedChangeSets = shareOp.getCommittedChangeSets();
            if (commitedChangeSets != null) {
                if (commitedChangeSets.size() == 0) {
                    csUUIDs.add(csHandle.getItemId().getUuidValue());
                } else {
                    Iterator csIt = commitedChangeSets.iterator();
                    while (csIt.hasNext()) {
                        csUUIDs.add(((IChangeSetHandle)csIt.next()).getItemId().getUuidValue());
                    }
                }
            }
            if (!parms.hfs.booleanValue() && parms.createProject.booleanValue() && parms.hfsSandbox != null) {
                IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 1, monitor);
                String[] componentPath = new String[]{parms.projectName};
                IVersionableHandle remoteItem = config.resolvePath(component.getRootFolder(), componentPath, null);
                ISandbox hfsSandbox = this.getSandbox(parms.hfsSandbox);
                if (hfsSandbox != null) {
                    ISPFLoadOperation hfsISPFLoadOp = null;
                    ILoadOperation hfsLoadOp = null;
                    if (ispfLoad) {
                        hfsISPFLoadOp = new ISPFLoadOperation(UssLoadDilemmahandler.getInstance());
                        hfsISPFLoadOp.setLoadFilter(this.getHFSLoadFilter());
                        hfsISPFLoadOp.requestLoad(hfsSandbox, null, wsConn, componentHandle, Collections.singletonList(remoteItem));
                        ZFilesystemRestClient.runOp(hfsISPFLoadOp, monitor);
                    } else {
                        hfsLoadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)UssLoadDilemmahandler.getInstance());
                        hfsLoadOp.setLoadFilter(this.getHFSLoadFilter());
                        hfsLoadOp.requestLoad(hfsSandbox, null, wsConn, componentHandle, Collections.singletonList(remoteItem));
                        ZFilesystemRestClient.runOp((IFileSystemOperation)hfsLoadOp, monitor);
                    }
                    ZFilesystemRestClient.runOp(ispfLoad ? hfsISPFLoadOp : hfsLoadOp, monitor);
                }
            }
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        if (ZShareDilemmaHandler.getInstance().getFailedEncoded() != null && ZShareDilemmaHandler.getInstance().getFailedEncoded().size() > 0) {
            StringBuilder error = new StringBuilder();
            for (IEncodingUploadFailure failure : ZShareDilemmaHandler.getInstance().getFailedEncoded()) {
                error.append(failure.getStatus().getMessage());
                error.append("\n");
            }
            ZShareDilemmaHandler.getInstance().getFailedEncoded().clear();
            throw new Exception(error.toString());
        }
        return csUUIDs.toArray(new String[csUUIDs.size()]);
    }

    @Override
    public String[] postShareLike(ParmsShareLike parms, IProgressMonitor monitor) throws ZComponentException, FileAgentRepositoryException, TeamRepositoryException, PDSManagerException, Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IShareable modelShareable = ZFilesystemRestClient.findShareable(parms.modelName, session);
        if (modelShareable != null) {
            ArrayList<String> csUUIDs;
            IConfiguration config;
            String pathModel = null;
            ISharingDescriptor descriptor = modelShareable.getShare(monitor).getSharingDescriptor();
            String workspaceUUID = descriptor.getConnectionHandle().getItemId().getUuidValue();
            IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, workspaceUUID, monitor);
            IComponentHandle componentHandle = descriptor.getComponent();
            try {
                config = ZFilesystemRestClient.getWorkspaceConnection(repo, (IWorkspaceHandle)descriptor.getConnectionHandle(), monitor).configuration(descriptor.getComponent());
            }
            catch (TeamRepositoryException ex) {
                config = null;
            }
            ISystemDefinitionModelClient isdc = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
            FileLineDelimiter lineDelimiter = modelShareable.getLineDelimiter(monitor);
            String contentType = modelShareable.getContentType(monitor);
            Boolean binary = contentType.equalsIgnoreCase("application/unknown") && lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE);
            Map modelProperties = modelShareable.getMetadataProperties(monitor).getCurrentProperties();
            for (String key : modelProperties.keySet()) {
                String codepageVal;
                if (!key.equals("team.enterprise.language.definition") && !key.equals("team.enterprise.build.changes.ignoreForDependencyBuild") && !key.equals("team.enterprise.build.alwaysload") && !key.startsWith("team.enterprise.build.var.") && !key.equals("mvsCodePage") || key.equals("mvsCodePage") && ((codepageVal = (String)modelProperties.get("mvsCodePage")) == null || codepageVal.length() <= 0) || !key.equals("team.enterprise.language.definition") || repo == null) continue;
                String uuidValue = (String)modelProperties.get("team.enterprise.language.definition");
                ILanguageDefinition langDef = (ILanguageDefinition)isdc.findSystemDefinition(uuidValue, null, ILanguageDefinition.ITEM_TYPE, monitor);
                List translators = langDef.getTranslators();
                for (ITranslatorEntry entry : translators) {
                    ITranslator translator;
                    if (entry.getKind() != "com.ibm.team.enterprise.systemdefinition.entry.translator" || (translator = (ITranslator)isdc.findSystemDefinition(entry.getValue(), null, ITranslator.ITEM_TYPE, (IProgressMonitor)new NullProgressMonitor())) == null) continue;
                    List translatorVars = translator.getVariables();
                    for (IVariable v : translatorVars) {
                        if (this.isReservedVariable(v)) continue;
                        Properties props = new Properties();
                        String defaultName = DEFAULT_USER_VARIABLE_PREFIX + v.getName();
                        props.put(defaultName, v.getValue());
                    }
                }
            }
            String extension = null;
            IChangeSetHandle csHandle = null;
            if (parms.changesetID != null && parms.changesetID.length() > 0) {
                csHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null);
            }
            this.switchAuth(session.getMVSID(), parms.passTicket);
            try {
                ArrayList sandboxesToRemove;
                IShareOperation shareOp;
                block38: {
                    if (csHandle == null) {
                        csHandle = wsConn.createChangeSet(componentHandle, parms.comment == null ? "" : parms.comment, true, monitor);
                    }
                    if (parms.workItem != null && parms.workItem.length() > 0) {
                        ZFilesystemRestClient.doWIAssociation(repo, parms.workItem, csHandle, wsConn, monitor);
                    }
                    shareOp = IOperationFactory.instance.getShareOperation((ShareDilemmaHandler)ZShareDilemmaHandler.getInstance());
                    sandboxesToRemove = new ArrayList();
                    String model = modelShareable.getFullPath().toOSString();
                    String dsName = parms.dsName == null ? model.substring(0, model.indexOf("(")) : parms.dsName;
                    String sandboxRoot = ZFilesystemRestClient.findShareRoot(dsName, session);
                    if (config != null) {
                        List rept;
                        IVersionable versionable;
                        IVersionableManager vManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager();
                        try {
                            versionable = vManager.fetchCompleteState(modelShareable.getVersionable(monitor), monitor);
                        }
                        catch (TeamRepositoryException ex) {
                            versionable = null;
                        }
                        if (versionable == null) {
                            rept = null;
                        } else {
                            try {
                                rept = config.determineAncestorsInHistory(Collections.singletonList(versionable), monitor);
                            }
                            catch (TeamRepositoryException ex) {
                                rept = null;
                            }
                        }
                        if (rept != null) {
                            pathModel = this.makePath(((IAncestorReport)rept.get(0)).getNameItemPairs());
                        }
                    }
                    if (pathModel != null) {
                        String relativePath;
                        int lastDelimiter = pathModel.lastIndexOf(47);
                        int lastIndexOfPeriod = pathModel.lastIndexOf(46);
                        if (lastIndexOfPeriod > 0 && lastIndexOfPeriod > lastDelimiter) {
                            extension = pathModel.substring(lastIndexOfPeriod + 1);
                        }
                        String subModel = pathModel.substring(1, lastDelimiter);
                        int firstDelimiter = subModel.indexOf(47) + 1;
                        lastDelimiter = subModel.lastIndexOf(47);
                        String projectName = pathModel.substring(1, firstDelimiter);
                        String folderName = subModel.substring(lastDelimiter + 1);
                        int numMembers = parms.memberNames == null ? 0 : parms.memberNames.length;
                        ArrayList<RelativeLocation> locations = new ArrayList<RelativeLocation>();
                        String modelDsName = parms.modelName.substring(0, parms.modelName.indexOf("("));
                        String string = relativePath = sandboxRoot == null ? "" : modelDsName.substring(sandboxRoot.length());
                        if (relativePath.length() > 0 && relativePath.charAt(0) == '.') {
                            relativePath = relativePath.substring(1);
                        }
                        ArrayList<String> remoteNames = null;
                        int j = 0;
                        while (j < numMembers) {
                            if (relativePath.length() > 0) {
                                locations.add(new RelativeLocation(new String[]{relativePath, parms.memberNames[j]}));
                            } else {
                                locations.add(new RelativeLocation(new String[]{parms.memberNames[j]}));
                            }
                            ++j;
                        }
                        if (extension != null) {
                            extension = "." + extension;
                            remoteNames = new ArrayList<String>();
                            j = 0;
                            while (j < numMembers) {
                                remoteNames.add(String.valueOf(parms.memberNames[j]) + extension);
                                ++j;
                            }
                        }
                        IFolderHandle ifh = null;
                        ifh = (IFolderHandle)config.resolvePath(config.rootFolderHandle(monitor), new String[]{projectName, "zOSsrc", folderName}, monitor);
                        ISandbox sandbox = null;
                        sandbox = sandboxRoot != null ? this.getSandbox(sandboxRoot) : this.getSandbox(dsName);
                        shareOp.share(wsConn, csHandle, componentHandle, ifh, new String[0], sandbox, locations, remoteNames, false, null, monitor);
                        for (IRelativeLocation iRelativeLocation : locations) {
                            shareOp.assignProperties(sandbox.getRoot().append(iRelativeLocation), modelProperties, monitor);
                            shareOp.assignFileProperties(sandbox.getRoot().append(iRelativeLocation), binary != false ? FileLineDelimiter.LINE_DELIMITER_NONE : FileLineDelimiter.LINE_DELIMITER_PLATFORM, binary != false ? "application/unknown" : "text/plain", monitor);
                        }
                        try {
                            ZFilesystemRestClient.runOp((IFileSystemOperation)shareOp, monitor);
                        }
                        catch (Exception exception) {
                            if (!(exception instanceof FileSystemStatusException) || ZShareDilemmaHandler.getInstance().getFailedEncoded() == null || ZShareDilemmaHandler.getInstance().getFailedEncoded().size() > 0) break block38;
                            throw exception;
                        }
                    }
                }
                for (ISandbox sandbox : sandboxesToRemove) {
                    FileSystemCore.getSharingManager().deregister(sandbox, monitor);
                }
                csUUIDs = new ArrayList<String>();
                Collection commitedChangeSets = shareOp.getCommittedChangeSets();
                if (commitedChangeSets != null) {
                    if (commitedChangeSets.size() == 0) {
                        csUUIDs.add(csHandle.getItemId().getUuidValue());
                    } else {
                        Iterator csIt = commitedChangeSets.iterator();
                        while (csIt.hasNext()) {
                            csUUIDs.add(((IChangeSetHandle)csIt.next()).getItemId().getUuidValue());
                        }
                    }
                }
            }
            catch (Exception e) {
                this.unSwitchAuth(session.getMVSID(), parms.passTicket);
                throw e;
            }
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            if (ZShareDilemmaHandler.getInstance().getFailedEncoded() != null && ZShareDilemmaHandler.getInstance().getFailedEncoded().size() > 0) {
                StringBuilder error = new StringBuilder();
                for (IEncodingUploadFailure failure : ZShareDilemmaHandler.getInstance().getFailedEncoded()) {
                    error.append(failure.getStatus().getMessage());
                    error.append("\n");
                }
                ZShareDilemmaHandler.getInstance().getFailedEncoded().clear();
                throw new Exception(error.toString());
            }
            return csUUIDs.toArray(new String[csUUIDs.size()]);
        }
        throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
    }

    private void createEclipseProject(String name, String projectName) {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>" + projectName + "</name>\n" + "\t<comment></comment>\n" + "\t<projects>\n" + "\t</projects>\n" + "\t<buildSpec>\n" + "\t</buildSpec>\n" + "\t<natures>\n" + "\t</natures>\n" + "</projectDescription>\n";
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(name) + "/" + projectName + "/.project"), "UTF8"));
            out.write(contents);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void postLogout(ParmsBlank parms, IProgressMonitor monitor) throws FileSystemException, Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        try {
            ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
            this.switchAuth(session.getMVSID(), parms.passTicket);
            ISPFSession.logout(parms.clientKey, monitor);
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        }
        catch (NotLoggedInException notLoggedInException) {
            // empty catch block
        }
        ISPFSession.logout(parms.clientKey, monitor);
    }

    @Override
    public LoginResponseDTO postLogin(ParmsLogin parms, IProgressMonitor monitor) throws TeamRepositoryException, Exception {
        LoginResponseDTO response;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("repositoryUrl=" + parms.repositoryUrl + ",userId=" + parms.userId + ",passTicket=" + parms.passTicket));
        }
        ISPFSession.logout(parms.clientKey, monitor);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (parms.timezone != null && parms.timezone.length() > 0) {
            dateFormat.setTimeZone(TimeZone.getTimeZone(parms.timezone));
        } else if (parms.currentDate != null) {
            try {
                Date clientDate = new SimpleDateFormat("yyyyMMddHH:mm:ss").parse(parms.currentDate);
                TimeZone defaultTimeZone = TimeZone.getDefault();
                Date now = Calendar.getInstance(defaultTimeZone).getTime();
                long offset = now.getTime() - clientDate.getTime();
                offset = Math.round((double)offset / 900000.0) * 900000L;
                dateFormat.setTimeZone(new SimpleTimeZone(defaultTimeZone.getOffset(now.getTime()) - (int)offset, ""));
            }
            catch (ParseException clientDate) {
                // empty catch block
            }
        }
        ISPFSession session = new ISPFSession(parms.userId, parms.password, parms.repositoryUrl, parms.mvsId, dateFormat, monitor);
        if (parms.propertiesFile != null && parms.propertiesFile.length() > 0) {
            session.setPropertiesFile(parms.propertiesFile);
        }
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            HashSet<ISandbox> sandboxesToRegister = new HashSet<ISandbox>();
            int numMVSSandboxes = parms.mvsSandboxes == null ? 0 : parms.mvsSandboxes.length;
            try {
                int i = 0;
                while (i < numMVSSandboxes) {
                    if (sandboxesToRegister.add(this.getSandbox(parms.mvsSandboxes[i])) && LOG.isInfoEnabled()) {
                        LOG.info((Object)("User " + parms.userId + " registered " + parms.mvsSandboxes[i]));
                    }
                    ++i;
                }
                int numHFSSandboxes = parms.hfsSandboxes == null ? 0 : parms.hfsSandboxes.length;
                int i2 = 0;
                while (i2 < numHFSSandboxes) {
                    if (sandboxesToRegister.add(this.getSandbox(parms.hfsSandboxes[i2])) && LOG.isInfoEnabled()) {
                        LOG.info((Object)("User " + parms.userId + " registered " + parms.hfsSandboxes[i2]));
                    }
                    ++i2;
                }
            }
            catch (TeamRepositoryException numHFSSandboxes) {
                // empty catch block
            }
            try {
                session.registerSandboxes(sandboxesToRegister, monitor);
            }
            catch (FileSystemStatusException ex) {
                ZFilesystemRestClient.dumpStatus(ex.getStatus());
                throw ex;
            }
            response = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createLoginResponseDTO();
            response.setClientKey(session.getKey());
            response.setRepoVersion(((TeamRepository)session.getLoggedInRepository()).getRepositoryVersion());
            response.setRepoUid(session.getLoggedInRepository().getId().getUuidValue());
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        return response;
    }

    @Override
    public String getIsJazzAdmin(ParmsBlank parms, IProgressMonitor monitor) throws NotLoggedInException {
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        Boolean isJazzAdmin = this.isUserJazzAdmin(session.getLoggedInRepository(), monitor);
        return isJazzAdmin.toString();
    }

    @Override
    public HistoryDTO getHistory(ParmsGetHistory parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        HistoryDTO result = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createHistoryDTO();
        IShareable shareable = ZFilesystemRestClient.findShareable(parms.fullMemberName, session);
        ISharingDescriptor descriptor = shareable.getShare(monitor).getSharingDescriptor();
        IWorkspace workspace = (IWorkspace)repo.itemManager().fetchPartialItem((IItemHandle)descriptor.getConnectionHandle(), 0, Collections.singletonList(IWorkspace.NAME_PROPERTY), monitor);
        NamedItemDTO wsDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
        wsDTO.setItemId(workspace.getItemId().getUuidValue());
        wsDTO.setName(workspace.getName());
        result.setWorkspace(wsDTO);
        IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, monitor);
        IChangeHistory changeHistory = wsConn.changeHistory(descriptor.getComponent());
        IVersionableHandle versionable = shareable.getVersionable(monitor);
        List historyChanges = changeHistory.getHistoryFor(versionable, Integer.MAX_VALUE, null);
        ArrayList<IChangeSetHandle> handles = new ArrayList<IChangeSetHandle>(historyChanges.size());
        for (IChangeHistoryEntryChange historyChange : historyChanges) {
            handles.add(historyChange.changeSet());
        }
        result.getChangesets().addAll(ZFilesystemRestClient.convertChangeSets(session, handles, null, false, versionable, monitor));
        return result;
    }

    @Override
    public ComponentHistoryDTO[] getComponentHistory(ParmsGetComponentHistory parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ArrayList<ComponentHistoryDTO> result = new ArrayList<ComponentHistoryDTO>();
        IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.wsUUID), null);
        IWorkspace workspace = (IWorkspace)repo.itemManager().fetchPartialItem((IItemHandle)wsHandle, 0, Collections.singletonList(IWorkspace.NAME_PROPERTY), monitor);
        IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, monitor);
        IComponentHandle comp = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.componentUUID), null);
        WorkspaceNamespace namespace = (WorkspaceNamespace)WorkspaceNamespace.getNamespace((IConnection)wsConn, (IComponentHandle)comp);
        EraDescriptor changeSets = EraDescriptor.createLiveHistory((WorkspaceNamespace)namespace, (boolean)true, (IProgressMonitor)monitor);
        int historyDepth = Integer.parseInt(parms.historyDepth);
        List deliveries = changeSets.getLastDeliveries(historyDepth, monitor);
        Map fetchedChangeSets = RepoFetcher.fetchCurrents((ITeamRepository)repo, (Collection)DeliveryInfo.getChangeSetList((List)deliveries), (IProgressMonitor)monitor);
        ArrayList orderedDeliveries = new ArrayList();
        orderedDeliveries.addAll(deliveries);
        Collections.reverse(orderedDeliveries);
        Map<UUID, Summary> summaries = ZFilesystemRestClient.getSummaries(repo, new ArrayList<IChangeSet>(fetchedChangeSets.values()), monitor);
        for (DeliveryInfo next : orderedDeliveries) {
            ComponentHistoryDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentHistoryDTO();
            ItemId changeSetId = next.getChangeSet();
            IChangeSet thisCS = (IChangeSet)fetchedChangeSets.get(changeSetId);
            thisDTO.setItemId(thisCS.getItemId().getUuidValue());
            thisDTO.setAuthor(((IContributor)repo.itemManager().fetchPartialItem((IItemHandle)thisCS.getAuthor(), 0, Collections.singletonList(IContributor.NAME_PROPERTY), monitor)).getName());
            thisDTO.setCreationDate(session.getDateFormat().format(thisCS.getLastChangeDate()));
            thisDTO.setComment(thisCS.getComment());
            Summary s = summaries.get(thisCS.getItemId());
            thisDTO.setSummary(s.summary);
            IContributor contributor = (IContributor)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)next.getDeliveredBy(), (IProgressMonitor)monitor);
            thisDTO.setAddedBy(contributor.getName());
            thisDTO.setAddedDate(session.getDateFormat().format(next.getDeliveryDate()));
            result.add(thisDTO);
        }
        return result.toArray(new ComponentHistoryDTO[result.size()]);
    }

    @Override
    public void postResolveConflict(ParmsResolveConflict parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.rwsUUID, monitor);
        ILogicalConflictReport conflictReport = FileSystemCore.getFileSystemManager((ITeamRepository)repo).getFileSystemView((IConnection)wsConn).conflictReport(monitor);
        Collection changes = conflictReport.getChange((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.compUUID), null), (IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.versionableUUID), null));
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            if (parms.resolveWithMine.booleanValue()) {
                IMarkAsMergedOperation op = IOperationFactory.instance.getMarkAsMergedOperation((MarkAsMergedDilemmaHandler)new MyMarkAsMergedDilemmaHandler());
                op.setContext(wsConn, conflictReport);
                op.addChangesToResolve(changes);
                op.run(monitor);
            } else {
                IApplyAcceptedOperation op = IOperationFactory.instance.getApplyAcceptedOperation(null);
                op.setContext(wsConn, conflictReport);
                op.addChangesToResolve(changes);
                op.run(monitor);
            }
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public ConflictDTO[] getConflicts(ParmsGetConflicts parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.rwsUUID), null), monitor);
        ArrayList<ConflictDTO> result = new ArrayList<ConflictDTO>();
        Collection conflictReports = wsConn.conflictReport().conflicts();
        for (IItemConflictReport thisCR : conflictReports) {
            ConflictDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createConflictDTO();
            thisDTO.setItemId(thisCR.getCommonAncestorState().getItemId().getUuidValue());
            thisDTO.setComponentID(thisCR.getComponent().getItemId().getUuidValue());
            ZosScmPaths lrp = ZosScmUtils.getFullPaths(repo, thisCR.getCommonAncestorState(), wsConn.configuration(thisCR.getComponent()), monitor);
            thisDTO.setScmPath(lrp.getScmPath());
            thisDTO.setZosPath(lrp.getZosPath());
            thisDTO.setFileItemId(thisCR.getCommonAncestorState().getItemId().getUuidValue());
            result.add(thisDTO);
        }
        return result.toArray(new ConflictDTO[result.size()]);
    }

    private String getWorkspaceIdFromBuild(ITeamRepository repo, String rwsUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        String PROPERTY_WORKSPACE_UUID = "team.enterprise.scm.workspaceUUID";
        IBuildDefinition buildDefn = (IBuildDefinition)repo.itemManager().fetchPartialItem(IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)rwsUUID), null), 0, Arrays.asList(IBuildDefinition.PROPERTY_PROPERTIES, IBuildDefinition.PROPERTY_CONFIGURATION_ELEMENTS, IBuildDefinition.PROPERTY_PROCESS_AREA), monitor);
        if (buildDefn != null) {
            IBuildProperty wsUUIDprop = buildDefn.getProperty("teamz.scm.workspaceUUID");
            if (wsUUIDprop == null || wsUUIDprop.getValue().length() <= 0) {
                wsUUIDprop = buildDefn.getProperty("team.enterprise.scm.workspaceUUID");
            }
            if (wsUUIDprop != null) {
                String wsUUID = wsUUIDprop.getValue();
                IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, wsUUID, monitor);
                IWorkspaceHandle flowTarget = Flow.getFlowTarget(repo, wsConn, true);
                return flowTarget.getItemId().getUuidValue();
            }
        }
        return null;
    }

    @Override
    public NamedItemDTO[] getComponents(ParmsGetComponents parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        String rwsUUID = parms.fromBuild != null && parms.fromBuild != false ? this.getWorkspaceIdFromBuild(repo, parms.rwsUUID, monitor) : parms.rwsUUID;
        List components = repo.itemManager().fetchPartialItems(ZFilesystemRestClient.getWorkspaceConnection(repo, rwsUUID, monitor).getComponents(), 1, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
        ArrayList<NamedItemDTO> result = new ArrayList<NamedItemDTO>(components.size());
        for (IComponent comp : components) {
            NamedItemDTO dto = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            dto.setItemId(comp.getItemId().getUuidValue());
            dto.setName(comp.getName());
            result.add(dto);
        }
        return result.toArray(new NamedItemDTO[result.size()]);
    }

    @Override
    public WorkspaceDetailsDTO[] getWorkspaceDetails(ParmsGetWorkspaceDetails parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        ArrayList<WorkspaceDetailsDTO> result = new ArrayList<WorkspaceDetailsDTO>();
        int numWorkspaces = parms.wsUUIDs == null ? 0 : parms.wsUUIDs.length;
        UUID loggedInContributorID = repo.loggedInContributor().getItemId();
        int i = 0;
        while (i < numWorkspaces) {
            IWorkspaceConnection wsConn = null;
            try {
                wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUIDs[i], monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (wsConn != null && wsConn.getOwner().getItemId().equals((Object)loggedInContributorID)) {
                WorkspaceDetailsDTO wsDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
                wsDTO.setItemId(parms.wsUUIDs[i]);
                wsDTO.setName(wsConn.getName());
                wsDTO.setDescription(wsConn.getDescription());
                wsDTO.setVisibility(this.getReadScope(wsConn));
                List components = repo.itemManager().fetchPartialItems(wsConn.getComponents(), 0, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
                int numComponents = components == null ? 0 : components.size();
                int j = 0;
                while (j < numComponents) {
                    IComponent thisComponent = (IComponent)components.get(j);
                    NamedItemDTO compDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
                    compDTO.setItemId(thisComponent.getItemId().getUuidValue());
                    compDTO.setName(thisComponent.getName());
                    wsDTO.getComponents().add(compDTO);
                    ++j;
                }
                IWorkspaceHandle cFlow = Flow.getFlowTarget(repo, wsConn);
                IWorkspaceHandle dFlow = Flow.getDefaultFlowTarget(repo, wsConn);
                List<IFlowNodeHandle> flowsHandle = Flow.getFlowTargets(repo, wsConn);
                List flows = repo.itemManager().fetchPartialItems(flowsHandle, 0, Collections.singletonList(IWorkspace.NAME_PROPERTY), monitor);
                int numFlows = flows == null ? 0 : flows.size();
                int k = 0;
                while (k < numFlows) {
                    IWorkspace thisStream = (IWorkspace)flows.get(k);
                    IWorkspaceConnection wsConnFlow = null;
                    boolean isStream = false;
                    try {
                        wsConnFlow = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)thisStream, monitor);
                        isStream = wsConnFlow.isStream();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    WorkspaceDetailsDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
                    thisDTO.setItemId(thisStream.getItemId().getUuidValue());
                    thisDTO.setName(thisStream.getName());
                    thisDTO.setStream(isStream);
                    thisDTO.setIsCurrent(thisStream.sameItemId((IItemHandle)cFlow));
                    thisDTO.setIsDefault(thisStream.sameItemId((IItemHandle)dFlow));
                    wsDTO.getFlows().add(thisDTO);
                    ++k;
                }
                result.add(wsDTO);
            }
            ++i;
        }
        return result.toArray(new WorkspaceDetailsDTO[result.size()]);
    }

    private String getReadScope(IWorkspaceConnection wsConn) {
        IReadScope scope = wsConn.getReadScope();
        if (scope instanceof IContributorDeferringScope) {
            return "project";
        }
        if (scope instanceof IPrivateScope) {
            return "private";
        }
        if (scope instanceof IProcessAreaScope) {
            return "process_area_scope";
        }
        if (scope instanceof IPublicScope) {
            return "public";
        }
        if (scope instanceof ITeamAreaPrivateScope) {
            return "team_area_private_scope";
        }
        if (scope instanceof IAccessGroupScope) {
            return "access_group_scope";
        }
        return "unknown_scope";
    }

    @Override
    public void postUnload(ParmsUnload parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            IUnshareOperation unshareOperation = IOperationFactory.instance.getUnshareOperation((UnshareDilemmaHandler)new ZUnshareDilemmaHandler(session), ZFilesystemRestClient.getRepositoryResolver(repo));
            IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(session.getLoggedInRepository(), parms.workspaceUUID, monitor);
            unshareOperation.requestUnshare((IConnection)wsConn, (Collection)wsConn.getComponents());
            unshareOperation.setDeleteContent(parms.delete.booleanValue());
            ZFilesystemRestClient.runOp((IFileSystemOperation)unshareOperation, monitor);
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public void postLoadz(ParmsLoadz parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ISPFLoadOperation ISPFmvsLoadOp = null;
        ISPFLoadOperation ISPFhfsLoadOp = null;
        ILoadOperation mvsLoadOp = null;
        ILoadOperation hfsLoadOp = null;
        if (ispfLoad) {
            ISPFmvsLoadOp = new ISPFLoadOperation(ZLoadDilemmaHandler.getInstance());
            ISPFhfsLoadOp = new ISPFLoadOperation(UssLoadDilemmahandler.getInstance());
            ISPFhfsLoadOp.setLoadFilter(this.getHFSLoadFilter());
        } else {
            mvsLoadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)ZLoadDilemmaHandler.getInstance());
            hfsLoadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)UssLoadDilemmahandler.getInstance());
            hfsLoadOp.setLoadFilter(this.getHFSLoadFilter());
        }
        ISandbox mvsSandbox = parms.mvsPrefix == null ? null : this.getSandbox(parms.mvsPrefix);
        ISandbox hfsSandbox = parms.hfsDestination == null ? null : this.getSandbox(parms.hfsDestination);
        IWorkspaceConnection wsToLoad = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.workspaceUUID, monitor);
        if (parms.reload.booleanValue()) {
            IShare[] allShares;
            IRepositoryResolver resolver = ZFilesystemRestClient.getRepositoryResolver(repo);
            if (mvsSandbox != null) {
                allShares = mvsSandbox.allShares(monitor);
                if (ispfLoad) {
                    ISPFmvsLoadOp.requestReLoad(Arrays.asList(allShares), resolver, monitor);
                } else {
                    mvsLoadOp.requestReLoad(Arrays.asList(allShares), resolver, monitor);
                }
            }
            if (hfsSandbox != null) {
                allShares = hfsSandbox.allShares(monitor);
                if (ispfLoad) {
                    ISPFhfsLoadOp.requestReLoad(Arrays.asList(allShares), resolver, monitor);
                } else {
                    hfsLoadOp.requestReLoad(Arrays.asList(allShares), resolver, monitor);
                }
            }
        } else {
            int numComps = parms.artefactsToLoad.length;
            ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>(numComps);
            ParmsArtefact[] parmsArtefactArray = parms.artefactsToLoad;
            int n = parms.artefactsToLoad.length;
            int n2 = 0;
            while (n2 < n) {
                ParmsArtefact artefact = parmsArtefactArray[n2];
                componentHandles.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)artefact.componentToLoad), null));
                ++n2;
            }
            List components = repo.itemManager().fetchCompleteItems(componentHandles, 1, monitor);
            for (IComponent component : components) {
                ArrayList<Object> versionablesToLoadDsn = new ArrayList<Object>();
                ArrayList<Object> versionablesToLoadUss = new ArrayList<Object>();
                ParmsArtefact[] parmsArtefactArray2 = parms.artefactsToLoad;
                int n3 = parms.artefactsToLoad.length;
                int n4 = 0;
                while (n4 < n3) {
                    ParmsArtefact artefact = parmsArtefactArray2[n4];
                    if (component.getItemId().equals((Object)UUID.valueOf((String)artefact.componentToLoad))) {
                        if (artefact.folders != null && artefact.folders.length > 0) {
                            String[] stringArray = artefact.folders;
                            int n5 = artefact.folders.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String folder = stringArray[n6];
                                if (folder.length() > 0) {
                                    Path ipathFolder = new Path(folder);
                                    IVersionableHandle remoteItem = wsToLoad.configuration((IComponentHandle)component).resolvePath(component.getRootFolder(), ipathFolder.segments(), null);
                                    String[] segments = ipathFolder.segments();
                                    Boolean exclude = false;
                                    String[] stringArray2 = segments;
                                    int n7 = segments.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        String s = stringArray2[n8];
                                        if (s.equals("zOSsrc") || s.equals(".zOSbin") || s.equals("zOSout")) {
                                            exclude = true;
                                        }
                                        ++n8;
                                    }
                                    if (!exclude.booleanValue()) {
                                        versionablesToLoadUss.add(remoteItem);
                                    }
                                    versionablesToLoadDsn.add(remoteItem);
                                }
                                ++n6;
                            }
                        } else {
                            versionablesToLoadDsn.addAll(wsToLoad.configuration((IComponentHandle)component).childEntries(component.getRootFolder(), null).values());
                            versionablesToLoadUss.addAll(wsToLoad.configuration((IComponentHandle)component).childEntries(component.getRootFolder(), null).values());
                        }
                    }
                    ++n4;
                }
                if (!versionablesToLoadDsn.isEmpty() && mvsSandbox != null) {
                    if (ispfLoad) {
                        ISPFmvsLoadOp.requestLoad(mvsSandbox, null, wsToLoad, (IComponentHandle)component, versionablesToLoadDsn);
                    } else {
                        mvsLoadOp.requestLoad(mvsSandbox, null, wsToLoad, (IComponentHandle)component, versionablesToLoadDsn);
                    }
                }
                if (versionablesToLoadUss.isEmpty() || hfsSandbox == null) continue;
                if (ispfLoad) {
                    ISPFhfsLoadOp.requestLoad(hfsSandbox, null, wsToLoad, (IComponentHandle)component, versionablesToLoadUss);
                    continue;
                }
                hfsLoadOp.requestLoad(hfsSandbox, null, wsToLoad, (IComponentHandle)component, versionablesToLoadUss);
            }
        }
        this.switchAuth(session.getMVSID(), parms.passTicket, parms.clientKey);
        try {
            if (ispfLoad) {
                ThreadOwner threadOwner = new ThreadOwner(session.getMVSID(), parms.passTicket, APPL_ID, ISPFSession.getSession(parms.clientKey).getProperties());
                ISPFmvsLoadOp.setThreadOwner((IThreadOwner)threadOwner);
                ISPFhfsLoadOp.setThreadOwner((IThreadOwner)threadOwner);
            }
            ZFilesystemRestClient.runOp(ispfLoad ? ISPFmvsLoadOp : mvsLoadOp, monitor);
            ZFilesystemRestClient.runOp(ispfLoad ? ISPFhfsLoadOp : hfsLoadOp, monitor);
        }
        finally {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket, parms.clientKey);
        }
        HashSet<ISandbox> toRegister = new HashSet<ISandbox>();
        if (mvsSandbox != null) {
            toRegister.add(mvsSandbox);
        }
        if (hfsSandbox != null) {
            toRegister.add(hfsSandbox);
        }
        session.registerSandboxes(toRegister, monitor);
    }

    private ILoadFilter getHFSLoadFilter() {
        return LoadFilter.exclude((String[])new String[]{"zOSsrc", ".zOSbin", "zOSout"});
    }

    private static void runOp(IFileSystemOperation op, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            op.run(monitor);
        }
        catch (FileSystemStatusException ex) {
            IStatus currentStatus = ex.getStatus();
            String abendMessage = ZFilesystemRestClient.dumpStatus(currentStatus);
            if (abendMessage != null) {
                throw new FileSystemStatusException(abendMessage, (Throwable)ex);
            }
            throw ex;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void runCheckinOp(IFileSystemOperation op, ZCommitDilemmaHandler handler, IProgressMonitor monitor) throws TeamRepositoryException {
        block5: {
            block6: {
                try {
                    ZFilesystemRestClient.runOp(op, monitor);
                    break block5;
                }
                catch (OperationCanceledException ex) {
                    inaccessibleShares = handler.getInaccessibleForUpdate();
                    v0 = num = inaccessibleShares == null ? 0 : inaccessibleShares.size();
                    if (num <= 0) break block6;
                    list = new StringBuilder();
                    list.append(ex.getLocalizedMessage());
                    ** for (inaccessibleShare : inaccessibleShares)
                }
lbl-1000:
                // 1 sources

                {
                    list.append(inaccessibleShare.getLocalPath());
                    continue;
                }
lbl15:
                // 1 sources

                throw new FileSystemException(NLS.bind((String)Messages.ZFilesystemRestClient_UNCHECKED_IN_CHANGES, (Object)list.toString()));
            }
            siblingSharesToAdd = handler.getsiblingSharesToAdd();
            v1 = numSiblings = siblingSharesToAdd == null ? 0 : siblingSharesToAdd.size();
            if (numSiblings > 0) {
                list = new StringBuilder();
                list.append(ex.getLocalizedMessage());
                for (IShareable sibling : siblingSharesToAdd) {
                    list.append(sibling.getLocalPath());
                }
                throw new FileSystemException(NLS.bind((String)Messages.ZFilesystemRestClient_UNCHECKED_IN_CHANGES, (Object)list.toString()));
            }
            throw ex;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void runChangeChangesetHistoryOp(IFileSystemOperation op, IChangeChangesetHistoryDilemmaHandler handler, IProgressMonitor monitor) throws TeamRepositoryException, AcceptException {
        block5: {
            try {
                ZFilesystemRestClient.runOp(op, monitor);
            }
            catch (OperationCanceledException ex) {
                changed = handler.getLocalChangePaths();
                v0 = numChanged = changed == null ? 0 : changed.size();
                if (numChanged <= 0) break block5;
                list = new StringBuilder();
                i = 0;
                ** while (i < numChanged)
            }
lbl-1000:
            // 1 sources

            {
                if (i > 0) {
                    list.append(",");
                }
                list.append(changed.get(i));
                ++i;
                continue;
            }
lbl18:
            // 1 sources

            throw new AcceptException(NLS.bind((String)Messages.ZFilesystemRestClient_UNCHECKED_IN_CHANGES, (Object)list.toString()));
        }
        throw ex;
        catch (VersionablePermissionDeniedException ex) {
            throw ex;
        }
    }

    @Override
    public void postUndo(ParmsUndo parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            IShareable shareable = ZFilesystemRestClient.findShareable(parms.member, session);
            if (shareable != null) {
                ILocalChange change = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChange(shareable, monitor);
                if (change != null && change.getType() != 0) {
                    FileSystemCore.getSharingManager().getLocalChangeManager().undoChanges(new ILocalChange[]{change}, ZFilesystemRestClient.getRepositoryResolver(session.getLoggedInRepository()), null, monitor);
                } else {
                    ISharingDescriptor descriptor = shareable.getShare(monitor).getSharingDescriptor();
                    ILocalChange[] changes = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponent(), this.getSandbox(ZFilesystemRestClient.findShareRoot(parms.member, session)));
                    ArrayList<ILocalChange> changeList = new ArrayList<ILocalChange>();
                    ILocalChange[] iLocalChangeArray = changes;
                    int n = changes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRelativeLocation changeLoc;
                        ILocalChange potentialChange = iLocalChangeArray[n2];
                        if (potentialChange.getType() != 0 && (changeLoc = potentialChange.getOriginalPath()) != null && (changeLoc = changeLoc.getParent().append(this.getActualMemberName(changeLoc))).equals((Object)shareable.getLocalPath())) {
                            changeList.add(potentialChange);
                        }
                        ++n2;
                    }
                    FileSystemCore.getSharingManager().getLocalChangeManager().undoChanges(changeList.toArray(new ILocalChange[changeList.size()]), ZFilesystemRestClient.getRepositoryResolver(session.getLoggedInRepository()), null, monitor);
                }
            }
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    private static String dumpStatus(IStatus status) {
        IStatus[] kids;
        Throwable t;
        String msg = status.getMessage();
        String abendMessage = "";
        if (msg != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)msg);
            }
            abendMessage = msg;
        }
        if ((t = status.getException()) != null) {
            String message;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)t);
            }
            if ((message = t.getMessage()).contains("AbendCode=0xb37") || message.contains("AbendCode=0xd37") || message.contains("AbendCode=0xe37")) {
                abendMessage = String.valueOf(abendMessage) + message;
            }
        }
        if ((kids = status.getChildren()) != null) {
            IStatus[] iStatusArray = kids;
            int n = kids.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus thisKid = iStatusArray[n2];
                abendMessage = String.valueOf(abendMessage) + " " + ZFilesystemRestClient.dumpStatus(thisKid);
                ++n2;
            }
        }
        return abendMessage;
    }

    protected List<String> getMembers(String dataset) throws IOException {
        if (ZFilesystemRestClient.isHierarchical(dataset)) {
            return Arrays.asList(new File(dataset).list());
        }
        ArrayList<String> result = new ArrayList<String>();
        try (PdsDirectory dir = null;){
            dir = new PdsDirectory("//'" + dataset + "'");
            for (PdsDirectory.MemberInfo thisInfo : dir) {
                String thisName = thisInfo.getName();
                if (!thisName.toUpperCase().equals(thisName)) continue;
                result.add(thisInfo.getName());
            }
        }
        return result;
    }

    protected String createFullPath(String dirOrPDS, String memOrFile) {
        if (ZFilesystemRestClient.isHierarchical(dirOrPDS)) {
            return new File(dirOrPDS, memOrFile).getAbsolutePath();
        }
        return String.valueOf(dirOrPDS) + "(" + memOrFile + ")";
    }

    private Map<String, String> getLockStatus(ITeamRepository repo, Collection<IWorkspaceHandle> streamsToCheck, Collection<IComponentHandle> componentsToCheck, Collection<IVersionableHandle> versionablesToCheck, Map<String, String> versionableUUIDToNameMap, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, String> versionableNameToLockInitialsMap = new HashMap<String, String>();
        ILockSearchCriteria criteria = ILockSearchCriteria.FACTORY.newInstance();
        criteria.getStreams().addAll(streamsToCheck);
        criteria.getComponents().addAll(componentsToCheck);
        criteria.getVersionables().addAll(versionablesToCheck);
        Collection streamLockReports = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findLocks(criteria, Integer.MAX_VALUE, monitor).getReports();
        if (streamLockReports != null) {
            for (IStreamLockReport slr : streamLockReports) {
                Collection componentLockReports = slr.getComponentLocks();
                for (IComponentLockReport clr : componentLockReports) {
                    Collection versionableLocks = clr.getLocks();
                    for (IVersionableLock vl : versionableLocks) {
                        String name = versionableUUIDToNameMap.get(vl.getVersionable().getItemId().getUuidValue());
                        if (name == null) continue;
                        versionableNameToLockInitialsMap.put(name, ZFilesystemRestClient.getInitials(repo, vl.getContributor(), monitor));
                    }
                }
            }
        }
        return versionableNameToLockInitialsMap;
    }

    protected ILocation getLocation(String dataSet, String shareRoot) {
        if (ZFilesystemRestClient.isHierarchical(dataSet)) {
            return new PathLocation(dataSet);
        }
        return new DataSetLocation(shareRoot, dataSet.substring(shareRoot.length()), null);
    }

    public static boolean isOnWindows() {
        String osProp = System.getProperty("os.name");
        return osProp != null && (osProp.contains("Windows") || osProp.contains("Linux"));
    }

    protected String getActualMemberName(String memberNameWithExtension) {
        if (ZFilesystemRestClient.isOnWindows()) {
            return memberNameWithExtension;
        }
        int idxOfPeriod = memberNameWithExtension.indexOf(46);
        if (idxOfPeriod > 0) {
            memberNameWithExtension = memberNameWithExtension.substring(0, idxOfPeriod);
        }
        return memberNameWithExtension;
    }

    protected String getActualMemberName(IRelativeLocation relLoc) {
        String memberNameWithExtension = relLoc.getName();
        if (ZFilesystemRestClient.isHierarchical(relLoc.toPath().toOSString())) {
            return memberNameWithExtension;
        }
        if (ZFilesystemRestClient.isOnWindows()) {
            return memberNameWithExtension;
        }
        int idxOfPeriod = memberNameWithExtension.indexOf(46);
        if (idxOfPeriod > 0) {
            memberNameWithExtension = memberNameWithExtension.substring(0, idxOfPeriod);
        }
        return memberNameWithExtension;
    }

    private Map<String, Byte> getVersionablesWithLocalChanges(ITeamRepository repo, ISandbox sandbox, ILocation dataSetLocation, boolean refresh, IProgressMonitor monitor) throws FileSystemException {
        int n;
        int n2;
        IShare[] iShareArray;
        HashMap<String, Byte> versionablesWithLocalChanges = new HashMap<String, Byte>();
        ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
        if (refresh) {
            IShare[] allSandboxShares = sandbox.allShares(monitor);
            ArrayList<IShareable> datasetShareables = new ArrayList<IShareable>();
            ILocation sandboxRoot = sandbox.getRoot();
            ILocation datasetContainingShare = null;
            iShareArray = allSandboxShares;
            n2 = allSandboxShares.length;
            n = 0;
            while (n < n2) {
                IShare thisShare = iShareArray[n];
                if (dataSetLocation instanceof DataSetLocation) {
                    datasetContainingShare = sandboxRoot.append(thisShare.getPath()).getParent();
                    if (dataSetLocation.equals((Object)datasetContainingShare)) {
                        datasetShareables.add(thisShare.getShareable());
                    }
                } else {
                    datasetContainingShare = sandboxRoot.append(thisShare.getPath());
                    if (datasetContainingShare.isPrefixOf(dataSetLocation)) {
                        datasetShareables.add(thisShare.getShareable());
                    }
                }
                ++n;
            }
            FileSystemCore.getSharingManager().getLocalChangeManager().refreshChanges(datasetShareables, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, monitor);
        }
        Collection configDescriptors = sandbox.allLoadedConfigurations(monitor);
        for (LoadedConfigurationDescriptor descriptor : configDescriptors) {
            lcm.syncPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, sandbox, monitor);
            ILocalChange[] changes = lcm.getPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, sandbox);
            iShareArray = changes;
            n2 = changes.length;
            n = 0;
            while (n < n2) {
                IShare change = iShareArray[n];
                IRelativeLocation originalPath = change.getOriginalPath();
                if (originalPath != null) {
                    IRelativeLocation ParentOforiginal = originalPath.removeLastSegments(1);
                    ILocation computedLoc = sandbox.getRoot().append(ParentOforiginal);
                    if (dataSetLocation.isPrefixOf(sandbox.getRoot().append(originalPath)) && computedLoc.sameLocation(dataSetLocation, true)) {
                        if (change.isType(4)) {
                            versionablesWithLocalChanges.put(this.getActualMemberName(originalPath), ParmsGetMemberStatus.DELETED);
                        } else if (change.isType(8)) {
                            IRelativeLocation newPath = change.getResultingPath();
                            if (newPath != null) {
                                versionablesWithLocalChanges.put(this.getActualMemberName(newPath), ParmsGetMemberStatus.DIRTY);
                            }
                        } else if (change.isType(32) || change.isType(1)) {
                            versionablesWithLocalChanges.put(this.getActualMemberName(originalPath), ParmsGetMemberStatus.DIRTY);
                        }
                    }
                }
                ++n;
            }
        }
        return versionablesWithLocalChanges;
    }

    private String getEncoding(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        String encoding = null;
        FileItemInfo info = ((Shareable)shareable).getFileItemInfo(monitor);
        if (info != null) {
            encoding = info.getStoredEncoding();
        }
        if (encoding == null || encoding.trim().length() < 1) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    @Override
    public MemberStatusDTO[] getMemberStatus(ParmsGetMemberStatus parms, final IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ArrayList<MemberStatusDTO> result = new ArrayList<MemberStatusDTO>();
        String shareRoot = ZFilesystemRestClient.findShareRoot(parms.dataset, session);
        ISandbox sandbox = shareRoot != null ? this.getSandbox(shareRoot) : null;
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            ArrayList<IVersionableHandle> versionablesToCheck = new ArrayList<IVersionableHandle>();
            ArrayList<IComponentHandle> componentsToCheck = new ArrayList<IComponentHandle>();
            ArrayList<IWorkspaceHandle> streamsToCheck = new ArrayList<IWorkspaceHandle>();
            final HashMap<String, String> versionableUUIDToNameMap = new HashMap<String, String>();
            List<String> members = parms.members == null || parms.members.length == 0 ? this.getMembers(parms.dataset) : Arrays.asList(parms.members);
            HashMap<String, IWorkspaceHandle> rwsUUIDToFlowTargetMap = new HashMap<String, IWorkspaceHandle>();
            final HashMap<String, MemberStatusDTO> versionableNameToDTOMap = new HashMap<String, MemberStatusDTO>();
            IVerifyInSyncOperation inSyncOp = IOperationFactory.instance.getVerifyInSyncOperation(new OutOfSyncDilemmaHandler(){

                public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                    for (IShareOutOfSync shareOOS : sharesOutOfSync) {
                        MemberStatusDTO dto;
                        IVersionableHandle verOOS = null;
                        try {
                            verOOS = shareOOS.getShare().getShareable().getRemote(monitor);
                        }
                        catch (FileSystemException fileSystemException) {
                            // empty catch block
                        }
                        String verName = (String)versionableUUIDToNameMap.get(verOOS.getItemId().getUuidValue());
                        if (verName == null || (dto = (MemberStatusDTO)versionableNameToDTOMap.get(verName)) == null) continue;
                        dto.setStatus(ParmsGetMemberStatus.OUT_OF_SYNC);
                    }
                    return 0;
                }
            });
            for (String member : members) {
                IWorkspace wks;
                IShare share;
                MemberStatusDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createMemberStatusDTO();
                result.add(thisDTO);
                thisDTO.setName(member);
                IShareable shareable = ZFilesystemRestClient.findShareable(this.createFullPath(parms.dataset, member), session);
                IShare iShare = share = shareable == null ? null : shareable.getShare(monitor);
                if (share == null) {
                    thisDTO.setStatus(ParmsGetMemberStatus.UNMANAGED);
                    continue;
                }
                String encoding = this.getEncoding(shareable, monitor);
                thisDTO.setEncoding(encoding);
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                if (!repo.getId().getUuidValue().equals(descriptor.getRepositoryId().getUuidValue())) {
                    thisDTO.setStatus(ParmsGetMemberStatus.OFFLINE);
                    continue;
                }
                IVersionableHandle thisVersionable = shareable.getVersionable(monitor);
                if (thisVersionable == null || thisVersionable.getStateId() == null) {
                    thisDTO.setStatus(ParmsGetMemberStatus.DIRTY);
                    continue;
                }
                String versionableID = thisVersionable.getItemId().getUuidValue();
                IContextHandle connectionHandle = descriptor.getConnectionHandle();
                IComponentHandle componentHandle = descriptor.getComponent();
                String rwsUUID = connectionHandle.getItemId().getUuidValue();
                IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, rwsUUID, monitor);
                versionableNameToDTOMap.put(member, thisDTO);
                inSyncOp.addToVerify((IConnection)wsConn, share);
                versionablesToCheck.add(thisVersionable);
                componentsToCheck.add(componentHandle);
                versionableUUIDToNameMap.put(versionableID, member);
                IWorkspaceHandle flowTarget = (IWorkspaceHandle)rwsUUIDToFlowTargetMap.get(rwsUUID);
                if (flowTarget == null) {
                    flowTarget = Flow.getFlowTarget(repo, wsConn);
                    rwsUUIDToFlowTargetMap.put(rwsUUID, flowTarget);
                }
                if (flowTarget == null || !(wks = (IWorkspace)repo.itemManager().fetchPartialItem((IItemHandle)flowTarget, 0, Arrays.asList(IWorkspace.NAME_PROPERTY, IWorkspace.STREAM_PROPERTY, IWorkspace.ITEM_ID_PROPERTY), monitor)).isStream()) continue;
                streamsToCheck.add(flowTarget);
            }
            inSyncOp.run(monitor);
            int totalSize = versionablesToCheck.size();
            int index = 0;
            int MAX_SIZE = 2048;
            int end = 0;
            while (index < totalSize) {
                Map<String, String> versionableUUIDToLockInitialsMap;
                if (totalSize > MAX_SIZE) {
                    end = end + MAX_SIZE > totalSize ? totalSize : end + MAX_SIZE;
                    List<IVersionableHandle> subListversionablesToCheck = versionablesToCheck.subList(index, end);
                    index += MAX_SIZE;
                    versionableUUIDToLockInitialsMap = this.getLockStatus(repo, streamsToCheck, componentsToCheck, subListversionablesToCheck, versionableUUIDToNameMap, monitor);
                } else {
                    index += MAX_SIZE;
                    versionableUUIDToLockInitialsMap = this.getLockStatus(repo, streamsToCheck, componentsToCheck, versionablesToCheck, versionableUUIDToNameMap, monitor);
                }
                for (Map.Entry<String, String> entry : versionableUUIDToLockInitialsMap.entrySet()) {
                    MemberStatusDTO dto = (MemberStatusDTO)versionableNameToDTOMap.get(entry.getKey());
                    if (dto == null) continue;
                    dto.setLockInit(entry.getValue());
                }
            }
            if (sandbox != null) {
                Map<String, Byte> dirtyVersionables = this.getVersionablesWithLocalChanges(repo, sandbox, this.getLocation(parms.dataset, shareRoot), parms.refresh, monitor);
                for (Map.Entry<String, Byte> thisVersionableChange : dirtyVersionables.entrySet()) {
                    String name = thisVersionableChange.getKey();
                    Byte status = thisVersionableChange.getValue();
                    MemberStatusDTO dto = (MemberStatusDTO)versionableNameToDTOMap.get(name);
                    if (dto == null) {
                        if (status != ParmsGetMemberStatus.DELETED) continue;
                        dto = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createMemberStatusDTO();
                        dto.setName(name);
                        dto.setStatus(status.byteValue());
                        result.add(dto);
                        continue;
                    }
                    if (dto.getStatus() != ParmsGetMemberStatus.UNCHANGED) continue;
                    dto.setStatus(status.byteValue());
                }
            }
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        return result.toArray(new MemberStatusDTO[result.size()]);
    }

    private static Map<UUID, Summary> getSummaries(ITeamRepository repo, List<IChangeSet> changesets, IProgressMonitor monitor) throws TeamRepositoryException {
        int numChangesets;
        HashMap<UUID, Summary> csUUIDtoSummary = new HashMap<UUID, Summary>();
        int n = numChangesets = changesets == null ? 0 : changesets.size();
        if (numChangesets == 0) {
            return csUUIDtoSummary;
        }
        List summaries = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getChangeSetLinkSummary(changesets, monitor);
        int numSummaries = summaries == null ? 0 : summaries.size();
        int i = 0;
        while (i < numSummaries) {
            IChangeSetLinkSummary thisSummary = (IChangeSetLinkSummary)summaries.get(i);
            UUID csid = thisSummary.getChangeSet().getItemId();
            IChangeSet thisCS = null;
            int j = 0;
            while (j < numChangesets && thisCS == null) {
                IChangeSet acs = changesets.get(j);
                if (csid.equals((Object)acs.getItemId())) {
                    thisCS = acs;
                }
                ++j;
            }
            Summary s = new Summary();
            s.summary = thisSummary.getSummary();
            s.comment = thisCS == null ? "" : thisCS.getComment();
            csUUIDtoSummary.put(csid, s);
            ++i;
        }
        return csUUIDtoSummary;
    }

    @Override
    public NamedItemDTO[] getBaselines(ParmsGetBaselines parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        IWorkspaceConnection streamConnection = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.streamUUID, monitor);
        ArrayList<NamedItemDTO> result = new ArrayList<NamedItemDTO>();
        for (ICurrentComponentInfo compInfo : streamConnection.getComponentsInfo()) {
            IBaseline curBaseline = (IBaseline)repo.itemManager().fetchPartialItem((IItemHandle)compInfo.basis(), 0, Arrays.asList(IBaseline.NAME_PROPERTY, IBaseline.ID_PROPERTY, IBaseline.COMPONENT_PROPERTY), monitor);
            IComponent curComponent = (IComponent)repo.itemManager().fetchPartialItem((IItemHandle)curBaseline.getComponent(), 0, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
            NamedItemDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            thisDTO.setItemId(curComponent.getItemId().getUuidValue());
            thisDTO.setName(String.valueOf(curComponent.getName()) + " (" + curBaseline.getId() + ":" + curBaseline.getName() + ")");
            result.add(thisDTO);
        }
        return result.toArray(new NamedItemDTO[result.size()]);
    }

    @Override
    public String postCreateWorkItem(ParmsCreateWorkItem parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IProjectAreaHandle projectarea = session.getProjectArea();
        IWorkItem wi = ZFilesystemRestClient.createWorkItem(repo, projectarea, parms.typeId, parms.categoryUUID, parms.severityId, parms.plannedForUUID, parms.foundInUUID, parms.summary, parms.description, parms.tags, monitor);
        return Integer.toString(wi.getId());
    }

    private static IWorkItem createWorkItem(ITeamRepository repo, IProjectAreaHandle projectArea, String typeId, String categoryUUID, String severityId, String plannedForUUID, String foundInUUID, String summary, String description, String tags, IProgressMonitor monitor) throws TeamRepositoryException {
        IDetailedStatus saveStatus;
        UUID categ_uuid;
        IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
        IWorkItemHandle handle = workingCopyManager.connectNew(workItemClient.findWorkItemType(projectArea, "defect", monitor), null);
        WorkItemWorkingCopy workingCopy = workingCopyManager.getWorkingCopy(handle);
        IWorkItem iw = workingCopy.getWorkItem();
        IWorkItemType workItemType = workItemClient.findWorkItemType(projectArea, typeId, monitor);
        workItemClient.updateWorkItemType(iw, workItemType, null, monitor);
        iw.setOwner((IContributorHandle)repo.loggedInContributor());
        iw.setCreator((IContributorHandle)repo.loggedInContributor());
        if (categoryUUID != null && (categ_uuid = UUID.valueOf((String)categoryUUID)) != null) {
            ICategoryHandle category = (ICategoryHandle)ICategory.ITEM_TYPE.createItemHandle(categ_uuid, null);
            iw.setCategory(category);
        }
        if (severityId != null) {
            IEnumeration enumeration = workItemClient.resolveEnumeration((IAttributeHandle)workItemClient.findAttribute(projectArea, IWorkItem.SEVERITY_PROPERTY, monitor), monitor);
            List severities = enumeration.getEnumerationLiterals();
            ISeverity fSeverity = null;
            for (ISeverity severity : severities) {
                if (!severity.getIdentifier2().getStringIdentifier().equals(severityId)) continue;
                fSeverity = severity;
                break;
            }
            if (fSeverity == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.ZFilesystemRestClient_INVALID_SECURTITY_ATTRIBUTE, (Object[])new String[]{severityId}));
            }
            iw.setSeverity(fSeverity.getIdentifier2());
        }
        if (plannedForUUID != null) {
            UUID plannedFor_uuid = UUID.valueOf((String)plannedForUUID);
            IIterationHandle iteration = (IIterationHandle)IIteration.ITEM_TYPE.createItemHandle(plannedFor_uuid, null);
            iw.setTarget(iteration);
        }
        if (foundInUUID != null) {
            UUID foundIn_uuid = UUID.valueOf((String)foundInUUID);
            IAttribute attribute = workItemClient.findAttribute(projectArea, IWorkItem.FOUND_IN_PROPERTY, null);
            IDeliverableHandle deliverable = (IDeliverableHandle)IDeliverable.ITEM_TYPE.createItemHandle(foundIn_uuid, null);
            iw.setValue(attribute, (Object)deliverable);
        }
        if (summary != null) {
            iw.setHTMLSummary(XMLString.createFromPlainText((String)summary));
        }
        if (description == null) {
            description = "";
        }
        iw.setHTMLDescription(XMLString.createFromPlainText((String)description));
        if (tags != null) {
            iw.setTags2(TagsAttributeType.parseTags((String)tags));
        }
        if (!(saveStatus = workingCopy.save(monitor)).isOK()) {
            throw new TeamRepositoryException(saveStatus.getException());
        }
        workingCopyManager.disconnect(handle);
        return workingCopy.getWorkItem();
    }

    @Override
    public NamedItemDTO[] getWorkItemTypes(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        ArrayList<NamedItemDTO> result = new ArrayList<NamedItemDTO>();
        List types = workItemClient.findWorkItemTypes(session.getProjectArea(), monitor);
        for (IWorkItemType type : types) {
            NamedItemDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            thisDTO.setItemId(type.getIdentifier());
            thisDTO.setName(type.getDisplayName());
            if (((WorkItemType)type).isDefault()) {
                result.add(0, thisDTO);
                continue;
            }
            result.add(thisDTO);
        }
        return result.toArray(new NamedItemDTO[result.size()]);
    }

    @Override
    public NamedItemDTO getWorkItemDefaultType(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        List types = workItemClient.findWorkItemTypes(session.getProjectArea(), monitor);
        NamedItemDTO thisDTO = null;
        Iterator iterator = types.iterator();
        if (iterator.hasNext()) {
            IWorkItemType type = (IWorkItemType)iterator.next();
            thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            thisDTO.setItemId(type.getIdentifier());
            thisDTO.setName(type.getDisplayName());
            return thisDTO;
        }
        return thisDTO;
    }

    @Override
    public NamedItemDTO[] getWorkItemSeverities(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        ArrayList<NamedItemDTO> result = new ArrayList<NamedItemDTO>();
        IEnumeration enumeration = workItemClient.resolveEnumeration((IAttributeHandle)workItemClient.findAttribute(session.getProjectArea(), IWorkItem.SEVERITY_PROPERTY, monitor), monitor);
        List severities = enumeration.getEnumerationLiterals();
        for (ISeverity severity : severities) {
            NamedItemDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            thisDTO.setItemId(severity.getIdentifier2().getStringIdentifier());
            thisDTO.setName(severity.getName());
            if (((Severity)severity).isDefault()) {
                result.add(0, thisDTO);
                continue;
            }
            result.add(thisDTO);
        }
        return result.toArray(new NamedItemDTO[result.size()]);
    }

    @Override
    public NamedItemDTO getWorkItemDefaultSeverity(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        IEnumeration enumeration = workItemClient.resolveEnumeration((IAttributeHandle)workItemClient.findAttribute(session.getProjectArea(), IWorkItem.SEVERITY_PROPERTY, monitor), monitor);
        List severities = enumeration.getEnumerationLiterals();
        NamedItemDTO thisDTO = null;
        for (ISeverity severity : severities) {
            if (!((Severity)severity).isDefault()) continue;
            thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            thisDTO.setItemId(severity.getIdentifier2().getStringIdentifier());
            thisDTO.setName(severity.getName());
            return thisDTO;
        }
        return thisDTO;
    }

    @Override
    public NamedItemDTO[] getWorkItemCategories(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        ArrayList<NamedItemDTO> result = new ArrayList<NamedItemDTO>();
        List findCategories = workItemClient.findCategories(session.getProjectArea(), ICategory.FULL_PROFILE, monitor);
        for (ICategory category : findCategories) {
            NamedItemDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            thisDTO.setItemId(category.getItemId().getUuidValue());
            thisDTO.setName(category.getName());
            result.add(thisDTO);
        }
        return result.toArray(new NamedItemDTO[result.size()]);
    }

    @Override
    public NamedItemDTO[] getWorkItemFoundIn(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        ArrayList<NamedItemDTO> result = new ArrayList<NamedItemDTO>();
        List deliverables = workItemClient.findDeliverablesByProjectArea(session.getProjectArea(), false, IDeliverable.DEFAULT_PROFILE, monitor);
        for (IDeliverable deliverable : deliverables) {
            NamedItemDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            thisDTO.setItemId(deliverable.getItemId().getUuidValue());
            thisDTO.setName(deliverable.getName());
            result.add(thisDTO);
        }
        return result.toArray(new NamedItemDTO[result.size()]);
    }

    @Override
    public NamedItemDTO[] getWorkItemPlannedFor(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IAuditableCommon client = (IAuditableCommon)repo.getClientLibrary(IAuditableCommon.class);
        ArrayList<NamedItemDTO> result = new ArrayList<NamedItemDTO>();
        List iterations = null;
        iterations = IterationsHelper.findIterations((IAuditableCommon)client, (IProjectAreaHandle)session.getProjectArea(), (ItemProfile)ItemProfile.ITERATION_DEFAULT, (boolean)false, (IProgressMonitor)monitor);
        for (IIteration iteration : iterations) {
            NamedItemDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            thisDTO.setItemId(iteration.getItemId().getUuidValue());
            thisDTO.setName(iteration.getLabel());
            result.add(thisDTO);
        }
        return result.toArray(new NamedItemDTO[result.size()]);
    }

    @Override
    public WorkitemDTO[] getWorkItems(ParmsWorkitem parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IAuditableClient auditableClient = (IAuditableClient)repo.getClientLibrary(IAuditableClient.class);
        IQueryClient queryClient = (IQueryClient)repo.getClientLibrary(IQueryClient.class);
        IProjectAreaHandle pa = session.getProjectArea();
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE);
        IWorkItemClient wiClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        IQueryResult queryResults = null;
        Boolean includeResolved = parms.includeResolved != null && parms.includeResolved != false;
        Boolean myAssignmentsOnly = parms.myAssignmentsOnly == null || parms.myAssignmentsOnly != false;
        AttributeExpression sameprojectArea = new AttributeExpression(factory.findAttribute(pa, IWorkItem.PROJECT_AREA_PROPERTY, (IAuditableCommon)auditableClient, monitor), AttributeOperation.EQUALS, (Object)pa);
        queryResults = includeResolved.booleanValue() ? (myAssignmentsOnly.booleanValue() ? queryClient.getResolvedExpressionResults(pa, (Expression)new Statement(new SelectClause(), (Expression)new Term(0, new Expression[]{sameprojectArea, new AttributeExpression(factory.findAttribute(pa, IWorkItem.OWNER_PROPERTY, (IAuditableCommon)auditableClient, monitor), AttributeOperation.EQUALS, (Object)repo.loggedInContributor())}), new SortCriteria[]{new SortCriteria(IWorkItem.ID_PROPERTY, false)}), IWorkItem.DEFAULT_PROFILE) : queryClient.getResolvedExpressionResults(pa, (Expression)new Statement(new SelectClause(), (Expression)sameprojectArea, new SortCriteria[]{new SortCriteria(IWorkItem.ID_PROPERTY, false)}), IWorkItem.DEFAULT_PROFILE)) : (myAssignmentsOnly != false ? queryClient.getResolvedExpressionResults(pa, (Expression)new Statement(new SelectClause(), (Expression)new Term(0, new Expression[]{sameprojectArea, new AttributeExpression(factory.findAttribute(pa, IWorkItem.OWNER_PROPERTY, (IAuditableCommon)auditableClient, monitor), AttributeOperation.EQUALS, (Object)repo.loggedInContributor()), new VariableAttributeExpression(factory.findAttribute(pa, IWorkItem.STATE_PROPERTY, (IAuditableCommon)auditableClient, monitor), AttributeOperation.EQUALS, (IAttributeVariable)new StatusVariable(5))}), new SortCriteria[]{new SortCriteria(IWorkItem.ID_PROPERTY, false)}), IWorkItem.DEFAULT_PROFILE) : queryClient.getResolvedExpressionResults(pa, (Expression)new Statement(new SelectClause(), (Expression)new Term(0, new Expression[]{sameprojectArea, new VariableAttributeExpression(factory.findAttribute(pa, IWorkItem.STATE_PROPERTY, (IAuditableCommon)auditableClient, monitor), AttributeOperation.EQUALS, (IAttributeVariable)new StatusVariable(5))}), new SortCriteria[]{new SortCriteria(IWorkItem.ID_PROPERTY, false)}), IWorkItem.DEFAULT_PROFILE));
        ArrayList<WorkitemDTO> result = new ArrayList<WorkitemDTO>();
        while (queryResults.hasNext(monitor)) {
            IResolvedResult thisResult = (IResolvedResult)queryResults.next(monitor);
            WorkitemDTO workitemDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkitemDTO();
            IWorkItem thisWI = (IWorkItem)thisResult.getItem();
            String stateName = "";
            try {
                Identifier state = thisWI.getState2();
                IWorkflowInfo workflowInfo = wiClient.getWorkflow(thisWI.getWorkItemType(), pa, monitor);
                stateName = workflowInfo.getStateName(state);
            }
            catch (Exception exception) {
                // empty catch block
            }
            workitemDTO.setItemId(Integer.toString(thisWI.getId()));
            workitemDTO.setStatus(stateName);
            workitemDTO.setSummary(thisWI.getHTMLSummary().getPlainText());
            workitemDTO.setType(thisWI.getWorkItemType());
            result.add(workitemDTO);
        }
        return result.toArray(new WorkitemDTO[result.size()]);
    }

    private boolean isReservedVariable(IVariable variable) {
        String[] stringArray = Constants.reservedVariableNames;
        int n = Constants.reservedVariableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String reservedVar = stringArray[n2];
            if (variable.getName().equalsIgnoreCase(reservedVar)) {
                return true;
            }
            ++n2;
        }
        stringArray = Constants.reservedVariableSuffixes;
        n = Constants.reservedVariableSuffixes.length;
        n2 = 0;
        while (n2 < n) {
            String reservedSuffix = stringArray[n2];
            if (variable.getName().toUpperCase().endsWith(reservedSuffix.toUpperCase())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public MemberMetadataDTO getMemberMetadata(ParmsGetMemberMetadata parms, IProgressMonitor monitor) throws Exception {
        IVersionableManager vManager;
        ITeamRepository repo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        MemberMetadataDTO result = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createMemberMetadataDTO();
        IShareable shareable = ZFilesystemRestClient.findShareable(parms.memberName, session);
        ISharingDescriptor descriptor = shareable.getShare(monitor).getSharingDescriptor();
        result.setRepoUid(descriptor.getRepositoryId().getUuidValue());
        if (shareable != null) {
            FileLineDelimiter lineDelimiter = shareable.getLineDelimiter(monitor);
            String contentType = shareable.getContentType(monitor);
            result.setBinary(contentType.equalsIgnoreCase("application/unknown") && lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE));
        }
        Map curProps = shareable.getMetadataProperties(monitor).getCurrentProperties();
        try {
            repo = session.getLoggedInRepository();
        }
        catch (TeamRepositoryException ex) {
            repo = null;
        }
        ISystemDefinitionModelClient isdc = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
        Boolean langdefProp = false;
        for (String key : curProps.keySet()) {
            String codepageVal;
            if (!key.equals("team.enterprise.language.definition") && !key.equals("team.enterprise.build.changes.ignoreForDependencyBuild") && !key.equals("team.enterprise.build.alwaysload") && !key.startsWith("team.enterprise.build.var.") && !key.equals("mvsCodePage") || key.equals("mvsCodePage") && ((codepageVal = (String)curProps.get("mvsCodePage")) == null || codepageVal.length() <= 0)) continue;
            if (key.equals("team.enterprise.language.definition") && repo != null) {
                String uuidValue = (String)curProps.get("team.enterprise.language.definition");
                langdefProp = true;
                ILanguageDefinition langDef = (ILanguageDefinition)isdc.findSystemDefinition(uuidValue, null, ILanguageDefinition.ITEM_TYPE, monitor);
                result.setLangdefName(langDef.getName());
                List translators = langDef.getTranslators();
                for (ITranslatorEntry entry : translators) {
                    ITranslator translator;
                    if (entry.getKind() != "com.ibm.team.enterprise.systemdefinition.entry.translator" || (translator = (ITranslator)isdc.findSystemDefinition(entry.getValue(), null, ITranslator.ITEM_TYPE, monitor)) == null) continue;
                    List translatorVars = translator.getVariables();
                    for (IVariable v : translatorVars) {
                        if (this.isReservedVariable(v)) continue;
                        PropertyDTO prop = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createPropertyDTO();
                        String defaultName = DEFAULT_USER_VARIABLE_PREFIX + v.getName();
                        prop.setName(defaultName);
                        prop.setValue(v.getValue());
                        result.getProperties().add(prop);
                    }
                }
            }
            PropertyDTO prop = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createPropertyDTO();
            prop.setName(key);
            prop.setValue((String)curProps.get(key));
            result.getProperties().add(prop);
        }
        if (repo != null) {
            if (repo.getId().getUuidValue().equals(descriptor.getRepositoryId().getUuidValue())) {
                IWorkspace workspace;
                result.setComponentName(descriptor.getComponentName());
                result.setCompUUID(descriptor.getComponent().getItemId().getUuidValue());
                result.setWorkspaceName(descriptor.getConnectionName());
                try {
                    workspace = (IWorkspace)repo.itemManager().fetchPartialItem((IItemHandle)descriptor.getConnectionHandle(), 0, Collections.singletonList(IWorkspace.NAME_PROPERTY), monitor);
                }
                catch (TeamRepositoryException ex) {
                    workspace = null;
                }
                if (workspace != null) {
                    IConfiguration config;
                    result.setWorkspaceName(workspace.getName());
                    result.setWorkspaceUUID(workspace.getItemId().getUuidValue());
                    try {
                        config = ZFilesystemRestClient.getWorkspaceConnection(repo, (IWorkspaceHandle)descriptor.getConnectionHandle(), monitor).configuration(descriptor.getComponent());
                    }
                    catch (TeamRepositoryException ex) {
                        config = null;
                    }
                    if (config != null) {
                        List rept;
                        IVersionable versionable;
                        vManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager();
                        try {
                            versionable = vManager.fetchCompleteState(shareable.getVersionable(monitor), monitor);
                        }
                        catch (TeamRepositoryException ex) {
                            versionable = null;
                        }
                        if (versionable == null) {
                            rept = null;
                        } else {
                            try {
                                rept = config.determineAncestorsInHistory(Collections.singletonList(versionable), monitor);
                            }
                            catch (TeamRepositoryException ex) {
                                rept = null;
                            }
                        }
                        if (rept != null) {
                            result.setPath(this.makePath(((IAncestorReport)rept.get(0)).getNameItemPairs()));
                        }
                    }
                }
            } else {
                result.setComponentName(descriptor.getComponent().getItemId().getUuidValue());
                result.setCompUUID(descriptor.getComponent().getItemId().getUuidValue());
                result.setWorkspaceName(descriptor.getConnectionHandle().getItemId().getUuidValue());
            }
        }
        if (!langdefProp.booleanValue()) {
            int lastIndexOfPeriod;
            IVersionable remote;
            String name;
            String extension = null;
            IVersionableHandle remoteHandle = shareable.getRemote(monitor);
            if (remoteHandle != null && (name = (remote = (vManager = SCMPlatform.getWorkspaceManager((ITeamRepository)session.getLoggedInRepository()).versionableManager()).fetchPartialState(remoteHandle, Collections.singletonList(IVersionable.NAME_PROPERTY), monitor)).getName()) != null && (lastIndexOfPeriod = name.lastIndexOf(46)) > 0) {
                extension = name.substring(lastIndexOfPeriod + 1);
            }
            if (extension != null) {
                ILanguageDefinition langDef = isdc.getDefaultLanguageDefinition(extension, (IProgressMonitor)new NullProgressMonitor());
                if (langDef != null) {
                    result.setDefaultLangdef(true);
                    result.setLangdefName(langDef.getName());
                }
            } else {
                result.setDefaultLangdef(false);
            }
        }
        return result;
    }

    @Override
    public GetActiveChangesetsDTO getActiveChangesets(ParmsGetActiveChangesets parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        GetActiveChangesetsDTO result = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createGetActiveChangesetsDTO();
        IWorkspaceHandle wsHandle = null;
        IComponentHandle compHandle = null;
        boolean allSameConfig = true;
        int numMembers = parms.members == null ? 0 : parms.members.length;
        int i = 0;
        while (i < numMembers && allSameConfig) {
            IShareable shareable = ZFilesystemRestClient.findShareable(parms.members[i], session);
            ISharingDescriptor descriptor = shareable.getShare(monitor).getSharingDescriptor();
            IWorkspaceHandle thisWSHandle = (IWorkspaceHandle)descriptor.getConnectionHandle();
            if (wsHandle == null) {
                wsHandle = thisWSHandle;
            } else if (!wsHandle.getItemId().equals((Object)thisWSHandle.getItemId())) {
                allSameConfig = false;
            }
            IComponentHandle thisCompHandle = descriptor.getComponent();
            if (compHandle == null) {
                compHandle = thisCompHandle;
            } else if (!compHandle.getItemId().equals((Object)thisCompHandle.getItemId())) {
                allSameConfig = false;
            }
            ++i;
        }
        result.setAllSameConfig(allSameConfig);
        if (allSameConfig && wsHandle != null && compHandle != null) {
            int numHandles;
            IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, wsHandle, monitor);
            wsConn.refresh(monitor);
            List handles = wsConn.activeChangeSets(compHandle);
            int n = numHandles = handles == null ? 0 : handles.size();
            if (numHandles == 0) {
                return result;
            }
            IChangeSetHandle csHandle = wsConn.getCurrentChangeSet(compHandle);
            if (csHandle != null) {
                result.setCurrentChangesetID(csHandle.getItemId().getUuidValue());
            }
            List changesets = repo.itemManager().fetchPartialItems(handles, 0, Collections.singletonList(IChangeSet.COMMENT_PROPERTY), monitor);
            Map<UUID, Summary> csUUIDtoSummary = ZFilesystemRestClient.getSummaries(repo, changesets, monitor);
            int numChangesets = changesets == null ? 0 : changesets.size();
            int i2 = 0;
            while (i2 < numChangesets) {
                IChangeSet thisCS = (IChangeSet)changesets.get(i2);
                ChangesetDTO csDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createChangesetDTO();
                csDTO.setItemId(thisCS.getItemId().getUuidValue());
                Summary s = csUUIDtoSummary.get(thisCS.getItemId());
                if (s != null) {
                    csDTO.setSummary(s.summary);
                    csDTO.setComment(s.comment);
                }
                result.getChangesets().add(csDTO);
                ++i2;
            }
        }
        return result;
    }

    @Override
    public void postChangeProperties(ParmsChangeProperties parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        IShareable shareable = ZFilesystemRestClient.findShareable(parms.member, session);
        IMetadataProperties userProperties = shareable.getMetadataProperties(monitor);
        HashMap<String, String> properties = new HashMap<String, String>(userProperties.getCurrentProperties());
        IChangePropertiesOperation changePropertyOperation = IOperationFactory.instance.getChangePropertiesOperation(null);
        int numProps = parms.properties == null ? 0 : parms.properties.length;
        int i = 0;
        while (i < numProps) {
            if (parms.properties[i].value == null || parms.properties[i].value.equals(".deleteRTCproperty")) {
                properties.remove(parms.properties[i].name);
            } else {
                properties.put(parms.properties[i].name, parms.properties[i].value);
            }
            ++i;
        }
        if (parms.binary != null && parms.binary.booleanValue()) {
            changePropertyOperation.setContentType(shareable, "application/unknown");
            changePropertyOperation.setLineDelimiter(shareable, FileLineDelimiter.LINE_DELIMITER_NONE);
        } else {
            changePropertyOperation.setContentType(shareable, "text/plain");
            changePropertyOperation.setLineDelimiter(shareable, FileLineDelimiter.LINE_DELIMITER_PLATFORM);
        }
        this.switchAuth(session.getMVSID(), parms.passTicket);
        changePropertyOperation.setProperties(shareable, properties);
        try {
            ZFilesystemRestClient.runOp((IFileSystemOperation)changePropertyOperation, monitor);
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public NamedItemDTO[] getMatchingDSDefs(ParmsGetMatchingDSDefs parms, IProgressMonitor monitor) throws TeamRepositoryException {
        List projectAreas;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
        ArrayList<NamedItemDTO> result = new ArrayList<NamedItemDTO>();
        String shareRoot = parms.dsName == null ? null : ZFilesystemRestClient.findShareRoot(parms.dsName, session);
        String relativeName = null;
        if (shareRoot != null && (relativeName = parms.dsName.substring(shareRoot.length())).length() > 0 && relativeName.charAt(0) == '.') {
            relativeName = relativeName.substring(1);
        }
        int numProjectAreas = (projectAreas = ((IProcessItemService)repo.getClientLibrary(IProcessItemService.class)).findAllProjectAreas(Collections.singletonList("name"), monitor)) == null ? 0 : projectAreas.size();
        int paIndex = 0;
        while (paIndex < numProjectAreas) {
            List itemList = client.findSystemDefinitions(IDataSetDefinition.ITEM_TYPE, (IProjectAreaHandle)projectAreas.get(paIndex), 0, false, Arrays.asList(IDataSetDefinition.SMALL_PROFILE), monitor);
            for (ISystemDefinition item : itemList) {
                IDataSetDefinition dsdef = (IDataSetDefinition)item;
                if (relativeName != null && !relativeName.equals(dsdef.getDsName())) continue;
                NamedItemDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
                thisDTO.setItemId(dsdef.getItemId().getUuidValue());
                thisDTO.setName(dsdef.getName());
                result.add(thisDTO);
            }
            ++paIndex;
        }
        return result.toArray(new NamedItemDTO[result.size()]);
    }

    @Override
    public NamedItemDTO[] getListLangDefs(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ISystemDefinitionModelClient ldClient = com.ibm.team.enterprise.systemdefinition.client.ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repo);
        ArrayList<NamedItemDTO> result = new ArrayList<NamedItemDTO>();
        List projectAreas = ((IProcessItemService)repo.getClientLibrary(IProcessItemService.class)).findAllProjectAreas(Collections.singletonList("name"), monitor);
        int numProjectAreas = projectAreas == null ? 0 : projectAreas.size();
        int i = 0;
        while (i < numProjectAreas) {
            List langDefs = ldClient.findSystemDefinitions(IZosLanguageDefinition.ITEM_TYPE, (IProjectAreaHandle)projectAreas.get(i), -1, false, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor);
            if (langDefs != null && langDefs.size() > 0) {
                for (ISystemDefinition systemDefinition : langDefs) {
                    if (systemDefinition.isArchived()) continue;
                    NamedItemDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
                    thisDTO.setItemId(systemDefinition.getItemId().getUuidValue());
                    thisDTO.setName(systemDefinition.getName());
                    result.add(thisDTO);
                }
            }
            ++i;
        }
        return result.toArray(new NamedItemDTO[result.size()]);
    }

    private static IChangeHistorySyncReport getReport(ITeamRepository repo, IWorkspaceHandle sourceWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeHistorySyncReport syncReport;
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, sourceWorkspace, monitor);
        IWorkspaceHandle flowTargetHandle = Flow.getFlowTarget(repo, wsConn);
        if (flowTargetHandle != null) {
            List<IComponentHandle> excludedComponents = Flow.getExcludedComponents(repo, wsConn, monitor);
            syncReport = wsConn.compareTo((IFlowNodeConnection)ZFilesystemRestClient.getWorkspaceConnection(repo, flowTargetHandle, monitor), 3, excludedComponents, monitor);
        } else {
            syncReport = null;
        }
        return syncReport;
    }

    private static List<PendingChangeDTO> convertBaselines(ISPFSession session, List<IBaselineHandle> blHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<PendingChangeDTO> result = new ArrayList<PendingChangeDTO>();
        ITeamRepository repo = session.getLoggedInRepository();
        List baselines = repo.itemManager().fetchCompleteItems(blHandles, 0, monitor);
        int numBaselines = baselines == null ? 0 : baselines.size();
        int i = 0;
        while (i < numBaselines) {
            IBaseline thisBL = (IBaseline)baselines.get(i);
            PendingChangeDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createPendingChangeDTO();
            thisDTO.setIsBaseline(true);
            thisDTO.setItemId(thisBL.getItemId().getUuidValue());
            thisDTO.setAuthor(((IContributor)repo.itemManager().fetchPartialItem((IItemHandle)thisBL.getCreator(), 0, Collections.singletonList(IContributor.NAME_PROPERTY), monitor)).getName());
            IComponent curComponent = (IComponent)repo.itemManager().fetchPartialItem((IItemHandle)thisBL.getComponent(), 0, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
            thisDTO.setComponentName(curComponent.getName());
            String summary = thisBL.getId() + ": " + thisBL.getName();
            String comment = thisBL.getComment();
            thisDTO.setSummary(summary);
            thisDTO.setComment(comment);
            thisDTO.setHasConflicts(false);
            thisDTO.setCreationDate(session.getDateFormat().format(thisBL.getCreationDate()));
            thisDTO.setICreationDate(thisBL.getCreationDate().getTime());
            result.add(thisDTO);
            ++i;
        }
        return result;
    }

    @Override
    public ChangesetDTO[] getPendingChanges(ParmsGetPendingChanges parms, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceHandle sourceWorkspace;
        ISPFSession session;
        ITeamRepository repo;
        IChangeHistorySyncReport syncReport;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        if ((syncReport = ZFilesystemRestClient.getReport(repo = (session = ZFilesystemRestClient.getSession(parms.clientKey)).getLoggedInRepository(), sourceWorkspace = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.wsUUID), null), monitor)) != null) {
            List outgoingCS = syncReport.outgoingChangeSets();
            List csHandles = parms.incoming != false ? outgoingCS : syncReport.incomingChangeSets();
            List<ChangesetDTO> result = ZFilesystemRestClient.convertChangeSets(session, parms.incoming != false ? syncReport.incomingChangeSets() : outgoingCS, ZFilesystemRestClient.findAffectedVersionables(repo, csHandles, monitor), false, null, monitor);
            result.addAll(ZFilesystemRestClient.convertBaselines(session, parms.incoming != false ? syncReport.incomingBaselines() : syncReport.outgoingBaselines(), monitor));
            Collections.sort(result, new Comparator<ChangesetDTO>(){

                @Override
                public int compare(ChangesetDTO e1, ChangesetDTO e2) {
                    int ret = e1.getComponentName().compareTo(e2.getComponentName());
                    if (ret == 0) {
                        return e1.getICreationDate() <= e2.getICreationDate() ? 1 : -1;
                    }
                    return ret;
                }
            });
            return result.toArray(new ChangesetDTO[result.size()]);
        }
        return new ChangesetDTO[0];
    }

    private static boolean hasConflicts(IChangeSet changeSet, Set<String> conflictUUIDs) {
        if (conflictUUIDs != null) {
            List changes = changeSet.changes();
            int numChanges = changes == null ? 0 : changes.size();
            int j = 0;
            while (j < numChanges) {
                if (conflictUUIDs.contains(((IChange)changes.get(j)).item().getItemId().getUuidValue())) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private static Set<String> findAffectedVersionables(ITeamRepository repo, List<IChangeSetHandle> csHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        List changeSets = repo.itemManager().fetchPartialItems(csHandles, 0, Collections.singletonList(IChangeSet.CHANGES_PROPERTY), monitor);
        HashSet<String> affectedUUIDs = new HashSet<String>();
        for (IChangeSet thisCS : changeSets) {
            List changes = thisCS.changes();
            int numChanges = changes == null ? 0 : changes.size();
            int j = 0;
            while (j < numChanges) {
                affectedUUIDs.add(((IChange)changes.get(j)).item().getItemId().getUuidValue());
                ++j;
            }
        }
        return affectedUUIDs;
    }

    private static boolean findConflicts(ITeamRepository repo, List<IChangeSetHandle> incoming, List<IChangeSetHandle> outgoing, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean incomingBigger = incoming.size() > outgoing.size();
        Set<String> affectedUUIDs = ZFilesystemRestClient.findAffectedVersionables(repo, incomingBigger ? outgoing : incoming, monitor);
        List changeSets = repo.itemManager().fetchPartialItems(incomingBigger ? incoming : outgoing, 0, Collections.singletonList(IChangeSet.CHANGES_PROPERTY), monitor);
        for (IChangeSet thisCS : changeSets) {
            if (!ZFilesystemRestClient.hasConflicts(thisCS, affectedUUIDs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GetUsersWorkspacesDTO[] getListUsersWorkspaces(ParmsGetRepositoryWorkspaces parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ArrayList<GetUsersWorkspacesDTO> result = new ArrayList<GetUsersWorkspacesDTO>();
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        List<Object> detailUUIDs = parms.detailUUIDs != null && parms.detailUUIDs.length > 0 ? Arrays.asList(parms.detailUUIDs) : new ArrayList();
        IContributor contribHandle = repo.loggedInContributor();
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
        criteria.getFilterByOwnerOptional().add(contribHandle);
        List handles = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findWorkspaces(criteria, Integer.MAX_VALUE, null);
        List workspaces = repo.itemManager().fetchPartialItems(handles, 0, Collections.singletonList(IWorkspace.NAME_PROPERTY), monitor);
        for (IWorkspace workspace : workspaces) {
            GetUsersWorkspacesDTO details = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createGetUsersWorkspacesDTO();
            NamedItemDTO wsDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            String wsUUID = workspace.getItemId().getUuidValue();
            wsDTO.setName(workspace.getName());
            wsDTO.setItemId(wsUUID);
            details.setWorkspace(wsDTO);
            boolean incoming = false;
            boolean outgoing = false;
            boolean conflicts = false;
            boolean merges = false;
            if (detailUUIDs.contains(wsUUID)) {
                IWorkspaceConnection wsConn;
                IChangeHistorySyncReport syncReport = ZFilesystemRestClient.getReport(repo, (IWorkspaceHandle)workspace, monitor);
                if (syncReport != null) {
                    List incomingCS = syncReport.incomingChangeSets();
                    List outgoingCS = syncReport.outgoingChangeSets();
                    incoming = incomingCS != null && incomingCS.size() > 0;
                    boolean bl = outgoing = outgoingCS != null && outgoingCS.size() > 0;
                    if (incoming && outgoing) {
                        conflicts = ZFilesystemRestClient.findConflicts(repo, incomingCS, outgoingCS, monitor);
                    }
                    if (!incoming) {
                        List incomingBL = syncReport.incomingBaselines();
                        boolean bl2 = incoming = incomingBL != null && incomingBL.size() > 0;
                    }
                    if (!outgoing) {
                        List outgoingBL = syncReport.outgoingBaselines();
                        boolean bl3 = outgoing = outgoingBL != null && outgoingBL.size() > 0;
                    }
                }
                if ((wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, monitor)).conflictReport().conflicts().size() > 0) {
                    merges = true;
                }
            }
            details.setHasIncoming(incoming);
            details.setHasOutgoing(outgoing);
            details.setHasConflicts(conflicts);
            details.setHasMerges(merges);
            result.add(details);
        }
        return result.toArray(new GetUsersWorkspacesDTO[result.size()]);
    }

    private void setAllPermissions(ITeamRepository repository, IProcessArea processArea, BuildPropertiesDTO result) throws TeamRepositoryException {
        IProcessClientService processService = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
        IClientProcess clientProcess = processService.getClientProcess(processArea, null);
        boolean[] permitted = clientProcess.getPermittedActions(processArea, "com.ibm.team.enterprise.build.ui.requestFullBuildOperation", new String[]{"requestFullBuildAction"}, null);
        result.setHasFullBuildPermission(permitted[0]);
        permitted = clientProcess.getPermittedActions(processArea, "com.ibm.team.enterprise.build.ui.requestSimulationBuildOperation", new String[]{"requestSimulationBuildAction"}, null);
        result.setHasSimulationBuildPermission(permitted[0]);
        permitted = clientProcess.getPermittedActions(processArea, "com.ibm.team.enterprise.build.ui.overrideAdvancedPropertiesOperation", new String[]{"overrideAdvancedPropertiesPersonalAction"}, null);
        result.setHasOverrideAdvancedPropertiesPersonalAction(permitted[0]);
        permitted = clientProcess.getPermittedActions(processArea, "com.ibm.team.enterprise.build.ui.overrideAdvancedPropertiesOperation", new String[]{"overrideAdvancedPropertiesTeamAction"}, null);
        result.setHasOverrideAdvancedPropertiesTeamAction(permitted[0]);
    }

    @Override
    public BuildPropertiesDTO getBuildProperties(ParmsGetBuildProperties parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        String RATIONAL_BUILDAGENT_MARKER = "com.ibm.rational.buildforge.buildagent";
        String PROPERTY_BUILD_FILE = "team.enterprise.build.ant.buildFile";
        String PROPERTY_ANT_ARGS = "team.enterprise.build.ant.antArgs";
        String PROPERTY_BUILD_TARGETS = "team.enterprise.build.ant.targets";
        String PROPERTY_CONDITIONAL_BUILD = "team.enterprise.build.ant.conditionalBuild";
        String PROPERTY_USE_GENERATED = "team.enterprise.build.ant.useGeneratedBuildFile";
        BuildPropertiesDTO result = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createBuildPropertiesDTO();
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        List buildProps = null;
        if (parms.buildDefnUUID != null) {
            String subsetPropertyValue;
            IBuildDefinition buildDefn = (IBuildDefinition)repo.itemManager().fetchPartialItem(IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildDefnUUID), null), 1, Arrays.asList(IBuildDefinition.PROPERTY_PROPERTIES, IBuildDefinition.PROPERTY_CONFIGURATION_ELEMENTS, IBuildDefinition.PROPERTY_PROCESS_AREA), monitor);
            buildProps = buildDefn.getProperties();
            result.setIsPersonal(false);
            IProcessAreaHandle processAreaHandle = buildDefn.getProcessArea();
            IProcessArea processArea = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 1, monitor);
            this.setAllPermissions(repo, processArea, result);
            IBuildProperty subsetProperty = buildDefn.getProperty("teamz.build.ant.buildableSubset");
            String string = subsetPropertyValue = subsetProperty != null ? subsetProperty.getValue() : "";
            if (!subsetPropertyValue.isEmpty()) {
                result.setSubset(BuildableSubsetUtil.getSlug((String)subsetPropertyValue, (String)buildDefn.getItemId().getUuidValue()));
            }
            String PROPERTY_MANDATORY_SUBSET_SLUG = "team.enterprise.build.ant.mandatorySubset";
            IBuildProperty mandatorySubsetProperty = buildDefn.getProperty("team.enterprise.build.ant.mandatorySubset");
            String mandatorySubsetSlug = mandatorySubsetProperty != null ? mandatorySubsetProperty.getValue() : null;
            String mandatorySubsetLabel = BuildableSubsetUtil.getLabelFromSlug((String)mandatorySubsetSlug);
            result.setMandatorySubset(mandatorySubsetLabel);
            result.setIsRationalBuildAgentBuild(buildDefn.getConfigurationElement("com.ibm.rational.buildforge.buildagent") != null);
            String ELEMENT_ID = "com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement";
            IBuildConfigurationElement element = buildDefn.getConfigurationElement("com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement");
            if (element != null) {
                this.addPropertyValue(element, result.getProperties(), "team.enterprise.build.ant.antArgs");
                this.addPropertyValue(element, result.getProperties(), "team.enterprise.build.ant.buildFile");
                this.addPropertyValue(element, result.getProperties(), "team.enterprise.build.ant.targets");
                this.addPropertyValue(element, result.getProperties(), "team.enterprise.build.ant.conditionalBuild");
                this.addPropertyValue(element, result.getProperties(), "team.enterprise.build.ant.useGeneratedBuildFile");
            }
        } else if (parms.buildResultUUID != null) {
            IBuildResult buildResult = (IBuildResult)repo.itemManager().fetchPartialItem(IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildResultUUID), null), 0, Arrays.asList(IBuildResult.PROPERTY_BUILD_REQUESTS, IBuildResult.PROPERTY_PERSONAL_BUILD), monitor);
            IBuildRequest request = ZFilesystemRestClient.getBuildRequest(buildResult, repo, monitor);
            IBuildDefinitionInstance buildDefnInstance = request.getBuildDefinitionInstance();
            buildProps = buildDefnInstance.getProperties();
            result.setIsPersonal(buildResult.isPersonalBuild());
            result.setIsRationalBuildAgentBuild(buildDefnInstance.getConfigurationElement("com.ibm.rational.buildforge.buildagent") != null);
        }
        int numBuildProps = buildProps == null ? 0 : buildProps.size();
        int i = 0;
        while (i < numBuildProps) {
            String workspaceUUID;
            IBuildProperty thisProp = (IBuildProperty)buildProps.get(i);
            if ("teamz.scm.workspaceUUID".equals(thisProp.getName()) && (workspaceUUID = thisProp.getValue()) != null && workspaceUUID.length() > 0) {
                IWorkspaceConnection wsConn = null;
                try {
                    wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, workspaceUUID, monitor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (wsConn != null) {
                    result.setWorkspaceName(wsConn.getName());
                }
            }
            PropertyDTO thisPropDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createPropertyDTO();
            thisPropDTO.setName(thisProp.getName());
            thisPropDTO.setValue(thisProp.getValue());
            thisPropDTO.setIsGenericEditAllowed(thisProp.isGenericEditAllowed());
            result.getProperties().add(thisPropDTO);
            ++i;
        }
        return result;
    }

    private void addPropertyValue(IBuildConfigurationElement element, List<? super PropertyDTO> properties, String propertyName) {
        String value;
        IConfigurationProperty confProp = element.getConfigurationProperty(propertyName);
        if (confProp != null && (value = confProp.getValue()) != null && value.length() > 0) {
            PropertyDTO thisPropDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createPropertyDTO();
            thisPropDTO.setName(propertyName);
            thisPropDTO.setValue(value);
            thisPropDTO.setIsGenericEditAllowed(false);
            properties.add((PropertyDTO)thisPropDTO);
        }
    }

    protected static String getInitials(ITeamRepository repo, IContributorHandle contrib, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contrib == null) {
            return "";
        }
        String fullName = ((IContributor)repo.itemManager().fetchPartialItem((IItemHandle)contrib, 0, Collections.singletonList(IContributor.NAME_PROPERTY), monitor)).getName();
        return fullName;
    }

    protected static String getItemId(ITeamRepository repo, IContributorHandle contrib, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contrib == null) {
            return "";
        }
        String fullName = ((IContributor)repo.itemManager().fetchPartialItem((IItemHandle)contrib, 0, Collections.singletonList(IContributor.ITEM_ID_PROPERTY), monitor)).getUserId();
        return fullName;
    }

    @Override
    public NamedItemDTO[] getBuildableSubsets(ParmsGetBuildableSubsets parms, IProgressMonitor monitor) throws Exception {
        List<IBuildDefinitionHandle> buildDefinitionHandles;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        String ownerId = repo.loggedInContributor().getItemId().getUuidValue();
        if (parms.defnUUID == null || parms.defnUUID.length == 0) {
            buildDefinitionHandles = ZFilesystemRestClient.getAllBuildDefinitionsHandles(session, monitor);
        } else {
            buildDefinitionHandles = new ArrayList<IBuildDefinitionHandle>(parms.defnUUID.length);
            int i = 0;
            while (i < parms.defnUUID.length) {
                UUID uuid = UUID.valueOf((String)parms.defnUUID[i]);
                IBuildDefinitionHandle buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(uuid, null);
                buildDefinitionHandles.add(buildDefinitionHandle);
                ++i;
            }
        }
        ArrayList subsets = new ArrayList();
        for (IBuildDefinitionHandle buildDefinitionHandle : buildDefinitionHandles) {
            List sub = client.getAllBuildableSubsets(buildDefinitionHandle, ownerId);
            subsets.addAll(sub);
        }
        int numSubsets = subsets == null ? 0 : subsets.size();
        NamedItemDTO[] result = new NamedItemDTO[numSubsets];
        int i = 0;
        while (i < numSubsets) {
            result[i] = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            result[i].setItemId(((ISubset)subsets.get(i)).getBuildDefinition().getItemId().getUuidValue());
            result[i].setName(((ISubset)subsets.get(i)).getLabel());
            ++i;
        }
        return result;
    }

    @Override
    public BuildResultDTO[] getBuildResults(ParmsGetBuildResults parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ArrayList<BuildResultDTO> result = new ArrayList<BuildResultDTO>();
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        List<IBuildResult> results = ZFilesystemRestClient.queryBuildResults(repo, (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildDefnUUID), null), false, monitor);
        int numResults = results == null ? 0 : results.size();
        int i = 0;
        while (i < numResults) {
            String personalInit;
            BuildResultDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createBuildResultDTO();
            IBuildResult thisResult = results.get(i);
            thisDTO.setItemId(thisResult.getItemId().getUuidValue());
            thisDTO.setLabel(thisResult.getLabel());
            long startTime = thisResult.getBuildStartTime();
            if (startTime != Long.MAX_VALUE && startTime > 0L) {
                thisDTO.setStartTime(session.getDateFormat().format(new Date(startTime)));
            }
            if (thisResult.isPersonalBuild()) {
                personalInit = "*";
                IBuildRequest buildReq = ZFilesystemRestClient.getBuildRequest(thisResult, repo, monitor);
                if (buildReq != null) {
                    personalInit = ZFilesystemRestClient.getInitials(repo, buildReq.getInitiatingContributor(), monitor);
                }
            } else {
                personalInit = "";
            }
            thisDTO.setPersonalInit(personalInit);
            int stateByte = -1;
            BuildState state = thisResult.getState();
            if (state.equals((Object)BuildState.IN_PROGRESS)) {
                stateByte = 2;
            } else if (state.equals((Object)BuildState.COMPLETED)) {
                BuildStatus status = thisResult.getStatus();
                if (status.equals((Object)BuildStatus.OK)) {
                    stateByte = 0;
                } else if (status.equals((Object)BuildStatus.ERROR)) {
                    stateByte = 1;
                }
            } else if (state.equals((Object)BuildState.NOT_STARTED)) {
                stateByte = 3;
            } else if (state.equals((Object)BuildState.CANCELED)) {
                stateByte = 4;
            } else if (state.equals((Object)BuildState.INCOMPLETE)) {
                stateByte = 5;
            }
            thisDTO.setState((byte)stateByte);
            if (BuildState.IN_PROGRESS.equals((Object)state)) {
                thisDTO.setDuration(DaemonUtils.getDuration(new Date().getTime() - startTime));
            } else {
                thisDTO.setDuration(DaemonUtils.getDuration(thisResult.getBuildTimeTaken()));
            }
            result.add(thisDTO);
            ++i;
        }
        return result.toArray(new BuildResultDTO[result.size()]);
    }

    @Override
    public void postRequestBuild(ParmsRequestBuild parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        String PROPERTY_BUILDAGENT_PASSWORD = "com.ibm.rational.buildforge.buildagent.password";
        String PROPERTY_BUILDAGENT_USERID = "com.ibm.rational.buildforge.buildagent.userid";
        String PROPERTY_WORKSPACE_UUID = "team.enterprise.scm.workspaceUUID";
        String PROPERTY_TEAM_WORKSPACE_UUID = "team.enterprise.scm.teamWorkspaceUUID";
        String PROPERTY_RESOURCE_PREFIX = "team.enterprise.scm.resourcePrefix";
        String PROPERTY_RESOURCE_TEAMPREFIX = "team.enterprise.scm.resourceTeamPrefix";
        ITeamRepository repo = ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository();
        ITeamBuildRequestClient client = ClientFactory.getTeamBuildRequestClient((ITeamRepository)repo);
        IBuildDefinition buildDef = (IBuildDefinition)repo.itemManager().fetchPartialItem(IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildDefnUUID), null), 0, Arrays.asList(IBuildDefinition.PROPERTY_PROPERTIES, IBuildDefinition.PROPERTY_ID), monitor);
        if (!ZFilesystemRestClient.isDefinitionSupported(repo, buildDef, monitor)) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.ZFilesystemRestClient_NO_SUPPORTING_ENGINES, (Object)buildDef.getId()));
        }
        ArrayList<IBuildProperty> newProps = new ArrayList<IBuildProperty>();
        ArrayList<String> newPropNames = new ArrayList<String>();
        int numProps = parms.properties == null ? 0 : parms.properties.length;
        int i = 0;
        while (i < numProps) {
            if ("teamz.build.ant.buildableSubset".equals(parms.properties[i].name)) {
                IConfigurationProperty subsetProperty;
                IBuildConfigurationElement element = buildDef.getConfigurationElement("com.ibm.teamz.build.dependency");
                if (element != null && (subsetProperty = element.getConfigurationProperty("teamz.build.ant.buildableSubset")) != null) {
                    subsetProperty.setValue(parms.properties[i].value);
                }
            } else {
                newPropNames.add(parms.properties[i].name);
                if ("com.ibm.rational.buildforge.buildagent.password".equals(parms.properties[i].name)) {
                    try {
                        parms.properties[i].value = new String(ObfuscationHelper.encrypt((byte[])parms.properties[i].value.getBytes("UTF-8")), "UTF-8");
                    }
                    catch (UnsupportedEncodingException element) {
                    }
                    catch (GeneralSecurityException element) {
                        // empty catch block
                    }
                }
                IBuildProperty newProp = BuildItemFactory.createBuildProperty((String)parms.properties[i].name, (String)parms.properties[i].value);
                if ("com.ibm.rational.buildforge.buildagent.password".equals(parms.properties[i].name) || "com.ibm.rational.buildforge.buildagent.userid".equals(parms.properties[i].name)) {
                    newProp.setGenericEditAllowed(false);
                }
                newProps.add(newProp);
            }
            ++i;
        }
        ArrayList<IBuildProperty> deletedProps = new ArrayList<IBuildProperty>();
        List origProperties = buildDef.getProperties();
        int numOrigProps = origProperties == null ? 0 : origProperties.size();
        boolean depBuildV3 = false;
        boolean depBuildV4 = false;
        int i2 = 0;
        while (i2 < numOrigProps) {
            IBuildProperty thisProp = (IBuildProperty)origProperties.get(i2);
            if (thisProp.isGenericEditAllowed() && !newPropNames.remove(thisProp.getName())) {
                deletedProps.add(thisProp);
            }
            if ("com.ibm.team.build.internal.template.id".equals(thisProp.getName())) {
                depBuildV3 = "com.ibm.teamz.build.dependency.template".equals(thisProp.getValue());
                depBuildV4 = "com.ibm.team.enterprise.zos.build.dependency.template".equals(thisProp.getValue());
            }
            ++i2;
        }
        if (parms.workspaceUUID != null) {
            String originalDatasetPrefixValue;
            if (depBuildV4) {
                String originalWorkspaceValue;
                IBuildProperty originalWorkspace;
                newProps.add(BuildItemFactory.createBuildProperty((String)"team.enterprise.scm.workspaceUUID", (String)parms.workspaceUUID));
                IBuildProperty originalDatasetPrefix = buildDef.getProperty("team.enterprise.scm.resourcePrefix");
                if (originalDatasetPrefix != null && !(originalDatasetPrefixValue = originalDatasetPrefix.getValue()).equals("")) {
                    newProps.add(BuildItemFactory.createBuildProperty((String)"team.enterprise.scm.resourceTeamPrefix", (String)originalDatasetPrefixValue));
                }
                if ((originalWorkspace = buildDef.getProperty("team.enterprise.scm.workspaceUUID")) != null && !(originalWorkspaceValue = originalWorkspace.getValue()).equals("")) {
                    newProps.add(BuildItemFactory.createBuildProperty((String)"team.enterprise.scm.teamWorkspaceUUID", (String)originalWorkspaceValue));
                }
            } else {
                IBuildProperty originalDatasetPrefix;
                newProps.add(BuildItemFactory.createBuildProperty((String)"teamz.scm.workspaceUUID", (String)parms.workspaceUUID));
                if (depBuildV3 && (originalDatasetPrefix = buildDef.getProperty("teamz.scm.dataset.prefix")) != null && !(originalDatasetPrefixValue = originalDatasetPrefix.getValue()).equals("")) {
                    newProps.add(BuildItemFactory.createBuildProperty((String)"teamz.scm.dataset.teamprefix", (String)originalDatasetPrefixValue));
                }
            }
        }
        client.requestBuild((IBuildDefinitionHandle)buildDef, newProps.toArray(new IBuildProperty[newProps.size()]), deletedProps.toArray(new IBuildProperty[deletedProps.size()]), true, parms.workspaceUUID != null, monitor);
    }

    protected static boolean matches(String rawExpr, String buildId) {
        return Pattern.compile(String.valueOf(rawExpr.toLowerCase().replaceAll("\\.", "\\\\.").replaceAll("%", ".").replaceAll("\\*\\*", ".+").replaceAll("\\*", ".[^.]*")) + "(\\..*)*", 2).matcher(buildId).matches();
    }

    @Override
    public BuildDefinitionDTO[] getBuildDefinitions(ParmsGetBuildDefinitions parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ArrayList<BuildDefinitionDTO> result = new ArrayList<BuildDefinitionDTO>();
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        List<IBuildDefinition> allDefns = ZFilesystemRestClient.getAllBuildDefinitions(session, monitor);
        int numDefns = allDefns == null ? 0 : allDefns.size();
        int i = 0;
        while (i < numDefns) {
            IBuildDefinition thisDefn = allDefns.get(i);
            String templateId = thisDefn.getPropertyValue("com.ibm.team.build.internal.template.id", null);
            if (!(templateId != null && (parms.onlyDepBuild != null && parms.onlyDepBuild.booleanValue() && !templateId.equalsIgnoreCase("com.ibm.team.enterprise.zos.build.dependency.template") || templateId.startsWith("com.ibm.team.enterprise.promotion") || templateId.startsWith("com.ibm.team.enterprise.packaging") || templateId.startsWith("com.ibm.team.enterprise.deployment")))) {
                String buildId = thisDefn.getId();
                if (parms.pattern == null || ZFilesystemRestClient.matches(parms.pattern, buildId)) {
                    BuildDefinitionDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createBuildDefinitionDTO();
                    thisDTO.setItemId(thisDefn.getItemId().getUuidValue());
                    thisDTO.setName(buildId);
                    List<IBuildResult> results = ZFilesystemRestClient.queryBuildResults(repo, (IBuildDefinitionHandle)thisDefn, true, monitor);
                    byte resultByte = -1;
                    if (results != null && results.size() > 0) {
                        BuildStatus status = results.get(0).getStatus();
                        if (status.equals((Object)BuildStatus.OK)) {
                            resultByte = 0;
                        } else if (status.equals((Object)BuildStatus.ERROR)) {
                            resultByte = 1;
                        }
                    }
                    thisDTO.setLastResult(resultByte);
                    result.add(thisDTO);
                }
            }
            ++i;
        }
        return result.toArray(new BuildDefinitionDTO[result.size()]);
    }

    private static List<IBuildDefinitionHandle> getAllBuildDefinitionsHandles(ISPFSession session, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = session.getLoggedInRepository();
        ArrayList<IBuildDefinitionHandle> handles = new ArrayList<IBuildDefinitionHandle>();
        ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)repo);
        IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel buildDefinitionQueryModel = IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildDefinitionQueryModel);
        IProjectArea projectArea = (IProjectArea)repo.itemManager().fetchCompleteItem((IItemHandle)session.getProjectArea(), 0, monitor);
        List teamAreaHandles = projectArea.getTeamAreas();
        ArrayList<IProjectArea> processAreaHandles = new ArrayList<IProjectArea>(teamAreaHandles.size() + 1);
        processAreaHandles.add(projectArea);
        processAreaHandles.addAll(teamAreaHandles);
        IItemHandleInputArg[] itemHandleArgs = new IItemHandleInputArg[processAreaHandles.size()];
        int i = 0;
        while (i < processAreaHandles.size()) {
            itemHandleArgs[i] = query.newItemHandleArg();
            ++i;
        }
        query.filter(((BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel)buildDefinitionQueryModel).processArea()._in(itemHandleArgs));
        IItemQueryPage queryPage = buildClient.uncommittedQueryItems(query, processAreaHandles.toArray(), 512, monitor);
        handles.addAll(queryPage.getItemHandles());
        UUID queryToken = queryPage.getToken();
        while (queryPage.getNextStartPosition() != -1) {
            queryPage = (IItemQueryPage)buildClient.fetchPage(queryToken, queryPage.getNextStartPosition(), 512, monitor);
            handles.addAll(queryPage.getItemHandles());
        }
        return handles;
    }

    private static List<IBuildDefinition> getAllBuildDefinitions(ISPFSession session, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = session.getLoggedInRepository();
        ArrayList handles = new ArrayList();
        ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)repo);
        IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel buildDefinitionQueryModel = IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildDefinitionQueryModel);
        IProjectArea projectArea = (IProjectArea)repo.itemManager().fetchCompleteItem((IItemHandle)session.getProjectArea(), 0, monitor);
        List teamAreaHandles = projectArea.getTeamAreas();
        ArrayList<IProjectArea> processAreaHandles = new ArrayList<IProjectArea>(teamAreaHandles.size() + 1);
        processAreaHandles.add(projectArea);
        processAreaHandles.addAll(teamAreaHandles);
        IItemHandleInputArg[] itemHandleArgs = new IItemHandleInputArg[processAreaHandles.size()];
        int i = 0;
        while (i < processAreaHandles.size()) {
            itemHandleArgs[i] = query.newItemHandleArg();
            ++i;
        }
        query.filter(((BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel)buildDefinitionQueryModel).processArea()._in(itemHandleArgs));
        IItemQueryPage queryPage = buildClient.uncommittedQueryItems(query, processAreaHandles.toArray(), 512, monitor);
        handles.addAll(queryPage.getItemHandles());
        UUID queryToken = queryPage.getToken();
        while (queryPage.getNextStartPosition() != -1) {
            queryPage = (IItemQueryPage)buildClient.fetchPage(queryToken, queryPage.getNextStartPosition(), 512, monitor);
            handles.addAll(queryPage.getItemHandles());
        }
        return repo.itemManager().fetchPartialItems(handles, 0, Arrays.asList(IBuildDefinition.PROPERTY_ID, IBuildDefinition.PROPERTY_PROPERTIES), monitor);
    }

    protected static List<IBuildResult> queryBuildResults(ITeamRepository repo, IBuildDefinitionHandle defnHandle, boolean onlyLastCompletedNonPersonalBuild, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList handles = new ArrayList();
        ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)repo);
        IBaseBuildResultQueryModel.IBuildResultQueryModel buildResultQueryModel = IBaseBuildResultQueryModel.IBuildResultQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
        IPredicate filter = buildResultQueryModel.buildDefinition()._eq((IItemHandle)defnHandle);
        if (onlyLastCompletedNonPersonalBuild) {
            filter = filter._and(buildResultQueryModel.personalBuild()._eq(Boolean.FALSE));
            filter = filter._and(buildResultQueryModel.buildState()._eq(BuildState.COMPLETED.toString()));
            query.setResultLimit(1);
        }
        query.filter(filter);
        query.orderByDsc((IField)buildResultQueryModel.buildStartTime());
        IItemQueryPage queryPage = buildClient.uncommittedQueryItems(query, IQueryService.EMPTY_PARAMETERS, 512, monitor);
        handles.addAll(queryPage.getItemHandles());
        UUID queryToken = queryPage.getToken();
        while (queryPage.getNextStartPosition() != -1) {
            queryPage = (IItemQueryPage)buildClient.fetchPage(queryToken, queryPage.getNextStartPosition(), 512, monitor);
            handles.addAll(queryPage.getItemHandles());
        }
        return repo.itemManager().fetchPartialItems(handles, 1, Arrays.asList(IBuildResult.PROPERTY_LABEL, IBuildResult.PROPERTY_BUILD_START_TIME, IBuildResult.PROPERTY_BUILD_STATE, IBuildResult.PROPERTY_BUILD_STATUS, IBuildResult.PROPERTY_PERSONAL_BUILD, IBuildResult.PROPERTY_BUILD_REQUESTS, IBuildResult.PROPERTY_BUILD_TIME_TAKEN), monitor);
    }

    private static IBuildRequest getBuildRequest(IBuildResult buildResult, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        List buildRequests = repo.itemManager().fetchPartialItems(buildResult.getBuildRequests(), 0, Arrays.asList(IBuildRequest.PROPERTY_BUILD_ACTION, IBuildRequest.PROPERTY_BUILD_DEFINITION_INSTANCE, IBuildRequest.PROPERTY_INITIATING_CONTRIBUTOR), monitor);
        IBuildRequest buildRequest = null;
        for (IBuildRequest request : buildRequests) {
            if (request == null || !request.getBuildAction().getAction().equals("com.ibm.team.build.action.requestBuild")) continue;
            buildRequest = request;
        }
        return buildRequest;
    }

    private static IRepositoryResolver getRepositoryResolver(final ITeamRepository repo) throws TeamRepositoryException {
        return new IRepositoryResolver(){

            public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                if (repo.getId().equals((Object)id)) {
                    return repo;
                }
                throw new TeamRepositoryException(Messages.ZFilesystemRestClient_UNKNOWN_REPOSITORY);
            }
        };
    }

    protected static String findShareRoot(String name, ISPFSession session) {
        Collection<ISandbox> sandboxes = session.getRegisteredSandboxes();
        for (ISandbox sandbox : sandboxes) {
            ILocation root = sandbox.getRoot();
            if (root instanceof DataSetLocation) {
                String dsPrefix = ((DataSetLocation)root).getDataSetPrefix();
                if (!name.startsWith(String.valueOf(dsPrefix) + '.')) continue;
                return dsPrefix;
            }
            String rootName = ((PathLocation)root).toOSString();
            String sName = String.valueOf(name) + '/';
            if (!sName.startsWith(String.valueOf(rootName) + '/')) continue;
            return rootName;
        }
        return null;
    }

    protected static ILocation findLocation(String fullyQualifiedName, ISPFSession session) {
        String shareRoot = ZFilesystemRestClient.findShareRoot(fullyQualifiedName, session);
        if (shareRoot != null) {
            if (ZFilesystemRestClient.isHierarchical(fullyQualifiedName)) {
                return new PathLocation(fullyQualifiedName);
            }
            int leftParenIdx = fullyQualifiedName.indexOf("(");
            DataSetLocation location = new DataSetLocation(shareRoot, fullyQualifiedName.substring(shareRoot.length() + 1, leftParenIdx), fullyQualifiedName.substring(leftParenIdx + 1, fullyQualifiedName.length() - 1));
            return location;
        }
        return null;
    }

    protected static IShareable findShareable(String fullyQualifiedName, ISPFSession session) {
        String shareRoot = ZFilesystemRestClient.findShareRoot(fullyQualifiedName, session);
        if (shareRoot != null) {
            if (ZFilesystemRestClient.isHierarchical(fullyQualifiedName)) {
                return FileSystemCore.getSharingManager().findShareable((ILocation)new PathLocation(fullyQualifiedName), ResourceType.FILE);
            }
            int leftParenIdx = fullyQualifiedName.indexOf("(");
            DataSetLocation location = new DataSetLocation(shareRoot, fullyQualifiedName.substring(shareRoot.length() + 1, leftParenIdx), fullyQualifiedName.substring(leftParenIdx + 1, fullyQualifiedName.length() - 1));
            return FileSystemCore.getSharingManager().findShareable((ILocation)location, ResourceType.FILE);
        }
        return null;
    }

    private static boolean isHierarchical(String name) {
        return name.contains("/") || name.contains("\\");
    }

    protected ISandbox getSandbox(String root) throws TeamRepositoryException {
        Object rootLoc = ZFilesystemRestClient.isHierarchical(root) ? new PathLocation(root) : new DataSetLocation(root);
        if (corruptionListener.isCorrupt((ILocation)rootLoc)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Corruption of sandbox at " + root + " reported."));
            }
            throw new TeamRepositoryException(NLS.bind((String)Messages.ZFilesystemRestClient_CORRUPT_METADATA, (Object)root));
        }
        return FileSystemCore.getSharingManager().getSandbox((ILocation)rootLoc, false);
    }

    private static boolean isDefinitionSupported(ITeamRepository teamRepository, IBuildDefinition buildDefinition, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamBuildClient client = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        IBaseBuildEngineQueryModel.IBuildEngineQueryModel buildEngineQueryModel = IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT;
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)buildEngineQueryModel);
        query.filter(buildEngineQueryModel.active()._isTrue()._and(buildEngineQueryModel.supportedBuildDefinitions()._contains(query.newItemHandleArg())));
        query.select(query.count());
        IDataQueryPage page = client.queryData(query, new Object[]{buildDefinition}, 1, monitor);
        IDataRow row = page.getRow(0);
        return row.getInt(0) > 0;
    }

    @Override
    public String getFileExtension(ParmsGetFileExtension parms, IProgressMonitor monitor) throws TeamRepositoryException {
        int lastIndexOfPeriod;
        IVersionableManager vManager;
        IVersionable remote;
        String name;
        IVersionableHandle remoteHandle;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        String extension = "";
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        IShareable shareable = ZFilesystemRestClient.findShareable(parms.member, session);
        if (shareable != null && (remoteHandle = shareable.getRemote(monitor)) != null && (name = (remote = (vManager = SCMPlatform.getWorkspaceManager((ITeamRepository)session.getLoggedInRepository()).versionableManager()).fetchPartialState(remoteHandle, Collections.singletonList(IVersionable.NAME_PROPERTY), monitor)).getName()) != null && (lastIndexOfPeriod = name.lastIndexOf(46)) > 0) {
            extension = name.substring(lastIndexOfPeriod + 1);
        }
        return extension;
    }

    @Override
    public void postRename(ParmsRename parms, IProgressMonitor monitor) throws Exception {
        IShare share;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        IShareable toRenameShareable = ZFilesystemRestClient.findShareable(this.createFullPath(parms.dataSet, parms.oldName), session);
        if (toRenameShareable != null && (share = toRenameShareable.getShare(monitor)) != null) {
            ISharingDescriptor descriptor = share.getSharingDescriptor();
            ZMoveFoldersDilemmaHandler handler = new ZMoveFoldersDilemmaHandler();
            IMoveFoldersOperation moveOp = IOperationFactory.instance.getMoveFoldersOperation((MoveFoldersDilemmaHandler)handler);
            moveOp.addRenameRequest(ZFilesystemRestClient.getWorkspaceConnection(session.getLoggedInRepository(), (IWorkspaceHandle)descriptor.getConnectionHandle(), monitor), descriptor.getComponent(), new IVersionableHandle[]{toRenameShareable.getRemote(monitor)}, new String[]{parms.newName}, "");
            this.switchAuth(session.getMVSID(), parms.passTicket);
            try {
                ZFilesystemRestClient.runChangeChangesetHistoryOp((IFileSystemOperation)moveOp, handler, monitor);
                IShareable newShareable = ZFilesystemRestClient.findShareable(this.createFullPath(parms.dataSet, this.getActualMemberName(parms.newName)), session);
                if (newShareable != null) {
                    FileSystemCore.getSharingManager().getLocalChangeManager().refreshChanges(Collections.singletonList(newShareable), ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, monitor);
                }
            }
            catch (Exception e) {
                this.unSwitchAuth(session.getMVSID(), parms.passTicket);
                throw e;
            }
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        }
    }

    @Override
    public void postMemberChanged(ParmsMemberChanged parms, IProgressMonitor monitor) throws Exception {
        ISPFSession session;
        IShareable shareable;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        if ((shareable = ZFilesystemRestClient.findShareable(parms.member, session = ZFilesystemRestClient.getSession(parms.clientKey))) != null && shareable.getShare(monitor) != null) {
            this.switchAuth(session.getMVSID(), parms.passTicket);
            try {
                FileSystemCore.getSharingManager().getLocalChangeManager().refreshChanges(Collections.singletonList(shareable), ILocalChangeManager.RefreshType.OPTIMIZED_TRAVERSAL, monitor);
            }
            catch (Exception e) {
                this.unSwitchAuth(session.getMVSID(), parms.passTicket);
                throw e;
            }
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        }
    }

    @Override
    public SandboxesReportDTO postSandboxesStatus(ParmsRepairMetadata parms, IProgressMonitor monitor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        SandboxesReportDTO response = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createSandboxesReportDTO();
        response.setCorrupted(false);
        try {
            if (parms.sandboxHfsRoot != null) {
                this.getSandbox(parms.sandboxHfsRoot);
            }
            if (parms.sandboxRoot != null) {
                this.getSandbox(parms.sandboxRoot);
            }
        }
        catch (TeamRepositoryException e) {
            response.setCorrupted(true);
        }
        return response;
    }

    @Override
    public void postRepairMetadata(ParmsRepairMetadata parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        IMetadataRepairOperation repairOp = null;
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            if (parms.sandboxHfsRoot != null) {
                repairOp = IOperationFactory.instance.getMetadataRepairOperation((ILocation)new PathLocation(parms.sandboxHfsRoot), null, ZFilesystemRestClient.getRepositoryResolver(ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository()));
                ZFilesystemRestClient.runOp((IFileSystemOperation)repairOp, monitor);
            }
            if (parms.sandboxRoot != null) {
                repairOp = IOperationFactory.instance.getMetadataRepairOperation((ILocation)new DataSetLocation(parms.sandboxRoot), null, ZFilesystemRestClient.getRepositoryResolver(ZFilesystemRestClient.getSession(parms.clientKey).getLoggedInRepository()));
                ZFilesystemRestClient.runOp((IFileSystemOperation)repairOp, monitor);
            }
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public WorkspaceDetailsDTO[] getLoadedConfigurations(ParmsGetLoadedConfigurations parms, IProgressMonitor monitor) throws TeamRepositoryException {
        int numDatasets;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        UUID repoUUID = repo.getId();
        String shareRoot = null;
        boolean failed = false;
        int n = numDatasets = parms.datasets == null ? 0 : parms.datasets.length;
        if (numDatasets == 0) {
            return new WorkspaceDetailsDTO[0];
        }
        int i = 0;
        while (i < numDatasets && !failed) {
            String thisShareRoot = ZFilesystemRestClient.findShareRoot(parms.datasets[i], session);
            if (thisShareRoot == null) {
                failed = true;
            } else if (shareRoot == null) {
                shareRoot = thisShareRoot;
            } else if (!shareRoot.equals(thisShareRoot)) {
                failed = true;
            }
            ++i;
        }
        if (failed) {
            throw new TeamRepositoryException(Messages.ZFilesystemRestClient_NO_SANDBOX);
        }
        ISandbox theSandbox = this.getSandbox(shareRoot);
        HashMap<String, WorkspaceDetailsDTO> rwsUUIDToDTOMap = new HashMap<String, WorkspaceDetailsDTO>();
        Collection loadedConfigs = theSandbox.allLoadedConfigurations(monitor);
        for (LoadedConfigurationDescriptor config : loadedConfigs) {
            if (!repoUUID.equals((Object)config.id)) continue;
            String rwsUUID = config.connectionHandle.getItemId().getUuidValue();
            WorkspaceDetailsDTO dto = (WorkspaceDetailsDTO)rwsUUIDToDTOMap.get(rwsUUID);
            if (dto == null) {
                dto = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
                dto.setName(config.connectionName);
                dto.setItemId(rwsUUID);
                rwsUUIDToDTOMap.put(rwsUUID, dto);
            }
            NamedItemDTO compDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
            compDTO.setName(config.componentName);
            compDTO.setItemId(config.componentHandle.getItemId().getUuidValue());
            dto.getComponents().add(compDTO);
        }
        Collection dtos = rwsUUIDToDTOMap.values();
        return dtos.toArray(new WorkspaceDetailsDTO[dtos.size()]);
    }

    @Override
    public String[] getUnsharedMembers(ParmsGetUnsharedMembers parms, IProgressMonitor monitor) throws Exception {
        ArrayList<String> unsharedMembers;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            unsharedMembers = new ArrayList<String>();
            List<String> allMembers = this.getMembers(parms.dsName);
            if (allMembers != null) {
                for (String member : allMembers) {
                    IShare share;
                    IShareable shareable = ZFilesystemRestClient.findShareable(this.createFullPath(parms.dsName, member), session);
                    IShare iShare = share = shareable == null ? null : shareable.getShare(monitor);
                    if (share != null) continue;
                    unsharedMembers.add(member);
                }
            }
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        return unsharedMembers.toArray(new String[unsharedMembers.size()]);
    }

    @Override
    public String[] getSharedMembers(ParmsGetUnsharedMembers parms, IProgressMonitor monitor) throws Exception {
        ArrayList<String> sharedMembers;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            sharedMembers = new ArrayList<String>();
            List<String> allMembers = this.getMembers(parms.dsName);
            if (allMembers != null) {
                for (String member : allMembers) {
                    IShare share;
                    IShareable shareable = ZFilesystemRestClient.findShareable(this.createFullPath(parms.dsName, member), session);
                    IShare iShare = share = shareable == null ? null : shareable.getShare(monitor);
                    if (share == null) continue;
                    sharedMembers.add(member);
                }
            }
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        return sharedMembers.toArray(new String[sharedMembers.size()]);
    }

    @Override
    public void postSetComponentCurrentFlow(ParmsCollaboration parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection local = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.rwsUUID, monitor);
        IWorkspaceHandle flowTarget = null;
        if (parms.flowTargetUUID != null && parms.flowTargetUUID.length() > 0) {
            IWorkspaceConnection collaboration = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.flowTargetUUID, monitor);
            flowTarget = ((FlowNodeConnection)collaboration).getWorkspaceHandle();
        }
        boolean modified = false;
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        for (IComponentHandle component : local.getComponents()) {
            if (!component.getItemId().getUuidValue().equals(parms.compUUID)) continue;
            FlowTableUtil.setCurrentCollaboration((IFlowTable)flowTable, (IComponentHandle)component, (IWorkspaceHandle)flowTarget);
            modified = true;
            break;
        }
        if (modified) {
            local.setFlowTable(flowTable, monitor);
        }
    }

    @Override
    public void postSetCurrentStream(ParmsCollaboration parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection local = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.rwsUUID, monitor);
        IWorkspaceConnection collaboration = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.flowTargetUUID, monitor);
        IWorkspaceHandle dFlow = Flow.getDefaultFlowTarget(repo, local);
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
            boolean modified = false;
            if (!FlowTableUtil.hasCollaboration((IWorkspaceConnection)local, (IWorkspaceConnection)collaboration)) {
                FlowTableUtil.addCollaboration((IFlowTable)flowTable, (IWorkspaceConnection)local, (IWorkspaceConnection)collaboration);
                modified = true;
            }
            ConnectionDescriptor currentCollaboration = FlowTableUtil.getCurrentCollaborationDescriptor((IWorkspaceConnection)local);
            if (!collaboration.getContextHandle().sameItemId((IItemHandle)(currentCollaboration == null ? null : currentCollaboration.connectionHandle))) {
                FlowTableUtil.setCurrentCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)collaboration.getResolvedWorkspace());
                for (IComponentHandle component : local.getComponents()) {
                    FlowTableUtil.setCurrentCollaboration((IFlowTable)flowTable, (IComponentHandle)component, null);
                }
                modified = true;
            }
            if (modified) {
                local.setFlowTable(flowTable, monitor);
            }
            FlowTableUtil.addCollaboration((IFlowTable)flowTable, (IWorkspaceConnection)local, (IWorkspaceConnection)collaboration);
            FlowTableUtil.setCurrentCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)((IWorkspaceHandle)collaboration.getContextHandle()));
            FlowTableUtil.setDefaultCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)dFlow);
            local.setFlowTable(flowTable, null);
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public void postSetDefaultStream(ParmsCollaboration parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection local = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.rwsUUID, monitor);
        IWorkspaceConnection collaboration = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.flowTargetUUID, monitor);
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        FlowTableUtil.setDefaultCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)((IWorkspaceHandle)collaboration.getContextHandle()));
        local.setFlowTable(flowTable, null);
    }

    @Override
    public void postLoadzFromUUID(ParmsLoadzUuid parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            IChangeSet cs = (IChangeSet)repo.itemManager().fetchPartialItem(IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null), 0, Arrays.asList(IChangeSet.CHANGES_PROPERTY, IChangeSet.COMPONENT_PROPERTY), monitor);
            IFileItemHandle fileState = null;
            for (IChange change : cs.changes()) {
                if (!change.item().getItemId().getUuidValue().equals(parms.fileItemId) || !(change.item() instanceof IFileItemHandle)) continue;
                int kind = change.kind();
                if (kind == 16) {
                    fileState = (IFileItemHandle)change.beforeState();
                    break;
                }
                fileState = (IFileItemHandle)change.afterState();
                break;
            }
            IShareable shareable = ZFilesystemRestClient.findShareable(parms.destination, session);
            this.loadFile(repo, (IVersionableHandle)fileState, parms.destination, session, shareable);
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public void postRegisterSandbox(ParmsLoadz parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            ISandbox mvsSandbox = parms.mvsPrefix == null ? null : this.getSandbox(parms.mvsPrefix);
            ISandbox hfsSandbox = parms.hfsDestination == null ? null : this.getSandbox(parms.hfsDestination);
            HashSet<ISandbox> toRegister = new HashSet<ISandbox>();
            if (mvsSandbox != null) {
                toRegister.add(mvsSandbox);
            }
            if (hfsSandbox != null) {
                toRegister.add(hfsSandbox);
            }
            session.registerSandboxes(toRegister, monitor);
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public void postCancelBuildRequest(ParmsGetBuildProperties parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildResult buildResult = (IBuildResult)repo.itemManager().fetchPartialItem(IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildResultUUID), null), 0, Arrays.asList(IBuildResult.PROPERTY_BUILD_REQUESTS, IBuildResult.PROPERTY_PERSONAL_BUILD), monitor);
        List buildRequests = repo.itemManager().fetchPartialItems(buildResult.getBuildRequests(), 0, Arrays.asList(IBuildRequest.PROPERTY_BUILD_ACTION, IBuildRequest.PROPERTY_BUILD_DEFINITION_INSTANCE, IBuildRequest.PROPERTY_INITIATING_CONTRIBUTOR), monitor);
        for (IBuildRequest request : buildRequests) {
            if (request == null || !request.getBuildAction().getAction().equals("com.ibm.team.build.action.requestBuild")) continue;
            ITeamBuildRequestClient client = ClientFactory.getTeamBuildRequestClient((ITeamRepository)repo);
            String[] properties = PropertyHelper.union((String[])IBuildRequest.PROPERTIES_REQUIRED, (String[])new String[]{IBuildRequest.PROPERTY_BUILD_RESULT});
            client.cancelPendingRequest((IBuildRequestHandle)request, properties, null);
        }
    }

    @Override
    public void postAbandonBuildRequest(ParmsGetBuildProperties parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildResultHandle buildResult = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildResultUUID), null);
        ITeamBuildRequestClient client = ClientFactory.getTeamBuildRequestClient((ITeamRepository)repo);
        client.makeBuildIncomplete(buildResult, IBuildResult.PROPERTIES_REQUIRED, null);
    }

    @Override
    public void postDeleteBuildRequest(ParmsGetBuildProperties parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildResult buildResult = (IBuildResult)repo.itemManager().fetchPartialItem(IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildResultUUID), null), 0, Arrays.asList(IBuildResult.PROPERTY_DELETE_ALLOWED, IBuildResult.PROPERTY_BUILD_REQUESTS, IBuildResult.PROPERTY_BUILD_STATE), monitor);
        if (buildResult.getState() == BuildState.IN_PROGRESS) {
            return;
        }
        if (!buildResult.isDeleteAllowed()) {
            throw new TeamRepositoryException(Messages.ZFilesystemRestClient_DELETION_NOT_ALLOWED);
        }
        ITeamBuildRequestClient client = ClientFactory.getTeamBuildRequestClient((ITeamRepository)repo);
        client.delete((IBuildResultHandle)buildResult, monitor);
    }

    @Override
    public ContributionLogsDTO[] getBuildResultContributionLogs(ParmsGetBuildProperties parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildResult buildResult = (IBuildResult)repo.itemManager().fetchPartialItem(IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildResultUUID), null), 0, Arrays.asList(IBuildResult.PROPERTY_BUILD_REQUESTS, IBuildResult.PROPERTY_BUILD_STATE), monitor);
        ITeamBuildClient client = ClientFactory.getTeamBuildClient((ITeamRepository)repo);
        IBuildResultContribution[] fetchedContributions = client.getBuildResultContributions((IBuildResultHandle)buildResult, IBuildResultContribution.LOG_EXTENDED_CONTRIBUTION_ID, null);
        ArrayList<ContributionLogsDTO> result = new ArrayList<ContributionLogsDTO>();
        IBuildResultContribution[] iBuildResultContributionArray = fetchedContributions;
        int n = fetchedContributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            ContributionLogsDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createContributionLogsDTO();
            String fileItem = contribution.getExtendedContributionData().getContentId().getUuidValue();
            thisDTO.setFileItemId(fileItem);
            thisDTO.setFilename(contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME));
            thisDTO.setDescription(contribution.getLabel());
            thisDTO.setSize(Long.toString(contribution.getExtendedContributionData().getEstimatedConvertedLength()));
            result.add(thisDTO);
            ++n2;
        }
        return result.toArray(new ContributionLogsDTO[result.size()]);
    }

    @Override
    public void postLogLoad(ParmsLogLoad parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildResult buildResult = (IBuildResult)repo.itemManager().fetchPartialItem(IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildResultUUID), null), 0, Arrays.asList(IBuildResult.PROPERTY_BUILD_REQUESTS, IBuildResult.PROPERTY_BUILD_STATE), monitor);
        ITeamBuildClient client = ClientFactory.getTeamBuildClient((ITeamRepository)repo);
        IBuildResultContribution[] fetchedContributions = client.getBuildResultContributions((IBuildResultHandle)buildResult, IBuildResultContribution.LOG_EXTENDED_CONTRIBUTION_ID, null);
        IBuildResultContribution log = null;
        IBuildResultContribution[] iBuildResultContributionArray = fetchedContributions;
        int n = fetchedContributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            String currentId = contribution.getExtendedContributionData().getContentId().getUuidValue();
            if (currentId.equals(parms.fileItemId)) {
                log = contribution;
                break;
            }
            ++n2;
        }
        if (log == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.ZFilesystemRestClient_LOGFILE_NOTFOUND, (Object)parms.fileItemId));
        }
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            IContent content = log.getExtendedContributionData();
            long sizeMax = content.getEstimatedConvertedLength();
            InputStream inputStream = repo.contentManager().retrieveContentStream(content, monitor);
            String serverEncoding = content.getCharacterEncoding();
            if (serverEncoding == null) {
                serverEncoding = "UTF-8";
            }
            String codepage = System.getenv("ZLANG");
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Loading " + parms.destination + " with serverEncoding=" + serverEncoding + " codepage=" + codepage));
            }
            if (codepage == null) {
                codepage = serverEncoding;
            }
            TextFileLoader fileLoader = new TextFileLoader(parms.destination);
            fileLoader.updateContents(inputStream, codepage, serverEncoding, parms.direction, parms.percent, sizeMax);
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public void postLoadzFromChangeset(ParmsLoadzFromChangeset parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IChangeSet cs = (IChangeSet)repo.itemManager().fetchPartialItem(IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null), 0, Arrays.asList(IChangeSet.CHANGES_PROPERTY, IChangeSet.COMPONENT_PROPERTY), monitor);
        IWorkspaceConnection conn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.workspaceID, monitor);
        conn.refresh(monitor);
        IShareable shareable = ZFilesystemRestClient.findShareable(parms.fullMemberName, session);
        String sUUIDshareableItemId = shareable.getVersionable(monitor).getItemId().getUuidValue();
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            for (IChange thisChange : cs.changes()) {
                int kind = thisChange.kind();
                String sfileItemId = thisChange.item().getItemId().getUuidValue();
                if (!sUUIDshareableItemId.equals(sfileItemId)) continue;
                IFileItemHandle fileState = kind == 16 ? (IFileItemHandle)thisChange.beforeState() : (IFileItemHandle)thisChange.afterState();
                this.loadFile(repo, (IVersionableHandle)fileState, parms.destination, session, shareable);
                break;
            }
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public ChangesetHistoryDTO[] getChangeSetCheckinHistory(ParmsGetChangeSetCheckinHistory parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ArrayList<ChangesetHistoryDTO> result = new ArrayList<ChangesetHistoryDTO>();
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IChangeSet cs = (IChangeSet)repo.itemManager().fetchPartialItem(IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null), 0, Arrays.asList(IChangeSet.CHANGES_PROPERTY, IChangeSet.COMPONENT_PROPERTY), monitor);
        IShareable shareable = ZFilesystemRestClient.findShareable(parms.fullMemberName, session);
        IVersionableHandle ivh = shareable.getVersionable(monitor);
        ProviderFactory providerFactory = (ProviderFactory)repo.getClientLibrary(ProviderFactory.class);
        List changeNodes = ChangeSetStatesUtil.getChangeNodes((IChangeSetHandle)cs, (IVersionableHandle)ivh, (ItemProvider)providerFactory.getItemProvider(), (IProgressMonitor)monitor);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        for (IChangeNode node : changeNodes) {
            ChangesetHistoryDTO chd = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createChangesetHistoryDTO();
            chd.setItemId(node.getState().getStateId().getUuidValue());
            chd.setDate(node.getDate().toString());
            chd.setType(node.getType().toString());
            IVersionableIdentifier versionableIdentifier = wm.getVersionableIdentifiers(new IVersionableHandle[]{node.getState()}, null)[0];
            if (versionableIdentifier != null) {
                chd.setVersionId(versionableIdentifier.getShortVersionId());
            }
            result.add(0, chd);
        }
        return result.toArray(new ChangesetHistoryDTO[result.size()]);
    }

    @Override
    public void postLoadzFromCheckinHistory(ParmsLoadzFromCheckinHistory parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IChangeSet cs = (IChangeSet)repo.itemManager().fetchPartialItem(IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null), 0, Arrays.asList(IChangeSet.CHANGES_PROPERTY, IChangeSet.COMPONENT_PROPERTY), monitor);
        IShareable shareable = ZFilesystemRestClient.findShareable(parms.fullMemberName, session);
        IVersionableHandle ivh = shareable.getVersionable(monitor);
        IFileItemHandle fileState = null;
        ProviderFactory providerFactory = (ProviderFactory)repo.getClientLibrary(ProviderFactory.class);
        List changeNodes = ChangeSetStatesUtil.getChangeNodes((IChangeSetHandle)cs, (IVersionableHandle)ivh, (ItemProvider)providerFactory.getItemProvider(), (IProgressMonitor)monitor);
        this.switchAuth(session.getMVSID(), parms.passTicket);
        try {
            for (IChangeNode node : changeNodes) {
                if (!node.getState().getStateId().getUuidValue().equals(parms.stateId)) continue;
                fileState = (IFileItemHandle)node.getState();
                this.loadFile(repo, (IVersionableHandle)fileState, parms.destination, session, shareable);
                break;
            }
        }
        catch (Exception e) {
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
            throw e;
        }
        this.unSwitchAuth(session.getMVSID(), parms.passTicket);
    }

    @Override
    public void postLoadzFromCheckinHistorySandbox(ParmsLoadzFromCheckinHistory parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        ISPFLoadOperation ISPFloadOp = null;
        ILoadOperation loadOp = null;
        if (ispfLoad) {
            ISPFloadOp = new ISPFLoadOperation(ZLoadDilemmaHandler.getInstance());
        } else {
            loadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)ZLoadDilemmaHandler.getInstance());
        }
        ISandbox sandbox = parms.sandbox == null ? null : this.getSandbox(parms.sandbox);
        IWorkspaceConnection wsToLoad = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.workspaceUUID, monitor);
        IChangeSet cs = (IChangeSet)repo.itemManager().fetchPartialItem(IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.changesetID), null), 0, Arrays.asList(IChangeSet.CHANGES_PROPERTY, IChangeSet.COMPONENT_PROPERTY), monitor);
        IShareable shareable = ZFilesystemRestClient.findShareable(parms.fullMemberName, session);
        IVersionableHandle ivh = shareable.getVersionable(monitor);
        IVersionableHandle fileState = null;
        ProviderFactory providerFactory = (ProviderFactory)repo.getClientLibrary(ProviderFactory.class);
        List changeNodes = ChangeSetStatesUtil.getChangeNodes((IChangeSetHandle)cs, (IVersionableHandle)ivh, (ItemProvider)providerFactory.getItemProvider(), (IProgressMonitor)monitor);
        IComponent component = (IComponent)repo.itemManager().fetchPartialItem((IItemHandle)cs.getComponent(), 0, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
        ArrayList<IVersionableHandle> versionablesToLoad = new ArrayList<IVersionableHandle>();
        for (IChangeNode node : changeNodes) {
            if (!node.getState().getStateId().getUuidValue().equals(parms.stateId)) continue;
            fileState = node.getState();
            versionablesToLoad.add(fileState);
            break;
        }
        if (!versionablesToLoad.isEmpty()) {
            if (sandbox != null) {
                if (ispfLoad) {
                    ISPFloadOp.requestLoad(sandbox, null, wsToLoad, (IComponentHandle)component, versionablesToLoad);
                } else {
                    loadOp.requestLoad(sandbox, null, wsToLoad, (IComponentHandle)component, versionablesToLoad);
                }
            }
            this.switchAuth(session.getMVSID(), parms.passTicket);
            try {
                ZFilesystemRestClient.runOp(ispfLoad ? ISPFloadOp : loadOp, monitor);
            }
            catch (Exception e) {
                this.unSwitchAuth(session.getMVSID(), parms.passTicket);
                throw e;
            }
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        }
    }

    private void loadFile(ITeamRepository repo, IVersionableHandle fileState, String destination, ISPFSession session, IShareable shareable) throws TeamRepositoryException, IOException {
        if (fileState != null) {
            IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager();
            IFileItem fileItem = (IFileItem)versionableManager.fetchCompleteState(fileState, null);
            InputStream inputStream = FileSystemCore.getContentManager((ITeamRepository)repo).retrieveContentStream((IFileItemHandle)fileState, fileItem.getContent(), null);
            String codepage = (String)fileItem.getUserProperties().get("mvsCodePage");
            String serverEncoding = fileItem.getContent().getCharacterEncoding();
            if ((codepage == null || codepage.trim().length() < 1) && (codepage = System.getenv("ZLANG")) == null) {
                codepage = !ZFilesystemRestClient.isHierarchical(destination) ? System.getProperty("file.encoding") : serverEncoding;
            }
            TextFileLoader fileLoader = new TextFileLoader(destination);
            fileLoader.updateContents(inputStream, codepage, serverEncoding, null, null, 0L);
            ILocation location = ZFilesystemRestClient.findLocation(destination, session);
            IFileStorage storage = ((IShareableInternal)shareable).getFileStorage();
            if (location instanceof DataSetLocation) {
                ZFileInterface zfi = ZFileInterface.createZFileInterface((DataSetLocation)((DataSetLocation)location), (IFileStorage)storage, null);
                try {
                    zfi.setModificationStamp(fileItem.getFileTimestamp().getTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getSpecialCharacters(ParmsBlank parms, IProgressMonitor monitor) {
        return SPECIAL_CHARACTERS;
    }

    @Override
    public String getApplId(ParmsBlank parms, IProgressMonitor monitor) {
        return APPL_ID;
    }

    @Override
    public String getScmWork(ParmsBlank parms, IProgressMonitor monitor) {
        return System.getenv("SCM_WORK");
    }

    @Override
    public String getEnvVariable(ParmsEnvVariable parms, IProgressMonitor monitor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        if (parms != null) {
            return System.getenv(parms.name);
        }
        return "";
    }

    @Override
    public WarningDTO postAcceptAll(ParmsGetPendingChanges parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceUpdateOperation op = IOperationFactory.instance.getWorkspaceUpdateOperation((WorkspaceUpdateDilemmaHandler)ZWorkspaceUpdateDilemmaHandler.getDefault());
        ZWorkspaceUpdateDilemmaHandler.getDefault().setPermitsUncheckedIn(parms.getPermitsUnchecked());
        IWorkspaceHandle sourceWorkspace = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.wsUUID), null);
        IWorkspaceConnection targetWSConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(sourceWorkspace, monitor);
        WarningDTO warning = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createWarningDTO();
        IChangeHistorySyncReport syncReport = ZFilesystemRestClient.getReport(repo, sourceWorkspace, monitor);
        if (syncReport != null) {
            List csHandles = syncReport.incomingChangeSets();
            List baselines = syncReport.incomingBaselines();
            op.accept(targetWSConn, SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(Flow.getFlowTarget(repo, targetWSConn), monitor), syncReport, baselines, csHandles, new ArrayList());
            this.switchAuth(session.getMVSID(), parms.passTicket);
            try {
                ZFilesystemRestClient.runChangeChangesetHistoryOp((IFileSystemOperation)op, ZWorkspaceUpdateDilemmaHandler.getDefault(), monitor);
            }
            catch (AcceptException e) {
                this.unSwitchAuth(session.getMVSID(), parms.passTicket);
                warning.setStatus(-1);
                warning.setMessage(e.getMessage());
                return warning;
            }
            catch (Exception e) {
                this.unSwitchAuth(session.getMVSID(), parms.passTicket);
                throw e;
            }
            this.unSwitchAuth(session.getMVSID(), parms.passTicket);
        }
        warning.setStatus(targetWSConn.conflictReport().conflicts().size());
        return warning;
    }

    @Override
    public ComponentScopeDTO[] getComponentFlowTarget(ParmsGetComponentScope parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ArrayList<ComponentScopeDTO> result = new ArrayList<ComponentScopeDTO>();
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUID, monitor);
        IFlowTable flowTable = wsConn.getFlowTable();
        IWorkspaceConnection collaboration = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.flowTargetUUID, monitor);
        IWorkspace node = collaboration.getResolvedWorkspace();
        Collection componentScopes = flowTable.getComponentScopes((IFlowNodeHandle)node);
        HashSet<UUID> selectedItemIds = new HashSet<UUID>();
        for (IComponentHandle handle : componentScopes) {
            selectedItemIds.add(handle.getItemId());
        }
        collaboration.getComponents();
        for (IComponentHandle componentHandle : collaboration.getComponents()) {
            IComponent comp = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 1, monitor);
            ComponentScopeDTO thisDTO = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentScopeDTO();
            thisDTO.setItemId(comp.getItemId().getUuidValue());
            thisDTO.setName(comp.getName());
            thisDTO.setIsFlowed(false);
            if (selectedItemIds.isEmpty() || selectedItemIds.contains(comp.getItemId())) {
                thisDTO.setIsFlowed(true);
            }
            result.add(thisDTO);
        }
        return result.toArray(new ComponentScopeDTO[result.size()]);
    }

    @Override
    public void postSetComponentScope(ParmsSetComponentScope parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IWorkspaceConnection wsConn = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.wsUUID, monitor);
        IWorkspaceConnection collaboration = ZFilesystemRestClient.getWorkspaceConnection(repo, parms.flowTargetUUID, monitor);
        IFlowTable flowTable = wsConn.getFlowTable().getWorkingCopy();
        ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
        String[] stringArray = parms.getComponents();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String compUUID = stringArray[n2];
            IComponentHandle compHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)compUUID), null);
            componentHandles.add(compHandle);
            ++n2;
        }
        flowTable.setComponentScopes((IFlowNodeHandle)collaboration.getResolvedWorkspace(), componentHandles);
        wsConn.setFlowTable(flowTable, null);
    }

    @Override
    public NamedItemDTO[] getAllBuildableSubsets(ParmsBlank parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        List<IBuildDefinitionHandle> buildDefinitionHandles = ZFilesystemRestClient.getAllBuildDefinitionsHandles(session, monitor);
        ArrayList<NamedItemDTO> results = new ArrayList<NamedItemDTO>();
        String ownerId = repo.loggedInContributor().getUserId();
        for (IBuildDefinitionHandle buildDefinitionHandle : buildDefinitionHandles) {
            List subsets = client.getAllBuildableSubsets(buildDefinitionHandle, ownerId);
            int numSubsets = subsets == null ? 0 : subsets.size();
            int i = 0;
            while (i < numSubsets) {
                NamedItemDTO result = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createNamedItemDTO();
                result.setItemId(((ISubset)subsets.get(i)).getBuildDefinition().getItemId().getUuidValue());
                result.setName(((ISubset)subsets.get(i)).getLabel());
                results.add(result);
                ++i;
            }
        }
        return results.toArray(new NamedItemDTO[results.size()]);
    }

    @Override
    public void postCreateBuildableSubset(ParmsBuildableSubset parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset workingSubset = (ISubset)client.createNewSubset().getWorkingCopy();
        workingSubset.setLabel(parms.subsetName);
        workingSubset.setBuildDefinition((IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildDefnUUID), null));
        workingSubset.setOwner((IContributorHandle)repo.loggedInContributor());
        workingSubset.setDescription(parms.description == null ? "" : parms.description);
        Visibility visibility = parms.privateVisibility != null && parms.privateVisibility != false ? Visibility.PRIVATE_LITERAL : Visibility.PUBLIC_LITERAL;
        workingSubset.setVisibility(visibility);
        int nbFiles = parms.fileDesc.length;
        if (nbFiles > 0) {
            ArrayList<ISubsetFileDesc> buildableFiles = workingSubset.getFileDescs();
            int i = 0;
            while (i < nbFiles) {
                Boolean notFound = true;
                if (buildableFiles != null) {
                    for (ISubsetFileDesc buildable : buildableFiles) {
                        if (!buildable.getFileItem().getItemId().getUuidValue().equals(parms.fileDesc[i].fileItemId) || !buildable.getComponent().getItemId().getUuidValue().equals(parms.fileDesc[i].componentId)) continue;
                        notFound = false;
                    }
                } else {
                    buildableFiles = new ArrayList<ISubsetFileDesc>();
                    workingSubset.getFileDescs().addAll(buildableFiles);
                }
                if (notFound.booleanValue()) {
                    ISubsetFileDesc fileDesc = BuildableSubsetUtil.createFileDesc((String)parms.fileDesc[i].componentId, (String)parms.fileDesc[i].fileItemId);
                    buildableFiles.add(fileDesc);
                }
                ++i;
            }
        }
        client.saveSubset(workingSubset, null);
    }

    @Override
    public void postUpdateOwnerBuildableSubset(ParmsOwnerBuildableSubset parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        if (parms.subsetName == null || parms.subsetName.length() == 0) {
            throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset previousSubset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        ISubset subset = (ISubset)previousSubset.getWorkingCopy();
        if (subset != null) {
            if (parms.ownerID != null && parms.ownerID.length() > 0) {
                subset.setOwner(BuildableSubsetUtil.createContributorHandle((String)parms.ownerID));
            } else {
                subset.setOwner(null);
            }
            client.saveSubset(subset, previousSubset);
        }
    }

    @Override
    public void postUpdateBuildableSubset(ParmsBuildableSubset parms, IProgressMonitor monitor) throws Exception {
        String oldbuildDefnUUID;
        String oldsubsetName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        if (parms.subsetName == null || parms.subsetName.length() == 0) {
            throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset subset = client.getSubsetItem(BuildableSubsetUtil.convertToNewSlug((String)(oldsubsetName = parms.oldsubsetName != null && parms.oldsubsetName.length() > 0 ? parms.oldsubsetName : parms.subsetName), (String)(oldbuildDefnUUID = parms.oldbuildDefnUUID != null && parms.oldbuildDefnUUID.length() > 0 ? parms.oldbuildDefnUUID : parms.buildDefnUUID)));
        ISubset workingSubset = (ISubset)subset.getWorkingCopy();
        if (workingSubset != null) {
            workingSubset.setLabel(parms.subsetName);
            if (parms.buildDefnUUID != null && parms.buildDefnUUID.length() > 0) {
                IBuildDefinitionHandle buildDefHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildDefnUUID), null);
                workingSubset.setBuildDefinition(buildDefHandle);
            }
            if (parms.description != null) {
                workingSubset.setDescription(parms.description);
            }
            if (parms.privateVisibility != null) {
                Visibility visibility = parms.privateVisibility != false ? Visibility.PRIVATE_LITERAL : Visibility.PUBLIC_LITERAL;
                workingSubset.setVisibility(visibility);
            }
            client.saveSubset(workingSubset, subset);
        }
    }

    @Override
    public void postAddSubsetContent(ParmsAddContentBuildableSubset parms, IProgressMonitor monitor) throws Exception {
        int nbFiles;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        if ((nbFiles = parms.fileDesc.length) > 0) {
            if (parms.subsetName == null || parms.subsetName.length() == 0) {
                throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
            }
            ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
            ITeamRepository repo = session.getLoggedInRepository();
            IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
            ISubset previousSubset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
            ISubset subset = (ISubset)previousSubset.getWorkingCopy();
            if (subset != null) {
                List buildableFiles = subset.getFileDescs();
                List toAdd = Stream.of(parms.fileDesc).map(file -> BuildableSubsetUtil.createFileDesc((String)file.componentId, (String)file.fileItemId)).filter(file -> !BuildableSubsetUtil.containsFileWithRef((ISubsetFileDesc)file, (Collection)buildableFiles)).collect(Collectors.toList());
                subset.getFileDescs().addAll(toAdd);
                client.saveSubset(subset, previousSubset);
            }
        }
    }

    @Override
    public void postRemoveSubsetContent(ParmsUpdateContentBuildableSubset parms, IProgressMonitor monitor) throws Exception {
        int nbFiles;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        if ((nbFiles = parms.fileUUIDs.length) > 0) {
            if (parms.subsetName == null || parms.subsetName.length() == 0) {
                throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
            }
            ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
            ITeamRepository repo = session.getLoggedInRepository();
            IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
            ISubset previousSubset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
            ISubset subset = (ISubset)previousSubset.getWorkingCopy();
            if (subset != null) {
                List buildableFiles = subset.getFileDescs();
                Iterator iter = buildableFiles.iterator();
                block0: while (iter.hasNext()) {
                    ISubsetFileDesc buildableFile = (ISubsetFileDesc)iter.next();
                    int i = 0;
                    while (i < nbFiles) {
                        if (parms.fileUUIDs[i].equalsIgnoreCase(buildableFile.getFileItem().getItemId().getUuidValue())) {
                            iter.remove();
                            continue block0;
                        }
                        ++i;
                    }
                }
            }
            client.saveSubset(subset, previousSubset);
        }
    }

    @Override
    public void postUpdateSubsetContent(ParmsUpdateContentBuildableSubset parms, IProgressMonitor monitor) throws Exception {
        int nbFiles;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        if ((nbFiles = parms.fileUUIDs.length) > 0) {
            if (parms.subsetName == null || parms.subsetName.length() == 0) {
                throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
            }
            ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
            ITeamRepository repo = session.getLoggedInRepository();
            IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
            ISubset previousSubset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
            ISubset subset = (ISubset)previousSubset.getWorkingCopy();
            if (subset != null) {
                List buildablFiles = subset.getFileDescs();
                block0: for (ISubsetFileDesc buildableFile : buildablFiles) {
                    int i = 0;
                    while (i < nbFiles) {
                        if (parms.fileUUIDs[i].equalsIgnoreCase(buildableFile.getFileItem().getItemId().getUuidValue())) {
                            buildableFile.setAlwaysBuild(parms.alwaysBuild.booleanValue());
                            continue block0;
                        }
                        ++i;
                    }
                }
            }
            client.saveSubset(subset, previousSubset);
        }
    }

    @Override
    public void postRemoveAllSubsetContent(ParmsUpdateContentBuildableSubset parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        if (parms.subsetName == null || parms.subsetName.length() == 0) {
            throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset previousSubset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        ISubset subset = (ISubset)previousSubset.getWorkingCopy();
        if (subset != null) {
            subset.getFileDescs().clear();
        }
        client.saveSubset(subset, previousSubset);
    }

    protected IContributorHandle getContributor(ITeamRepository repo, String userId) throws TeamRepositoryException {
        IContributorManager contributorManager = repo.contributorManager();
        IContributor contributorHandle = null;
        contributorHandle = contributorManager.fetchContributorByUserId(userId, null);
        return contributorHandle;
    }

    @Override
    public void postCreateBuildableSubsetFromWorkItem(ParmsCreateBuildableSubsetWorkItem parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        boolean includeWorkItemChildren = false;
        boolean includeImpacts = false;
        IWorkItemHandle[] workItemHandles = new IWorkItemHandle[1];
        includeWorkItemChildren = parms.includeWorkItemChildren != null && parms.includeWorkItemChildren != false;
        includeImpacts = parms.includeImpacts != null && parms.includeImpacts != false;
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        if (parms.workitem != null || parms.dynamicWorkitem != null) {
            String workItem = parms.workitem != null ? parms.workitem : parms.dynamicWorkitem;
            workItemHandles[0] = ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).findWorkItemById(Integer.parseInt(workItem), IWorkItem.SMALL_PROFILE, monitor);
            if (workItemHandles[0] == null) {
                throw new ItemNotFoundException(NLS.bind((String)Messages.ZFilesystemRestClient_WORK_ITEM_NOT_FOUND, (Object)workItem));
            }
            IBuildDefinitionHandle buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildDefnUUID), null);
            Visibility visibility = parms.privateVisibility != null && parms.privateVisibility != false ? Visibility.PRIVATE_LITERAL : Visibility.PUBLIC_LITERAL;
            Object contributor = null;
            contributor = parms.ownerID != null && parms.ownerID.length() > 0 ? this.getContributor(repo, parms.ownerID) : repo.loggedInContributor();
            ISubset subset = (ISubset)client.createNewSubset().getWorkingCopy();
            WorkItemBuildSubsetRule rule = new WorkItemBuildSubsetRule();
            rule.setDynamic(parms.dynamicWorkitem != null);
            IWorkItemHandle[] iWorkItemHandleArray = workItemHandles;
            int n = workItemHandles.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkItemHandle wiHandle = iWorkItemHandleArray[n2];
                rule.addWorkItem(wiHandle);
                ++n2;
            }
            rule.setIncludeChildren(includeWorkItemChildren);
            subset.setBuildDefinition(buildDefinitionHandle);
            subset = client.processRule((IBuildSubsetRule)rule, buildDefinitionHandle, subset, includeImpacts);
            subset = subset.isWorkingCopy() ? subset : (ISubset)subset.getWorkingCopy();
            subset.setVisibility(visibility);
            subset.setOwner((IContributorHandle)contributor);
            subset.setLabel(parms.subsetName != null ? parms.subsetName : "");
            if (parms.description != null && parms.description.length() > 0) {
                subset.setDescription(parms.description);
            } else {
                subset.setDescription("");
            }
            client.saveSubset(subset, null);
        }
    }

    @Override
    public SubsetDTO getSubsetDetail(ParmsBuildableSubset parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset subset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        SubsetDTO dto = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createSubsetDTO();
        if (subset != null) {
            dto.setVisibility(subset.getVisibility().getLiteral());
            dto.setDescription(subset.getDescription());
            dto.setOwnerId(ZFilesystemRestClient.getInitials(repo, subset.getOwner(), monitor));
            dto.setBuildDefnUUID(parms.buildDefnUUID);
            dto.setLabel(subset.getLabel());
            IBuildDefinition buildDefn = (IBuildDefinition)repo.itemManager().fetchPartialItem(IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildDefnUUID), null), 0, Arrays.asList(IBuildDefinition.PROPERTY_ID), monitor);
            if (buildDefn != null) {
                dto.setBuildId(buildDefn.getId());
            }
        }
        return dto;
    }

    @Override
    public SubsetContentDTO[] getSubsetContent(ParmsBuildableSubset parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset subset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        String rwsUUID = this.getWorkspaceIdFromBuild(repo, parms.buildDefnUUID, monitor);
        ArrayList<SubsetContentDTO> results = new ArrayList<SubsetContentDTO>();
        if (subset != null) {
            List buildablFiles = subset.getFileDescs();
            ZosScmUtils.populateSubsetContent(repo, rwsUUID, results, buildablFiles, monitor);
        }
        return results.toArray(new SubsetContentDTO[results.size()]);
    }

    @Override
    public void postDeleteBuildableSubset(ParmsBuildableSubset parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        if (parms.subsetName == null || parms.subsetName.length() == 0) {
            throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset subset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        client.deleteBuildableSubset(subset);
    }

    @Override
    public SubsetContentDTO[] getSubsetContentFromWorkItem(ParmsCreateBuildableSubsetWorkItem parms, IProgressMonitor monitor) throws Exception {
        ArrayList<SubsetContentDTO> results = new ArrayList<SubsetContentDTO>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        if (parms.subsetName == null || parms.subsetName.length() == 0) {
            throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
        }
        ArrayList<IWorkItem> workItemHandles = new ArrayList<IWorkItem>();
        if (parms.workitem != null) {
            IWorkItem workItemHandle = ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).findWorkItemById(Integer.parseInt(parms.workitem), IWorkItem.SMALL_PROFILE, monitor);
            if (workItemHandle == null) {
                throw new ItemNotFoundException(NLS.bind((String)Messages.ZFilesystemRestClient_WORK_ITEM_NOT_FOUND, (Object)parms.workitem));
            }
            workItemHandles.add(workItemHandle);
            IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
            IBuildDefinitionHandle buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildDefnUUID), null);
            boolean includeWorkItemChildren = parms.includeWorkItemChildren != null && parms.includeWorkItemChildren != false;
            boolean includeImpacts = parms.includeImpacts != null && parms.includeImpacts != false;
            ISubset subset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
            ISubset workingSubset = (ISubset)(subset != null ? subset.getWorkingCopy() : client.createNewSubset().getWorkingCopy());
            workingSubset.setBuildDefinition(buildDefinitionHandle);
            workingSubset.setLabel(parms.subsetName != null ? parms.subsetName : "");
            WorkItemBuildSubsetRule subsetRule = new WorkItemBuildSubsetRule();
            subsetRule.setDynamic(false);
            subsetRule.setIncludeChildren(includeWorkItemChildren);
            subsetRule.addWorkItem((IWorkItemHandle)workItemHandle);
            ISubset fResultSubset = client.processRule((IBuildSubsetRule)subsetRule, buildDefinitionHandle, workingSubset, includeImpacts);
            List wiBuildableFiles = fResultSubset.getFileDescs();
            ZosScmUtils.populateSubsetContent(repo, results, wiBuildableFiles, null, monitor);
        }
        return results.toArray(new SubsetContentDTO[results.size()]);
    }

    @Override
    public void postAddSubsetContentFromWorkItem(ParmsCreateBuildableSubsetWorkItem parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        boolean includeWorkItemChildren = false;
        boolean includeImpacts = false;
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        if (parms.subsetName == null || parms.subsetName.length() == 0) {
            throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
        }
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        IBuildDefinitionHandle buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildDefnUUID), null);
        ISubset previousSubset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        ISubset subset = (ISubset)previousSubset.getWorkingCopy();
        if (subset != null && parms.workitem != null) {
            includeWorkItemChildren = parms.includeWorkItemChildren != null && parms.includeWorkItemChildren != false;
            includeImpacts = parms.includeImpacts != null && parms.includeImpacts != false;
            WorkItemBuildSubsetRule subsetRule = new WorkItemBuildSubsetRule();
            subsetRule.setDynamic(false);
            subsetRule.setIncludeChildren(includeWorkItemChildren);
            IWorkItem workItemHandle = ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).findWorkItemById(Integer.parseInt(parms.workitem), IWorkItem.SMALL_PROFILE, monitor);
            if (workItemHandle != null) {
                subsetRule.addWorkItem((IWorkItemHandle)workItemHandle);
            }
            subset = client.processRule((IBuildSubsetRule)subsetRule, buildDefinitionHandle, subset, includeImpacts);
            client.saveSubset(subset, previousSubset);
        }
    }

    @Override
    public String[] getPropertiesVisibilities(ParmsGetPropertiesVisibilities parms, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<String> visibilities;
        block6: {
            ITeamRepository repo;
            block5: {
                String PROPERTY_UI_REQUEST_OPTION_VISIBILITY = "team.enterprise.build.ui.requestOptionVisibility";
                String ELEMENT_ID = "com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)parms);
                }
                ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
                repo = session.getLoggedInRepository();
                visibilities = new ArrayList<String>();
                if (parms.buildDefnUUID == null) break block5;
                IBuildDefinition buildDefn = (IBuildDefinition)repo.itemManager().fetchPartialItem(IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildDefnUUID), null), 1, Arrays.asList(IBuildDefinition.PROPERTY_PROPERTIES, IBuildDefinition.PROPERTY_CONFIGURATION_ELEMENTS, IBuildDefinition.PROPERTY_PROCESS_AREA), monitor);
                List<EnterpriseRequestDialogOption> options = EnterpriseRequestDialogOption.parseOptions(buildDefn.getConfigurationPropertyValue("com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement", "team.enterprise.build.ui.requestOptionVisibility", null), true);
                for (EnterpriseRequestDialogOption option : options) {
                    if (parms.personnalVisibility != null && parms.personnalVisibility.booleanValue()) {
                        if (!option.getPersonalVisibility()) continue;
                        visibilities.add(option.getBuildPropertyName());
                        continue;
                    }
                    if (!option.getTeamVisibility()) continue;
                    visibilities.add(option.getBuildPropertyName());
                }
                break block6;
            }
            if (parms.buildResultUUID == null) break block6;
            IBuildResult buildResult = (IBuildResult)repo.itemManager().fetchPartialItem(IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.buildResultUUID), null), 1, Arrays.asList(IBuildResult.PROPERTY_BUILD_REQUESTS, IBuildResult.PROPERTY_PERSONAL_BUILD), monitor);
            IBuildRequest request = ZFilesystemRestClient.getBuildRequest(buildResult, repo, monitor);
            IBuildDefinitionInstance buildDefnInstance = request.getBuildDefinitionInstance();
            List<EnterpriseRequestDialogOption> options = EnterpriseRequestDialogOption.parseOptions(buildDefnInstance.getConfigurationElement("com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement").getConfigurationProperty("team.enterprise.build.ui.requestOptionVisibility").getValue(), true);
            for (EnterpriseRequestDialogOption option : options) {
                if (parms.personnalVisibility != null && parms.personnalVisibility.booleanValue()) {
                    if (!option.getPersonalVisibility()) continue;
                    visibilities.add(option.getBuildPropertyName());
                    continue;
                }
                if (!option.getTeamVisibility()) continue;
                visibilities.add(option.getBuildPropertyName());
            }
        }
        return visibilities.toArray(new String[visibilities.size()]);
    }

    @Override
    public UserDTO[] getUsersProjectArea(ParmsBlank parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IProjectAreaHandle projectArea = session.getProjectArea();
        IProcessArea processArea = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)projectArea, 1, monitor);
        IContributorHandle[] membersHandle = processArea.getMembers();
        ArrayList<UserDTO> results = new ArrayList<UserDTO>();
        IContributorHandle[] iContributorHandleArray = membersHandle;
        int n = membersHandle.length;
        int n2 = 0;
        while (n2 < n) {
            IContributorHandle memberHandle = iContributorHandleArray[n2];
            IContributor member = (IContributor)repo.itemManager().fetchPartialItem((IItemHandle)memberHandle, 1, Arrays.asList(IContributor.NAME_PROPERTY, IContributor.USERID_PROPERTY), monitor);
            UserDTO result = ZFilesystemRestClientDTOcoreFactory.eINSTANCE.createUserDTO();
            result.setItemId(member.getItemId().getUuidValue());
            result.setName(member.getName());
            result.setUserId(member.getUserId());
            results.add(result);
            ++n2;
        }
        return results.toArray(new UserDTO[results.size()]);
    }

    @Override
    public SubsetCriteriaDTO[] getSubsetCriteria(ParmsBuildableSubset parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset subset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        ArrayList<SubsetCriteriaDTO> results = new ArrayList<SubsetCriteriaDTO>();
        if (subset != null) {
            List criterias = subset.getCriteria().getReferences();
            ZosScmUtils.populateSubsetCriteria(repo, results, criterias, monitor);
        }
        return results.toArray(new SubsetCriteriaDTO[results.size()]);
    }

    private ISubset getSubset(ITeamRepository repo, String subsetName, String buildefId) {
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        try {
            return client.getSubsetItem(BuildableSubsetUtil.getSlug((String)subsetName, (String)buildefId));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void postAddSubsetCriteria(ParmsCreateBuildableSubsetWorkItem parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        boolean includeWorkItemChildren = false;
        boolean includeImpacts = false;
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        if (parms.subsetName == null || parms.subsetName.length() == 0) {
            throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
        }
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset previousSubset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        ISubset subset = (ISubset)previousSubset.getWorkingCopy();
        if (subset != null && parms.workitem != null) {
            includeWorkItemChildren = parms.includeWorkItemChildren != null && parms.includeWorkItemChildren != false;
            includeImpacts = parms.includeImpacts != null && parms.includeImpacts != false;
            WorkItemBuildSubsetRule subsetRule = new WorkItemBuildSubsetRule();
            subsetRule.setDynamic(true);
            subsetRule.setIncludeChildren(includeWorkItemChildren);
            IWorkItem workItemHandle = ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).findWorkItemById(Integer.parseInt(parms.workitem), IWorkItem.SMALL_PROFILE, monitor);
            if (workItemHandle != null) {
                subsetRule.addWorkItem((IWorkItemHandle)workItemHandle);
            }
            subset = client.processRule((IBuildSubsetRule)subsetRule, subset.getBuildDefinition(), subset, includeImpacts);
            client.saveSubset(subset, previousSubset);
        }
    }

    @Override
    public void postRemoveSubsetCriteria(ParmsRemoveBuildableSubsetWorkitem parms, IProgressMonitor monitor) throws Exception {
        int numWorkItems;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        int n = numWorkItems = parms.workitems == null ? 0 : parms.workitems.length;
        if (parms.subsetName == null || parms.subsetName.length() == 0 || numWorkItems == 0) {
            throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
        }
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset previousSubset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        ISubset subset = (ISubset)previousSubset.getWorkingCopy();
        boolean found = false;
        if (subset != null) {
            List workItemHandles = ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).findWorkItemsById(Arrays.asList(parms.workitems).stream().map(s -> Integer.parseInt(s)).collect(Collectors.toList()), monitor);
            List criterias = subset.getCriteria().getReferences();
            ArrayList<ISubsetCriteria> toRemove = new ArrayList<ISubsetCriteria>();
            int j = 0;
            while (j < criterias.size()) {
                ISubsetCriteria criteria = (ISubsetCriteria)criterias.get(j);
                if (criteria instanceof ICriteriaWorkItem) {
                    ICriteriaWorkItem wiCriteria = (ICriteriaWorkItem)criteria;
                    if (wiCriteria.isDynamic()) {
                        List wis = wiCriteria.getWorkItems();
                        int i = 0;
                        while (i < wis.size()) {
                            IWorkItemHandle wi = (IWorkItemHandle)wiCriteria.getWorkItems().get(i);
                            int k = 0;
                            while (k < numWorkItems) {
                                if (wi.getItemId().equals((Object)((IWorkItemHandle)workItemHandles.get(k)).getItemId())) {
                                    toRemove.add(criteria);
                                    found = true;
                                    break;
                                }
                                if (found) break;
                                ++k;
                            }
                            ++i;
                        }
                    }
                    if (found) break;
                }
                ++j;
            }
            if (found) {
                subset.getCriteria().getReferences().removeAll(toRemove);
                client.saveSubset(subset, previousSubset);
            }
        }
    }

    @Override
    public SubsetContentDTO[] getSubsetPreview(ParmsRemoveBuildableSubsetWorkitem parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        if (parms.subsetName == null || parms.subsetName.length() == 0) {
            throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
        }
        ArrayList<SubsetContentDTO> results = new ArrayList<SubsetContentDTO>();
        String rwsUUID = this.getWorkspaceIdFromBuild(repo, parms.buildDefnUUID, monitor);
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset subset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        ISubset resolvedSubset = null;
        if (subset != null) {
            boolean hasDynamic = false;
            for (ISubsetCriteria criterion : subset.getCriteria().getReferences()) {
                if (!BuildableSubsetUtil.isDynamic((ISubsetCriteria)criterion)) continue;
                hasDynamic = true;
                break;
            }
            resolvedSubset = hasDynamic ? client.evaluateSubset((ISubset)subset.getWorkingCopy()) : subset;
            if (resolvedSubset != null && resolvedSubset.getFileDescs() != null && !resolvedSubset.getFileDescs().isEmpty()) {
                List wiBuildableFiles = resolvedSubset.getFileDescs();
                ZosScmUtils.populateSubsetContent2(repo, rwsUUID, results, wiBuildableFiles, parms.workitems, monitor);
            }
        }
        return results.toArray(new SubsetContentDTO[results.size()]);
    }

    @Override
    public void postUpdateSubsetCriteria(ParmsCreateBuildableSubsetWorkItem parms, IProgressMonitor monitor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)parms);
        }
        ISPFSession session = ZFilesystemRestClient.getSession(parms.clientKey);
        ITeamRepository repo = session.getLoggedInRepository();
        if (parms.subsetName == null || parms.subsetName.length() == 0) {
            throw new Exception(Messages.ZFilesystemRestClient_MISSING_PARAMETER);
        }
        IBuildableSubsetClient client = (IBuildableSubsetClient)repo.getClientLibrary(IBuildableSubsetClient.class);
        ISubset previousSubset = client.getSubsetItem(BuildableSubsetUtil.getSlug((String)parms.subsetName, (String)parms.buildDefnUUID));
        ISubset subset = (ISubset)previousSubset.getWorkingCopy();
        boolean found = false;
        if (subset != null) {
            IWorkItem workItemHandle = ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).findWorkItemById(Integer.parseInt(parms.workitem), IWorkItem.SMALL_PROFILE, monitor);
            List criterias = subset.getCriteria().getReferences();
            ArrayList toRemove = new ArrayList();
            int j = 0;
            while (j < criterias.size()) {
                ISubsetCriteria criteria = (ISubsetCriteria)criterias.get(j);
                if (criteria instanceof ICriteriaWorkItem) {
                    ICriteriaWorkItem wiCriteria = (ICriteriaWorkItem)criteria;
                    if (wiCriteria.isDynamic()) {
                        List wis = wiCriteria.getWorkItems();
                        int i = 0;
                        while (i < wis.size()) {
                            IWorkItemHandle wi = (IWorkItemHandle)wiCriteria.getWorkItems().get(i);
                            if (wi.getItemId().equals((Object)workItemHandle.getItemId())) {
                                boolean includeImpacts;
                                boolean includeWorkItemChildren = parms.includeWorkItemChildren != null && parms.includeWorkItemChildren != false;
                                boolean bl = includeImpacts = parms.includeImpacts != null && parms.includeImpacts != false;
                                if (parms.includeWorkItemChildren != null) {
                                    wiCriteria.setIncludeChildren(includeWorkItemChildren);
                                }
                                if (parms.includeImpacts != null) {
                                    wiCriteria.setIncludeImpacted(includeImpacts);
                                }
                                found = true;
                                break;
                            }
                            if (found) break;
                            ++i;
                        }
                    }
                    if (found) break;
                }
                ++j;
            }
            if (found) {
                client.saveSubset(subset, previousSubset);
            }
        }
    }

    private static class MyMarkAsMergedDilemmaHandler
    extends MarkAsMergedDilemmaHandler {
        private MyMarkAsMergedDilemmaHandler() {
        }

        public int unmergedChanges(Collection<ILogicalChange> changes) {
            return 0;
        }
    }

    private static class Summary {
        String summary;
        String comment;

        private Summary() {
        }
    }
}

