/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal;

import com.ibm.jzos.ZFile;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.teamz.build.ant.zos.utils.JzosUtility;
import com.ibm.teamz.fileagent.internal.extensions.impl.ConvertFromPseudoSOSIInputStream;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZFileInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextFileLoader {
    private static Log LOG = LogFactory.getLog(TextFileLoader.class);
    static final String TOP = "top";
    static final String BOT = "bot";
    private final String fullPath;
    private static final int BUFFER_SIZE_UNDEFINED = 0;
    private static final String WRITE_TEXT_FILE_OPTIONS = "wt";

    public TextFileLoader(String fullPath) throws FileSystemException {
        this.fullPath = fullPath;
    }

    private static boolean isHierarchical(String name) {
        return name.contains("/") || name.contains("\\");
    }

    public void updateContents(InputStream inputStream, String localEncoding, String serverEncoding, String direction, String size, long sizemax) throws IOException, FileSystemException {
        if (TextFileLoader.isHierarchical(this.fullPath)) {
            this.createAlldirs(this.fullPath);
            this.updateFileTextContents(inputStream, this.fullPath, localEncoding, serverEncoding, direction, size, sizemax);
        } else {
            String formattedMember = JzosUtility.getSlashSlashQuotedDSN((String)this.fullPath);
            this.updateMemberTextContents(inputStream, formattedMember, localEncoding, serverEncoding);
        }
    }

    private void createAlldirs(String fp) {
        String dirs = fp.substring(0, fp.lastIndexOf(47));
        File file = new File(dirs);
        file.mkdirs();
    }

    private void updateFileTextContents(InputStream inputStream, String fullPath, String localEncoding, String serverEncoding, String direction, String size, long sizemax) throws IOException {
        int percentToDownload = 0;
        long offset = 0L;
        long sizeToDownload = 0L;
        if (sizemax != 0L) {
            if (size == null) {
                size = "100";
            }
            if (direction == null || !direction.equals(TOP) && !direction.equals(BOT)) {
                direction = TOP;
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Direction are neither bot or top, choose bot by default");
                }
            }
        }
        if (serverEncoding == null) {
            serverEncoding = "";
        }
        OutputStream out = null;
        ReaderToInputStream contentStream = new ReaderToInputStream((Reader)new InputStreamReader(inputStream, serverEncoding), localEncoding);
        int buf_size = 0;
        try {
            File f = new File(fullPath);
            out = new FileOutputStream(f);
            boolean bConvertSOSI = ZFileInterface.SOSIConversionNeeded((String)localEncoding);
            if (sizemax != 0L) {
                percentToDownload = this.convertSize(size);
                if (percentToDownload > 100) {
                    percentToDownload = 100;
                }
                if (direction.equals(TOP)) {
                    sizeToDownload = sizemax * (long)percentToDownload / 100L;
                } else {
                    percentToDownload = 100 - percentToDownload;
                    offset = sizemax * (long)percentToDownload / 100L;
                    sizeToDownload = sizemax;
                }
                if (!bConvertSOSI) {
                    TextFileLoader.copyByte((InputStream)contentStream, out, buf_size, sizeToDownload, offset);
                } else {
                    TextFileLoader.copyByte((InputStream)new ConvertFromPseudoSOSIInputStream((InputStream)contentStream), out, buf_size, sizeToDownload, offset);
                }
            } else if (!bConvertSOSI) {
                TextFileLoader.copyByte((InputStream)contentStream, out, buf_size);
            } else {
                TextFileLoader.copyByte((InputStream)new ConvertFromPseudoSOSIInputStream((InputStream)contentStream), out, buf_size);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        inputStream.close();
        out.flush();
        out.close();
    }

    private int convertSize(String size) {
        int result = 0;
        try {
            result = Integer.parseInt(size);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private void updateMemberTextContents(InputStream inputStream, String formattedMember, String localEncoding, String serverEncoding) throws IOException {
        if (serverEncoding == null) {
            serverEncoding = "";
        }
        OutputStream out = null;
        ReaderToInputStream contentStream = new ReaderToInputStream((Reader)new InputStreamReader(inputStream, serverEncoding), localEncoding);
        int buf_size = 0;
        boolean bConvertSOSI = false;
        try {
            ZFile zFileOut = new ZFile(formattedMember, WRITE_TEXT_FILE_OPTIONS);
            out = zFileOut.getOutputStream();
            bConvertSOSI = ZFileInterface.SOSIConversionNeeded((String)localEncoding);
            if (!bConvertSOSI) {
                TextFileLoader.copyByte((InputStream)contentStream, out, buf_size);
            } else {
                TextFileLoader.copyByte((InputStream)new ConvertFromPseudoSOSIInputStream((InputStream)contentStream), out, buf_size);
            }
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static long copyByte(InputStream input, OutputStream output, int buffer_size) throws IOException {
        byte[] buffer = new byte[buffer_size == 0 ? 8192 : buffer_size];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    private static long copyByte(InputStream input, OutputStream output, int buffer_size, long size_max, long offset) throws IOException {
        byte[] buffer = new byte[buffer_size == 0 ? 8192 : buffer_size];
        long count = 0L;
        if (offset > 0L) {
            count = input.skip(offset);
        }
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            if (count > size_max) break;
            if ((long)n > size_max) {
                n = (int)size_max;
            }
            output.write(buffer, 0, n);
            count += (long)n;
            if ((long)n > size_max) break;
        }
        return count;
    }
}

