/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.teamz.daemon.client.internal.ISPFSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SessionCleanupThread
extends Thread {
    private static Log LOG = LogFactory.getLog(SessionCleanupThread.class);
    private final long sleepTime;
    private final long inactiveThreshhold;
    private final HashMap<String, ISPFSession> sessionMap;

    public SessionCleanupThread(long sleepTime, long inactiveThreshhold, HashMap<String, ISPFSession> sessionMap) {
        super("ISPF Session Cleanup");
        this.setDaemon(true);
        this.sessionMap = sessionMap;
        this.sleepTime = sleepTime;
        this.inactiveThreshhold = inactiveThreshhold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Running ISPF session cleanup...");
            }
            ArrayList<ISPFSession> sessionsToRemove = new ArrayList<ISPFSession>();
            HashMap<String, ISPFSession> hashMap = this.sessionMap;
            synchronized (hashMap) {
                Collection<ISPFSession> sessions = this.sessionMap.values();
                if (sessions != null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)"Running ISPF session cleanup...");
                    }
                    for (ISPFSession thisSession : sessions) {
                        if (new Date().getTime() - thisSession.getLastUsedTime().getTime() <= this.inactiveThreshhold) continue;
                        sessionsToRemove.add(thisSession);
                    }
                }
            }
            for (ISPFSession thisSession : sessionsToRemove) {
                String repoURI;
                try {
                    repoURI = thisSession.getLoggedInRepository().getRepositoryURI();
                }
                catch (Throwable t) {
                    repoURI = "?";
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Session for " + thisSession.getMVSID() + " @ " + repoURI + " inactive since " + thisSession.getLastUsedTime() + ". Logging out."));
                }
                try {
                    ISPFSession.logout(thisSession.getKey(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (FileSystemException ex) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)"Problem deregistering sandboxes:", (Throwable)ex);
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Session cleanup completed.");
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

