/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.daemon.client.internal.ISPFLoginHandler;
import com.ibm.teamz.daemon.client.internal.SessionCleanupThread;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;

public class ISPFSession {
    private static final HashMap<String, ISPFSession> sessionMap;
    private static Log LOG;
    private final ITeamRepository repo;
    private String sessionKey;
    private final String mvsID;
    private final DateFormat dateFormat;
    private IProjectAreaHandle connectedProjectArea;
    private Date lastUsed;
    private IOperationReport deliverReport;
    private final Set<ISandbox> registeredSandboxes = new HashSet<ISandbox>();
    private String propertiesFile;
    private Properties properties;

    static {
        LOG = LogFactory.getLog(ISPFSession.class);
        sessionMap = new HashMap();
        String intervalStr = System.getProperty("com.ibm.teamz.daemon.cleanup.interval");
        String threshholdStr = System.getProperty("com.ibm.teamz.daemon.cleanup.threshhold");
        if (intervalStr != null && threshholdStr != null) {
            long interval = -1L;
            long threshhold = -1L;
            try {
                interval = Long.parseLong(intervalStr);
                threshhold = Long.parseLong(threshholdStr);
            }
            catch (Throwable t) {
                interval = -1L;
                threshhold = -1L;
            }
            if (interval > 0L && threshhold > 0L) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Starting cleanup thread with interval of " + interval + " and threshhold of " + threshhold));
                }
                new SessionCleanupThread(interval, threshhold, sessionMap).start();
            }
        }
    }

    public static ISPFSession getSession(String key) {
        ISPFSession session = sessionMap.get(key);
        if (session != null) {
            session.lastUsed = new Date();
        }
        return session;
    }

    Date getLastUsedTime() {
        return this.lastUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logout(String key, IProgressMonitor monitor) throws FileSystemException {
        ISPFSession oldSession;
        HashMap<String, ISPFSession> hashMap = sessionMap;
        synchronized (hashMap) {
            oldSession = sessionMap.remove(key);
        }
        if (oldSession != null && oldSession.repo != null && oldSession.repo.loggedIn()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(String.valueOf(oldSession.mvsID) + " logged out of " + oldSession.repo.getRepositoryURI()));
            }
            oldSession.repo.logout();
            for (ISandbox sandbox : oldSession.registeredSandboxes) {
                FileSystemCore.getSharingManager().deregister(sandbox, monitor);
            }
            oldSession.registeredSandboxes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISPFSession(String username, String password, String uri, String mvsID, DateFormat dateFormat, IProgressMonitor monitor) throws TeamRepositoryException {
        this.repo = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(uri);
        ISPFLoginHandler loginHandler = new ISPFLoginHandler(username, password);
        this.repo.registerLoginHandler((ITeamRepository.ILoginHandler)loginHandler);
        try {
            this.repo.login(monitor);
        }
        catch (TeamRepositoryException ex) {
            TeamRepositoryException authException = loginHandler.getAuthException();
            if (authException != null) {
                throw authException;
            }
            throw ex;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("MVS user " + mvsID + " logged in to " + uri + " as " + username + "."));
        }
        this.sessionKey = UUID.randomUUID().toString();
        HashMap<String, ISPFSession> hashMap = sessionMap;
        synchronized (hashMap) {
            while (sessionMap.containsKey(this.sessionKey)) {
                this.sessionKey = UUID.randomUUID().toString();
            }
            sessionMap.put(this.sessionKey, this);
        }
        this.mvsID = mvsID;
        this.dateFormat = dateFormat;
        this.lastUsed = new Date();
        this.propertiesFile = null;
        this.properties = null;
    }

    public String getKey() {
        return this.sessionKey;
    }

    public ITeamRepository getLoggedInRepository() throws NotLoggedInException {
        if (this.repo != null && this.repo.loggedIn()) {
            return this.repo;
        }
        throw new NotLoggedInException();
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String getMVSID() {
        return this.mvsID;
    }

    public IProjectAreaHandle getProjectArea() {
        return this.connectedProjectArea;
    }

    public void setProjectArea(IProjectAreaHandle projectArea) {
        this.connectedProjectArea = projectArea;
    }

    public void setPendingDeliver(IOperationReport report) {
        this.deliverReport = report;
    }

    public IOperationReport getPendingDeliver() {
        return this.deliverReport;
    }

    public void registerSandboxes(Set<ISandbox> sandboxes, IProgressMonitor monitor) throws FileSystemException {
        FileSystemCore.getSharingManager().register(new ArrayList<ISandbox>(sandboxes), monitor);
        this.registeredSandboxes.addAll(sandboxes);
    }

    public void removeRegisteredSandboxes(Collection<ISandbox> sandboxes) {
        this.registeredSandboxes.removeAll(sandboxes);
    }

    public Collection<ISandbox> getRegisteredSandboxes() {
        return new HashSet<ISandbox>(this.registeredSandboxes);
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

