/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal;

import com.ibm.teamz.daemon.client.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EnterpriseRequestDialogOption {
    public static final String PROPERTY_CHANGED_ITEMS_ONLY = "changedItemsOnly";
    public static final String PROPERTY_MANDATORY_SUBSET = "mandatorySubset";
    public static final String PROPERTY_PREVIEW_BUILD = "previewBuild";
    public static final String PROPERTY_SIMULATION_BUILD = "simulationBuild";
    public static final String PROPERTY_VERIFY_BUILD_OUTPUTS = "verifyBuildOutputs";
    public static final String PROPERTY_FULL_MIN_LOAD = "fullMinLoad";
    public static final String PROPERTY_TRUST_OUTPUTS = "trustOutputs";
    public static final String PROPERTY_CONDITIONAL_BUILD = "conditionalBuild";
    public static final String PROPERTY_IMPACTS_REPOSITORY = "impactsInRepo";
    public static final String PROPERTY_IMPACTS_NOT_REPOSITORY = "impactsNotRepo";
    public static final String PROPERTY_IMPACTS_ALWAYS_BUILD = "impactsAlwaysBuild";
    public static final String PROPERTY_APPEND_LIBRARIES = "appendLibraries";
    public static final String PROPERTY_DELETE_DIRECTORY = "deleteDirectory";
    public static final String PROPERTY_ANT_ARGUMENTS = "antArgs";
    public static final String PROPERTY_PREBUILD_SCRIPT = "prebuildScript";
    public static final String PROPERTY_POSTBUILD_SCRIPT = "postbuildScript";
    public static final String PROPERTY_ALWAYS_RUN_POSTBUILD = "alwaysRunPostbuild";
    public static final String PROPERTY_CUSTOM_BUILD_FILE = "customBuildFile";
    public static final String PROPERTY_CUSTOM_BUILD_TARGETS = "customBuildTargets";
    private static final RequestDialogEntry[] COMMON_DEFAULT_OPTIONS = new RequestDialogEntry[]{new RequestDialogEntry("changedItemsOnly", Messages.EnterpriseRequestDialogOption_BUILD_CHANGED_ITEMS_ONLY, "team.enterprise.build.ant.buildChangesOnly", false, false, true, true, true, true), new RequestDialogEntry("mandatorySubset", Messages.EnterpriseRequestDialogOption_MANDATORY_SUBSET, "team.enterprise.build.ant.mandatorySubset", false, false, false, false, true, true), new RequestDialogEntry("previewBuild", Messages.EnterpriseRequestDialogOption_PREVIEW_BUILD, "team.enterprise.build.dependency.previewBuild", false, false, true, false, true, false), new RequestDialogEntry("simulationBuild", Messages.EnterpriseRequestDialogOption_SIMULATION_BUILD, "team.enterprise.build.ant.simulationMode", false, true, true, false, true, false), new RequestDialogEntry("verifyBuildOutputs", Messages.EnterpriseRequestDialogOption_SIMULATION_BUILD_BINARY_CHECK, "team.enterprise.build.ant.simulationModeBinaryCheck", false, true, true, false, true, false), new RequestDialogEntry("fullMinLoad", Messages.EnterpriseRequestDialogOption_MINIMUM_LOAD, "team.enterprise.build.ant.fullMinimumLoad", false, false, false, true, false, true), new RequestDialogEntry("trustOutputs", Messages.EnterpriseRequestDialogOption_TRUST_OUTPUTS, "team.enterprise.build.dependency.trustOutputs", false, true, false, false, true, true), new RequestDialogEntry("impactsInRepo", Messages.EnterpriseRequestDialogOption_IMPACTS_REPOSITORY, "team.enterprise.build.impacts.disableInputQueries", false, true, false, false, true, true), new RequestDialogEntry("impactsNotRepo", Messages.EnterpriseRequestDialogOption_IMPACTS_NOT_REPOSITORY, "team.enterprise.build.impacts.disableParserOutputQueries", false, true, false, false, true, true), new RequestDialogEntry("impactsAlwaysBuild", Messages.EnterpriseRequestDialogOption_IMPACTS_ALWAYS_BUILD, "team.enterprise.build.impacts.disableAlwaysBuildQueries", false, true, false, false, true, true), new RequestDialogEntry("deleteDirectory", Messages.EnterpriseRequestDialogOption_DELETE_LOAD_DIRECTORY, "teamz.scm.deleteDestinationBeforeFetch", false, true, false, false, true, true), new RequestDialogEntry("antArgs", Messages.EnterpriseRequestDialogOption_ANT_ARGUMENTS, "team.enterprise.build.ant.antArgs", true, true, false, false, true, true), new RequestDialogEntry("prebuildScript", Messages.EnterpriseRequestDialogOption_RUN_PREBUILD_SCRIPT, "team.enterprise.build.ant.preBuildFile", false, true, false, false, true, true), new RequestDialogEntry("postbuildScript", Messages.EnterpriseRequestDialogOption_RUN_POSTBUILD_SCRIPT, "team.enterprise.build.ant.postBuildFile", false, true, false, false, true, true), new RequestDialogEntry("alwaysRunPostbuild", Messages.EnterpriseRequestDialogOption_ALWAYS_RUN_POSTBUILD_SCRIPT, "team.enterprise.build.ant.alwaysRunPostBuildFile", false, true, false, false, true, true), new RequestDialogEntry("customBuildFile", Messages.EnterpriseRequestDialogOption_CUSTOM_BUILD_FILE, "team.enterprise.build.ant.buildFile", true, true, false, false, true, true), new RequestDialogEntry("customBuildTargets", Messages.EnterpriseRequestDialogOption_CUSTOM_BUILD_TARGETS, "team.enterprise.build.ant.targets", true, true, false, false, true, true)};
    public static final String IDEPEND_PROPERTY_CONDITIONAL_BUILD = "team.enterprise.build.ant.conditionalBuild";
    private static final RequestDialogEntry[] ZOS_DEFAULT_OPTIONS = new RequestDialogEntry[]{new RequestDialogEntry("conditionalBuild", "Conditional build", "team.enterprise.build.ant.conditionalBuild", true, true, false, false, true, true)};
    private final RequestDialogEntry entry;
    private boolean teamVisibility;
    private boolean personalVisibility;

    public EnterpriseRequestDialogOption(String id, String label, String buildPropertyName, boolean isConfigurationProperty, boolean requiresPermission, boolean defaultTeamVisibility, boolean defaultPersonalVisibility, boolean teamVisibilityModifiable, boolean personalVisibilityModifiable) {
        this(new RequestDialogEntry(id, label, buildPropertyName, isConfigurationProperty, requiresPermission, defaultTeamVisibility, defaultPersonalVisibility, teamVisibilityModifiable, personalVisibilityModifiable));
    }

    private EnterpriseRequestDialogOption(RequestDialogEntry entry) {
        this.entry = entry;
        this.teamVisibility = entry.defaultTeamVisibility;
        this.personalVisibility = entry.defaultPersonalVisibility;
    }

    public String getId() {
        return this.entry.id;
    }

    public String getLabel() {
        return this.entry.label;
    }

    public String getBuildPropertyName() {
        return this.entry.buildPropertyName;
    }

    public boolean getTeamVisibility() {
        return this.teamVisibility;
    }

    public boolean getPersonalVisibility() {
        return this.personalVisibility;
    }

    public void setTeamVisibility(boolean visibility) {
        if (this.isTeamVisibilityModifiable()) {
            this.teamVisibility = visibility;
        }
    }

    public void setPersonalVisibility(boolean visibility) {
        if (this.isPersonalVisibilityModifiable()) {
            this.personalVisibility = visibility;
        }
    }

    public boolean isTeamVisibilityModifiable() {
        return this.entry.teamVisibilityModifiable;
    }

    public boolean isPersonalVisibilityModifiable() {
        return this.entry.personalVisibilityModifiable;
    }

    public boolean isConfigurationProperty() {
        return this.entry.isConfigurationProperty;
    }

    public boolean requiresPermission() {
        return this.entry.requiresPermission;
    }

    public String toString() {
        return this.entry.label;
    }

    public static List<EnterpriseRequestDialogOption> parseOptions(String value, boolean isZOS) {
        RequestDialogEntry[] platformOptions = ZOS_DEFAULT_OPTIONS;
        ArrayList<EnterpriseRequestDialogOption> options = new ArrayList<EnterpriseRequestDialogOption>(COMMON_DEFAULT_OPTIONS.length + platformOptions.length);
        RequestDialogEntry[] requestDialogEntryArray = COMMON_DEFAULT_OPTIONS;
        int n = COMMON_DEFAULT_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            RequestDialogEntry commonEntry = requestDialogEntryArray[n2];
            options.add(new EnterpriseRequestDialogOption(commonEntry));
            ++n2;
        }
        requestDialogEntryArray = platformOptions;
        n = platformOptions.length;
        n2 = 0;
        while (n2 < n) {
            RequestDialogEntry platformEntry = requestDialogEntryArray[n2];
            options.add(new EnterpriseRequestDialogOption(platformEntry));
            ++n2;
        }
        if (value != null && !(value = value.trim()).isEmpty()) {
            String[] pairs;
            String[] stringArray = pairs = value.split(",");
            int n3 = pairs.length;
            n = 0;
            while (n < n3) {
                String pair = stringArray[n];
                int equalsIdx = pair.indexOf(61);
                if (equalsIdx != -1) {
                    String id = pair.substring(0, equalsIdx).trim();
                    String visibilityValue = pair.substring(equalsIdx + 1).trim();
                    for (EnterpriseRequestDialogOption nextOption : options) {
                        if (!nextOption.getId().equals(id)) continue;
                        nextOption.setTeamVisibility(visibilityValue.contains("t"));
                        nextOption.setPersonalVisibility(visibilityValue.contains("p"));
                        break;
                    }
                }
                ++n;
            }
        }
        Collections.sort(options, new Comparator<EnterpriseRequestDialogOption>(){

            @Override
            public int compare(EnterpriseRequestDialogOption object1, EnterpriseRequestDialogOption object2) {
                return object1.getLabel().compareTo(object2.getLabel());
            }
        });
        return options;
    }

    private static class RequestDialogEntry {
        final String id;
        final String label;
        final String buildPropertyName;
        final boolean isConfigurationProperty;
        final boolean requiresPermission;
        final boolean defaultTeamVisibility;
        final boolean defaultPersonalVisibility;
        final boolean teamVisibilityModifiable;
        final boolean personalVisibilityModifiable;

        public RequestDialogEntry(String id, String label, String buildPropertyName, boolean isConfigurationProperty, boolean requiresPermission, boolean defaultTeamVisibility, boolean defaultPersonalVisibility, boolean teamVisibilityModifiable, boolean personalVisibilityModifiable) {
            this.id = id;
            this.label = label;
            this.buildPropertyName = buildPropertyName;
            this.isConfigurationProperty = isConfigurationProperty;
            this.requiresPermission = requiresPermission;
            this.defaultTeamVisibility = defaultTeamVisibility;
            this.defaultPersonalVisibility = defaultPersonalVisibility;
            this.teamVisibilityModifiable = teamVisibilityModifiable;
            this.personalVisibilityModifiable = personalVisibilityModifiable;
        }
    }
}

