/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.LogManager;

public class DaemonUtils {
    public static String getInitials(String fullName) {
        if (fullName == null || fullName.trim().length() == 0) {
            return "*";
        }
        String[] segments = fullName.split("[ -]");
        if (segments.length <= 3) {
            StringBuffer buf = new StringBuffer();
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String seg = stringArray[n2];
                if (seg.length() > 0) {
                    buf.append(seg.charAt(0));
                }
                ++n2;
            }
            return buf.toString();
        }
        char first = ' ';
        int firstIndex = 0;
        while (first == ' ' && firstIndex < segments.length) {
            if (segments[firstIndex].length() > 0) {
                first = segments[firstIndex].charAt(0);
            }
            ++firstIndex;
        }
        char last = ' ';
        int lastIndex = segments.length - 1;
        while (last == ' ' && lastIndex > firstIndex) {
            if (segments[lastIndex].length() > 0) {
                last = segments[lastIndex].charAt(0);
            }
            --lastIndex;
        }
        return "" + first + last;
    }

    public static String getDuration(long timeTakenInMillis) {
        if (timeTakenInMillis <= 0L) {
            return "";
        }
        long timeTakenInSeconds = timeTakenInMillis / 1000L;
        String hoursTaken = "" + (int)Math.floor(timeTakenInSeconds / 3600L);
        String minutesTaken = "" + (int)Math.floor(timeTakenInSeconds % 3600L / 60L);
        String secondsTaken = "" + (int)(timeTakenInSeconds % 60L);
        if (hoursTaken.length() < 2) {
            hoursTaken = "0" + hoursTaken;
        }
        if (minutesTaken.length() < 2) {
            minutesTaken = "0" + minutesTaken;
        }
        if (secondsTaken.length() < 2) {
            secondsTaken = "0" + secondsTaken;
        }
        return String.valueOf(hoursTaken) + ":" + minutesTaken + ":" + secondsTaken;
    }

    static void chkInit() {
        String filePath = System.getProperty("java.util.logging.config.file");
        try {
            LogManager.getLogManager().readConfiguration(new FileInputStream(filePath));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String formattedMess(String[] mess, Throwable e) {
        StringBuffer bf = new StringBuffer();
        if (mess != null) {
            String[] stringArray = mess;
            int n = mess.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                if (m != null) {
                    bf.append(m);
                }
                ++n2;
            }
        }
        if (e != null) {
            bf.append(e.getMessage() != null ? e.getMessage() : e.toString());
            e.printStackTrace();
        }
        return bf.toString();
    }
}

