/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.daemon.client.internal;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CorruptionListener
implements ICorruptCopyFileAreaListener {
    private final Set<String> corruptedRoots = new HashSet<String>();
    private static Log LOG = LogFactory.getLog(CorruptionListener.class);

    public void corrupt(ICorruptCopyFileAreaEvent event) {
        String rootStr = event.getRoot().toOSString();
        if (event.isCorrupt()) {
            this.corruptedRoots.add(rootStr);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Corruption of sandbox with root " + rootStr + " detected."));
            }
        } else {
            this.corruptedRoots.remove(rootStr);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Sandbox with root " + rootStr + " is no longer corrupt."));
            }
        }
    }

    public boolean isCorrupt(ILocation sandboxRoot) {
        return this.corruptedRoots.contains(sandboxRoot.toOSString());
    }
}

