/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.common.fileagent.xml;

import com.ibm.teamz.common.fileagent.api.ICreateDataSetsOperation;
import com.ibm.teamz.common.fileagent.api.ILoadFilesOperation;
import com.ibm.teamz.common.fileagent.api.ILoadFoldersOperation;
import com.ibm.teamz.common.fileagent.internal.xml.AuthenticationOperation;
import com.ibm.teamz.common.fileagent.internal.xml.CreateDataSetsOperation;
import com.ibm.teamz.common.fileagent.internal.xml.LoadFilesOperation;
import com.ibm.teamz.common.fileagent.internal.xml.LoadFoldersOperation;
import com.ibm.teamz.common.fileagent.internal.xml.LoadWorkspaceOperation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileAgentOperationListGenerator {
    private static final String XML_EXTENSION = ".xml";
    private static final String FA_OPERATION_LIST_PREFIX = "FAOperationList";
    private LoadWorkspaceOperation fLoadWorkspaceOperation;
    private LoadFoldersOperation fLoadFoldersOperation;
    private LoadFilesOperation fLoadFilesOperation;
    private CreateDataSetsOperation fCreateDataSetsOperation;
    private AuthenticationOperation fAuthenticationOperation;

    public void createLoadWorkspaceOperation(String workspaceUUID, String dataSetPrefix, String HFSDestination, String resultFile, boolean loadOnlyUSS) {
        this.fLoadWorkspaceOperation = new LoadWorkspaceOperation(workspaceUUID, dataSetPrefix, HFSDestination, resultFile, loadOnlyUSS);
    }

    public void createLoadWorkspaceOperation(String workspaceUUID, String dataSetPrefix, String HFSDestination, String resultFile) {
        this.fLoadWorkspaceOperation = new LoadWorkspaceOperation(workspaceUUID, dataSetPrefix, HFSDestination, resultFile);
    }

    public ILoadFoldersOperation createLoadFoldersOperation(String workspaceUUID, String dataSetPrefix) {
        this.fLoadFoldersOperation = new LoadFoldersOperation(workspaceUUID, dataSetPrefix);
        return this.fLoadFoldersOperation;
    }

    public ILoadFilesOperation createLoadFilesOperation(String workspaceUUID, String dataSetPrefix) {
        this.fLoadFilesOperation = new LoadFilesOperation(workspaceUUID, dataSetPrefix);
        return this.fLoadFilesOperation;
    }

    public void createLoadFileOperation(String dataSetDefinitionUUID, String componentName, String filePath) {
        this.fLoadFilesOperation.addFileWithDataSetDefinition(dataSetDefinitionUUID, componentName, filePath);
    }

    public ICreateDataSetsOperation createCreateDataSetsOperation(String dataSetPrefix) {
        this.fCreateDataSetsOperation = new CreateDataSetsOperation(dataSetPrefix);
        return this.fCreateDataSetsOperation;
    }

    public void createAuthenticationOperation(String userID, String encryptedPassword) {
        this.fAuthenticationOperation = new AuthenticationOperation(userID, encryptedPassword);
    }

    public File generate() throws Exception {
        return this.generate(null);
    }

    public File generate(String filePath) throws Exception {
        Source source = this.createDocumentSource();
        File operationListFile = null;
        operationListFile = filePath != null ? new File(filePath) : File.createTempFile(FA_OPERATION_LIST_PREFIX, XML_EXTENSION);
        StreamResult result = new StreamResult(operationListFile.toURI().getPath());
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
        transformer.transform(source, result);
        return operationListFile;
    }

    public byte[] generateToByteArray() throws Exception {
        Source source = this.createDocumentSource();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
        transformer.transform(source, result);
        return out.toByteArray();
    }

    public InputStream generateToStream() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(this.generateToByteArray());
        return input;
    }

    private Source createDocumentSource() throws Exception {
        Element dataSets;
        Element files;
        Element folders;
        Document operationList = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = operationList.createElement("operations");
        operationList.appendChild(root);
        if (this.fAuthenticationOperation != null) {
            root.appendChild(this.fAuthenticationOperation.createXMLElement(operationList));
        }
        if (this.fLoadWorkspaceOperation != null) {
            root.appendChild(this.fLoadWorkspaceOperation.createXMLElement(operationList));
        }
        if (this.fLoadFoldersOperation != null && (folders = this.fLoadFoldersOperation.createXMLElement(operationList)) != null) {
            root.appendChild(folders);
        }
        if (this.fLoadFilesOperation != null && (files = this.fLoadFilesOperation.createXMLElement(operationList)) != null) {
            root.appendChild(files);
        }
        if (this.fCreateDataSetsOperation != null && (dataSets = this.fCreateDataSetsOperation.createXMLElement(operationList)) != null) {
            root.appendChild(dataSets);
        }
        DOMSource source = new DOMSource(operationList);
        return source;
    }

    public static void main(String[] args) throws Exception {
        String workspaceUUID = "_workspace_uuid_string";
        String dataSetPrefix = "BUILD.CBL";
        String HFSDestination = "/u/build/cbl";
        String resultFile = "u/build/cbl/fetchedFiles.xml";
        String dataSetDefinitionUUID = "_dataset_definition_uuid_string";
        String componentName = "COBOL Programs";
        if (args.length == 1) {
            String filePath = null;
            filePath = args[0];
            FileAgentOperationListGenerator gen = new FileAgentOperationListGenerator();
            gen.createLoadWorkspaceOperation(workspaceUUID, dataSetPrefix, HFSDestination, resultFile);
            ILoadFoldersOperation folders = gen.createLoadFoldersOperation(workspaceUUID, dataSetPrefix);
            folders.addFolder(dataSetDefinitionUUID, componentName, "ProjectA/zOSsrc/MyCobolSrc");
            folders.addFolder(dataSetDefinitionUUID, componentName, "ProjectA/zOSsrc/MyCobolLinkEdits");
            ILoadFilesOperation files = gen.createLoadFilesOperation(workspaceUUID, dataSetPrefix);
            files.addFileWithDataSetDefinition(dataSetDefinitionUUID, componentName, "ProjectA/zOSsrc/FolderB/Hello.cbl");
            files.addFileWithDataSetName("BUILD.LNK.STUFF", componentName, "ProjectA/zOSsrc/FolderB/Hello.lnk");
            ICreateDataSetsOperation dataSets = gen.createCreateDataSetsOperation(dataSetPrefix);
            dataSets.addDataSet(dataSetDefinitionUUID);
            gen.generate(filePath);
        }
    }
}

