/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.common.fileagent.internal.xml;

import com.ibm.teamz.common.fileagent.api.ILoadFoldersOperation;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LoadFoldersOperation
implements ILoadFoldersOperation {
    private String fWorkspaceUUID;
    private String fDataSetPrefix;
    private List<LoadFolder> fFolders;

    public LoadFoldersOperation(String workspaceUUID, String dataSetPrefix) {
        this.fWorkspaceUUID = workspaceUUID;
        this.fDataSetPrefix = dataSetPrefix;
        this.fFolders = new ArrayList<LoadFolder>();
    }

    @Override
    public void addFolder(String dataSetDefinitionUUID, String componentName, String folderPath) {
        this.fFolders.add(new LoadFolder(dataSetDefinitionUUID, componentName, folderPath));
    }

    public Element createXMLElement(Document doc) {
        if (this.fFolders.size() == 0) {
            return null;
        }
        Element element = doc.createElement("loadFolders");
        if (this.fWorkspaceUUID != null) {
            element.setAttribute("workspaceUUID", this.fWorkspaceUUID);
        }
        if (this.fDataSetPrefix != null) {
            element.setAttribute("dataSetPrefix", this.fDataSetPrefix);
        }
        for (LoadFolder folder : this.fFolders) {
            Element el = doc.createElement("folder");
            if (folder.getDataSetDefinitionUUID() != null) {
                el.setAttribute("dataSetDefinitionUUID", folder.getDataSetDefinitionUUID());
            }
            if (folder.getComponentName() != null) {
                el.setAttribute("componentName", folder.getComponentName());
            }
            if (folder.getFolderPath() != null) {
                el.setAttribute("folderPath", folder.getFolderPath());
            }
            element.appendChild(el);
        }
        return element;
    }

    public String getWorkspaceUUID() {
        return this.fWorkspaceUUID;
    }

    public String getDataSetPrefix() {
        return this.fDataSetPrefix;
    }

    public List<LoadFolder> getFolders() {
        return this.fFolders;
    }

    class LoadFolder {
        private String fDataSetDefinitionUUID;
        private String fComponentName;
        private String fFolderPath;

        public LoadFolder(String dataSetDefinitionUUID, String componentName, String folderPath) {
            this.fDataSetDefinitionUUID = dataSetDefinitionUUID;
            this.fComponentName = componentName;
            this.fFolderPath = folderPath;
        }

        public String getDataSetDefinitionUUID() {
            return this.fDataSetDefinitionUUID;
        }

        public String getComponentName() {
            return this.fComponentName;
        }

        public String getFolderPath() {
            return this.fFolderPath;
        }
    }
}

