/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.common.fileagent.internal.xml;

import com.ibm.teamz.common.fileagent.api.ILoadFilesOperation;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LoadFilesOperation
implements ILoadFilesOperation {
    private static final String FILE_SEPARATOR_ZOS = "/";
    private String fWorkspaceUUID;
    private String fDataSetPrefix;
    private List<LoadFile> fFiles;

    public LoadFilesOperation(String workspaceUUID, String dataSetPrefix) {
        this.fWorkspaceUUID = workspaceUUID;
        this.fDataSetPrefix = dataSetPrefix;
        this.fFiles = new ArrayList<LoadFile>();
    }

    @Override
    public void addFileWithDataSetDefinition(String dataSetDefinitionUUID, String componentName, String filePath) {
        this.fFiles.add(new LoadFile(dataSetDefinitionUUID, null, componentName, filePath));
    }

    @Override
    public void addFileWithDataSetName(String dataSetName, String componentName, String filePath) {
        this.fFiles.add(new LoadFile(null, dataSetName, componentName, filePath));
    }

    public Element createXMLElement(Document doc) {
        if (this.fFiles.size() == 0) {
            return null;
        }
        Element element = doc.createElement("loadFiles");
        if (this.fWorkspaceUUID != null) {
            element.setAttribute("workspaceUUID", this.fWorkspaceUUID);
        }
        if (this.fDataSetPrefix != null) {
            element.setAttribute("dataSetPrefix", this.fDataSetPrefix);
        }
        for (LoadFile file : this.fFiles) {
            Element el = doc.createElement("file");
            if (file.getDataSetDefinitionUUID() != null) {
                el.setAttribute("dataSetDefinitionUUID", file.getDataSetDefinitionUUID());
            }
            if (file.getDataSetName() != null) {
                el.setAttribute("dataSetName", file.getDataSetName());
            }
            if (file.getComponentName() != null) {
                el.setAttribute("componentName", file.getComponentName());
            }
            if (file.getFilePath() != null) {
                String path = file.getFilePath();
                if (!path.startsWith(FILE_SEPARATOR_ZOS)) {
                    path = FILE_SEPARATOR_ZOS + path;
                }
                el.setAttribute("filePath", path);
            }
            element.appendChild(el);
        }
        return element;
    }

    public String getWorkspaceUUID() {
        return this.fWorkspaceUUID;
    }

    public String getDataSetPrefix() {
        return this.fDataSetPrefix;
    }

    public List<LoadFile> getFiles() {
        return this.fFiles;
    }

    class LoadFile {
        private String fDataSetDefinitionUUID;
        private String fDataSetName;
        private String fComponentName;
        private String fFilePath;

        public LoadFile(String dataSetDefinitionUUID, String dataSetName, String componentName, String filePath) {
            this.fDataSetDefinitionUUID = dataSetDefinitionUUID;
            this.fDataSetName = dataSetName;
            this.fComponentName = componentName;
            this.fFilePath = filePath;
        }

        public String getDataSetDefinitionUUID() {
            return this.fDataSetDefinitionUUID;
        }

        public String getComponentName() {
            return this.fComponentName;
        }

        public String getFilePath() {
            return this.fFilePath;
        }

        public String getDataSetName() {
            return this.fDataSetName;
        }
    }
}

