/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.common.fileagent.internal.xml;

import com.ibm.teamz.common.fileagent.api.ICreateDataSetsOperation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateDataSetsOperation
implements ICreateDataSetsOperation {
    private String fDataSetPrefix;
    private Map<String, DataSet> fDataSets;

    public CreateDataSetsOperation(String dataSetPrefix) {
        this.fDataSetPrefix = dataSetPrefix;
        this.fDataSets = new HashMap<String, DataSet>();
    }

    @Override
    public void addDataSet(String dataSetDefinitionUUID) {
        DataSet dsd = new DataSet();
        dsd.setUuid(dataSetDefinitionUUID);
        this.fDataSets.put(dataSetDefinitionUUID, dsd);
    }

    @Override
    public void addDataSet(String dataSetDefinitionUUID, String dataSetDefinitionStateUUID) {
        DataSet dsd = new DataSet();
        dsd.setUuid(dataSetDefinitionUUID);
        dsd.setStateId(dataSetDefinitionStateUUID);
        this.fDataSets.put(dataSetDefinitionUUID, dsd);
    }

    public Element createXMLElement(Document doc) {
        if (this.fDataSets.size() == 0) {
            return null;
        }
        Element element = doc.createElement("createDataSets");
        if (this.fDataSetPrefix != null) {
            element.setAttribute("dataSetPrefix", this.fDataSetPrefix);
        }
        Iterator<String> it = this.fDataSets.keySet().iterator();
        while (it.hasNext()) {
            Element el = doc.createElement("dataSet");
            String dataSetDefinitionUUID = it.next();
            if (dataSetDefinitionUUID != null) {
                DataSet dsd = this.fDataSets.get(dataSetDefinitionUUID);
                el.setAttribute("dataSetDefinitionUUID", dsd.getUuid());
                String stateId = dsd.getStateId();
                if (stateId != null && stateId.length() > 0) {
                    el.setAttribute("stateID", stateId);
                }
            }
            element.appendChild(el);
        }
        return element;
    }

    public String getFDataSetPrefix() {
        return this.fDataSetPrefix;
    }

    private class DataSet {
        private String uuid;
        private String stateId;

        private DataSet() {
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setStateId(String stateId) {
            this.stateId = stateId;
        }

        public String getStateId() {
            return this.stateId;
        }
    }
}

