/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.client.metadata.core.api;

import com.ibm.team.enterprise.common.common.IMetadata;
import com.ibm.team.enterprise.common.common.IMetadataFactory;
import com.ibm.team.enterprise.common.common.IValidator;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.teamz.client.metadata.core.api.Metadata;
import com.ibm.teamz.client.metadata.core.validators.DefaultValidator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class MetadataFactory
implements IMetadataFactory {
    private static MetadataFactory instance = null;
    private IValidator defaultMetadataValidator = new DefaultValidator();
    private HashMap<String, IConfigurationElement> metadataElementMap = new HashMap();

    protected MetadataFactory() {
    }

    public static MetadataFactory getInstance() {
        if (instance == null) {
            instance = new MetadataFactory();
        }
        return instance;
    }

    public IMetadata getMetadata(String sourcePath) {
        return this.getMetadata(sourcePath, false);
    }

    public IMetadata getContainerMetadata(String sourcePath) {
        return this.getMetadata(sourcePath, true);
    }

    private IMetadata getMetadata(String sourcePath, boolean isFolder) {
        try {
            return new Metadata(sourcePath, isFolder);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    public IMetadata getMetadata(URI sourceFileURI) {
        return this.getMetadata(sourceFileURI, false);
    }

    public IMetadata getContainerMetadata(URI sourceFileURI) {
        return this.getMetadata(sourceFileURI, true);
    }

    private IMetadata getMetadata(URI sourceFileURI, boolean isFolder) {
        try {
            return new Metadata(sourceFileURI, isFolder);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    public IValidator getDefaultMetadataValidator() {
        if (this.defaultMetadataValidator == null) {
            this.defaultMetadataValidator = new DefaultValidator();
        }
        return this.defaultMetadataValidator;
    }

    public IConfigurationElement getExtensionElement(String metadataKey) {
        if (this.metadataElementMap == null) {
            this.metadataElementMap = new HashMap();
        }
        if (this.metadataElementMap.isEmpty()) {
            this.loadExtensions();
        }
        if (!this.metadataElementMap.isEmpty()) {
            return this.metadataElementMap.get(metadataKey);
        }
        return null;
    }

    private void loadExtensions() {
        ArrayList<IConfigurationElement> metadataElementArray = new ArrayList<IConfigurationElement>();
        IExtensionPoint metadataExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.teamz.metadata.core.extension");
        IConfigurationElement[] points = metadataExtensionPoint.getConfigurationElements();
        int i = 0;
        while (i < points.length) {
            if (points[i].getName().equalsIgnoreCase("metadataElement")) {
                metadataElementArray.add(points[i]);
            }
            ++i;
        }
        for (IConfigurationElement element : metadataElementArray) {
            String elementKey = element.getAttribute("key");
            this.metadataElementMap.put(elementKey, element);
        }
    }
}

