/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.client.metadata.core.api;

import com.ibm.team.enterprise.common.common.IMetadata;
import com.ibm.team.enterprise.common.common.IValidator;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.client.metadata.api.AbstractMetadata;
import com.ibm.teamz.client.metadata.core.api.MetadataFactory;
import com.ibm.teamz.client.metadata.core.nls.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class Metadata
extends AbstractMetadata {
    private IShareable sourceShareable;
    private File sourceFile;
    private boolean isFolderMetadata;
    private File metadataFile;
    private FileInputStream metadataFileStream;
    private Properties properties = null;
    protected boolean isVersionable = false;
    private IMetadataProperties versionableProperties = null;

    private Metadata() {
        this.isVersionableMetadataCompliant();
    }

    public Metadata(File sourceFile) throws FileNotFoundException, IOException, FileSystemException {
        this();
        this.sourceFile = sourceFile;
        if (this.isVersionable) {
            this.init30(sourceFile);
        } else {
            this.init(sourceFile);
        }
    }

    public Metadata(String sourcePath, boolean isFolder) throws FileNotFoundException, IOException, FileSystemException {
        this();
        this.sourceFile = new File(sourcePath);
        this.isFolderMetadata = isFolder;
        if (this.isVersionable) {
            this.init30(this.sourceFile);
        } else {
            this.init(this.sourceFile);
        }
    }

    public Metadata(URI resourceURI, boolean isFolder) throws FileNotFoundException, IOException, FileSystemException {
        this();
        this.isFolderMetadata = isFolder;
        this.init30(resourceURI);
    }

    private void isVersionableMetadataCompliant() {
        this.isVersionable = true;
    }

    private void init(File sourceFile) throws FileNotFoundException, IOException {
        this.properties = new Properties();
        this.metadataFile = this.getMetadataFile(sourceFile);
        if (this.metadataFile != null) {
            this.metadataFileStream = new FileInputStream(this.metadataFile);
            DataInputStream dataIn = new DataInputStream(this.metadataFileStream);
            byte[] bytes = new byte[(int)this.metadataFile.length()];
            dataIn.readFully(bytes);
            dataIn.close();
            this.metadataFileStream.close();
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
            this.properties.load(bytesIn);
            bytesIn.close();
        }
    }

    private void init30(File sourceFile) throws FileSystemException {
        Object eclipseResource = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path sourceFilePath = new Path(sourceFile.getPath());
        eclipseResource = this.isFolderMetadata ? root.getContainerForLocation((IPath)sourceFilePath) : root.getFileForLocation((IPath)sourceFilePath);
        if (eclipseResource != null) {
            this.sourceShareable = (IShareable)eclipseResource.getAdapter(IShareable.class);
            if (this.sourceShareable != null) {
                this.versionableProperties = this.sourceShareable.getMetadataProperties((IProgressMonitor)new NullProgressMonitor());
            } else {
                System.err.println(Messages.Metadata_CANNOT_ADAPT);
            }
        } else {
            System.err.print(NLS.bind((String)Messages.Metadata_CANNOT_RESOLVE, (Object)sourceFilePath.toOSString()));
        }
    }

    private void init30(URI resourceURI) throws FileSystemException {
        IContainer eclipseResource = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (this.isFolderMetadata) {
            IContainer[] containers = root.findContainersForLocationURI(resourceURI);
            eclipseResource = containers[0];
        } else {
            IFile[] files = root.findFilesForLocationURI(resourceURI);
            eclipseResource = files[0];
        }
        if (eclipseResource != null) {
            this.sourceShareable = (IShareable)eclipseResource.getAdapter(IShareable.class);
            if (this.sourceShareable != null) {
                this.versionableProperties = this.sourceShareable.getMetadataProperties((IProgressMonitor)new NullProgressMonitor());
            } else {
                System.err.println(Messages.Metadata_CANNOT_ADAPT);
            }
        } else {
            System.err.print(NLS.bind((String)Messages.Metadata_CANNOT_RESOLVE, (Object)resourceURI.toString()));
        }
    }

    private File getMetadataFile(File sourceFile) throws FileNotFoundException, IOException {
        File projectRoot = null;
        File metadataFile = null;
        String metadataDirectoryPath = this.isFolderMetadata ? new String(".properties") : new String(String.valueOf(sourceFile.getName()) + ".properties");
        try {
            File parentFile = this.isFolderMetadata ? sourceFile : sourceFile.getParentFile();
            String parentFileName = "";
            do {
                if (parentFile == null) continue;
                parentFileName = parentFile.getName();
                metadataDirectoryPath = String.valueOf(parentFileName) + File.separator + metadataDirectoryPath;
                parentFile = parentFile.getParentFile();
            } while (parentFile != null && !parentFileName.equalsIgnoreCase("zOSsrc") && !parentFileName.equalsIgnoreCase("zOSout"));
            projectRoot = parentFile;
            if (this.isFolderMetadata && projectRoot.getName().equalsIgnoreCase(".antzBuild")) {
                projectRoot = projectRoot.getParentFile();
            }
        }
        catch (NullPointerException e) {
            Object parentFile = null;
        }
        if (projectRoot != null) {
            File metadataParentFile = null;
            metadataDirectoryPath = String.valueOf(projectRoot.getPath()) + File.separator + ".antzBuild" + File.separator + metadataDirectoryPath;
            metadataFile = new File(metadataDirectoryPath);
            metadataParentFile = metadataFile.getParentFile();
            if (metadataParentFile != null && !metadataParentFile.exists()) {
                metadataParentFile.mkdirs();
            }
            metadataFile.createNewFile();
        }
        return metadataFile;
    }

    public String getDefaultProperty(String metadataKey) {
        return this.getProperty(metadataKey);
    }

    public List<String> getDefaultProperties(String metadataKey) {
        String rawString = this.getDefaultProperty(metadataKey);
        String[] splitStrings = rawString.split("[ \t\r\n]*,[ \t\r\n]*");
        List<String> stringList = Arrays.asList(splitStrings);
        return stringList;
    }

    public String getProperty(String metadataKey) {
        if (this.isVersionable) {
            if (this.versionableProperties != null) {
                Map propertyMap = this.versionableProperties.getCurrentProperties();
                return propertyMap != null ? (String)propertyMap.get(metadataKey) : null;
            }
            return null;
        }
        return this.properties != null ? this.properties.getProperty(metadataKey) : null;
    }

    public List<String> getProperties(String metadataKey) {
        String rawString = this.getProperty(metadataKey);
        List<String> stringList = null;
        if (rawString != null) {
            String[] splitStrings = rawString.split("[ \t\r\n]*,[ \t\r\n]*");
            stringList = Arrays.asList(splitStrings);
        }
        return stringList;
    }

    public Properties getAllProperties() {
        Properties returnProperties = null;
        if (this.metadataFile != null) {
            returnProperties = new Properties();
            if (!this.isFolderMetadata && this.metadataFile.exists()) {
                String parentFileName;
                File parentFile = this.metadataFile.getParentFile();
                String string = parentFileName = parentFile != null ? parentFile.getName() : new String("");
                if (!parentFileName.equalsIgnoreCase("zOSsrc") && !parentFileName.equalsIgnoreCase("zOSout")) {
                    IMetadata parentMetadata = MetadataFactory.getInstance().getContainerMetadata(parentFile.getAbsolutePath());
                    Properties parentProperties = parentMetadata.getAllProperties();
                    returnProperties.putAll((Map<?, ?>)parentProperties);
                }
            }
            if (this.metadataFile.exists() && this.metadataFile.canRead()) {
                FileInputStream fileMetadata = null;
                try {
                    fileMetadata = new FileInputStream(this.metadataFile);
                    returnProperties.load(fileMetadata);
                    fileMetadata.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return returnProperties;
    }

    @Override
    protected void setClientProperty(String metadataKey, String metadataValue) {
        if (this.isVersionable) {
            try {
                try {
                    IChangePropertiesOperation operation = IOperationFactory.instance.getChangePropertiesOperation(new ChangePropertiesDilemmaHandler());
                    Map propertyMap = this.versionableProperties.getCurrentProperties();
                    HashMap<String, String> newPropertyMap = new HashMap<String, String>();
                    newPropertyMap.putAll(propertyMap);
                    if (metadataValue.equalsIgnoreCase("")) {
                        newPropertyMap.remove(metadataKey);
                    } else {
                        newPropertyMap.put(metadataKey, metadataValue);
                    }
                    operation.setProperties(this.sourceShareable, newPropertyMap);
                    operation.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                    try {
                        this.versionableProperties = this.sourceShareable.getMetadataProperties((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (FileSystemException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    this.versionableProperties = this.sourceShareable.getMetadataProperties((IProgressMonitor)new NullProgressMonitor());
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (metadataValue.equalsIgnoreCase("")) {
                this.properties.remove(metadataKey);
            } else {
                this.properties.setProperty(metadataKey, metadataValue);
            }
            FileOutputStream fileOutputStream = null;
            if (this.metadataFile != null && this.metadataFile.exists() && this.metadataFile.canWrite()) {
                try {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    this.properties.store(byteOut, null);
                    byteOut.close();
                    fileOutputStream = new FileOutputStream(this.metadataFile);
                    fileOutputStream.write(byteOut.toByteArray());
                    fileOutputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean delete() {
        File metadataParentFile = null;
        boolean deleteResult = false;
        boolean fileDeleteResult = false;
        boolean directoryDeleteResult = false;
        if (this.metadataFile != null) {
            metadataParentFile = this.metadataFile.getParentFile();
            if (this.metadataFile.exists()) {
                try {
                    if (this.metadataFileStream != null) {
                        this.metadataFileStream.close();
                    }
                }
                catch (IOException e) {
                    return false;
                }
                fileDeleteResult = this.metadataFile.delete();
            } else {
                fileDeleteResult = true;
            }
            if (metadataParentFile != null) {
                if (metadataParentFile.exists()) {
                    if (metadataParentFile.isDirectory()) {
                        directoryDeleteResult = metadataParentFile.listFiles().length > 0 ? true : metadataParentFile.delete();
                    }
                } else {
                    directoryDeleteResult = true;
                }
            }
            deleteResult = fileDeleteResult && directoryDeleteResult;
        }
        return deleteResult;
    }

    public IValidator getValidator(String metadataKey) {
        IConfigurationElement metadataElement = MetadataFactory.getInstance().getExtensionElement(metadataKey);
        try {
            if (metadataElement != null) {
                return (IValidator)metadataElement.createExecutableExtension("validatorClass");
            }
            return MetadataFactory.getInstance().getDefaultMetadataValidator();
        }
        catch (CoreException ce) {
            return MetadataFactory.getInstance().getDefaultMetadataValidator();
        }
        catch (ClassCastException cc) {
            return MetadataFactory.getInstance().getDefaultMetadataValidator();
        }
    }
}

