/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.client;

import com.ibm.team.enterprise.common.common.AntzBuildNature;
import com.ibm.team.enterprise.common.common.IMetadata;
import com.ibm.team.enterprise.common.common.RdzLocalNature;
import com.ibm.team.enterprise.common.common.ZComponentException;
import com.ibm.team.enterprise.common.common.ZComponentNature;
import com.ibm.team.enterprise.internal.common.client.nls.Messages;
import com.ibm.teamz.client.RTCzMetadataFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ZComponentFactory {
    private static List<String> defaultNatures = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(AntzBuildNature.ID);
            this.add(ZComponentNature.ID);
            this.add(RdzLocalNature.ID);
        }
    };

    public static IProject createZComponentProject(String projectName, List<String> natures, IProgressMonitor monitor) throws ZComponentException {
        return ZComponentFactory.createZComponentProject(projectName, natures, true, monitor);
    }

    public static IProject createZComponentProject(String projectName, List<String> natures, boolean buildXml, IProgressMonitor monitor) throws ZComponentException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (natures == null) {
            natures = defaultNatures;
        } else {
            natures.add(ZComponentNature.ID);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ZComponentFactory.validateName(projectName, 4);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            throw new ZComponentException(NLS.bind((String)Messages.ZComponent_PROJECT_ALREADY_EXISTS, (Object)projectName));
        }
        IProjectDescription description = workspace.newProjectDescription(project.getName());
        description.setName(projectName);
        description.setNatureIds(natures.toArray(new String[natures.size()]));
        try {
            IFile xmlFile;
            project.create(description, monitor);
            project.open(monitor);
            IFolder resource = project.getFolder("zOSsrc");
            if (!resource.exists()) {
                resource.create(true, true, monitor);
            }
            if (buildXml && !(xmlFile = project.getFile("build.xml")).exists()) {
                byte[] bytes;
                try {
                    bytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project name=\"SAMPLE\" default=\"all\" xmlns:antz=\"antlib:com.ibm.team.enterprise.zos.build.ant\" \n\txmlns:rsel=\"antlib:org.apache.tools.ant.types.resources.selectors\">\n\t<description>EWM EE sample build</description>\n\n\t<taskdef name=\"startBuildActivity\"\n\t\t classname=\"com.ibm.team.build.ant.task.StartBuildActivityTask\" />\n\t<taskdef name=\"artifactFilePublisher\"\n\t\t classname=\"com.ibm.team.build.ant.task.ArtifactFilePublisherTask\" />\n\n\t<import file=\"${team.enterprise.scm.fetchDestination}/macrodefs.xml\"/>\n\n\t<!-- Compile all source files with data set names that -->\t<!-- do not end with 'LINK'. The sample script assumes -->\t<!-- data sets that ends in 'LINK' are link-edit input -->\t<!-- files.                                            -->\t<target name=\"compile\" description=\"Compile\">\n\t\t<startBuildActivity label=\"Compile\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:not>\n\t\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t\t</rsel:not>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t   \n\t<!-- Link-Edit -->\n\t<target name=\"linkedit\" description=\"Link-Edit\">\n\t\t<startBuildActivity label=\"Link-Edit\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t\n\t<!-- Build -->\n\t<target name=\"all\" depends=\"compile,linkedit\" description=\"Build\"/>\n\t\n</project>\n".getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    bytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project name=\"SAMPLE\" default=\"all\" xmlns:antz=\"antlib:com.ibm.team.enterprise.zos.build.ant\" \n\txmlns:rsel=\"antlib:org.apache.tools.ant.types.resources.selectors\">\n\t<description>EWM EE sample build</description>\n\n\t<taskdef name=\"startBuildActivity\"\n\t\t classname=\"com.ibm.team.build.ant.task.StartBuildActivityTask\" />\n\t<taskdef name=\"artifactFilePublisher\"\n\t\t classname=\"com.ibm.team.build.ant.task.ArtifactFilePublisherTask\" />\n\n\t<import file=\"${team.enterprise.scm.fetchDestination}/macrodefs.xml\"/>\n\n\t<!-- Compile all source files with data set names that -->\t<!-- do not end with 'LINK'. The sample script assumes -->\t<!-- data sets that ends in 'LINK' are link-edit input -->\t<!-- files.                                            -->\t<target name=\"compile\" description=\"Compile\">\n\t\t<startBuildActivity label=\"Compile\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:not>\n\t\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t\t</rsel:not>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t   \n\t<!-- Link-Edit -->\n\t<target name=\"linkedit\" description=\"Link-Edit\">\n\t\t<startBuildActivity label=\"Link-Edit\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t\n\t<!-- Build -->\n\t<target name=\"all\" depends=\"compile,linkedit\" description=\"Build\"/>\n\t\n</project>\n".getBytes();
                }
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                xmlFile.create((InputStream)is, true, monitor);
            }
            project.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            throw new ZComponentException((Throwable)e);
        }
        return project;
    }

    public static IFolder createZFolder(String projectName, String zFolderName, Properties properties, IProgressMonitor monitor) throws ZComponentException {
        String subfolder = "zOSsrc";
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ZComponentFactory.validateName(projectName, 4);
        ZComponentFactory.validateName(zFolderName, 2);
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(projectName);
            if (!project.hasNature(ZComponentNature.ID)) {
                throw new ZComponentException(Messages.bind((String)Messages.ZComponent_PROJECT_NOT_ZCOMPONENT, (Object)zFolderName));
            }
            IFolder resourceFolder = project.getFolder(subfolder);
            if (resourceFolder == null || !resourceFolder.exists()) {
                resourceFolder.create(true, true, monitor);
            }
            IFolder zFolder = resourceFolder.getFolder(zFolderName);
            zFolder.create(true, true, monitor);
            if (properties != null) {
                IMetadata metadata = RTCzMetadataFactory.getInstance().getBuildzMetadata((IResource)zFolder);
                metadata.setProperties(properties);
            }
            project.refreshLocal(2, monitor);
            return zFolder;
        }
        catch (CoreException ce) {
            throw new ZComponentException((Throwable)ce);
        }
    }

    public static IFile createZFile(String projectName, String zFolderName, String zFileName, IProgressMonitor progressMonitor) throws ZComponentException {
        return ZComponentFactory.createZFile(projectName, zFolderName, zFileName, null, progressMonitor);
    }

    public static IFile createZFile(String projectName, String zFolderName, String zFileName, Properties properties, IProgressMonitor monitor) throws ZComponentException {
        return ZComponentFactory.createZFile(projectName, zFolderName, zFileName, properties, true, monitor);
    }

    public static IFile createZFile(String projectName, String zFolderName, String zFileName, Properties properties, boolean refresh, IProgressMonitor monitor) throws ZComponentException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ZComponentFactory.validateName(projectName, 4);
        ZComponentFactory.validateName(zFolderName, 2);
        ZComponentFactory.validateName(zFileName, 1);
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(projectName);
            if (!project.hasNature(ZComponentNature.ID)) {
                throw new ZComponentException(Messages.bind((String)Messages.ZComponent_PROJECT_NOT_ZCOMPONENT, (Object)zFileName));
            }
            IFolder resourceFolder = project.getFolder("zOSsrc");
            if (resourceFolder == null || !resourceFolder.exists()) {
                resourceFolder.create(true, true, monitor);
            }
            IFolder zFolder = resourceFolder.getFolder(zFolderName);
            IFile zFile = zFolder.getFile(zFileName);
            zFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
            if (properties != null) {
                IMetadata metadata = RTCzMetadataFactory.getInstance().getBuildzMetadata((IResource)zFile);
                metadata.setProperties(properties);
            }
            if (refresh) {
                project.refreshLocal(2, monitor);
            }
            return zFile;
        }
        catch (CoreException ce) {
            throw new ZComponentException((Throwable)ce);
        }
    }

    public static IFile createZFileWithoutRefreshing(String projectName, String zFolderName, String zFileName, Properties properties, IProgressMonitor monitor) throws ZComponentException {
        return ZComponentFactory.createZFile(projectName, zFolderName, zFileName, properties, false, monitor);
    }

    public static void validateProjectName(String name) throws ZComponentException {
        ZComponentFactory.validateName(name, 4);
    }

    public static void validateFolderName(String name) throws ZComponentException {
        ZComponentFactory.validateName(name, 2);
    }

    public static void validateFileName(String name) throws ZComponentException {
        ZComponentFactory.validateName(name, 1);
    }

    public static void validateName(String name, int resourceType) throws ZComponentException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String errorMsg = "";
        IStatus nameStatus = workspace.validateName(name, resourceType);
        if (!nameStatus.isOK()) {
            switch (resourceType) {
                case 4: {
                    errorMsg = NLS.bind((String)Messages.ZComponent_PROJECT_NAME_INVALID, (Object)name, (Object)nameStatus.getMessage());
                    break;
                }
                case 2: {
                    errorMsg = NLS.bind((String)Messages.ZComponent_ZFOLDER_NAME_INVALID, (Object)name, (Object)nameStatus.getMessage());
                    break;
                }
                case 1: {
                    errorMsg = NLS.bind((String)Messages.ZComponent_ZFILE_NAME_INVALID, (Object)name, (Object)nameStatus.getMessage());
                }
            }
            throw new ZComponentException(errorMsg, nameStatus);
        }
        if (name.indexOf(32) > -1) {
            switch (resourceType) {
                case 4: {
                    errorMsg = NLS.bind((String)Messages.ZComponent_PROJECT_NAME_INVALID, (Object)name, (Object)Messages.ZComponent_INVALID_SPACE_IN_ZCOMPONENT_PROJECT);
                    break;
                }
                case 2: {
                    errorMsg = NLS.bind((String)Messages.ZComponent_ZFOLDER_NAME_INVALID, (Object)name, (Object)Messages.ZComponent_INVALID_SPACE_IN_ZFOLDER);
                    break;
                }
                case 1: {
                    errorMsg = NLS.bind((String)Messages.ZComponent_ZFILE_NAME_INVALID, (Object)name, (Object)Messages.ZComponent_INVALID_SPACE_IN_ZFILE);
                }
            }
            throw new ZComponentException(errorMsg);
        }
    }
}

