/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.build.ui.utils;

import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.internal.build.ui.utils.LanguageDefinitionContentProvider;
import com.ibm.teamz.internal.build.ui.utils.LanguageDefinitionLabelProvider;
import com.ibm.teamz.internal.build.ui.utils.Messages;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class LanguageDefinitionSelectionDialog
extends ElementTreeSelectionDialog {
    private final ViewerFilter fFilter;

    public LanguageDefinitionSelectionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea) throws TeamRepositoryException {
        this(parentShell, teamRepository, projectArea, null, false);
    }

    public LanguageDefinitionSelectionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea, boolean allowMultipleSelection) throws TeamRepositoryException {
        this(parentShell, teamRepository, projectArea, null, allowMultipleSelection);
    }

    public LanguageDefinitionSelectionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea, ViewerFilter filter) throws TeamRepositoryException {
        this(parentShell, teamRepository, projectArea, filter, false);
    }

    public LanguageDefinitionSelectionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea, ViewerFilter filter, boolean allowMultipleSelection) throws TeamRepositoryException {
        super(parentShell, (ILabelProvider)new LanguageDefinitionLabelProvider(), (ITreeContentProvider)new LanguageDefinitionContentProvider(teamRepository));
        this.setTitle(Messages.LanguageDefinitionSelectionDialog_TITLE);
        this.setMessage(Messages.LanguageDefinitionSelectionDialog_DESCRIPTION);
        this.setAllowMultiple(allowMultipleSelection);
        this.setValidator(this.getSelectionValidator());
        if (projectArea != null) {
            this.setInput(projectArea);
        } else {
            this.setInput(teamRepository);
        }
        this.fFilter = filter;
    }

    private ISelectionStatusValidator getSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length >= 1) {
                    if (selection[0] instanceof ILanguageDefinition) {
                        return new Status(0, "com.ibm.teamz.build.ui", "");
                    }
                } else if (selection.length == 0) {
                    return new Status(4, "com.ibm.teamz.build.ui", "");
                }
                return new Status(4, "com.ibm.teamz.build.ui", "");
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        if (this.fFilter != null) {
            this.addFilter(this.fFilter);
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        return composite;
    }

    public ILanguageDefinition getSelectedLanguageDefinition() {
        return (ILanguageDefinition)this.getFirstResult();
    }

    public ILanguageDefinition[] getSelectedLanguageDefinitions() {
        Object[] rawResults = this.getResult();
        ILanguageDefinition[] langDefResults = Arrays.asList(rawResults).toArray(new ILanguageDefinition[1]);
        return langDefResults;
    }
}

