/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.build.ui.utils;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.internal.build.ui.TeamzBuildUIPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class LanguageDefinitionContentProvider
implements ITreeContentProvider,
IDeferredWorkbenchAdapter {
    private TreeViewer fTreeViewer = null;
    private final ITeamRepository fTeamRepository;
    private DeferredTreeContentManager fDeferredTreeManager;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Object rootElement;
    private Object[] children;
    private boolean fFetchInProgress;

    public LanguageDefinitionContentProvider(ITeamRepository repo) {
        this.fTeamRepository = repo;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ITeamRepository || parentElement instanceof IProjectArea) {
            if (parentElement == this.rootElement && this.children != null) {
                return new Object[0];
            }
            if (this.getContentManager() != null) {
                this.children = this.getContentManager().getChildren(parentElement);
                this.rootElement = parentElement;
                return this.children;
            }
            return new Object[]{IZosLanguageDefinition.ITEM_TYPE.createItem()};
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof ITeamRepository || element instanceof IProjectArea;
    }

    public Object[] getElements(Object root) {
        return this.getChildren(root);
    }

    public void dispose() {
        this.fDeferredTreeManager = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.fTreeViewer = (TreeViewer)viewer;
        }
    }

    private DeferredTreeContentManager getContentManager() {
        if (this.fDeferredTreeManager == null && this.fTreeViewer != null) {
            this.fDeferredTreeManager = new DeferredTreeContentManager((AbstractTreeViewer)this.fTreeViewer){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (LanguageDefinitionContentProvider.this.hasChildren(element)) {
                        return LanguageDefinitionContentProvider.this;
                    }
                    return super.getAdapter(element);
                }
            };
        }
        return this.fDeferredTreeManager;
    }

    private void getProjectAreas(ITeamRepository repo, IElementCollector collector, IProgressMonitor monitor) {
        try {
            List rawProjectAreas = repo.itemManager().fetchCompleteItems(this.fTeamRepository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, (IProgressMonitor)new NullProgressMonitor());
            ArrayList<IProjectArea> projectAreas = new ArrayList<IProjectArea>(rawProjectAreas.size());
            for (IProjectArea projectArea : rawProjectAreas) {
                if (projectArea == null) continue;
                projectAreas.add(projectArea);
            }
            Collections.sort(projectAreas, new Comparator<IProjectArea>(){

                @Override
                public int compare(IProjectArea o1, IProjectArea o2) {
                    String label1 = o1.getName();
                    String label2 = o2.getName();
                    return label1.compareTo(label2);
                }
            });
            collector.add(projectAreas.toArray(), monitor);
        }
        catch (TeamRepositoryException e) {
            TeamzBuildUIPlugin.log(e);
        }
    }

    private void getLangDefs(IProjectArea projectArea, IElementCollector collector, IProgressMonitor monitor) {
        try {
            ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.fTeamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
            List langDefs = client.findSystemDefinitionsComplete(IZosLanguageDefinition.ITEM_TYPE, (IProjectAreaHandle)projectArea, -1, false, (IProgressMonitor)new NullProgressMonitor());
            collector.add(langDefs.toArray(), monitor);
        }
        catch (TeamRepositoryException e) {
            TeamzBuildUIPlugin.log(e);
        }
    }

    public TreeViewer getFTreeViewer() {
        return this.fTreeViewer;
    }

    public void setFTreeViewer(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object parent, IElementCollector collector, IProgressMonitor monitor) {
        LanguageDefinitionContentProvider languageDefinitionContentProvider = this;
        synchronized (languageDefinitionContentProvider) {
            if (this.fFetchInProgress) {
                return;
            }
            this.fFetchInProgress = true;
        }
        try {
            monitor.beginTask("", 1000);
            if (parent instanceof ITeamRepository) {
                this.getProjectAreas((ITeamRepository)parent, collector, monitor);
            } else if (parent instanceof IProjectArea) {
                this.getLangDefs((IProjectArea)parent, collector, monitor);
            }
        }
        finally {
            monitor.done();
            this.fFetchInProgress = false;
        }
    }

    public ISchedulingRule getRule(Object arg0) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object arg0) {
        return null;
    }

    public String getLabel(Object obj) {
        if (obj instanceof ITeamRepository) {
            return ((ITeamRepository)obj).getName();
        }
        if (obj instanceof IProjectArea) {
            return ((IProjectArea)obj).getName();
        }
        return obj.toString();
    }
}

