/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.build.ui.utils;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.teamz.internal.build.ui.nls.Messages;
import com.ibm.teamz.internal.build.ui.utils.BuildableFilesNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildUtils {
    public static IWorkspaceConnection getWorkspaceConnection(ITeamRepository repo, IWorkspaceHandle workspace, IProgressMonitor progress) throws TeamRepositoryException {
        return SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspace, progress);
    }

    public static IWorkspace getWorkspaceFromUUID(String workspaceUUID, ITeamRepository repository) throws TeamRepositoryException {
        UUID workspaceUuid = null;
        try {
            workspaceUuid = UUID.valueOf((String)workspaceUUID);
        }
        catch (IllegalArgumentException exception) {
            throw new TeamRepositoryException(exception.getMessage(), (Throwable)exception);
        }
        return BuildUtils.getWorkspaceFromUUID(workspaceUuid, repository);
    }

    public static IWorkspace getWorkspaceFromUUID(UUID workspaceUuid, ITeamRepository repository) throws TeamRepositoryException {
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
        IItem item = repository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, (IProgressMonitor)new NullProgressMonitor());
        return (IWorkspace)item;
    }

    public static List<IComponentHandle> getAllComponentHandles(IWorkspaceConnection wksConn, IProgressMonitor progress) throws TeamRepositoryException {
        wksConn.refresh(progress);
        return wksConn.getComponents();
    }

    public static BuildableFilesNode createBuildableFilesTree(ITeamRepository repo, IWorkspaceHandle workspaceHandle, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspace stream = BuildUtils.getWorkspaceStream(workspaceHandle, repo);
        IWorkspace workspace = stream != null ? stream : workspaceHandle;
        IWorkspaceConnection connection = BuildUtils.getWorkspaceConnection(repo, (IWorkspaceHandle)workspace, progress);
        BuildableFilesNode tree = BuildableFilesNode.createTreeNode(null);
        List<IComponentHandle> componentHandles = BuildUtils.getAllComponentHandles(connection, progress);
        for (IComponentHandle componentHandle : componentHandles) {
            IConfiguration config = connection.configuration(componentHandle);
            if (config == null) continue;
            IComponent currentComponent = (IComponent)config.teamRepository().itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, progress);
            BuildableFilesNode componentTree = BuildableFilesNode.createTreeNode(currentComponent.getName());
            tree.getChildren().add(componentTree);
            Map projectMap = config.childEntriesForRoot(progress);
            if (projectMap == null) continue;
            BuildUtils.processProjects(repo, componentTree, projectMap, config, progress);
        }
        return tree;
    }

    public static void processProjects(ITeamRepository repo, BuildableFilesNode componentTree, Map projectMap, IConfiguration config, IProgressMonitor progress) throws TeamRepositoryException {
        List projects = config.fetchCompleteItems(new ArrayList(projectMap.values()), progress);
        for (IVersionable project : projects) {
            if (!(project instanceof IFolderHandle)) continue;
            BuildableFilesNode projectTree = BuildableFilesNode.createTreeNode(project.getName());
            componentTree.getChildren().add(projectTree);
            BuildUtils.processFolders(repo, projectTree, (IFolderHandle)project, config, progress);
        }
    }

    public static void processFolders(ITeamRepository repo, BuildableFilesNode projectTree, IFolderHandle project, IConfiguration config, IProgressMonitor progress) throws TeamRepositoryException {
        List<IVersionable> folders = BuildUtils.getProjectFolders(project, config, progress);
        for (IVersionable folder : folders) {
            BuildableFilesNode folderTree = BuildableFilesNode.createTreeNode(folder.getName());
            projectTree.getChildren().add(folderTree);
            BuildUtils.processFiles(repo, folderTree, (IFolderHandle)folder, config, progress);
        }
    }

    public static void processFiles(ITeamRepository repo, BuildableFilesNode folderTree, IFolderHandle folder, IConfiguration config, IProgressMonitor progress) throws TeamRepositoryException {
        List<IVersionable> files = BuildUtils.getFiles(folder, config, progress);
        for (IVersionable file : files) {
            String langDefUUID = BuildUtils.getLanguageDefinitionUUID(file);
            ILanguageDefinition langDef = null;
            try {
                ISystemDefinitionModelClient sysDefClient = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
                if (langDefUUID != null) {
                    langDef = (ILanguageDefinition)sysDefClient.findSystemDefinition(langDefUUID, null, ILanguageDefinition.ITEM_TYPE, progress);
                } else if (file instanceof IFileItemHandle) {
                    langDef = sysDefClient.getDefaultLanguageDefinition(file.getName(), progress);
                }
                if (langDef == null || langDef.getTranslators() == null || langDef.getTranslators().size() <= 0) continue;
                folderTree.getChildren().add(BuildableFilesNode.createLeafNode(file.getName(), file.getItemId().getUuidValue(), config.component().getItemId().getUuidValue()));
            }
            catch (ItemNotFoundException infe) {
                String label = String.valueOf(file.getName()) + " - " + Messages.BuildUtils_ERROR_LANG_DEF_NOT_FOUND;
                folderTree.getChildren().add(BuildableFilesNode.createErrorNode(label, file.getItemId().getUuidValue(), config.component().getItemId().getUuidValue()));
            }
        }
    }

    public static List<IVersionable> getProjectFolders(IFolderHandle project, IConfiguration configuration, IProgressMonitor progress) throws TeamRepositoryException {
        IFolderHandle zOSsrc;
        ArrayList<IVersionable> folders = new ArrayList<IVersionable>();
        if (project instanceof IFolderHandle && (zOSsrc = BuildUtils.getChildFolderHandle("zOSsrc", project, configuration, progress)) != null) {
            Map srcFolderMap = configuration.childEntries(zOSsrc, progress);
            List children = configuration.fetchCompleteItems(new ArrayList(srcFolderMap.values()), progress);
            for (IVersionable child : children) {
                if (!(child instanceof IFolderHandle)) continue;
                folders.add(child);
            }
        }
        return folders;
    }

    public static IFolderHandle getChildFolderHandle(String child, IFolderHandle parentFolder, IConfiguration config, IProgressMonitor progress) throws TeamRepositoryException {
        Map entries = config.childEntries(parentFolder, progress);
        if (entries == null) {
            return null;
        }
        IVersionableHandle folder = (IVersionableHandle)entries.get(child);
        if (folder instanceof IFolderHandle) {
            return (IFolderHandle)folder;
        }
        return null;
    }

    public static List<IVersionable> getFiles(IFolderHandle folder, IConfiguration configuration, IProgressMonitor progress) throws TeamRepositoryException {
        ArrayList<IVersionable> files = new ArrayList<IVersionable>();
        Map folderMap = configuration.childEntries(folder, progress);
        List children = configuration.fetchCompleteItems(new ArrayList(folderMap.values()), progress);
        for (IVersionable child : children) {
            if (!(child instanceof IFileItemHandle)) continue;
            files.add(child);
        }
        return files;
    }

    public static String getLanguageDefinitionUUID(IVersionable file) {
        Map properties = file.getUserProperties();
        return (String)properties.get("team.enterprise.language.definition");
    }

    public static ITeamRepository getTeamRepository(String uri, final String username, final String password) throws TeamRepositoryException {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(uri);
        repo.registerLoginHandler(new ITeamRepository.ILoginHandler(){

            public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                return new ITeamRepository.ILoginHandler.ILoginInfo(){

                    public String getUserId() {
                        return username;
                    }

                    public String getPassword() {
                        return password;
                    }
                };
            }
        });
        repo.login(null);
        return repo;
    }

    public static IWorkspace getWorkspaceFromName(String workspaceName, ITeamRepository repository) throws TeamRepositoryException {
        try {
            UUID.valueOf((String)workspaceName);
            BuildUtils.getWorkspaceFromUUID(workspaceName, repository);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArrayList workspaceHandles = new ArrayList();
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setExactName(workspaceName);
        List foundWorkspaceHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).findWorkspaces(criteria, Integer.MAX_VALUE, null);
        workspaceHandles.addAll(foundWorkspaceHandles);
        ArrayList<IWorkspace> workspaces = new ArrayList<IWorkspace>();
        if (workspaceHandles.size() > 0) {
            List fetchedWorkspaces = repository.itemManager().fetchCompleteItems(workspaceHandles, 0, null);
            for (IWorkspace workspace : fetchedWorkspaces) {
                if (workspace == null || workspace.isStream()) continue;
                workspaces.add(workspace);
            }
        }
        if (workspaces.size() > 0) {
            return (IWorkspace)workspaces.get(0);
        }
        return null;
    }

    private static String getFileExtension(String fileName) {
        String rc = fileName;
        int idx = rc.lastIndexOf(46);
        if (idx > -1) {
            rc = rc.substring(idx + 1);
            return rc;
        }
        return null;
    }

    public static IWorkspace getWorkspaceStream(IWorkspaceHandle workspaceHandle, ITeamRepository repo) throws TeamRepositoryException {
        IWorkspace flowTarget;
        IWorkspaceHandle flowTargetHandle;
        UUID defaultFlow;
        IWorkspace workspace = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, null);
        if (workspace.isStream()) {
            return workspace;
        }
        IWorkspace stream = null;
        Workspace ws = (Workspace)workspace;
        CurrentFlows flows = ws.getCurrentFlows();
        if (flows != null && (defaultFlow = flows.getDefaultAcceptFlow()) != null && (flowTargetHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(defaultFlow, null)) != null && (flowTarget = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)flowTargetHandle, 0, null)).isStream()) {
            stream = flowTarget;
        }
        return stream;
    }
}

