/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.build.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wizards.newworkspace.NewWorkspaceWizard;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.teamz.internal.build.ui.nls.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FileAgentJazzScmConfigurationEditor
extends AbstractConfigurationElementEditor {
    private FormToolkit toolkit;
    private IBuildDefinition buildDefinitionWorkingCopy;
    protected Hyperlink workspaceTitleHyperlink;
    protected Color enabledHyperlinkForegroundColor;
    protected Color disabledHyperlinkForegroundColor;
    protected Text workspaceNameText;
    protected Button acceptBeforeFetchButton;
    protected Button buildOnlyIfChangesButton;
    protected Button selectWorkspaceButton;
    protected Button createWorkspaceButton;
    protected Button deleteLoadDirectoryButton;
    protected IWorkspace workspace;
    protected Text fetchDestinationText;
    protected Text datasetPrefixText;
    private static final String WORKSPACE_FLOW_WARNING_ID = "workspace.flow.warning";

    public FileAgentJazzScmConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        this.createWorkspaceNameWidgets(parent);
        this.createLoadOptionsWidgets(parent);
        this.createAcceptOptionsWidgets(parent);
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.buildDefinitionWorkingCopy = definition;
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.workspaceNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.workspaceNameText, Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_REQUIRED, (Control)this.workspaceNameText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.workspaceNameText, (Control)this.workspaceNameText);
        }
        if (this.fetchDestinationText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fetchDestinationText, Messages.FileAgentJazzScmConfigurationEditor_LOAD_DIRECTORY_REQUIRED, (Control)this.fetchDestinationText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fetchDestinationText, (Control)this.fetchDestinationText);
        }
        if (this.datasetPrefixText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.datasetPrefixText, Messages.FileAgentJazzScmConfigurationEditor_DATASET_PREFIX_REQUIRED, (Control)this.datasetPrefixText);
            isValid = false;
        } else {
            MappingValidation validation = new MappingValidation();
            int validationStatus = validation.isValidDSName(this.datasetPrefixText.getText());
            if (validationStatus != 0) {
                this.addErrorMessage(this.datasetPrefixText, validation.getNamingErrorMessage(validationStatus), (Control)this.datasetPrefixText);
                isValid = false;
            } else {
                this.removeErrorMessage(this.datasetPrefixText, (Control)this.datasetPrefixText);
            }
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private void createWorkspaceNameWidgets(Composite parent) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(Messages.FileAgentJazzScmConfigurationEditor_SECTION_TEXT_REPOSITORY);
        section.setDescription(Messages.FileAgentJazzScmConfigurationEditor_REPOSITORY_DESCRIPTION);
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.workspaceTitleHyperlink = this.toolkit.createHyperlink(composite, Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_LABEL, 0);
        this.workspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.enabledHyperlinkForegroundColor = this.workspaceTitleHyperlink.getForeground();
        this.workspaceTitleHyperlink.setLayoutData((Object)new TableWrapData());
        this.workspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.workspaceNameText = this.toolkit.createText(composite, "", 0);
        this.disabledHyperlinkForegroundColor = this.workspaceNameText.getForeground();
        this.workspaceNameText.setEnabled(false);
        this.workspaceNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.workspaceNameText.setLayoutData((Object)layoutData);
        this.selectWorkspaceButton = this.toolkit.createButton(composite, Messages.FileAgentJazzScmConfigurationEditor_SELECT_WORKSPACE_BUTTON_TITLE, 0);
        this.selectWorkspaceButton.addSelectionListener(this.getSelectWorkspaceListener());
        this.selectWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.createWorkspaceButton = this.toolkit.createButton(composite, Messages.FileAgentJazzScmConfigurationEditor_CREATE_WORKSPACE_BUTTON_TITLE, 0);
        this.createWorkspaceButton.addSelectionListener(this.getCreateWorkspaceListener());
        this.createWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.createSpacer(composite, 5, 1);
        Label label = this.toolkit.createLabel(composite, NLS.bind((String)Messages.FileAgentJazzScmConfigurationEditor_UUID_PROPERTY, (Object)"teamz.scm.workspaceUUID"), 64);
        label.setForeground(Display.getDefault().getSystemColor(16));
        layoutData = new TableWrapData(2, 32, 1, 3);
        label.setLayoutData((Object)layoutData);
        IBuildProperty property = this.buildDefinitionWorkingCopy.getProperty("teamz.scm.workspaceUUID");
        if (property.getValue().length() == 0) {
            this.setWorkspaceNameText("", false);
            return;
        }
        this.setWorkspaceNameText(Messages.FileAgentJazzScmConfigurationEditor_PENDING, false);
        final IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)property.getValue()), null);
        String jobName = Messages.FileAgentJazzScmConfigurationEditor_FETCHING_JOB_NAME;
        TeamBuildJob job = new TeamBuildJob(jobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                FileAgentJazzScmConfigurationEditor.this.workspace = FileAgentJazzScmConfigurationEditor.this.fetchWorkspace(workspaceHandle, monitor);
                FileAgentJazzScmConfigurationEditor.this.handleUpdateWorkspaceText(FileAgentJazzScmConfigurationEditor.this.workspace.getName());
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    FileAgentJazzScmConfigurationEditor.this.handleFetchFailed(status);
                }
            }
        };
        job.schedule();
    }

    private void createLoadOptionsWidgets(Composite parent) {
        this.createSpacer(parent, 5, 1);
        Section section = this.toolkit.createSection(parent, 450);
        section.setLayoutData((Object)new TableWrapData(128));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(Messages.FileAgentJazzScmConfigurationEditor_SECTION_TEXT_LOAD);
        section.setDescription(Messages.FileAgentJazzScmConfigurationEditor_SECTION_DESC_LOAD);
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.createSpacer(composite, 5, 2);
        IBuildProperty property = this.buildDefinitionWorkingCopy.getProperty("teamz.scm.fetchDestination");
        String description = NLS.bind((String)Messages.FileAgentJazzScmConfiguartionEditor_LOAD_DIRECTORY_DESC, (Object)"teamz.scm.fetchDestination");
        this.fetchDestinationText = this.createLabeledText(composite, Messages.FileAgentJazzScmConfigurationEditor_DESTINATION_LABEL, description, property.getValue());
        this.fetchDestinationText.addModifyListener(this.getFetchDestinationModifiedListener());
        boolean shouldDelete = false;
        property = this.buildDefinitionWorkingCopy.getProperty("teamz.scm.deleteDestinationBeforeFetch");
        if (property != null) {
            shouldDelete = Boolean.valueOf(property.getValue());
        }
        this.deleteLoadDirectoryButton = this.toolkit.createButton(composite, Messages.FileAgentJazzScmConfigurationEditor_DELETE_DESTINATION_DESC, 32);
        this.deleteLoadDirectoryButton.setLayoutData((Object)new TableWrapData(2, 32, 1, 2));
        this.deleteLoadDirectoryButton.setSelection(shouldDelete);
        this.deleteLoadDirectoryButton.addSelectionListener(this.getDeleteBeforeFetchSelectionListener());
        this.deleteLoadDirectoryButton.setEnabled(this.fetchDestinationText.getText().trim().length() > 0);
        this.createSpacer(composite, 5, 2);
        property = this.buildDefinitionWorkingCopy.getProperty("teamz.scm.dataset.prefix");
        description = NLS.bind((String)Messages.FileAgentJazzScmconfigurationEditor_DATASET_PREFIX_DESC, (Object)"teamz.scm.dataset.prefix");
        this.datasetPrefixText = this.createLabeledText(composite, Messages.FileAgentJazzScmConfigurationEditor_DATASET_PREFIX, description, property.getValue());
        this.datasetPrefixText.addModifyListener(this.getDatasetPrefixModifiedListener());
    }

    private void createAcceptOptionsWidgets(Composite parent) {
        this.createSpacer(parent, 15, 1);
        Section section = this.toolkit.createSection(parent, 450);
        section.setLayoutData((Object)new TableWrapData(128));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(Messages.FileAgentJazzScmConfigurationEditor_SECTION_TEXT_ACCEPT);
        section.setDescription(Messages.FileAgentJazzScmConfigurationEditor_SECTION_DESC_ACCEPT);
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        IBuildProperty property = this.buildDefinitionWorkingCopy.getProperty("teamz.scm.acceptBeforeFetch");
        this.acceptBeforeFetchButton = this.toolkit.createButton(composite, NLS.bind((String)Messages.FileAgentJazzScmConfigurationEditor_ACCEPT_DESC, (Object)"teamz.scm.acceptBeforeFetch"), 32);
        TableWrapData layoutData = new TableWrapData(2, 32, 1, 2);
        this.acceptBeforeFetchButton.setLayoutData((Object)layoutData);
        IBuildConfigurationElement dependencyElement = this.buildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teamz.build.dependency");
        if (dependencyElement != null) {
            this.acceptBeforeFetchButton.setSelection(true);
            this.acceptBeforeFetchButton.setEnabled(false);
        } else {
            this.acceptBeforeFetchButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        }
        this.acceptBeforeFetchButton.addSelectionListener(this.getAcceptBeforeFetchSelectionListener());
        property = this.buildDefinitionWorkingCopy.getProperty("teamz.scm.buildOnlyIfChanges");
        this.buildOnlyIfChangesButton = this.toolkit.createButton(composite, NLS.bind((String)Messages.FileAgentJazzScmConfigurationEditor_CHANGES_DESC, (Object)"teamz.scm.buildOnlyIfChanges"), 32);
        layoutData = new TableWrapData(2, 32, 1, 2);
        this.buildOnlyIfChangesButton.setLayoutData((Object)layoutData);
        this.buildOnlyIfChangesButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.buildOnlyIfChangesButton.addSelectionListener(this.getBuildOnlyIfChangesSelectionListener());
        this.buildOnlyIfChangesButton.setEnabled(this.acceptBeforeFetchButton.getSelection());
        this.createSpacer(composite, 5, 2);
        Label label = this.toolkit.createLabel(composite, NLS.bind((String)Messages.FileAgentJazzScmConfigurationEditor_OPTIONS_PROPERTY, (Object)"teamz.scm.acceptBeforeFetch", (Object)"teamz.scm.buildOnlyIfChanges"), 64);
        label.setForeground(Display.getDefault().getSystemColor(16));
        layoutData = new TableWrapData(2, 32, 1, 2);
        label.setLayoutData((Object)layoutData);
    }

    protected IHyperlinkListener getWorkspaceHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FileAgentJazzScmConfigurationEditor.this.openWorkspaceEditor();
            }
        };
    }

    protected void openWorkspaceEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)this.workspace)));
        }
    }

    protected SelectionListener getSelectWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.setWorkspace(FileAgentJazzScmConfigurationEditor.this.openWorkspaceChooserDialog(FileAgentJazzScmConfigurationEditor.this.workspaceTitleHyperlink.getShell(), FileAgentJazzScmConfigurationEditor.this.getTeamRepository()));
            }
        };
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, (boolean)false, null, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    protected SelectionListener getCreateWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.openWorkspaceCreationDialog();
            }
        };
    }

    protected void openWorkspaceCreationDialog() {
        NewWorkspaceWizard wizard = new NewWorkspaceWizard(UIContext.createPartContext((IWorkbenchPart)this), this.getTeamRepository(), false, (IPartResult)new IPartResult<AbstractPlaceWrapper>(){

            public void setResult(AbstractPlaceWrapper result) {
                FileAgentJazzScmConfigurationEditor.this.setWorkspace(result.getWorkspace());
            }
        }, true, (IReadScope)IReadScope.FACTORY.createPublicScope());
        new WizardDialog(this.workspaceTitleHyperlink.getShell(), (IWizard)wizard).open();
    }

    protected void setWorkspace(IWorkspace newWorkspace) {
        if (newWorkspace != null) {
            this.workspace = newWorkspace;
            IBuildProperty property = this.buildDefinitionWorkingCopy.getProperty("teamz.scm.workspaceUUID");
            property.setValue(this.workspace.getItemId().getUuidValue());
            this.setWorkspaceNameText(this.workspace.getName(), true);
            this.validate();
            this.setDirty(true);
            if (this.shouldShowWorkspaceFlowWarning()) {
                this.checkWorkspaceFlow();
            }
        }
    }

    private void checkWorkspaceFlow() {
        Workspace ws = (Workspace)this.workspace;
        CurrentFlows flows = ws.getCurrentFlows();
        if (flows == null || flows.getCurrentDeliverFlow() == null) {
            this.addErrorMessage(WORKSPACE_FLOW_WARNING_ID, Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_FLOW_WARNING_SHORT, (IStatus)new Status(2, "com.ibm.teamz.build.ui", Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_FLOW_WARNING));
        } else {
            this.removeErrorMessage(WORKSPACE_FLOW_WARNING_ID);
        }
    }

    private boolean shouldShowWorkspaceFlowWarning() {
        return this.buildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teamz.build.dependency") != null;
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    protected void handleUpdateWorkspaceText(final String workspaceName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FileAgentJazzScmConfigurationEditor.this.workspaceNameText.isDisposed()) {
                    FileAgentJazzScmConfigurationEditor.this.setWorkspaceNameText(workspaceName, true);
                }
                if (FileAgentJazzScmConfigurationEditor.this.shouldShowWorkspaceFlowWarning()) {
                    FileAgentJazzScmConfigurationEditor.this.checkWorkspaceFlow();
                }
            }
        });
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.toolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    private void setWorkspaceNameText(String text, boolean workspaceSet) {
        this.workspaceNameText.setText(text);
        this.workspaceNameText.setEnabled(workspaceSet);
        this.setWorkspaceTitleHyperlinkEnablement(workspaceSet);
    }

    private void setWorkspaceTitleHyperlinkEnablement(boolean enabled) {
        this.workspaceTitleHyperlink.setForeground(enabled ? this.enabledHyperlinkForegroundColor : this.disabledHyperlinkForegroundColor);
        this.workspaceTitleHyperlink.setUnderlined(enabled);
        this.workspaceTitleHyperlink.setEnabled(enabled);
    }

    private Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.toolkit.createLabel(parent, label);
        Text text = this.toolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.toolkit.createLabel(parent, description, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    protected void handleFetchFailed(final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FileAgentJazzScmConfigurationEditor.this.workspaceNameText.isDisposed()) {
                    String errorMessage = Messages.FileAgentJazzScmConfigurationEditor_ERROR_FETCHING;
                    if (status.getException() instanceof ItemNotFoundException) {
                        errorMessage = Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_DELETED;
                    }
                    FileAgentJazzScmConfigurationEditor.this.setWorkspaceNameText(errorMessage, false);
                }
            }
        });
    }

    private ModifyListener getFetchDestinationModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("teamz.scm.fetchDestination");
                String destination = FileAgentJazzScmConfigurationEditor.this.fetchDestinationText.getText().trim();
                property.setValue(destination);
                if (destination.length() == 0) {
                    FileAgentJazzScmConfigurationEditor.this.deleteLoadDirectoryButton.setSelection(false);
                    FileAgentJazzScmConfigurationEditor.this.deleteLoadDirectoryButton.setEnabled(false);
                    FileAgentJazzScmConfigurationEditor.this.getDeleteBeforeFetchSelectionListener().widgetSelected(null);
                } else {
                    FileAgentJazzScmConfigurationEditor.this.deleteLoadDirectoryButton.setEnabled(true);
                }
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getDatasetPrefixModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("teamz.scm.dataset.prefix");
                String prefix = FileAgentJazzScmConfigurationEditor.this.datasetPrefixText.getText().trim();
                property.setValue(prefix);
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getDeleteBeforeFetchSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("teamz.scm.deleteDestinationBeforeFetch");
                property.setValue(Boolean.toString(FileAgentJazzScmConfigurationEditor.this.deleteLoadDirectoryButton.getSelection()));
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getAcceptBeforeFetchSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("teamz.scm.acceptBeforeFetch");
                property.setValue(Boolean.toString(FileAgentJazzScmConfigurationEditor.this.acceptBeforeFetchButton.getSelection()));
                FileAgentJazzScmConfigurationEditor.this.buildOnlyIfChangesButton.setSelection(FileAgentJazzScmConfigurationEditor.this.acceptBeforeFetchButton.getSelection());
                FileAgentJazzScmConfigurationEditor.this.buildOnlyIfChangesButton.setEnabled(FileAgentJazzScmConfigurationEditor.this.acceptBeforeFetchButton.getSelection());
                FileAgentJazzScmConfigurationEditor.this.getBuildOnlyIfChangesSelectionListener().widgetSelected(null);
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getBuildOnlyIfChangesSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("teamz.scm.buildOnlyIfChanges");
                property.setValue(Boolean.toString(FileAgentJazzScmConfigurationEditor.this.buildOnlyIfChangesButton.getSelection()));
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    public IBuildDefinition getBuildDefinitionWorkingCopy() {
        return this.buildDefinitionWorkingCopy;
    }

    public Text getWorkspaceNameText() {
        return this.workspaceNameText;
    }

    public Text getFetchDestinationText() {
        return this.fetchDestinationText;
    }

    public Text getDatasetPrefixText() {
        return this.datasetPrefixText;
    }
}

