/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.build.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.teamz.internal.build.ui.editors.builddefinition.AbstractEnterpriseConfigurationEditor;
import com.ibm.teamz.internal.build.ui.nls.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class AntzConfigurationEditor
extends AbstractEnterpriseConfigurationEditor {
    private static final int FIELD_SPACING = 20;
    private FormToolkit toolkit;
    private Section configurationSection;
    private Text antHomeText;
    private Text antArgsText;
    private Text workingDirText;
    private Text javaHomeText;
    private Text javaArgsText;
    private Text propertiesFileText;

    public AntzConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_enterprise_ant";
    }

    public void createContent(Composite parent, FormToolkit kit) {
        this.toolkit = kit;
        parent.setLayout((Layout)new TableWrapLayout());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        this.createBuildFileSection(parent, this.toolkit);
        this.createSpacer(parent, 15, 1);
        this.configurationSection = this.toolkit.createSection(parent, 418);
        this.configurationSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.configurationSection.setLayout((Layout)new TableWrapLayout());
        this.configurationSection.setText(Messages.AntzConfigurationEditor_CONFIG_SECTION_TEXT);
        this.configurationSection.setDescription(Messages.AntzConfigurationEditor_CONFIG_SECTION_DESCRIPTION);
        Composite composite = this.toolkit.createComposite((Composite)this.configurationSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createAntHomeWidgets(composite);
        this.createAntArgsWidgets(composite);
        this.createWorkingDirWidgets(composite);
        this.createJavaHomeWidgets(composite);
        this.createJavaArgsWidgets(composite);
        this.createPropertiesFileWidgets(composite);
        this.configurationSection.setClient((Control)composite);
    }

    protected IBuildDefinition getBuildDefinitionWorkingCopy() {
        return this.fBuildDefinitionWorkingCopy;
    }

    @Override
    protected void createAdvancedWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.createBuildMaps");
        this.buildMapsButton = this.toolkit.createButton(parent, Messages.AntzConfigurationEditor_BUTTON_CREATE_BUILD_MAPS, 32);
        this.buildMapsButton.setLayoutData((Object)new TableWrapData(256));
        if (property != null) {
            boolean createBuildMaps = Boolean.parseBoolean(property.getValue());
            this.buildMapsButton.setSelection(createBuildMaps);
        } else {
            this.buildMapsButton.setSelection(false);
        }
        this.buildMapsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                AntzConfigurationEditor.this.getWorkingCopy().setConfigurationProperty(AntzConfigurationEditor.this.getConfigurationId(), "teamz.build.ant.createBuildMaps", Boolean.toString(AntzConfigurationEditor.this.buildMapsButton.getSelection()));
                AntzConfigurationEditor.this.setDirty(true);
            }
        });
        super.createAdvancedWidgets(parent);
    }

    @Override
    protected Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.toolkit.createLabel(parent, label);
        Text text = this.toolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        this.createSpacer(parent, -1, 1);
        Text descriptionLabel = new Text(parent, 72);
        descriptionLabel.setText(description);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    private void createWorkingDirWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.workingDir");
        this.createSpacer(parent, 20, 2);
        this.workingDirText = this.createLabeledText(parent, Messages.AntzConfigurationEditor_WORKING_DIR_LABEL, Messages.AntzConfigurationEditor_WORKING_DIR_DESC, property.getValue());
        this.workingDirText.addModifyListener(this.getWorkingDirModifiedListener());
    }

    private void createAntHomeWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.antHome");
        this.createSpacer(parent, 20, 2);
        this.antHomeText = this.createLabeledText(parent, Messages.AntzConfigurationEditor_ANT_HOME_LABEL, Messages.AntzConfigurationEditor_ANT_HOME_DESC, property.getValue());
        this.antHomeText.addModifyListener(this.getAntHomeModifiedListener());
    }

    private void createAntArgsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.antArgs");
        this.createSpacer(parent, 20, 2);
        this.antArgsText = this.createLabeledText(parent, Messages.AntzConfigurationEditor_ANT_ARGS_LABEL, Messages.AntzConfigurationEditor_ANT_ARGS_DESC, property.getValue());
        this.antArgsText.addModifyListener(this.getAntArgsModifiedListener());
    }

    private void createJavaHomeWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.javaHome");
        this.createSpacer(parent, 20, 2);
        this.javaHomeText = this.createLabeledText(parent, Messages.AntzConfigurationEditor_JAVA_HOME_LABEL, Messages.AntzConfigurationEditor_JAVA_HOME_DESC, property.getValue());
        this.javaHomeText.addModifyListener(this.getJavaHomeModifiedListener());
    }

    private void createJavaArgsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.javaVMArgs");
        this.createSpacer(parent, 20, 2);
        this.javaArgsText = this.createLabeledText(parent, Messages.AntzConfigurationEditor_VM_ARGS_LABEL, Messages.AntzConfigurationEditor_VM_ARGS_DESC, property.getValue());
        this.javaArgsText.addModifyListener(this.getJavaArgsModifiedListener());
    }

    private void createPropertiesFileWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.propertiesFile");
        this.createSpacer(parent, 20, 2);
        this.propertiesFileText = this.createLabeledText(parent, Messages.AntzConfigurationEditor_PROPERTIES_LABEL, Messages.AntzConfigurationEditor_PROPERTIES_DESC, property.getValue());
        this.propertiesFileText.addModifyListener(this.getPropertiesFileModifiedListener());
    }

    private ModifyListener getAntHomeModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntzConfigurationEditor.this.validate();
                IBuildConfigurationElement element = AntzConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement(AntzConfigurationEditor.this.getConfigurationId());
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("teamz.build.ant.antHome");
                buildFileProperty.setValue(AntzConfigurationEditor.this.antHomeText.getText().trim());
                AntzConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getAntArgsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = AntzConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement(AntzConfigurationEditor.this.getConfigurationId());
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("teamz.build.ant.antArgs");
                buildFileProperty.setValue(AntzConfigurationEditor.this.antArgsText.getText().trim());
                AntzConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getWorkingDirModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntzConfigurationEditor.this.validate();
                IBuildConfigurationElement element = AntzConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement(AntzConfigurationEditor.this.getConfigurationId());
                IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.workingDir");
                property.setValue(AntzConfigurationEditor.this.workingDirText.getText().trim());
                AntzConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getJavaHomeModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = AntzConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement(AntzConfigurationEditor.this.getConfigurationId());
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("teamz.build.ant.javaHome");
                buildFileProperty.setValue(AntzConfigurationEditor.this.javaHomeText.getText().trim());
                AntzConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getJavaArgsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = AntzConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement(AntzConfigurationEditor.this.getConfigurationId());
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("teamz.build.ant.javaVMArgs");
                buildFileProperty.setValue(AntzConfigurationEditor.this.javaArgsText.getText().trim());
                AntzConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getPropertiesFileModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntzConfigurationEditor.this.validate();
                IBuildConfigurationElement element = AntzConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement(AntzConfigurationEditor.this.getConfigurationId());
                IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.propertiesFile");
                property.setValue(AntzConfigurationEditor.this.propertiesFileText.getText().trim());
                AntzConfigurationEditor.this.setDirty(true);
            }
        };
    }

    public Text getAntHomeText() {
        return this.antHomeText;
    }

    public Text getAntArgsText() {
        return this.antArgsText;
    }

    public Text getWorkingDirText() {
        return this.workingDirText;
    }

    public Text getJavaHomeText() {
        return this.javaHomeText;
    }

    public Text getJavaArgsText() {
        return this.javaArgsText;
    }

    public Text getPropertiesFileText() {
        return this.propertiesFileText;
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.toolkit;
    }

    @Override
    protected IBuildDefinition getWorkingCopy() {
        return this.fBuildDefinitionWorkingCopy;
    }

    @Override
    protected String getConfigurationId() {
        return "com.ibm.teamz.build.ant";
    }
}

