/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.build.ui.editors.builddefinition;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.common.model.BuildDefinition;
import com.ibm.team.build.internal.common.model.BuildProperty;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.client.util.LanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.zos.build.common.dependency.BuildOrderProperty;
import com.ibm.team.enterprise.zos.build.common.dependency.BuildOrderPropertyParser;
import com.ibm.team.enterprise.zos.build.common.dependency.IBuildOrderProperty;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.teamz.internal.build.ui.nls.Messages;
import com.ibm.teamz.internal.build.ui.utils.LanguageDefinitionSelectionDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractEnterpriseConfigurationEditor
extends AbstractConfigurationElementEditor
implements SelectionListener,
ISelectionChangedListener,
ModifyListener {
    protected IBuildDefinition fBuildDefinitionWorkingCopy;
    private IProjectAreaHandle projectArea = null;
    private Button generateButton;
    private Button customButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private Button addButton;
    private Button removeButton;
    private Composite orderingComposite;
    private Composite fieldComposite;
    private Composite buttonComposite;
    private TableViewer orderTableViewer;
    private Text buildFileText;
    private Text buildTargetsText;
    protected Button buildMapsButton;
    protected Button reuseISPFButton;
    protected Text bpxwdynOptionsText;
    private final Adapter fPropertyChangedListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Object currentOrderTableInput;
            Object notifierSource;
            Object notifier = notification.getNotifier();
            if ((notifier instanceof BuildProperty || notifier instanceof BuildDefinition) && (notifierSource = notification.getOldValue()) == (currentOrderTableInput = AbstractEnterpriseConfigurationEditor.this.orderTableViewer.getInput())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEnterpriseConfigurationEditor.this.refreshOrderingControl();
                    }
                });
            }
        }
    };

    public AbstractEnterpriseConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void dispose() {
        super.dispose();
        IBuildDefinition fWorkingCopy = this.getWorkingCopy();
        if (fWorkingCopy != null) {
            ((BuildDefinition)fWorkingCopy).eAdapters().remove((Object)this.fPropertyChangedListener);
        }
    }

    public Control getFocusControl() {
        return this.orderingComposite;
    }

    protected void createBuildFileSection(Composite parent, FormToolkit toolkit) {
        Section buildFileSection = toolkit.createSection(parent, 384);
        buildFileSection.setLayoutData((Object)new TableWrapData(256, 256));
        buildFileSection.setLayout((Layout)new TableWrapLayout());
        buildFileSection.setText(Messages.AntzConfigurationEditor_SECTION_TITLE);
        Composite buildFileComposite = toolkit.createComposite((Composite)buildFileSection);
        buildFileComposite.setLayoutData((Object)new TableWrapData(256, 256));
        buildFileComposite.setLayout((Layout)new TableWrapLayout());
        this.generateButton = toolkit.createButton(buildFileComposite, Messages.EnterpriseConfigurationEditor_BUTTON_GENERATE, 16);
        this.generateButton.setLayoutData((Object)new TableWrapData());
        this.orderingComposite = toolkit.createComposite(buildFileComposite);
        this.orderingComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout orderingLayout = new TableWrapLayout();
        orderingLayout.numColumns = 2;
        orderingLayout.horizontalSpacing = 10;
        orderingLayout.leftMargin = 20;
        this.orderingComposite.setLayout((Layout)orderingLayout);
        this.createBuildOrderWidgets(this.orderingComposite);
        this.customButton = toolkit.createButton(buildFileComposite, Messages.EnterpriseConfigurationEditor_BUTTON_EXISTING, 16);
        this.customButton.setLayoutData((Object)new TableWrapData());
        IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.useGeneratedBuildFile");
        if (property != null) {
            boolean propertyValue = Boolean.parseBoolean(property.getValue());
            this.generateButton.setSelection(propertyValue);
            this.customButton.setSelection(!propertyValue);
        } else {
            this.customButton.setSelection(true);
            this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "teamz.build.ant.useGeneratedBuildFile", Boolean.toString(false));
        }
        this.generateButton.addSelectionListener((SelectionListener)this);
        this.customButton.addSelectionListener((SelectionListener)this);
        this.fieldComposite = toolkit.createComposite(buildFileComposite);
        this.fieldComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.leftMargin = 20;
        this.fieldComposite.setLayout((Layout)layout);
        Text customBuildLabel = new Text(this.fieldComposite, 8);
        customBuildLabel.setText(Messages.EnterpriseConfigurationEditor_LABEL_EXISTING);
        customBuildLabel.setForeground(this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
        TableWrapData labelData = new TableWrapData(256);
        labelData.colspan = 2;
        customBuildLabel.setLayoutData((Object)labelData);
        this.createBuildFileWidgets(this.fieldComposite);
        this.createBuildTargetWidgets(this.fieldComposite);
        this.createAdvancedWidgets(buildFileComposite);
        this.updateComponentState();
        buildFileSection.setClient((Control)buildFileComposite);
    }

    private void createBuildOrderWidgets(Composite parent) {
        Label buildOrderLabel = this.getToolkit().createLabel(parent, Messages.EnterpriseConfigurationEditor_LABEL_BUILDORDER_TABLE);
        TableWrapData labelData = new TableWrapData(256);
        labelData.colspan = 2;
        buildOrderLabel.setLayoutData((Object)labelData);
        final IProcessAreaHandle processArea = this.getWorkingCopy().getProcessArea();
        TeamBuildJob resolveProjectAreaJob = new TeamBuildJob(Messages.AbstractEnterpriseConfigurationEditor_JOBNAME_RESOLVEPROJECTAREA, false, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                AbstractEnterpriseConfigurationEditor.this.resolveProjectArea(processArea, monitor);
                return Status.OK_STATUS;
            }
        };
        resolveProjectAreaJob.schedule();
        Table orderTable = this.getToolkit().createTable(parent, 66306);
        orderTable.setSize(200, 150);
        TableWrapData tableData = new TableWrapData(256);
        tableData.heightHint = 115;
        orderTable.setLayoutData((Object)tableData);
        orderTable.pack();
        this.orderTableViewer = new TableViewer(orderTable);
        BuildOrderTableContentProvider orderTableContentProvider = new BuildOrderTableContentProvider();
        BuildOrderTableLabelProvider orderTableLabelProvider = new BuildOrderTableLabelProvider();
        this.orderTableViewer.setContentProvider((IContentProvider)orderTableContentProvider);
        this.orderTableViewer.setLabelProvider((IBaseLabelProvider)orderTableLabelProvider);
        IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.buildOrder");
        if (property != null && !property.getValue().equalsIgnoreCase("")) {
            List propertyList = BuildOrderPropertyParser.getInstance().decodeString(property.getValue());
            this.orderTableViewer.setInput((Object)propertyList);
        } else {
            this.orderTableViewer.setInput((Object)processArea);
        }
        this.orderTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.buttonComposite = this.getToolkit().createComposite(parent);
        this.buttonComposite.setLayoutData((Object)new TableWrapData(256, 16));
        TableWrapLayout buttonLayout = new TableWrapLayout();
        buttonLayout.makeColumnsEqualWidth = false;
        this.buttonComposite.setLayout((Layout)buttonLayout);
        this.addButton = this.getToolkit().createButton(this.buttonComposite, Messages.EnterpriseConfigurationEditor_BUTTON_BUILDORDER_ADD, 8);
        TableWrapData buttonData = new TableWrapData(128);
        this.addButton.setLayoutData((Object)buttonData);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton = this.getToolkit().createButton(this.buttonComposite, Messages.EnterpriseConfigurationEditor_BUTTON_BUILDORDER_REMOVE, 8);
        buttonData = new TableWrapData(128);
        this.removeButton.setLayoutData((Object)buttonData);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.moveUpButton = this.getToolkit().createButton(this.buttonComposite, Messages.EnterpriseConfigurationEditor_BUTTON_BUILDORDER_UP, 8);
        buttonData = new TableWrapData(128);
        this.moveUpButton.setLayoutData((Object)buttonData);
        this.moveUpButton.addSelectionListener((SelectionListener)this);
        this.moveDownButton = this.getToolkit().createButton(this.buttonComposite, Messages.EnterpriseConfigurationEditor_BUTTON_BUILDORDER_DOWN, 8);
        buttonData = new TableWrapData(128);
        this.moveDownButton.setLayoutData((Object)buttonData);
        this.moveDownButton.addSelectionListener((SelectionListener)this);
        this.createSpacer(parent, 5, 2);
    }

    private void resolveProjectArea(IProcessAreaHandle processArea, IProgressMonitor monitor) {
        if (processArea instanceof ITeamAreaHandle) {
            try {
                ITeamArea teamArea = (ITeamArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)processArea, 0, monitor);
                this.projectArea = teamArea.getProjectArea();
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        } else if (processArea instanceof IProjectAreaHandle) {
            this.projectArea = (IProjectAreaHandle)processArea;
        }
    }

    private void createBuildFileWidgets(Composite parent) {
        IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.buildFile");
        this.createSpacer(parent, 5, 2);
        this.buildFileText = this.createLabeledText(parent, Messages.AntzConfigurationEditor_BUILD_FILE_LABEL, Messages.AntzConfigurationEditor_BUILD_FILE_DESC, property.getValue());
        this.buildFileText.addModifyListener((ModifyListener)this);
    }

    private void createBuildTargetWidgets(Composite parent) {
        IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.targets");
        String targets = property.getValue();
        this.createSpacer(parent, 5, 2);
        this.buildTargetsText = this.createLabeledText(parent, Messages.AntzConfigurationEditor_BUILD_TARGETS_LABEL, Messages.AntzConfigurationEditor_BUILD_TARGETS_DESCRIPTION, targets);
        this.buildTargetsText.addModifyListener((ModifyListener)this);
    }

    protected Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.getToolkit().createLabel(parent, label);
        Text text = this.getToolkit().createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        return text;
    }

    protected void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.getToolkit().createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    protected boolean validateBuildFile() {
        if (this.customButton.getSelection() && this.buildFileText.getText().trim().equals("")) {
            this.addErrorMessage(this.buildFileText, Messages.AntzConfigurationEditor_BUILD_FILE_REQUIRED, (Control)this.buildFileText);
            return false;
        }
        this.removeMessage(this.buildFileText, (Control)this.buildFileText);
        return true;
    }

    protected void updateComponentState() {
        boolean generateBuildFile = this.generateButton.getSelection();
        Control[] controlArray = this.orderingComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control i = controlArray[n2];
            i.setEnabled(generateBuildFile);
            ++n2;
        }
        controlArray = this.buttonComposite.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            Control l = controlArray[n2];
            l.setEnabled(generateBuildFile);
            ++n2;
        }
        this.updateButtonState();
        controlArray = this.fieldComposite.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            Control j = controlArray[n2];
            j.setEnabled(!generateBuildFile);
            ++n2;
        }
    }

    private void updateButtonState() {
        IStructuredSelection selection = (IStructuredSelection)this.orderTableViewer.getSelection();
        BuildOrderTableContentProvider provider = (BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider();
        List<BuildOrderTableItem> itemList = provider.getItemList();
        if (itemList != null) {
            int lastIndex = itemList.size() - 1;
            if (selection.getFirstElement() != null) {
                BuildOrderTableItem itemSelection = (BuildOrderTableItem)selection.getFirstElement();
                int selectionIndex = itemList.indexOf(itemSelection);
                int selectionSize = selection.size();
                int greatestIndex = 0;
                if (selectionSize > 1) {
                    for (Object currSelection : selection.toList()) {
                        BuildOrderTableItem currItem = (BuildOrderTableItem)currSelection;
                        int currIndex = itemList.indexOf(currItem);
                        if (currIndex <= greatestIndex) continue;
                        greatestIndex = currIndex;
                    }
                }
                this.moveUpButton.setEnabled(selectionIndex != 0);
                this.moveDownButton.setEnabled(selectionIndex != lastIndex - (selectionSize - 1) && lastIndex != greatestIndex);
            }
        } else {
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        this.updateComponentState();
        Object eventSource = event.getSource();
        if (eventSource == this.generateButton || eventSource == this.customButton || eventSource == this.moveUpButton || eventSource == this.moveDownButton || eventSource == this.addButton || eventSource == this.removeButton) {
            block24: {
                if (eventSource == this.generateButton || eventSource == this.customButton) {
                    boolean useGeneratedBuildFile = this.generateButton.getSelection();
                    IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
                    IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.useGeneratedBuildFile");
                    property.setValue(Boolean.toString(useGeneratedBuildFile));
                    if (eventSource == this.generateButton) {
                        this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "teamz.build.ant.generateReports", Boolean.toString(this.generateButton.getSelection()));
                    }
                } else if (eventSource == this.moveUpButton || eventSource == this.moveDownButton) {
                    StructuredSelection tableSelection = (StructuredSelection)this.orderTableViewer.getSelection();
                    BuildOrderTableContentProvider contentProvider = (BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider();
                    List<BuildOrderTableItem> itemList = contentProvider.getItemList();
                    if (eventSource == this.moveUpButton) {
                        for (BuildOrderTableItem defItem : tableSelection.toList()) {
                            int originalIndex = itemList.indexOf(defItem);
                            BuildOrderTableItem removedObject = itemList.remove(originalIndex - 1);
                            itemList.add(originalIndex, removedObject);
                        }
                    } else if (eventSource == this.moveDownButton) {
                        List selectionListItems = tableSelection.toList();
                        int itemIndex = selectionListItems.size() - 1;
                        while (itemIndex >= 0) {
                            BuildOrderTableItem def = (BuildOrderTableItem)selectionListItems.get(itemIndex);
                            int originalIndex = itemList.indexOf(def);
                            BuildOrderTableItem removedObject = itemList.remove(originalIndex);
                            itemList.add(originalIndex + 1, removedObject);
                            --itemIndex;
                        }
                    }
                    this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "teamz.build.ant.buildOrder", this.getCurrentBuildOrderPropertyValue());
                    this.orderTableViewer.refresh();
                    this.orderTableViewer.setSelection((ISelection)tableSelection);
                } else if (eventSource == this.addButton) {
                    try {
                        ArrayList<UUID> existingUUIDList = new ArrayList<UUID>();
                        List<BuildOrderTableItem> existingItemList = ((BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider()).getItemList();
                        for (BuildOrderTableItem existingItem : existingItemList) {
                            existingUUIDList.add(existingItem.getLanguageDefintion().getItemId());
                        }
                        LanguageDefinitionSelectionDialog dialog = new LanguageDefinitionSelectionDialog(this.getSite().getShell(), this.getTeamRepository(), null, this.getLangDefFilter(existingUUIDList), true);
                        if (dialog.open() == 0) {
                            ILanguageDefinition[] newTargets = dialog.getSelectedLanguageDefinitions();
                            List<BuildOrderTableItem> itemList = ((BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider()).getItemList();
                            IProcessAreaHandle currentProcessArea = ((BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider()).getCurrentProcessArea();
                            ILanguageDefinition[] iLanguageDefinitionArray = newTargets;
                            int n = newTargets.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ILanguageDefinition singleTarget = iLanguageDefinitionArray[n2];
                                if (!currentProcessArea.equals((Object)singleTarget.getProjectArea())) {
                                    itemList.add(new BuildOrderTableItem(singleTarget, true));
                                } else {
                                    itemList.add(new BuildOrderTableItem(singleTarget));
                                }
                                ++n2;
                            }
                            this.orderTableViewer.refresh();
                            this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "teamz.build.ant.buildOrder", this.getCurrentBuildOrderPropertyValue());
                            break block24;
                        }
                        return;
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                } else if (eventSource == this.removeButton) {
                    boolean doRemove = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.EnterpriseConfigurationEditor_DIALOG_CONFIRM_REMOVE_TITLE, (String)Messages.EnterpriseConfigurationEditor_DIALOG_CONFIRM_REMOVE_MESSAGE);
                    if (doRemove) {
                        List<BuildOrderTableItem> itemList = ((BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider()).getItemList();
                        IStructuredSelection tableSelection = (IStructuredSelection)this.orderTableViewer.getSelection();
                        List selectionList = tableSelection.toList();
                        for (BuildOrderTableItem item : selectionList) {
                            itemList.remove(item);
                        }
                        this.orderTableViewer.refresh();
                        this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "teamz.build.ant.buildOrder", this.getCurrentBuildOrderPropertyValue());
                    } else {
                        return;
                    }
                }
            }
            this.setDirty(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void modifyText(ModifyEvent event) {
        if (event.getSource() == this.buildTargetsText) {
            IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty property = element.getConfigurationProperty("teamz.build.ant.targets");
            if (property == null) {
                property = BuildItemFactory.createConfigurationProperty();
                property.setName("com.ibm.team.build.ant.targets");
                element.getConfigurationProperties().add(property);
            }
            property.setValue(this.buildTargetsText.getText().trim());
            this.setDirty(true);
        } else if (event.getSource() == this.buildFileText) {
            IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty buildFileProperty = element.getConfigurationProperty("teamz.build.ant.buildFile");
            buildFileProperty.setValue(this.buildFileText.getText().trim());
            this.validateBuildFile();
            this.setDirty(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
        this.updateButtonState();
    }

    private String getCurrentBuildOrderPropertyValue() {
        BuildOrderTableContentProvider provider = (BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider();
        ArrayList<BuildOrderProperty> buildOrderList = new ArrayList<BuildOrderProperty>();
        for (BuildOrderTableItem item : provider.getItemList()) {
            buildOrderList.add(new BuildOrderProperty(item.getLanguageDefintion(), true));
        }
        String encodedString = BuildOrderPropertyParser.getInstance().encodeString(buildOrderList);
        return encodedString;
    }

    public void checkStateChanged(CheckStateChangedEvent arg0) {
        this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "teamz.build.ant.buildOrder", this.getCurrentBuildOrderPropertyValue());
        this.setDirty(true);
    }

    public boolean validate() {
        boolean isValid = true;
        boolean isGenerate = true;
        if (!this.generateButton.isDisposed()) {
            isGenerate = this.generateButton.getSelection();
        }
        if (!isGenerate && this.buildFileText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.buildFileText, Messages.AntzConfigurationEditor_BUILD_FILE_REQUIRED, (Control)this.buildFileText);
            isValid = false;
        } else {
            this.removeMessage(this.buildFileText, (Control)this.buildFileText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    public Text getBuildFileText() {
        return this.buildFileText;
    }

    public Text getBuildTargetsText() {
        return this.buildTargetsText;
    }

    private ViewerFilter getLangDefFilter(final List<UUID> duplicateList) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ILanguageDefinition) {
                    ILanguageDefinition langDef = (ILanguageDefinition)element;
                    UUID langDefId = langDef.getItemId();
                    if (langDefId != null && duplicateList.contains(langDefId)) {
                        return false;
                    }
                    return langDef.getTranslators().size() > 0;
                }
                return true;
            }
        };
    }

    private void refreshOrderingControl() {
        this.orderTableViewer.setInput((Object)this.getWorkingCopy().getProcessArea());
        this.orderTableViewer.refresh();
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        if (this.fBuildDefinitionWorkingCopy != null) {
            ((BuildDefinition)this.fBuildDefinitionWorkingCopy).eAdapters().remove((Object)this.fPropertyChangedListener);
        }
        this.fBuildDefinitionWorkingCopy = definition;
        ((BuildDefinition)this.fBuildDefinitionWorkingCopy).eAdapters().add((Object)this.fPropertyChangedListener);
    }

    protected void createAdvancedWidgets(Composite parent) {
        Composite advancedWidgetsComposite = this.getToolkit().createComposite(parent);
        advancedWidgetsComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.leftMargin = 0;
        layout.topMargin = 0;
        advancedWidgetsComposite.setLayout((Layout)layout);
        IBuildProperty buildProperty = this.fBuildDefinitionWorkingCopy.getProperty("teamz.build.ant.reuseISPFSession");
        this.reuseISPFButton = this.getToolkit().createButton(advancedWidgetsComposite, Messages.EnterpriseConfigurationEditor_BUTTON_REUSEISPF, 32);
        TableWrapData buttonData = new TableWrapData(256);
        buttonData.colspan = 2;
        this.reuseISPFButton.setLayoutData((Object)buttonData);
        if (buildProperty != null) {
            boolean reuseISPFSession = Boolean.parseBoolean(buildProperty.getValue());
            this.reuseISPFButton.setSelection(reuseISPFSession);
        } else {
            this.reuseISPFButton.setSelection(false);
        }
        this.reuseISPFButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                AbstractEnterpriseConfigurationEditor.this.getWorkingCopy().setProperty("teamz.build.ant.reuseISPFSession", Boolean.toString(AbstractEnterpriseConfigurationEditor.this.reuseISPFButton.getSelection()));
                AbstractEnterpriseConfigurationEditor.this.setDirty(true);
            }
        });
        this.createSpacer(advancedWidgetsComposite, 5, 2);
        buildProperty = this.fBuildDefinitionWorkingCopy.getProperty("teamz.build.ant.bpxwdyn.options");
        this.getToolkit().createLabel(advancedWidgetsComposite, Messages.EnterpriseConfigurationEditor_LABEL_BPXWDYNOPTIONS);
        this.bpxwdynOptionsText = this.getToolkit().createText(advancedWidgetsComposite, buildProperty != null ? buildProperty.getValue() : "");
        this.bpxwdynOptionsText.setLayoutData((Object)new TableWrapData(128));
        this.bpxwdynOptionsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AbstractEnterpriseConfigurationEditor.this.validate();
                IBuildProperty buildProperty = AbstractEnterpriseConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("teamz.build.ant.bpxwdyn.options");
                buildProperty.setValue(AbstractEnterpriseConfigurationEditor.this.bpxwdynOptionsText.getText().trim());
                AbstractEnterpriseConfigurationEditor.this.setDirty(true);
            }
        });
    }

    protected abstract FormToolkit getToolkit();

    protected abstract IBuildDefinition getWorkingCopy();

    protected abstract String getConfigurationId();

    protected class BuildOrderTableContentProvider
    implements IStructuredContentProvider {
        private IProcessAreaHandle currentProcessArea = null;
        private List<BuildOrderTableItem> contentList = null;
        private List<ILanguageDefinition> languageList = null;
        private Map<String, ILanguageDefinition> languageMap = null;
        private List<IBuildOrderProperty> propertyList = null;
        private Job fetchLangDefsJob = null;
        private Job fetchExternalLangDefsJob = null;

        public BuildOrderTableContentProvider() {
            this.fetchLangDefsJob = new FetchLangDefJob(Messages.AbstractEnterpriseConfigurationEditor_JOBNAME_FETCHLANGDEFS, true, AbstractEnterpriseConfigurationEditor.this.getTeamRepository());
            this.fetchExternalLangDefsJob = new FetchExternalLangDefJob(Messages.AbstractEnterpriseConfigurationEditor_JOBNAME_FETCHLANGDEFS, true, AbstractEnterpriseConfigurationEditor.this.getTeamRepository());
        }

        public List<BuildOrderTableItem> getItemList() {
            return this.contentList;
        }

        public IProcessAreaHandle getCurrentProcessArea() {
            return this.currentProcessArea;
        }

        public void dispose() {
            if (this.languageList != null) {
                this.languageList.clear();
            }
            if (this.languageMap != null) {
                this.languageMap.clear();
            }
            if (this.propertyList != null) {
                this.propertyList.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof IProcessAreaHandle) {
                if (AbstractEnterpriseConfigurationEditor.this.projectArea != null) {
                    this.fetchLangDefsJob.schedule();
                }
            } else if (newInput instanceof List) {
                this.propertyList = (List)newInput;
                this.fetchExternalLangDefsJob.schedule();
            }
        }

        private ILanguageDefinition getExternalLangDef(String langDefUUID) {
            ILanguageDefinition resultDefinition = null;
            try {
                resultDefinition = LanguageDefinition.get((ITeamRepository)AbstractEnterpriseConfigurationEditor.this.getTeamRepository(), (String)langDefUUID, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
            return resultDefinition;
        }

        public Object[] getElements(Object arg0) {
            Object[] objectArray;
            if (this.contentList == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = Messages.AbstractEnterpriseConfigurationEditor_JOBNAME_FETCHLANGDEFS;
            } else {
                objectArray = this.contentList.toArray();
            }
            return objectArray;
        }

        public Object[] getEnabledElements() {
            if (this.propertyList != null && !this.propertyList.isEmpty()) {
                ArrayList<BuildOrderTableItem> enabledElements = new ArrayList<BuildOrderTableItem>();
                for (IBuildOrderProperty prop : this.propertyList) {
                    if (!prop.isPropertyEnabled()) continue;
                    String UUID2 = prop.getPropertyUUID();
                    enabledElements.add(new BuildOrderTableItem(this.languageMap.get(UUID2)));
                }
                return enabledElements.toArray();
            }
            return null;
        }

        class FetchExternalLangDefJob
        extends FetchLangDefJob {
            FetchExternalLangDefJob(String jobName, boolean isUserJob, ITeamRepository repo) {
                super(jobName, isUserJob, repo);
            }

            @Override
            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                super.runProtected(monitor);
                if (!BuildOrderTableContentProvider.this.contentList.isEmpty()) {
                    BuildOrderTableContentProvider.this.contentList.clear();
                }
                ArrayList<ILanguageDefinition> updatedList = new ArrayList<ILanguageDefinition>();
                for (IBuildOrderProperty currProp : BuildOrderTableContentProvider.this.propertyList) {
                    ILanguageDefinition langDef = (ILanguageDefinition)BuildOrderTableContentProvider.this.languageMap.get(currProp.getPropertyUUID());
                    BuildOrderTableItem tableDef = null;
                    if (langDef == null) {
                        langDef = BuildOrderTableContentProvider.this.getExternalLangDef(currProp.getPropertyUUID());
                        if (langDef != null) {
                            tableDef = new BuildOrderTableItem(langDef, true);
                        }
                    } else {
                        tableDef = new BuildOrderTableItem(langDef);
                        updatedList.add(langDef);
                    }
                    if (tableDef == null) continue;
                    BuildOrderTableContentProvider.this.contentList.add(tableDef);
                }
                BuildOrderTableContentProvider.this.languageList.clear();
                BuildOrderTableContentProvider.this.languageList = updatedList;
                return Status.OK_STATUS;
            }
        }

        class FetchLangDefJob
        extends TeamBuildJob {
            FetchLangDefJob(String jobName, boolean isUserJob, ITeamRepository repo) {
                super(jobName, isUserJob, repo);
            }

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                BuildOrderTableContentProvider.this.currentProcessArea = (IProcessAreaHandle)AbstractEnterpriseConfigurationEditor.this.projectArea;
                ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)AbstractEnterpriseConfigurationEditor.this.getTeamRepository().getClientLibrary(ISystemDefinitionModelClient.class);
                List langDefs = null;
                try {
                    langDefs = client.findSystemDefinitionsComplete(IZosLanguageDefinition.ITEM_TYPE, AbstractEnterpriseConfigurationEditor.this.projectArea, -1, false, (IProgressMonitor)new NullProgressMonitor());
                    if (BuildOrderTableContentProvider.this.languageList != null) {
                        BuildOrderTableContentProvider.this.languageList.clear();
                    } else {
                        BuildOrderTableContentProvider.this.languageList = new ArrayList();
                    }
                    if (BuildOrderTableContentProvider.this.contentList != null) {
                        BuildOrderTableContentProvider.this.contentList.clear();
                    } else {
                        BuildOrderTableContentProvider.this.contentList = new ArrayList();
                    }
                    for (ISystemDefinition sysDef : langDefs) {
                        IZosLanguageDefinition langDef = (IZosLanguageDefinition)sysDef;
                        List translators = langDef.getTranslators();
                        if (translators == null || translators.isEmpty()) continue;
                        BuildOrderTableContentProvider.this.languageList.add(langDef);
                        BuildOrderTableContentProvider.this.contentList.add(new BuildOrderTableItem((ILanguageDefinition)langDef));
                    }
                    if (BuildOrderTableContentProvider.this.languageMap != null) {
                        BuildOrderTableContentProvider.this.languageMap.clear();
                    } else {
                        BuildOrderTableContentProvider.this.languageMap = new HashMap();
                    }
                    for (ISystemDefinition sysDef : langDefs) {
                        BuildOrderTableContentProvider.this.languageMap.put(sysDef.getItemId().getUuidValue(), (ILanguageDefinition)sysDef);
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!AbstractEnterpriseConfigurationEditor.this.orderTableViewer.getControl().isDisposed()) {
                            AbstractEnterpriseConfigurationEditor.this.orderTableViewer.refresh(true);
                        }
                    }
                });
            }
        }
    }

    protected class BuildOrderTableItem {
        private boolean isExternal = false;
        private final ILanguageDefinition languageDefinition;

        public BuildOrderTableItem(ILanguageDefinition langDef) {
            this.languageDefinition = langDef;
        }

        public BuildOrderTableItem(ILanguageDefinition langDef, boolean showProjectArea) {
            this(langDef);
            this.isExternal = showProjectArea;
        }

        public boolean isProjectAreaVisible() {
            return this.isExternal;
        }

        public ILanguageDefinition getLanguageDefintion() {
            return this.languageDefinition;
        }
    }

    protected class BuildOrderTableLabelProvider
    implements ITableLabelProvider {
        private IItemManager itemManager = null;

        protected BuildOrderTableLabelProvider() {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object item, int arg1) {
            if (this.itemManager == null) {
                this.itemManager = AbstractEnterpriseConfigurationEditor.this.getTeamRepository().itemManager();
            }
            if (item instanceof BuildOrderTableItem) {
                ILanguageDefinition langDefItem = ((BuildOrderTableItem)item).getLanguageDefintion();
                String columnText = langDefItem.getName();
                if (((BuildOrderTableItem)item).isExternal) {
                    try {
                        IProjectArea parentPA = (IProjectArea)this.itemManager.fetchCompleteItem((IItemHandle)langDefItem.getProjectArea(), 0, (IProgressMonitor)new NullProgressMonitor());
                        String projectAreaName = parentPA.getName();
                        String returnString = columnText.concat(" (" + projectAreaName + ")");
                        return returnString;
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                }
                return columnText;
            }
            if (item instanceof String) {
                return (String)item;
            }
            return null;
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }
}

