/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.build.ui.dialogs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.builddefinition.IBuildDefinitionTemplate;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.builddefinition.BuildDefinitionTemplateExtension;
import com.ibm.team.build.internal.common.builddefinition.BuildDefinitionTemplateExtensionManager;
import com.ibm.team.build.internal.common.model.BuildProperty;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.teamz.internal.build.ui.nls.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BuildDefMigrationDialog
extends Dialog {
    private static final String PLUGINID = "com.ibm.teamz.build.ui";
    private static final String ZOS_BUILD_DEPENDENCY_TEMPLATE_V4 = "com.ibm.team.enterprise.zos.build.dependency.template";
    private final IBuildDefinition fInitialDefinition;
    private CheckboxTableViewer fBuildDefsViewer;
    private BuildDefsProvider fBuildDefsProvider;
    private Button fSelectAllDefsButton;
    private Button fSelectNoDefsButton;
    private Button fMigrateButton;

    public static void promptForMigration(Shell parentShell, IBuildDefinition definition) {
        BuildDefMigrationMessageDialog migrationMsgDlg = new BuildDefMigrationMessageDialog(parentShell, definition);
        int response = migrationMsgDlg.open();
        if (response == 0) {
            BuildDefMigrationDialog migrationDlg = new BuildDefMigrationDialog(parentShell, definition);
            response = migrationDlg.open();
        }
    }

    private BuildDefMigrationDialog(Shell parentShell, IBuildDefinition definition) {
        super(parentShell);
        this.fInitialDefinition = definition;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.BuildDefMigrationDialog_DIALOG_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fMigrateButton = this.createButton(parent, 0, Messages.BuildDefMigrationDialog_DIALOG_BUTTON_MIGRATE, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        dialogAreaComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        dialogAreaComposite.setLayoutData((Object)gridData);
        Label label = new Label(dialogAreaComposite, 64);
        label.setText(Messages.BuildDefMigrationDialog_DIALOG_DESCRIPTION);
        GridData labelGridData = new GridData(4, 16384, true, false);
        labelGridData.widthHint = 200;
        label.setLayoutData((Object)labelGridData);
        this.createVerticalSpace(dialogAreaComposite, gridData);
        label = new Label(dialogAreaComposite, 0);
        label.setText(NLS.bind((String)Messages.BuildDefMigrationDialog_DIALOG_BUILD_DEFS, (Object)this.getProjectArea(this.fInitialDefinition).getName()));
        label.setToolTipText(Messages.BuildDefMigrationDialog_DIALOG_BUILD_DEFS_TOOLTIP);
        label.setLayoutData((Object)new GridData());
        Composite buildDefComposite = new Composite(dialogAreaComposite, 0);
        buildDefComposite.setLayout((Layout)new GridLayout(2, false));
        buildDefComposite.setLayoutData((Object)gridData);
        this.createBuildDefsTable(buildDefComposite);
        Composite buttonComposite = new Composite(buildDefComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.fSelectAllDefsButton = new Button(buttonComposite, 8);
        this.fSelectAllDefsButton.setText(Messages.BuildDefMigrationDialog_DIALOG_SELECT_ALL_DEFS);
        this.fSelectAllDefsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildDefMigrationDialog.this.fBuildDefsViewer.setAllChecked(true);
                BuildDefMigrationDialog.this.updateMigrationButton();
            }
        });
        this.fSelectNoDefsButton = new Button(buttonComposite, 8);
        this.fSelectNoDefsButton.setText(Messages.BuildDefMigrationDialog_DIALOG_DESELECT_ALL_DEFS);
        this.fSelectNoDefsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildDefMigrationDialog.this.fBuildDefsViewer.setAllChecked(false);
                BuildDefMigrationDialog.this.updateMigrationButton();
            }
        });
        Text descriptionLabel = new Text(dialogAreaComposite, 72);
        descriptionLabel.setText(Messages.BuildDefMigrationDialog_DIALOG_EXPLANATION);
        this.createVerticalSpace(dialogAreaComposite, gridData);
        BuildDefMigrationDialog.applyDialogFont((Control)dialogAreaComposite);
        this.fBuildDefsViewer.setInput((Object)this.getProjectArea(this.fInitialDefinition));
        this.fBuildDefsViewer.setChecked((Object)this.fInitialDefinition, true);
        this.fBuildDefsViewer.reveal((Object)this.fInitialDefinition);
        return dialogAreaComposite;
    }

    private void createVerticalSpace(Composite dialogAreaComposite, GridData gridData) {
        Label label = new Label(dialogAreaComposite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    private void updateMigrationButton() {
        if (this.fMigrateButton != null && this.fBuildDefsViewer != null) {
            boolean migrationEnabled = this.fBuildDefsViewer.getCheckedElements().length > 0;
            this.fMigrateButton.setEnabled(migrationEnabled);
        }
    }

    private void createBuildDefsTable(Composite parent) {
        this.fBuildDefsViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
        this.fBuildDefsProvider = new BuildDefsProvider(this.fInitialDefinition);
        this.fBuildDefsViewer.setContentProvider((IContentProvider)this.fBuildDefsProvider);
        this.fBuildDefsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((IBuildDefinition)object).getId();
            }
        });
        this.fBuildDefsViewer.getTable().setEnabled(true);
        GridData gridData = new GridData(768);
        gridData.heightHint = 200;
        this.fBuildDefsViewer.getTable().setLayoutData((Object)gridData);
        this.fBuildDefsViewer.getTable().pack(true);
        this.fBuildDefsViewer.setComparator(new ViewerComparator());
        this.fBuildDefsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                BuildDefMigrationDialog.this.updateMigrationButton();
            }
        });
    }

    protected void okPressed() {
        ITeamRepository origin = (ITeamRepository)this.fInitialDefinition.getOrigin();
        Object[] checkedElements = this.fBuildDefsViewer.getCheckedElements();
        Shell shell = this.getShell();
        super.okPressed();
        MultiStatus migrationResults = new MultiStatus(PLUGINID, 0, Messages.BuildDefMigrationMessage_Results_OK_TEXT, null);
        BuildDefMigrationDialog.migrateBuildDefs(shell, origin, checkedElements, migrationResults);
        if (migrationResults.matches(6)) {
            MultiStatus errorResults = new MultiStatus(PLUGINID, 0, Messages.BuildDefMigrationMessage_Results_ERRORS_TEXT, null);
            errorResults.merge((IStatus)migrationResults);
            migrationResults = errorResults;
        }
        final ErrorDialog resultsDialog = new ErrorDialog(shell, Messages.BuildDefMigrationMessage_Results_TITLE, null, (IStatus)migrationResults, 7);
        resultsDialog.setBlockOnOpen(true);
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    resultsDialog.open();
                }
            });
        } else {
            resultsDialog.open();
        }
    }

    protected IProjectArea getProjectArea(IBuildDefinition buildDef) {
        IProjectArea result = null;
        IProcessArea pa = null;
        try {
            TeamRepository teamRepository = (TeamRepository)buildDef.getOrigin();
            pa = (IProcessArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDef.getProcessArea(), 0, null);
            if (pa instanceof IProjectArea) {
                result = (IProjectArea)pa;
            } else if (pa instanceof ITeamArea) {
                result = (IProjectArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)pa.getProjectArea(), 0, null);
            }
        }
        catch (TeamRepositoryException e) {
            result = null;
        }
        return result;
    }

    private static void migrateBuildDefs(Shell parentShell, final ITeamRepository teamRepository, final Object[] buildDefs, final MultiStatus results) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block11: {
                    try {
                        try {
                            if (teamRepository == null || buildDefs == null) break block11;
                            if (monitor != null) {
                                monitor.beginTask(Messages.BuildDefMigration_MIGRATION_MONITOR, buildDefs.length);
                            }
                            int i = 0;
                            IBuildDefinition newDummyDef = null;
                            Object[] objectArray = buildDefs;
                            int n = buildDefs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                IBuildDefinition buildDef = (IBuildDefinition)o;
                                monitor.subTask(buildDef.getId());
                                if (newDummyDef == null) {
                                    newDummyDef = BuildItemFactory.createBuildDefinition();
                                    BuildDefinitionTemplateExtension template = BuildDefinitionTemplateExtensionManager.getInstance().getBuildDefinitionTemplate(BuildDefMigrationDialog.ZOS_BUILD_DEPENDENCY_TEMPLATE_V4);
                                    newDummyDef.initializeConfiguration((IBuildDefinitionTemplate)template);
                                }
                                IStatus result = new MigrateBuildDefs().migrateBuildTemplate(buildDef, newDummyDef);
                                results.add(result);
                                monitor.worked(i++);
                                if (monitor.isCanceled()) {
                                    break;
                                }
                                ++n2;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (monitor != null) {
                                monitor.done();
                            }
                        }
                    }
                    finally {
                        if (monitor != null) {
                            monitor.done();
                        }
                    }
                }
            }
        };
        try {
            ProgressMonitorDialog pd = new ProgressMonitorDialog(parentShell);
            pd.run(true, false, op);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class BuildDefMigrationMessageDialog
    extends MessageDialog {
        public BuildDefMigrationMessageDialog(Shell parentShell, IBuildDefinition definition) {
            super(parentShell, Messages.BuildDefMigrationMessage_TITLE, null, Messages.BuildDefMigrationMessage_TEXT, 3, new String[]{Messages.BuildDefMigrationMessage_BUTTON_CONTINUE, IDialogConstants.CANCEL_LABEL}, 1);
        }
    }

    private static class BuildDefsProvider
    implements IStructuredContentProvider {
        private IBuildDefinition fInitialBuildDefinition = null;
        private ITeamRepository fRepos = null;
        private IProjectArea fProjectArea = null;
        private List<IBuildDefinition> buildDefs = null;

        public BuildDefsProvider(IBuildDefinition initialBuildDefinition) {
            this.fInitialBuildDefinition = initialBuildDefinition;
            this.fRepos = (ITeamRepository)(this.fInitialBuildDefinition == null ? null : initialBuildDefinition.getOrigin());
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.buildDefs = new ArrayList<IBuildDefinition>();
            this.fProjectArea = (IProjectArea)newInput;
            IProjectArea projectArea = this.fProjectArea;
            if (projectArea != null) {
                this.buildDefs.add(this.fInitialBuildDefinition);
                IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel buildDefinitionQueryModel = IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT;
                IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildDefinitionQueryModel);
                IPredicate filter = ((BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel)buildDefinitionQueryModel).processArea().projectArea()._eq(projectArea.getItemHandle());
                query.filter(filter);
                IItemManager itemManager = this.fRepos.itemManager();
                ItemQueryIterator iter = new ItemQueryIterator(ClientFactory.getTeamBuildClient((ITeamRepository)this.fRepos), query, new Object[0]);
                LinkedList buildDefinitions = new LinkedList();
                try {
                    while (iter.hasNext(null)) {
                        List definitionHandles = iter.next(512, null);
                        buildDefinitions.addAll(itemManager.fetchCompleteItems(definitionHandles, 0, null));
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                for (IBuildDefinition buildDef : buildDefinitions) {
                    if (buildDef.getItemId().equals((Object)this.fInitialBuildDefinition.getItemId()) || !IBuildUtility.isOldDependencyBuild((IBuildDefinition)buildDef)) continue;
                    this.buildDefs.add(buildDef);
                }
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.buildDefs != null ? this.buildDefs.toArray() : new Object[]{};
        }
    }

    private static class MigrateBuildDefs {
        private static final String TEAM_ENTERPRISE_PREFIX = "team.enterprise.";
        private static final String TEAMZ_PREFIX = "teamz.";

        private IStatus migrateBuildTemplate(IBuildDefinition buildDef, IBuildDefinition newDummyDef) throws TeamBuildException, IllegalArgumentException, TeamRepositoryException {
            String buildDefId = buildDef.getId();
            Status result = null;
            try {
                IBuildProperty existingProp;
                BuildDefinitionTemplateExtension template = BuildDefinitionTemplateExtensionManager.getInstance().getBuildDefinitionTemplate(BuildDefMigrationDialog.ZOS_BUILD_DEPENDENCY_TEMPLATE_V4);
                ITeamRepository teamRepository = (ITeamRepository)buildDef.getOrigin();
                buildDef = (IBuildDefinition)buildDef.getWorkingCopy();
                ArrayList<IBuildProperty> propsToPreserve = new ArrayList<IBuildProperty>();
                List newTemplateProps = newDummyDef.getProperties();
                for (IBuildProperty newTemplateProp : newTemplateProps) {
                    String newTemplatePropName = newTemplateProp.getName();
                    existingProp = buildDef.getProperty(newTemplatePropName);
                    if (existingProp == null || !newTemplatePropName.startsWith(TEAMZ_PREFIX) && !newTemplatePropName.startsWith(TEAM_ENTERPRISE_PREFIX)) continue;
                    propsToPreserve.add(existingProp.copyProperty());
                }
                buildDef.initializeConfiguration((IBuildDefinitionTemplate)template);
                for (IBuildProperty propToPreserve : propsToPreserve) {
                    existingProp = buildDef.getProperty(propToPreserve.getName());
                    if (existingProp == null) continue;
                    existingProp.setValue(propToPreserve.getValue());
                }
                this.migrateConfigElement(buildDef, "com.ibm.teamz.build.preprocess.buildfiles", "com.ibm.team.enterprise.build.preprocess.buildfiles");
                this.migrateConfigElement(buildDef, "com.ibm.teamz.build.fileagentjazzscm", "com.ibm.team.enterprise.build.common.IFileAgentJazzScmConfigurationElement");
                this.migrateConfigElement(buildDef, "com.ibm.teamz.build.dependency", "com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement");
                this.migrateConfigElement(buildDef, "com.ibm.teamz.build.joboutput.publishing", "com.ibm.team.enterprise.build.common.IOutputPublishingConfigurationElement");
                this.migrateProperty(buildDef, newDummyDef, "teamz.scm.dataset.prefix", "team.enterprise.scm.resourcePrefix");
                this.migrateProperties(buildDef, newDummyDef, TEAMZ_PREFIX, TEAM_ENTERPRISE_PREFIX);
                buildDef.setProperty("team.enterprise.build.ant.fetchWorkspaceBeforeBuild", Boolean.TRUE.toString());
                ITeamBuildRecordClient recordClient = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
                recordClient.save(buildDef, null);
            }
            catch (Exception e) {
                result = new Status(4, BuildDefMigrationDialog.PLUGINID, NLS.bind((String)Messages.BuildDefMigrationMessage_Migration_FAILED, (Object)buildDefId, (Object)e.getLocalizedMessage()));
                e.printStackTrace();
            }
            if (result == null) {
                result = new Status(1, BuildDefMigrationDialog.PLUGINID, NLS.bind((String)Messages.BuildDefMigrationMessage_Migration_OK, (Object)buildDefId));
            }
            return result;
        }

        private void migrateProperty(IBuildDefinition buildDef, IBuildDefinition newDummyDef, String oldID, String newID) {
            IBuildProperty property = buildDef.getProperty(oldID);
            if (property != null) {
                IBuildProperty newProperty = buildDef.getProperty(newID);
                if (newProperty != null) {
                    newProperty.setValue(property.getValue());
                }
                if (newDummyDef.getProperty(property.getName()) == null) {
                    buildDef.getProperties().remove(property);
                }
            }
        }

        private void migrateProperties(IBuildDefinition buildDef, IBuildDefinition newDummyDef, String oldPrefix, String newPrefix) {
            Iterator iterator = buildDef.getProperties().iterator();
            while (iterator.hasNext()) {
                String newPropName;
                IBuildProperty newProp;
                BuildProperty buildProperty = (BuildProperty)iterator.next();
                if (!buildProperty.getName().startsWith(oldPrefix) || (newProp = buildDef.getProperty(newPropName = String.valueOf(newPrefix) + buildProperty.getName().substring(oldPrefix.length()))) == null) continue;
                newProp.setValue(buildProperty.getValue());
                if (newDummyDef.getProperty(buildProperty.getName()) != null) continue;
                iterator.remove();
            }
        }

        private void migrateConfigElement(IBuildDefinition buildDef, String oldCEid, String newCEid) {
            IBuildConfigurationElement oldCE = buildDef.getConfigurationElement(oldCEid);
            IBuildConfigurationElement newCE = buildDef.getConfigurationElement(newCEid);
            if (oldCE != null) {
                List oldCEProps = oldCE.getConfigurationProperties();
                for (Object object : oldCEProps) {
                    String newPropName;
                    IConfigurationProperty newProp;
                    IConfigurationProperty configProperty = (IConfigurationProperty)object;
                    if (!configProperty.getName().startsWith(TEAMZ_PREFIX) || (newProp = newCE.getConfigurationProperty(newPropName = TEAM_ENTERPRISE_PREFIX + configProperty.getName().substring(TEAMZ_PREFIX.length()))) == null) continue;
                    newProp.setValue(configProperty.getValue());
                }
                buildDef.getConfigurationElements().remove(oldCE);
            }
        }
    }
}

