/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ui.actions;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teamz.internal.build.ui.nls.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class IgnoreForBuildAction
extends AbstractActionDelegate {
    protected Set<IShareable> fSelection = new HashSet<IShareable>();
    private static final String IGNORE_ACTION_ID = "com.ibm.teamz.build.actions.ignoreforbuild";
    private static final String UNIGNORE_ACTION_ID = "com.ibm.teamz.build.actions.unignoreforbuild";
    private final Object lock = new Object();

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (!MessageDialog.openQuestion((Shell)shell, (String)Messages.IgnoreActionDialog_TITLE, (String)Messages.IgnoreActionDialog_TEXT)) {
            return;
        }
        this.updateProperty(shell, selection, true);
    }

    protected void updateProperty(Shell shell, IStructuredSelection structuredSelection, final boolean ignore) {
        List<IShareable> list;
        try {
            list = this.extractSelectedShareableFiles(structuredSelection, null);
        }
        catch (FileSystemException e1) {
            MessageDialog.openError((Shell)shell, (String)Messages.IgnoreActionDialogError_TITLE, (String)Messages.IgnoreActionDialogError_TEXT);
            return;
        }
        if (list.size() == 0) {
            return;
        }
        this.fSelection = new HashSet<IShareable>();
        this.fSelection.addAll(list);
        this.getOperationRunner().enqueue(Messages.IgnoreForBuildAction_UpdatingIgnoreForBuildPropertyJobName, new Operation(){

            public void run(IProgressMonitor progress, IStatusCollector problems) throws OperationFailedException {
                for (IShareable shareable : IgnoreForBuildAction.this.fSelection) {
                    try {
                        IChangePropertiesOperation operation = IOperationFactory.instance.getChangePropertiesOperation(new ChangePropertiesDilemmaHandler());
                        IMetadataProperties metadataProperties = shareable.getMetadataProperties(progress);
                        Map currentProperties = metadataProperties.getCurrentProperties();
                        HashMap<String, String> newProperties = new HashMap<String, String>();
                        newProperties.putAll(currentProperties);
                        if (ignore) {
                            newProperties.put("team.enterprise.build.changes.ignoreForDependencyBuild", Boolean.TRUE.toString());
                        } else {
                            newProperties.remove("team.enterprise.build.changes.ignoreForDependencyBuild");
                        }
                        operation.setProperties(shareable, newProperties);
                        operation.run(progress);
                    }
                    catch (FileSystemException e) {
                        e.printStackTrace();
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        List selectionList = ((IStructuredSelection)selection).toList();
        Set contexts = ComponentSyncUtil.getContexts((Collection)selectionList);
        if (!ComponentSyncUtil.allLoggedIn((Collection)contexts)) {
            action.setEnabled(false);
            return;
        }
        if (selectionList.size() == 1) {
            IShareable shareable = null;
            if (selectionList.get(0) instanceof ILocalChange) {
                ILocalChange localChange = (ILocalChange)selectionList.get(0);
                shareable = localChange.getShareable();
            } else if (selectionList.get(0) instanceof IOutgoingRemoteChangeSummary) {
                IOutgoingRemoteChangeSummary summary = (IOutgoingRemoteChangeSummary)selectionList.get(0);
                if (summary.getActivity().getChangeSet().isActive()) {
                    try {
                        shareable = this.findShareable((IRemoteChangeSummary)summary, null);
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            } else {
                action.setEnabled(true);
                return;
            }
            if (shareable == null) {
                action.setEnabled(false);
                return;
            }
            try {
                IMetadataProperties metadataProperties = shareable.getMetadataProperties((IProgressMonitor)new NullProgressMonitor());
                Map currentProperties = metadataProperties.getCurrentProperties();
                if (currentProperties.containsKey("team.enterprise.build.changes.ignoreForDependencyBuild")) {
                    boolean ignore = Boolean.parseBoolean((String)currentProperties.get("team.enterprise.build.changes.ignoreForDependencyBuild"));
                    if (ignore) {
                        if (action.getId().equals(UNIGNORE_ACTION_ID)) {
                            action.setEnabled(true);
                        }
                        action.setEnabled(false);
                        return;
                    }
                    action.setEnabled(action.getId().equals(IGNORE_ACTION_ID));
                }
                action.setEnabled(action.getId().equals(IGNORE_ACTION_ID));
            }
            catch (FileSystemException e) {
                e.printStackTrace();
                action.setEnabled(false);
                return;
            }
        } else {
            action.setEnabled(true);
        }
    }

    private List<IShareable> extractSelectedShareableFiles(IStructuredSelection selection, IProgressMonitor monitor) throws FileSystemException {
        ArrayList<IShareable> shared = new ArrayList<IShareable>(selection.size());
        List selList = selection.toList();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)selList.size());
        for (Object obj : selList) {
            this.extractShareableFilesFromObject(obj, shared, progress);
        }
        return shared;
    }

    private void extractShareableFilesFromObject(Object obj, List<IShareable> shared, SubMonitor progress) throws FileSystemException {
        IShareable shareable = null;
        if (obj instanceof ILocalChange) {
            ILocalChange localChange = (ILocalChange)obj;
            shareable = localChange.getShareable();
        } else if (obj instanceof ILocalFolder) {
            ILocalFolder folder = (ILocalFolder)obj;
            for (Object child : folder.getLocalChangeSource().getLocalChanges(folder)) {
                this.extractShareableFilesFromObject(child, shared, progress);
            }
        } else if (obj instanceof ILocalChangeSource) {
            ILocalChangeSource source = (ILocalChangeSource)obj;
            for (Object child : source.getLocalChanges()) {
                this.extractShareableFilesFromObject(child, shared, progress);
            }
        } else if (obj instanceof IUnresolvedItem) {
            IUnresolvedItem item = (IUnresolvedItem)obj;
            for (Object child : item.getLocalChanges()) {
                this.extractShareableFilesFromObject(child, shared, progress);
            }
        } else if (obj instanceof IUnresolvedFolder) {
            IUnresolvedFolder folder = (IUnresolvedFolder)obj;
            for (IUnresolvedItem item : folder.getItems()) {
                for (Object child : item.getLocalChanges()) {
                    this.extractShareableFilesFromObject(child, shared, progress);
                }
            }
        } else if (obj instanceof IUnresolvedSource) {
            IUnresolvedSource source = (IUnresolvedSource)obj;
            for (Object child : source.getModel().getLocalChangeSource().getLocalChanges()) {
                this.extractShareableFilesFromObject(child, shared, progress);
            }
        } else if (obj instanceof IOutgoingRemoteChangeSummary) {
            IOutgoingRemoteChangeSummary summary = (IOutgoingRemoteChangeSummary)obj;
            if (summary.getActivity().getChangeSet().isActive()) {
                try {
                    shareable = this.findShareable((IRemoteChangeSummary)summary, (IProgressMonitor)progress);
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                    return;
                }
            }
        } else if (obj instanceof IOutgoingRemoteActivity) {
            IOutgoingRemoteActivity activity = (IOutgoingRemoteActivity)obj;
            for (Object child : activity.getChanges()) {
                this.extractShareableFilesFromObject(child, shared, progress);
            }
        } else if (obj instanceof IOutgoingActivityFolder) {
            IOutgoingActivityFolder folder = (IOutgoingActivityFolder)obj;
            for (Object child : folder.getActivity().getChanges((IActivityFolder)folder)) {
                this.extractShareableFilesFromObject(child, shared, progress);
            }
        }
        if (shareable == null || shareable.getShare((IProgressMonitor)progress.newChild(1)) == null) {
            return;
        }
        if (!shared.contains(shareable)) {
            shared.add(shareable);
        }
    }

    private IShareable findShareable(IRemoteChangeSummary change, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        IRemoteActivity activity = change.getActivity();
        IComponentSyncContext context = activity.getActivitySource().getModel();
        IComponent component = context.getComponent();
        IShareable shareable = null;
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int i = 0;
        while (i < contexts.length) {
            if (contexts[i].getComponent().sameItemId((IItemHandle)component)) {
                progress.setWorkRemaining(contexts.length - i);
                shareable = this.findShareable((IWorkspaceHandle)contexts[i].getOutgoingTeamPlace().getResolvedWorkspace(), (IComponentHandle)component, change, (IProgressMonitor)progress.newChild(1));
                if (shareable != null) break;
            }
            ++i;
        }
        progress.done();
        return shareable;
    }

    private IShareable findShareable(IWorkspaceHandle ws, IComponentHandle component, IRemoteChangeSummary change, IProgressMonitor monitor) throws FileSystemException {
        IVersionableHandle item = change.getItem();
        return this.findShareable((IContextHandle)ws, component, item, monitor);
    }

    private IShareable findShareable(IContextHandle workspace, IComponentHandle component, IVersionableHandle item, IProgressMonitor monitor) throws FileSystemException {
        List<IShareable> result = this.findShareables(workspace, component, item, monitor);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        for (IShareable shareable : result) {
            if (shareable.getAdapter(IResource.class) == null) continue;
            return shareable;
        }
        return result.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<IShareable> findShareables(final IContextHandle workspace, final IComponentHandle component, final IVersionableHandle item, final IProgressMonitor monitor) throws FileSystemException {
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        final Collection sandboxes = sharingManager.getRegisteredSandboxes();
        final ArrayList<IShareable> result = new ArrayList<IShareable>(2);
        final boolean[] done = new boolean[1];
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (ISandbox sandbox : sandboxes) {
                    IShareable shareable = null;
                    try {
                        shareable = sandbox.findShareable(workspace, component, item, monitor);
                    }
                    catch (FileSystemException e) {
                        e.printStackTrace();
                    }
                    if (shareable == null) continue;
                    result.add(shareable);
                }
                done[0] = true;
                Object object = IgnoreForBuildAction.this.lock;
                synchronized (object) {
                    IgnoreForBuildAction.this.lock.notifyAll();
                }
            }
        }.start();
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (done[0]) {
                    return result;
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

