/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.types.resources;

import com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.teamz.buildmap.common.IInput;
import com.ibm.team.enterprise.internal.teamz.buildmap.common.util.BuildMapUtil;
import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.tasks.zos.AbstractRTCzTask;
import com.ibm.teamz.build.ant.types.resources.BuildableResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BuildableResourceCollection
extends DataType
implements ResourceCollection {
    private static final String BUILD_FILE_NAME_SPACE = "http://www.ibm.com/teamz/build/buildablefiles";
    private static final String DEPENDENCY_SET_NAME_SPACE = "http://www.ibm.com/teamz/build/dependencyset";
    private static final String INPUTS_NAME_SPACE = "http://www.ibm.com/teamz/build/buildmap/inputs/";
    private static final String OUTPUTS_NAME_SPACE = "http://www.ibm.com/teamz/build/buildmap/outputs/";
    private static final String PARSER_OUTPUTS_NAME_SPACE = "http://www.ibm.com/teamz/build/buildmap/parserOutputs/";
    private static final String DATASET_ATTRIBUTE = "dataset";
    private static final String MEMBER_ATTRIBUTE = "member";
    private static final String MACRO_ATTRIBUTE = "buildMacro";
    private static final String BUILDABLE_ELEMENT = "buildable";
    private static final String FILE_ELEMENT = "file";
    private static final String PROJECT_ELEMENT = "project";
    private static final String COMPONENT_ELEMENT = "component";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String LANGDEFNAME_ATTRIBUTE = "langDefName";
    private static final String UUID_ATTRIBUTE = "uuid";
    private static final String LANGUAGE_CODE_ATTRIBUTE = "languageCode";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String DEPENDENCY_SET_ELEMENT = "dependency-set";
    private static final String REBUILD_ATTRIBUITE = "rebuild";
    private static final String OUTPUTS_ELEMENT = "outputs";
    private static final String PARSER_OUTPUTS_ELEMENT = "parserOutputs";
    private static final String WORK_ITEMS_ELEMENT = "workItems";
    private static final String WORK_ITEM_ELEMENT = "workItem";
    private File fBuildableList;
    private final List<Resource> fResources = new ArrayList<Resource>();

    public boolean isFilesystemOnly() {
        return false;
    }

    public Iterator<Resource> iterator() {
        if (this.isReference()) {
            return ((BuildableResourceCollection)((Object)this.getCheckedRef(this.getProject()))).iterator();
        }
        if (this.fBuildableList == null || !this.fBuildableList.exists()) {
            throw new BuildException(NLS.bind((String)Messages.BUILDABLE_FILE_NOT_FOUND, (Object)this.fBuildableList));
        }
        this.initialize();
        return this.fResources.iterator();
    }

    public int size() {
        if (this.isReference()) {
            return ((BuildableResourceCollection)((Object)this.getCheckedRef())).size();
        }
        this.dieOnCircularReference();
        this.initialize();
        return this.fResources.size();
    }

    public File getBuildableList() {
        return this.fBuildableList;
    }

    public void setBuildableList(File buildableList) {
        this.fBuildableList = buildableList;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator<Resource> iterator = this.iterator();
        while (iterator.hasNext()) {
            BuildableResource resource = (BuildableResource)iterator.next();
            buffer.append(resource.getDatasetName());
            String memberName = resource.getMemberName();
            if (memberName != null) {
                buffer.append("(" + memberName + ")");
            }
            if (!iterator.hasNext()) continue;
            buffer.append(" : ");
        }
        return buffer.toString();
    }

    private void initialize() {
        if (this.fResources != null && this.fResources.size() > 0) {
            return;
        }
        if (this.fBuildableList == null || !this.fBuildableList.exists()) {
            throw new BuildException(NLS.bind((String)Messages.BUILDABLE_FILE_READ_ERROR, (Object)this.fBuildableList));
        }
        Document buildableFiles = this.parseBuildableList();
        NodeList buildable = buildableFiles.getElementsByTagNameNS(BUILD_FILE_NAME_SPACE, BUILDABLE_ELEMENT);
        Element buildableElement = (Element)buildable.item(0);
        String version = buildableElement.getAttributeNS(BUILD_FILE_NAME_SPACE, VERSION_ATTRIBUTE);
        this.log(NLS.bind((String)Messages.BUILDABLE_FILE_VERSION, (Object)version), 3);
        if (version.equals("")) {
            throw new BuildException(Messages.BUILDABLE_FILE_BACK_LEVEL);
        }
        NodeList components = buildableFiles.getElementsByTagNameNS(BUILD_FILE_NAME_SPACE, COMPONENT_ELEMENT);
        int numOfComponents = components.getLength();
        int i = 0;
        while (i < numOfComponents) {
            Node component = components.item(i);
            List<BuildableResource> componentResources = BuildableResourceCollection.getResources((Element)component, (ProjectComponent)this);
            if (componentResources.size() > 0) {
                this.fResources.addAll(componentResources);
            }
            ++i;
        }
    }

    private Document parseBuildableList() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(this.fBuildableList);
        }
        catch (ParserConfigurationException e) {
            this.log(e.getMessage(), 3);
            throw new BuildException(NLS.bind((String)Messages.BUILDABLE_PARSE_EXCEPTION, (Object)this.fBuildableList));
        }
        catch (SAXException e) {
            this.log(e.getMessage(), 3);
            throw new BuildException(NLS.bind((String)Messages.BUILDABLE_PARSE_EXCEPTION, (Object)this.fBuildableList));
        }
        catch (IOException e) {
            this.log(e.getMessage(), 3);
            throw new BuildException(NLS.bind((String)Messages.BUILDABLE_FILE_READ_ERROR, (Object)this.fBuildableList));
        }
        return document;
    }

    public void log(String msg, int msgLevel) {
        msg = "[antz:buildableset] " + AbstractRTCzTask.getDateString() + msg;
        if (this.getProject() != null) {
            this.getProject().log(msg, msgLevel);
        } else if (msgLevel <= 2) {
            System.err.println(msg);
        }
    }

    private static List<BuildableResource> getResources(Element componentElement, ProjectComponent comp) {
        NodeList projectNodes = componentElement.getElementsByTagNameNS(BUILD_FILE_NAME_SPACE, PROJECT_ELEMENT);
        ArrayList<BuildableResource> resources = new ArrayList<BuildableResource>();
        int numOfProjectNodes = projectNodes.getLength();
        int x = 0;
        while (x < numOfProjectNodes) {
            Element projectElement = (Element)projectNodes.item(x);
            NodeList resourceNodes = projectElement.getElementsByTagNameNS(BUILD_FILE_NAME_SPACE, FILE_ELEMENT);
            int numOfResourceNodes = resourceNodes.getLength();
            int i = 0;
            while (i < numOfResourceNodes) {
                Element workItemsElement;
                NodeList workItems;
                int size;
                NodeList workItemsList;
                Element parserOutputsElement;
                NodeList parserOutputFiles;
                int size2;
                NodeList parserOutputsList;
                Element outputsElement;
                NodeList outputFiles;
                int size3;
                NodeList outputsList;
                Element resourceElement = (Element)resourceNodes.item(i);
                String name = resourceElement.getAttributeNS(BUILD_FILE_NAME_SPACE, DATASET_ATTRIBUTE);
                String member = resourceElement.getAttributeNS(BUILD_FILE_NAME_SPACE, MEMBER_ATTRIBUTE);
                String buildMacro = resourceElement.getAttributeNS(BUILD_FILE_NAME_SPACE, MACRO_ATTRIBUTE);
                String componentName = componentElement.getAttributeNS(BUILD_FILE_NAME_SPACE, NAME_ATTRIBUTE);
                String projectName = projectElement.getAttributeNS(BUILD_FILE_NAME_SPACE, NAME_ATTRIBUTE);
                String langDefName = resourceElement.getAttributeNS(BUILD_FILE_NAME_SPACE, LANGDEFNAME_ATTRIBUTE);
                String languageCode = resourceElement.getAttributeNS(BUILD_FILE_NAME_SPACE, LANGUAGE_CODE_ATTRIBUTE);
                String uuid = resourceElement.getAttributeNS(BUILD_FILE_NAME_SPACE, UUID_ATTRIBUTE);
                BuildableResource resource = new BuildableResource(name, member, componentName, projectName, buildMacro, langDefName, uuid, languageCode);
                NodeList list = resourceElement.getElementsByTagNameNS(DEPENDENCY_SET_NAME_SPACE, DEPENDENCY_SET_ELEMENT);
                if (list.getLength() > 0) {
                    Element dependencySetElement = (Element)list.item(0);
                    BuildableResourceCollection.updateDependencySet(resource, dependencySetElement);
                }
                if ((outputsList = resourceElement.getElementsByTagNameNS(BUILD_FILE_NAME_SPACE, OUTPUTS_ELEMENT)).getLength() > 0 && (size3 = (outputFiles = (outputsElement = (Element)outputsList.item(0)).getElementsByTagNameNS(OUTPUTS_NAME_SPACE, FILE_ELEMENT)).getLength()) > 0) {
                    HashSet<IBuildFile> outputFilesSet = new HashSet<IBuildFile>(size3);
                    int j = 0;
                    while (j < size3) {
                        Node node = outputFiles.item(j);
                        IBuildFile buildFile = BuildMapUtil.readOutputsFile((Node)node);
                        if (buildFile != null) {
                            outputFilesSet.add(buildFile);
                        }
                        ++j;
                    }
                    resource.setOutputFiles(outputFilesSet);
                }
                if ((parserOutputsList = resourceElement.getElementsByTagNameNS(BUILD_FILE_NAME_SPACE, PARSER_OUTPUTS_ELEMENT)).getLength() > 0 && (size2 = (parserOutputFiles = (parserOutputsElement = (Element)parserOutputsList.item(0)).getElementsByTagNameNS(PARSER_OUTPUTS_NAME_SPACE, FILE_ELEMENT)).getLength()) > 0) {
                    HashSet<IBuildFile> parserOutputFilesSet = new HashSet<IBuildFile>(size2);
                    int j = 0;
                    while (j < size2) {
                        Node node = parserOutputFiles.item(j);
                        IBuildFile buildFile = BuildMapUtil.readParserOutputsFile((Node)node);
                        if (buildFile != null) {
                            parserOutputFilesSet.add(buildFile);
                        }
                        ++j;
                    }
                    resource.setParserOutputFiles(parserOutputFilesSet);
                }
                if ((workItemsList = resourceElement.getElementsByTagNameNS(BUILD_FILE_NAME_SPACE, WORK_ITEMS_ELEMENT)).getLength() > 0 && (size = (workItems = (workItemsElement = (Element)workItemsList.item(0)).getElementsByTagNameNS(BUILD_FILE_NAME_SPACE, WORK_ITEM_ELEMENT)).getLength()) > 0) {
                    HashSet<String> workItemsSet = new HashSet<String>(size);
                    int j = 0;
                    while (j < size) {
                        Element workItemElement = (Element)workItems.item(j);
                        workItemsSet.add(workItemElement.getTextContent());
                        ++j;
                    }
                    resource.setWorkItems(workItemsSet);
                }
                comp.log(NLS.bind((String)Messages.BUILDABLE_RESOURCE_ADDED, (Object)resource.toString()), 4);
                resources.add(resource);
                ++i;
            }
            ++x;
        }
        return resources;
    }

    public static void updateDependencySet(BuildableResource resource, Element dependencySetElement) {
        String rebuild = dependencySetElement.getAttribute(REBUILD_ATTRIBUITE);
        resource.setRebuild(Boolean.parseBoolean(rebuild));
        NodeList files = dependencySetElement.getElementsByTagNameNS(INPUTS_NAME_SPACE, FILE_ELEMENT);
        int size = files.getLength();
        int j = 0;
        while (j < size) {
            Node node = files.item(j);
            IBuildFile buildFile = BuildMapUtil.readInputsFile((Node)node);
            if (buildFile != null) {
                resource.add(buildFile);
            }
            ++j;
        }
    }

    public static void updateDependencySet(BuildableResource resource, boolean rebuild, Set<IInput> inputSet) {
        resource.setRebuild(rebuild);
        for (IInput input : inputSet) {
            IBuildFile buildFile = (IBuildFile)input.getArtifact();
            if (buildFile == null) continue;
            resource.add(buildFile);
        }
    }

    public static void updateDependencySet(BuildableResource resource, String dependencySetElementXML) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream ins = new ByteArrayInputStream(dependencySetElementXML.getBytes("UTF-8"));
        Document document = builder.parse(ins);
        NodeList list = document.getElementsByTagNameNS(DEPENDENCY_SET_NAME_SPACE, DEPENDENCY_SET_ELEMENT);
        if (list.getLength() > 0) {
            Element dependencySetElement = (Element)list.item(0);
            BuildableResourceCollection.updateDependencySet(resource, dependencySetElement);
        }
    }
}

