/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.types.resources;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Resource;

public class BuildableResource
extends Resource {
    public static final String GENERATED_OUTPUTS_LIST = "generatedOutputs.properties";
    private static final String ZERO_LENGTH_STRING = "";
    private String datasetName;
    private String memberName;
    private String projectName;
    private String componentName;
    private String buildMacro;
    private String langDefName;
    private String text;
    private String uuid;
    private String languageCode;
    private boolean rebuild;
    private final Set<IBuildFile> fInputFiles = new HashSet<IBuildFile>();
    private Set<IBuildFile> fOutputFiles;
    private Set<IBuildFile> fParserOutputFiles;
    private Set<IBuildFile> fResolvedInputFiles;
    private Set<String> fWorkItems;

    public BuildableResource() {
    }

    public BuildableResource(String datasetName, String memberName, String componentName, String projectName, String buildMacro, String LangDefName) {
        this(datasetName, memberName, componentName, projectName, buildMacro, LangDefName, ZERO_LENGTH_STRING);
    }

    public BuildableResource(String datasetName, String memberName, String componentName, String projectName, String buildMacro, String LangDefName, String uuid) {
        this(datasetName, memberName, componentName, projectName, buildMacro, LangDefName, uuid, ZERO_LENGTH_STRING);
    }

    public BuildableResource(String datasetName, String memberName, String componentName, String projectName, String buildMacro, String LangDefName, String uuid, String languageCode) {
        this.datasetName = datasetName;
        this.memberName = memberName;
        this.componentName = componentName;
        this.projectName = projectName;
        this.buildMacro = buildMacro;
        this.langDefName = LangDefName;
        this.uuid = uuid;
        this.languageCode = languageCode;
        StringBuffer name = new StringBuffer(this.getDatasetName());
        if (this.memberName != null) {
            name.append("(" + this.memberName + ")");
        }
        this.setName(name.toString());
    }

    public boolean isExists() {
        try {
            return ZFile.exists((String)this.getMvsName());
        }
        catch (ZFileException zfe) {
            return false;
        }
    }

    public String getMvsName() {
        return "//'" + this.getName() + "'";
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        ZFile file = new ZFile(this.getMvsName(), "rt");
        return file.getInputStream();
    }

    public String getBuildMacro() {
        return this.buildMacro;
    }

    public void setBuildMacro(String buildMacro) {
        this.buildMacro = buildMacro;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getLangDefName() {
        return this.langDefName;
    }

    public void setLangDefName(String langDefName) {
        this.langDefName = langDefName;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean isRebuild() {
        return this.rebuild;
    }

    public void setRebuild(boolean rebuild) {
        this.rebuild = rebuild;
    }

    public void addText(String text) {
        this.text = text;
    }

    public String getNestedText() {
        return this.text == null ? null : this.getProject().replaceProperties(this.text);
    }

    public long getSize() {
        return -1L;
    }

    public long getLastModified() {
        return 0L;
    }

    public String toString() {
        return "Resource name: " + this.getName() + " project: " + this.getProjectName() + " mvsName: " + this.getMvsName() + " buildMacro: " + this.getBuildMacro() + " rebuild: " + this.isRebuild();
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void add(IBuildFile buildFile) {
        this.fInputFiles.add(buildFile);
    }

    public Set<IBuildFile> getFiles() {
        return this.fInputFiles;
    }

    public void setOutputFiles(Set<IBuildFile> outputFiles) {
        this.fOutputFiles = outputFiles;
    }

    public Set<IBuildFile> getOutputFiles() {
        return this.fOutputFiles;
    }

    public void setParserOutputFiles(Set<IBuildFile> parserOutputFiles) {
        this.fParserOutputFiles = parserOutputFiles;
    }

    public Set<IBuildFile> getParserOutputFiles() {
        return this.fParserOutputFiles;
    }

    public void setResolvedInputFiles(Set<IBuildFile> resolvedInputFiles) {
        this.fResolvedInputFiles = resolvedInputFiles;
    }

    public Set<IBuildFile> getResolvedInputFiles() {
        return this.fResolvedInputFiles;
    }

    public Set<String> getWorkItems() {
        return this.fWorkItems;
    }

    public void setWorkItems(Set<String> workItemsSet) {
        this.fWorkItems = workItemsSet;
    }

    public static String getTmpDir(Project project) {
        String tmpDir = project.getProperty("teamz.scm.fetchDestination");
        if (tmpDir == null) {
            tmpDir = System.getProperty("java.io.tmpdir");
        }
        return tmpDir;
    }

    public static Properties loadGeneratedOutputProperties(Project project) throws IOException, FileNotFoundException {
        Properties outputsProperties = new Properties();
        File outputsPropertiesFile = new File(String.valueOf(BuildableResource.getTmpDir(project)) + "/" + GENERATED_OUTPUTS_LIST);
        outputsProperties = new Properties();
        if (outputsPropertiesFile.exists()) {
            outputsProperties.load(new FileInputStream(outputsPropertiesFile));
        }
        return outputsProperties;
    }

    public static void storeGeneratedOutputProperties(Project project, Properties p) throws FileNotFoundException, IOException {
        if (p != null) {
            File outputsPropertiesFile = new File(String.valueOf(BuildableResource.getTmpDir(project)) + "/" + GENERATED_OUTPUTS_LIST);
            p.store(new FileOutputStream(outputsPropertiesFile), ZERO_LENGTH_STRING);
        }
    }
}

