/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.tasks.zos;

import com.ibm.team.enterprise.build.common.promotion.IPromotableFile;
import com.ibm.team.enterprise.build.common.promotion.IPromotableResource;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfoUtil;
import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.internal.utils.ZOS;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.osgi.util.NLS;

public class PromoteHFSFilesTask
extends Task {
    private File sourceDir;
    private File targetDir;
    private File manifest;

    public void execute() {
        if (this.manifest != null && this.manifest.exists()) {
            this.validateDirectory(this.sourceDir, true);
            this.validateDirectory(this.targetDir, false);
            try {
                String manifestXML = ZOS.fileToString(this.manifest, "UTF-8");
                PromotionInfo pi = PromotionInfoUtil.parsePromotionInfo((String)manifestXML);
                for (IPromotableResource resource : pi.getPromotableResources().values()) {
                    boolean hasHFS = false;
                    File fullSrcPath = new File(this.sourceDir, resource.getSourceResource());
                    File fullTargetPath = new File(this.targetDir, resource.getTargetResource());
                    FileSet fileSet = new FileSet();
                    fileSet.setProject(this.getProject());
                    fileSet.setDir(fullSrcPath);
                    for (IPromotableFile file : resource.getFiles()) {
                        if (!"file".equals(file.getType())) continue;
                        hasHFS = true;
                        fileSet.createInclude().setName(file.getName());
                    }
                    if (!hasHFS) continue;
                    Copy copy = (Copy)this.getProject().createTask("copy");
                    copy.setTodir(fullTargetPath);
                    copy.addFileset(fileSet);
                    copy.execute();
                }
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            throw new BuildException(NLS.bind((String)Messages.PromoteHFSFilesTask_MANIFEST_DOES_NOT_EXIST_ERROR_MSG, (Object)(this.manifest == null ? "" : this.manifest.getAbsolutePath())));
        }
    }

    private void validateDirectory(File dir, boolean isSrc) {
        if (dir == null) {
            throw new BuildException(isSrc ? Messages.PromoteHFSFilesTask_SOURCE_DIR_NOT_SPECIFIED : Messages.PromoteHFSFilesTask_TARGET_DIR_NOT_SPECIFIED);
        }
        if (!dir.exists()) {
            if (isSrc) {
                throw new BuildException(NLS.bind((String)Messages.PromoteHFSFilesTask_DIR_DOES_NOT_EXIST, (Object)dir.getAbsolutePath()));
            }
            if (!dir.mkdirs()) {
                throw new BuildException(NLS.bind((String)Messages.PromoteHFSFilesTask_MKDIR_FAILED, (Object)dir.getAbsolutePath()));
            }
        }
        if (!dir.isDirectory()) {
            throw new BuildException(NLS.bind((String)Messages.PromoteHFSFilesTask_DIR_NOT_A_DIR, (Object)dir.getAbsolutePath()));
        }
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public void setSourceDir(File dir) {
        this.sourceDir = dir;
    }

    public void setTargetDir(File dir) {
        this.targetDir = dir;
    }
}

