/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.tasks.zos;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.tasks.zos.AbstractRTCzTask;
import java.io.File;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class LoadFiles
extends AbstractRTCzTask {
    private static final String EXECUTE_XML_FILE_CAPACITY = "executeXMLFileCapacity";
    private static final String EXECUTE_XML_FILE_CAPACITY_CERTIF = "executeXMLFileCapacityCertif";
    private static final String FA_XML_API_CLASS_NAME = "com.ibm.teamz.fileagent.ExecuteXMLFileCapacity";
    private static final String ZOS_FILE_SYSTEM_UTIL = "com.ibm.team.enterprise.zos.build.ant.internal.utils.FileSystemUtil";
    private static final String GETINSTANCE_METHOD_NAME = "getInstance";
    private static final String CREATELOCATION_METHOD_NAME = "createLocation";
    private String repositoryAddress;
    private String userId;
    private String passwordFile;
    private String workspaceUUID;
    private File certificateFile;
    private String loadDir;
    private String prefix;
    private boolean deleteMetadata;
    private boolean smartCard;
    private boolean kerberos;
    private File repositoriesFile;
    private File operationList;

    public File getRepositoriesFile() {
        return this.repositoriesFile;
    }

    public void setRepositoriesFile(File repositoriesFile) {
        this.repositoriesFile = repositoriesFile;
    }

    public boolean isSmartCard() {
        return this.smartCard;
    }

    public void setSmartCard(boolean smartCard) {
        this.smartCard = smartCard;
    }

    public boolean isKerberos() {
        return this.kerberos;
    }

    public void setKerberos(boolean kerberos) {
        this.kerberos = kerberos;
    }

    public File getCertificateFile() {
        return this.certificateFile;
    }

    public void setCertificateFile(File certificateFile) {
        this.certificateFile = certificateFile;
    }

    public String getRepositoryAddress() {
        return this.repositoryAddress;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.repositoryAddress = repositoryAddress;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getWorkspaceUUID() {
        return this.workspaceUUID;
    }

    public void setWorkspaceUUID(String workspaceUUID) {
        this.workspaceUUID = workspaceUUID;
    }

    public String getLoadDir() {
        return this.loadDir;
    }

    public void setLoadDir(String targetDirectory) {
        this.loadDir = targetDirectory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected static File getCertificateFile(Project p) {
        String value = p.getProperty("env.JAZZ_CERTIFICATE_FILE");
        return value == null ? null : new File(value);
    }

    protected static File getRegistryFile(Project p) {
        String value = p.getProperty("env.JAZZ_REGISTRY");
        return value == null ? null : new File(value);
    }

    public void setAuthenticationAttributes(String repositoryAddress, String userId, String passwordFile) {
        Project p = this.getProject();
        this.setUserId(userId);
        this.setPasswordFile(passwordFile);
        this.setCertificateFile(LoadFiles.getCertificateFile(p));
        this.setRepositoriesFile(LoadFiles.getRegistryFile(p));
    }

    public boolean isDeleteMetadata() {
        return this.deleteMetadata;
    }

    public void setDeleteMetadata(boolean deleteMetadata) {
        this.deleteMetadata = deleteMetadata;
    }

    public File getOperationList() {
        return this.operationList;
    }

    public void setOperationList(File operationList) {
        this.operationList = operationList;
    }

    public void execute() throws BuildException {
        ICorruptCopyFileAreaListener corruptSandboxListener = null;
        try {
            try {
                final Path fetchDestinationPath = new Path(new File(this.loadDir).getCanonicalPath());
                corruptSandboxListener = new ICorruptCopyFileAreaListener(){

                    public void corrupt(ICorruptCopyFileAreaEvent event) {
                        if (event.isCorrupt() && event.getRoot().equals((Object)fetchDestinationPath)) {
                            LoadFiles.this.log(NLS.bind((String)Messages.CORRUPT_SANDBOX_DURING_LOAD, (Object)fetchDestinationPath.toOSString()));
                        }
                    }
                };
                FileSystemCore.startUp();
                this.log("Add Corrupt Sandbox Listener.", 4);
                SharingManager sharingManager = (SharingManager)FileSystemCore.getSharingManager();
                sharingManager.addListener(corruptSandboxListener);
                Class<?> cls = Class.forName(FA_XML_API_CLASS_NAME);
                if (this.isDeleteMetadata()) {
                    Object zUtilCls = Class.forName(ZOS_FILE_SYSTEM_UTIL).getMethod(GETINSTANCE_METHOD_NAME, null).invoke(null, null);
                    ISandbox sandbox = sharingManager.getSandbox((ILocation)zUtilCls.getClass().getMethod(CREATELOCATION_METHOD_NAME, String.class).invoke(zUtilCls, this.prefix), false);
                    sharingManager.eraseSandboxMetadata(sandbox, (IProgressMonitor)new NullProgressMonitor());
                    this.log("MVS sandbox metadata for prefix " + this.prefix + " were erased.", 4);
                }
                this.setAuthenticationAttributes(this.repositoryAddress, this.userId, this.passwordFile);
                if (this.certificateFile != null && this.certificateFile.length() > 0L) {
                    String sCertificateFile = this.certificateFile.getCanonicalPath();
                    Method m = cls.getDeclaredMethod(EXECUTE_XML_FILE_CAPACITY_CERTIF, String.class, String.class, String.class, String.class);
                    this.log("Calling File Agent...", 4);
                    m.invoke(null, this.repositoryAddress, sCertificateFile, this.passwordFile, this.operationList.getCanonicalPath());
                } else {
                    Method m = cls.getDeclaredMethod(EXECUTE_XML_FILE_CAPACITY, String.class, String.class, String.class, String.class, String.class, String.class);
                    this.log("Calling File Agent...", 4);
                    String smartCardVal = null;
                    String kerberosVal = null;
                    if (this.smartCard) {
                        smartCardVal = "true";
                    }
                    if (this.kerberos) {
                        kerberosVal = "true";
                    }
                    m.invoke(null, this.repositoryAddress, this.userId, this.passwordFile, smartCardVal, kerberosVal, this.operationList.getCanonicalPath());
                }
                this.log("Returned from File Agent.", 4);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (corruptSandboxListener != null) {
                    this.log("Remove Corrupt Sandbox Listener.", 4);
                    ((SharingManager)FileSystemCore.getSharingManager()).removeListener(corruptSandboxListener);
                }
                this.log("Call FileSystemCore.shutDown()", 4);
                FileSystemCore.shutDown();
            }
            catch (FileSystemException e) {
                throw new BuildException((Throwable)e);
            }
            throw throwable;
        }
        try {
            if (corruptSandboxListener != null) {
                this.log("Remove Corrupt Sandbox Listener.", 4);
                ((SharingManager)FileSystemCore.getSharingManager()).removeListener(corruptSandboxListener);
            }
            this.log("Call FileSystemCore.shutDown()", 4);
            FileSystemCore.shutDown();
        }
        catch (FileSystemException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

