/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.tasks.zos;

import com.ibm.team.repository.common.util.ObfuscationHelper;
import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.internal.utils.PasswdHandler;
import com.ibm.teamz.build.ant.tasks.zos.AbstractRTCzTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KinitTask
extends AbstractRTCzTask {
    private String userId;
    private String passwordFile;
    private String krb5ccname;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getKrb5ccname() {
        return this.krb5ccname;
    }

    public void setKrb5ccname(String krb5ccname) {
        this.krb5ccname = krb5ccname;
    }

    private String decodePasswordFile(String path) throws ParserConfigurationException, SAXException, IOException {
        String result = "";
        FileInputStream inputStream = new FileInputStream(path);
        InputStreamReader reader = new InputStreamReader(inputStream);
        InputSource is = new InputSource(reader);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        PasswdHandler handler = new PasswdHandler();
        parser.parse(is, (DefaultHandler)handler);
        String encrypted = handler.getPasswd();
        try {
            result = new String(ObfuscationHelper.decryptString((String)encrypted));
        }
        catch (GeneralSecurityException e) {
            result = encrypted;
        }
        return result;
    }

    public void execute() {
        boolean isExecFile;
        this.log("KINIT passwordFile=" + this.getPasswordFile() + " userId=" + this.getUserId());
        String s = "";
        try {
            s = this.decodePasswordFile(this.getPasswordFile());
        }
        catch (ParserConfigurationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null || javaHome.isEmpty()) {
            throw new BuildException(Messages.INVALID_JAVA_HOME);
        }
        String kinitpath = String.valueOf(javaHome) + "/bin/kinit";
        File kinitFile = new File(kinitpath);
        boolean bl = isExecFile = kinitFile.isFile() && kinitFile.canExecute();
        if (!isExecFile) {
            this.log(String.valueOf(kinitpath) + " do not exist or is not executable");
            kinitpath = String.valueOf(javaHome) + "/jre/bin/kinit";
        }
        String cmdLine = this.getKrb5ccname() == null || this.getKrb5ccname().isEmpty() ? String.valueOf(kinitpath) + " " + this.getUserId() + " " + s : String.valueOf(kinitpath) + " -c " + this.getKrb5ccname() + " " + this.getUserId() + " " + s;
        try {
            Process kinitp = Runtime.getRuntime().exec(cmdLine);
            int retCode = kinitp.waitFor();
            this.log("Kinit rc: " + retCode);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

