/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.tasks.zos;

import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.team.build.ant.task.AbstractPublisherTask;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.ant.task.LogPublisherTask;
import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.internal.utils.AuthenticationUtilities;
import com.ibm.teamz.build.ant.internal.utils.TaskLog;
import com.ibm.teamz.build.ant.internal.utils.ZOS;
import com.ibm.teamz.build.ant.tasks.zos.AbstractRTCzTask;
import com.ibm.teamz.build.ant.types.zos.AbstractDD;
import com.ibm.teamz.build.ant.types.zos.Alloc;
import com.ibm.teamz.build.ant.types.zos.Concat;
import com.ibm.teamz.build.ant.zos.exceptions.ZosException;
import com.ibm.teamz.build.ant.zos.utils.ILoggingInterface;
import com.ibm.teamz.build.ant.zos.utils.ISPFGatewayUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.eclipse.osgi.util.NLS;

public class Executable
extends AbstractRTCzTask {
    private static final String SSI_INFO = "@{ssi_info}";
    private static final int SIXTEEN = 16;
    private static final String COMMA = ",";
    private static final String DD_PREFIX = "//DD:";
    private static final String EIGHT_SPACES = "        ";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String LOG_EXTENSION = ".log";
    private static final String PLAIN_TEXT = "plain/text";
    private static final String READ_ONLY = "r";
    private static final String TASKLIB = "TASKLIB";
    private static final String UTF_8 = "UTF-8";
    private static final String ZERO_LENGTH_STRING = "";
    private static final String CRLF = "\r\n";
    private static final int DEFAULT_SIZE = 16;
    private static final int CALL_METHOD_TYPE_ISPF = 1;
    private static final int CALL_METHOD_TYPE_TSO = 2;
    private final ArrayList<AbstractDD> allocs = new ArrayList();
    private String buildResultUUID;
    private String ddnamelist;
    private int maxrc;
    private String name;
    private String parm;
    private String password;
    private File passwordFile;
    private String pgm;
    private boolean publishoutputs;
    private boolean publishoutputsforerrorsonly;
    private String publishoutputsdds;
    private int rc;
    private String repositoryAddress;
    private boolean tasklib;
    private String userId;
    private String certificateFile;
    private boolean smartCard;
    private boolean kerberos;
    private String loadDir;
    private int callMethod;
    private String command;
    private boolean preview;

    protected String getCertificateFile() {
        return this.certificateFile;
    }

    protected void setCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
    }

    protected boolean isSmartCard() {
        return this.smartCard;
    }

    protected void setSmartCard(boolean smartCard) {
        this.smartCard = smartCard;
    }

    public boolean isKerberos() {
        return this.kerberos;
    }

    public void setKerberos(boolean kerberos) {
        this.kerberos = kerberos;
    }

    public void addAlloc(Alloc alloc) {
        this.allocs.add(alloc);
    }

    public void addConcat(Concat concat) {
        this.allocs.add(concat);
    }

    private void allocateDDs() throws IOException {
        for (AbstractDD alloc : this.allocs) {
            alloc.allocate(this);
            if (!TASKLIB.equals(alloc.getDd().toUpperCase(Locale.US))) continue;
            this.tasklib = true;
        }
    }

    private List<String[]> getAllocationStringList() {
        ArrayList<String[]> allocationStringList = new ArrayList<String[]>(16);
        for (AbstractDD alloc : this.allocs) {
            List<String[]> l = alloc.getAllocationStringList(this);
            allocationStringList.addAll(l);
        }
        return allocationStringList;
    }

    private String buildDdnames() {
        String ddnames = this.getDdnamelist();
        if (ddnames == null) {
            return null;
        }
        String[] dds = ddnames.split(COMMA);
        String s = ZERO_LENGTH_STRING;
        String[] stringArray = dds;
        int n = dds.length;
        int n2 = 0;
        while (n2 < n) {
            String dd = stringArray[n2];
            s = String.valueOf(s) + Executable.formatInEightChars(dd);
            ++n2;
        }
        return s;
    }

    public int compile(String pgm, String options, String ddnames, boolean attachx) {
        return new com.ibm.teamz.build.ant.jni.Executable().compile(pgm, options, ddnames, attachx);
    }

    public int exec(String parm) throws BuildException {
        int rc = 0;
        String pgm = this.getPgm();
        String name = this.getName();
        if (pgm == null) {
            throw new BuildException(NLS.bind((String)Messages.PGM_IS_NULL, (Object)name));
        }
        if (pgm.length() > 8) {
            throw new BuildException(NLS.bind((String)Messages.PGM_TOO_LONG, (Object)name, (Object)pgm));
        }
        pgm = Executable.formatInEightChars(pgm);
        String parameter = parm;
        if (parameter != null && parameter.contains(SSI_INFO)) {
            long l = System.currentTimeMillis() / 1000L;
            String ssi_info = String.format("%08x", l).toUpperCase(Locale.US);
            parameter = parameter.replace(SSI_INFO, ssi_info);
        }
        this.log(NLS.bind((String)Messages.MVSEXEC_INFO, (Object[])new String[]{name, pgm, parameter, this.buildDdnames()}), 3);
        rc = this.compile(pgm, parameter, this.buildDdnames(), this.tasklib);
        return rc;
    }

    public void execute() throws BuildException {
        if (this.isPreview()) {
            return;
        }
        if (this.callMethod == 1 || this.callMethod == 2) {
            try {
                this.executeTso();
                this.publishDDs(this.rc);
                return;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        try {
            this.allocateDDs();
        }
        catch (RcException rce) {
            this.freeDDs();
            throw new BuildException((Throwable)rce);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        this.rc = this.exec(this.getParm());
        this.log(NLS.bind((String)Messages.COMPILE_RESULT, (Object[])new Object[]{this.name, this.rc, Integer.toString(this.rc, 16)}), 3);
        this.rc = this.convertRc(this.rc);
        this.publishDDs(this.rc);
        this.freeDDs();
        this.checkRc(this.rc);
    }

    private void freeDDs() {
        for (AbstractDD alloc : this.allocs) {
            alloc.free(this);
        }
    }

    private void publishDDs(int rc) {
        boolean useGateway = this.callMethod == 1 || this.callMethod == 2;
        Set<String> outputdds = this.getDDsToBePublished(rc);
        for (AbstractDD alloc : this.allocs) {
            String ddname = alloc.getDd().toUpperCase(Locale.US);
            if (!outputdds.contains(ddname) || !(alloc instanceof Alloc)) continue;
            Alloc alc = (Alloc)alloc;
            if (useGateway && alc.getDsn() == null) continue;
            try {
                if (useGateway) {
                    alc.allocate(this);
                }
                this.publishFile(ddname, rc);
                if (!useGateway) continue;
                alloc.free(this);
            }
            catch (ZFileException ze) {
                this.log(ze.toString(), 2);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private Set<String> getDDsToBePublished(int rc) {
        HashSet<String> outputdds;
        block4: {
            outputdds = new HashSet<String>();
            if (!this.isPublishoutputs() || this.isPublishoutputsforerrorsonly() && rc <= this.getMaxrc()) break block4;
            if (this.getPublishoutputsdds() != null && this.getPublishoutputsdds().trim().length() > 0 && this.getPublishoutputsdds().charAt(0) != '$') {
                String[] dds;
                String s = this.getPublishoutputsdds().trim().toUpperCase(Locale.US);
                String[] stringArray = dds = s.split(COMMA);
                int n = dds.length;
                int n2 = 0;
                while (n2 < n) {
                    String dd = stringArray[n2];
                    outputdds.add(dd);
                    ++n2;
                }
            } else {
                for (AbstractDD alloc : this.allocs) {
                    if (!(alloc instanceof Alloc) || !((Alloc)alloc).isPublish()) continue;
                    String ddname = alloc.getDd().toUpperCase(Locale.US);
                    outputdds.add(ddname);
                }
            }
        }
        return outputdds;
    }

    private static String formatInEightChars(String s) {
        return (String.valueOf(s) + EIGHT_SPACES).substring(0, 8);
    }

    public String getBuildResultUUID() {
        return this.buildResultUUID;
    }

    public String getDdnamelist() {
        return this.ddnamelist;
    }

    public int getMaxrc() {
        return this.maxrc;
    }

    public String getName() {
        return this.name;
    }

    public String getParm() {
        return this.parm;
    }

    public String getPassword() {
        return this.password;
    }

    public File getPasswordFile() {
        return this.passwordFile;
    }

    public String getPgm() {
        return this.pgm;
    }

    public String getPublishoutputsdds() {
        return this.publishoutputsdds;
    }

    protected int getRc() {
        return this.rc;
    }

    public String getRepositoryAddress() {
        return this.repositoryAddress;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isOK(int maxRc) {
        return this.getRc() <= maxRc;
    }

    public boolean isPublishoutputs() {
        return this.publishoutputs;
    }

    public boolean isPublishoutputsforerrorsonly() {
        return this.publishoutputsforerrorsonly;
    }

    private void publish(File filePath, int rc) {
        LogPublisherTask logPublisherTask = new LogPublisherTask();
        logPublisherTask.setProject(this.getProject());
        logPublisherTask.setBuildResultUUID(this.buildResultUUID);
        logPublisherTask.setCharacterEncoding(UTF_8);
        logPublisherTask.setContentType(PLAIN_TEXT);
        logPublisherTask.setLabel(NLS.bind((String)Messages.SYSPRINT_DESCRIPTION, (Object)this.getName(), (Object)("&&ANTZTEMP".equals(this.getDescription()) ? Messages.INSTREAM_SOURCE : this.getDescription())));
        logPublisherTask.setDescription(logPublisherTask.getLabel());
        logPublisherTask.setFilePath(filePath);
        logPublisherTask.setRepositoryAddress(this.repositoryAddress);
        AuthenticationUtilities.setAuthenticationAttributes((AbstractTeamBuildTask)logPublisherTask, this.getRepositoryAddress(), this.getUserId(), this.getPasswordFile());
        logPublisherTask.setStatus((AbstractPublisherTask.BuildStatusAttribute)AbstractPublisherTask.BuildStatusAttribute.getInstance(AbstractPublisherTask.BuildStatusAttribute.class, (String)(rc > this.maxrc ? "ERROR" : (rc > 0 ? "WARNING" : "OK"))));
        logPublisherTask.setKerberos(this.kerberos);
        logPublisherTask.setSmartCard(this.smartCard);
        logPublisherTask.execute();
    }

    private void publishFile(String dd, int rc) throws IOException {
        if (!(this.password == null && this.passwordFile == null || this.buildResultUUID == null || this.repositoryAddress == null || this.userId == null && this.certificateFile == null)) {
            String x;
            String tmpdir = this.getLoadDir() == null ? System.getProperty(JAVA_IO_TMPDIR) : this.getLoadDir();
            File tempFile = new File(String.valueOf(tmpdir) + File.separator + dd + LOG_EXTENSION);
            EBCDICFilterInputStream ins = new EBCDICFilterInputStream(new ZFile(DD_PREFIX + dd, READ_ONLY).getInputStream());
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), UTF_8));
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)ins, com.ibm.teamz.build.ant.jni.Executable.retrieveEncoding()));
            while ((x = r.readLine()) != null) {
                w.write(String.valueOf(x) + CRLF);
            }
            w.flush();
            w.close();
            r.close();
            this.publish(tempFile, rc);
            tempFile.delete();
        }
    }

    private void publishFile(File f, String name, int rc) throws IOException {
        if (!(this.password == null && this.passwordFile == null || this.buildResultUUID == null || this.repositoryAddress == null || this.userId == null && this.certificateFile == null)) {
            String x;
            String tmpdir = this.getLoadDir() == null ? System.getProperty(JAVA_IO_TMPDIR) : this.getLoadDir();
            File tempFile = new File(String.valueOf(tmpdir) + File.separator + name + LOG_EXTENSION);
            EBCDICFilterInputStream ins = new EBCDICFilterInputStream(new FileInputStream(f));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), UTF_8));
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)ins, com.ibm.teamz.build.ant.jni.Executable.retrieveEncoding()));
            while ((x = r.readLine()) != null) {
                w.write(String.valueOf(x) + CRLF);
            }
            w.flush();
            w.close();
            r.close();
            this.publish(tempFile, rc);
            tempFile.delete();
        }
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public void setDdnamelist(String ddnamelist) {
        this.ddnamelist = ddnamelist;
    }

    public void setMaxrc(int maxrc) {
        this.maxrc = maxrc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParm(String parm) {
        this.parm = parm;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordFile(File passwordFile) {
        this.passwordFile = passwordFile;
    }

    public void setPgm(String pgm) {
        this.pgm = pgm;
    }

    public void setPublishoutputs(boolean publishoutputs) {
        this.publishoutputs = publishoutputs;
    }

    public void setPublishoutputsforerrorsonly(boolean publishoutputsforerrorsonly) {
        this.publishoutputsforerrorsonly = publishoutputsforerrorsonly;
    }

    public void setPublishoutputsdds(String publishoutputsdds) {
        this.publishoutputsdds = publishoutputsdds;
    }

    protected void setRc(int rc) {
        this.rc = rc;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.repositoryAddress = repositoryAddress;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLoadDir() {
        return this.loadDir;
    }

    public void setLoadDir(String loadDir) {
        this.loadDir = loadDir;
    }

    public int getCallMethod() {
        return this.callMethod;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCallMethod(int callMethod) {
        this.callMethod = callMethod;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    private int convertRc(int rc) {
        boolean allowNegativeReturnCode;
        int convertedRc = rc;
        if (rc < 0 && !(allowNegativeReturnCode = Boolean.valueOf(this.getProject().getProperty("teamz.build.ant.allowNegativeReturnCode")).booleanValue())) {
            int positiveRc = Math.abs(rc);
            this.log(NLS.bind((String)Messages.CONVERT_NEGATIVE_RC, (Object)rc, (Object)positiveRc), 3);
            convertedRc = positiveRc;
        }
        return convertedRc;
    }

    private void checkRc(int rc) {
        if (rc > this.getMaxrc()) {
            throw new BuildException(NLS.bind((String)Messages.RC_EXCEEDS_MAXRC, (Object[])new Object[]{this.name, rc, Integer.toString(rc, 16), this.maxrc, Integer.toString(this.maxrc, 16)}));
        }
    }

    private String allocateRexxScript(List<String[]> allocationStringList) throws BuildException, ZosException {
        String prefix = this.getProject().getProperty("teamz.scm.dataset.prefix");
        long sec = System.currentTimeMillis() / 1000L;
        boolean retry = true;
        String rexxScript = null;
        while (true) {
            try {
                String tempName = String.format("ID%05d", sec % 100000L);
                rexxScript = String.format("%s.%s.EXEC", prefix, tempName);
                this.log("Allocate " + rexxScript + " as the REXX script for ISPF Gateway.", 4);
                String allocationString = "ALLOC DA(" + rexxScript + ") FI(" + tempName + ") RECFM(F,B) LRECL(80) TRACKS SPACE(1,1) DSORG(PS) NEW CATALOG";
                ZOS.bpxwdyn((ProjectComponent)this, allocationString);
                ZOS.bpxwdyn((ProjectComponent)this, "FREE FI(" + tempName + ")");
                this.log(String.valueOf(rexxScript) + " is allocated.", 4);
            }
            catch (RcException e) {
                if (retry) {
                    ++sec;
                    retry = false;
                    continue;
                }
                throw e;
            }
            break;
        }
        return rexxScript;
    }

    private void executeTso() throws TransformerFactoryConfigurationError, Exception {
        boolean reuseISPFSession = Boolean.valueOf(this.getProject().getProperty("teamz.build.ant.reuseISPFSession"));
        boolean debugISPFGateway = Boolean.valueOf(this.getProject().getProperty("teamz.build.ant.debugISPFGateway"));
        String cmd = this.getCommand();
        String dirName = this.getLoadDir() == null ? System.getProperty(JAVA_IO_TMPDIR) : this.getLoadDir();
        File dir = new File(dirName);
        List<String[]> allocationStringList = this.getAllocationStringList();
        String rexxScript = this.allocateRexxScript(allocationStringList);
        File xml = ISPFGatewayUtil.generateXmlFile((ILoggingInterface)new TaskLog(this), (File)dir, (String)rexxScript, (String)cmd, (String)(this.getCallMethod() == 2 ? "TSO" : "ISPF"), (String)(reuseISPFSession ? "REUSE" : "NONE"), allocationStringList);
        File out = File.createTempFile("ispf", LOG_EXTENSION, dir);
        ExecTask execTask = new ExecTask();
        execTask.setProject(this.getProject());
        execTask.setLocation(this.getLocation());
        execTask.setTaskName("exec");
        execTask.setDir(dir);
        execTask.setOutput(out);
        execTask.setExecutable("/bin/sh");
        Commandline.Argument arg1 = execTask.createArg();
        arg1.setValue("-c");
        Commandline.Argument arg2 = execTask.createArg();
        String myISPFBinPath = this.getProject().getProperty("teamz.build.ant.myISPFBinPath");
        String path = String.valueOf(myISPFBinPath != null && myISPFBinPath.length() > 0 ? String.valueOf(myISPFBinPath) + ":" : ZERO_LENGTH_STRING) + "${PATH}:" + System.getenv("_CMDSERV_BASE_HOME") + "/bin";
        arg2.setValue("export PATH=" + path + "; cat " + xml.getCanonicalPath() + "|ISPZXML");
        execTask.setFailIfExecutionFails(true);
        try {
            execTask.execute();
            this.rc = ISPFGatewayUtil.getTranslatorReturnCode((File)out, (boolean)debugISPFGateway);
            this.log(NLS.bind((String)Messages.COMPILE_RESULT, (Object[])new Object[]{this.name, this.rc, Integer.toString(this.rc, 16)}), 3);
            this.rc = this.convertRc(this.rc);
            if (this.isPublishoutputs() && (!this.isPublishoutputsforerrorsonly() || this.rc > this.getMaxrc())) {
                this.publishFile(out, "ISPFGateway", this.rc);
            }
            this.checkRc(this.rc);
        }
        finally {
            if (!debugISPFGateway) {
                if (xml != null) {
                    xml.delete();
                }
                if (rexxScript != null) {
                    ZOS.removeDataset((ProjectComponent)this, rexxScript);
                }
                if (out != null) {
                    out.delete();
                }
            }
        }
    }

    class EBCDICFilterInputStream
    extends FilterInputStream {
        private static final int LINE_FEED = 37;
        private static final int CARRIAGE_RETURN = 13;
        private static final int NEW_LINE = 21;
        private static final int HORIZONTAL_TAB = 5;
        private static final int GRAPHIC_ESCAPE = 8;
        private static final int SHIFT_IN = 15;
        private static final int SHIFT_OUT = 14;
        private static final int EBCDIC_SPACE = 64;
        private static final int PRINT_AND_SKIP_TO_CHANNEL_1 = 137;
        private static final int SKIP_TO_CHANNEL_1 = 139;
        private boolean lineBoundary;
        InputStream in;

        EBCDICFilterInputStream(InputStream in) {
            super(in);
            this.lineBoundary = true;
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            return this.convert(this.in.read());
        }

        @Override
        public int read(byte[] b) throws IOException {
            return b == null ? 0 : this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n > 0) {
                int i = off;
                while (i < off + n) {
                    b[i] = (byte)this.convert(b[i] & 0xFF);
                    ++i;
                }
            }
            return n;
        }

        private int convert(int c) {
            if (this.lineBoundary && (c == 137 || c == 139)) {
                this.lineBoundary = false;
                return 64;
            }
            this.lineBoundary = c == 21 || c == 37;
            return c >= 64 || c == 14 || c == 15 || c == 8 || c == 5 || c == 21 || c == 13 || c == 37 ? c : 64;
        }
    }
}

