/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.tasks.zos;

import com.ibm.team.enterprise.build.client.promotion.IPromotionClient;
import com.ibm.teamz.build.ant.internal.utils.ZOS;
import com.ibm.teamz.build.ant.tasks.zos.AbstractRTCzTeamBuildTask;
import java.io.File;
import java.util.List;

public class DeleteTemporaryBuildMaps
extends AbstractRTCzTeamBuildTask {
    String PROPERTY_PROMOTION_INFO = "team.enterprise.promotionInfo";
    private static final String UTF_8 = "UTF-8";

    protected void collectAntAttributes(List arg0) {
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute() throws Exception {
        int connectionTimeoutOverride;
        boolean doNotCreateNewThread = Boolean.parseBoolean(this.getProject().getProperty("team.enterprise.promotion.finalizePromotedBuildMaps.doNotCreateNewThread"));
        int previousConnectionTimeout = -1;
        if (doNotCreateNewThread && (connectionTimeoutOverride = this.retrieveConnectionTimeoutOverride()) > -1) {
            previousConnectionTimeout = this.getTeamRepository().getConnectionTimeout();
            this.getTeamRepository().setConnectionTimeout(connectionTimeoutOverride);
        }
        this.log("Options:", 3);
        this.log("  Donot create new thread=" + doNotCreateNewThread, 3);
        this.log("  Repository connection timeout=" + this.getTeamRepository().getConnectionTimeout(), 3);
        String promotionFile = this.getProject().getProperty(this.PROPERTY_PROMOTION_INFO);
        File f = new File(promotionFile);
        IPromotionClient promotionClient = (IPromotionClient)this.getTeamRepository().getClientLibrary(IPromotionClient.class);
        String content = ZOS.fileToString(f, UTF_8);
        try {
            block12: {
                String requestId;
                int count;
                int maxLoop;
                int result;
                block11: {
                    if (doNotCreateNewThread) {
                        promotionClient.deleteTemporaryBuildMaps(content, null);
                        return;
                    }
                    result = -1;
                    maxLoop = this.parseInt(this.getProject().getProperty("team.enterprise.promotion.finalizePromotedBuildMaps.maxDelay")) / 5;
                    if (maxLoop <= 0) {
                        maxLoop = Integer.MAX_VALUE;
                    }
                    count = 0;
                    requestId = promotionClient.deleteTemporaryBuildMaps2(content, null);
                    if (!true) break block11;
                    if (result != -1) return;
                    if (count++ >= maxLoop) break block12;
                }
                do {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    result = promotionClient.getDeletingTemporaryBuildMapsStatus(requestId);
                    if (result != -1) return;
                } while (count++ < maxLoop);
            }
            return;
        }
        finally {
            if (doNotCreateNewThread && previousConnectionTimeout > -1) {
                this.getTeamRepository().setConnectionTimeout(previousConnectionTimeout);
            }
        }
    }

    private int parseInt(String aString) {
        try {
            if (aString != null) {
                return Integer.parseInt(aString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }
}

