/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.tasks.zos;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.internal.utils.MacroExec;
import com.ibm.teamz.build.ant.internal.utils.ZOS;
import com.ibm.teamz.build.ant.tasks.zos.AbstractRTCzTeamBuildTask;
import com.ibm.teamz.build.ant.types.resources.BuildableResource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.eclipse.osgi.util.NLS;

public class Compile
extends AbstractRTCzTeamBuildTask {
    public static final String COMPILE_ERROR_OCCURRED = ".compileErrorOccurred";
    private ResourceCollection resourceCollection;
    private Exception exception = null;
    private String buildResultUUID;
    private int total = 0;
    private int updated = 0;
    private final int uptodate = 0;
    private int failed = 0;

    protected void collectAntAttributes(List arg0) {
    }

    protected void doExecute() throws Exception {
        this.log(Messages.COMPILE_TASK_STARTED, 3);
        boolean isPersonalBuild = Boolean.valueOf(this.getProject().getProperty(IBuildResult.PROPERTY_PERSONAL_BUILD));
        ArrayList<BuildableResource> buildables = new ArrayList<BuildableResource>();
        if (this.resourceCollection != null) {
            this.total = this.resourceCollection.size();
        }
        for (Resource res : this.resourceCollection) {
            if (!(res instanceof BuildableResource)) continue;
            buildables.add((BuildableResource)res);
        }
        for (BuildableResource res : buildables) {
            String dsn;
            String buildableResourceName = res.getName();
            if (buildableResourceName == null) {
                buildableResourceName = Messages.INSTREAM_SOURCE;
            }
            this.log(NLS.bind((String)Messages.PROCESSING_BUILDABLE_FILE, (Object)buildableResourceName), 3);
            if (isPersonalBuild && !ZOS.datasetExists((ProjectComponent)this, dsn = String.valueOf(res.getDatasetName()) + "(" + res.getMemberName() + ")")) {
                this.log(NLS.bind((String)Messages.DATA_SET_NOT_FOUND_FOR_PERSONAL_BUILD, (Object)dsn), 3);
                continue;
            }
            MacroExec job = new MacroExec((Task)this, res);
            job = job.call();
            String langDefName = job.getLangDefName();
            Exception ex = job.getException();
            if (ex != null) {
                if (this.exception == null) {
                    this.exception = ex;
                    if (!this.shouldFailOnError()) {
                        File compileErrorOccurredFile = new File(String.valueOf(BuildableResource.getTmpDir(this.getProject())) + File.separator + COMPILE_ERROR_OCCURRED);
                        compileErrorOccurredFile.createNewFile();
                    }
                }
                ++this.failed;
                this.log(NLS.bind((String)Messages.JOB_FAILED, (Object[])new Object[]{langDefName, buildableResourceName, ex.getClass().getSimpleName(), ex.getMessage()}), 0);
                continue;
            }
            ++this.updated;
            this.log(NLS.bind((String)Messages.JOB_UPDATED, (Object)langDefName, (Object)buildableResourceName));
        }
        this.log(NLS.bind((String)Messages.BUILD_SUMMARY, (Object[])new Object[]{this.total, this.updated, 0, this.failed}));
        if (this.exception != null && this.shouldFailOnError()) {
            throw new BuildException(Messages.EXCEPTIONS_DURING_PROCESSING, (Throwable)this.exception);
        }
    }

    protected void configureTaskAttributes() {
        String s;
        if (this.getUserId() == null && !this.isKerberos() && (s = System.getenv("JAZZ_USER")) != null) {
            this.setUserId(s);
        }
        if (this.getPasswordFile() == null && !this.isKerberos() && (s = System.getenv("JAZZ_PASSWORD_FILE")) != null) {
            this.setPasswordFile(new File(s));
        }
        if (this.getRepositoryAddress() == null && (s = this.getProject().getProperty("repositoryAddress")) != null) {
            this.setRepositoryAddress(s);
        }
        if (this.getBuildResultUUID() == null && (s = this.getProject().getProperty("buildResultUUID")) != null) {
            this.setBuildResultUUID(s);
        }
    }

    public String getBuildResultUUID() {
        return this.buildResultUUID;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public void add(ResourceCollection resourceCollection) {
        this.resourceCollection = resourceCollection;
    }

    public ResourceCollection getResourceCollection() {
        return this.resourceCollection;
    }
}

