/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.tasks.zos;

import com.ibm.team.enterprise.build.common.promotion.IPromotableFile;
import com.ibm.team.enterprise.build.common.promotion.IPromotableResource;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfoUtil;
import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.jni.ISPFStatistics;
import com.ibm.teamz.build.ant.tasks.zos.AbstractCheckAccess;
import com.ibm.teamz.build.ant.tasks.zos.MyFrameworkLog;
import com.ibm.teamz.build.ant.zos.exceptions.UndefinedRecordFormatException;
import com.ibm.teamz.build.ant.zos.utils.CheckAccessUtil;
import com.ibm.teamz.build.ant.zos.utils.SSISupport;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;

public class CheckOutputsForPromotion
extends AbstractCheckAccess {
    public static final String CONTAINER_TYPE_SEQUENTIAL = "Sequentials";
    private boolean skipTimestampCheck = false;
    private File srcDir;
    private File targetDir;

    static {
        try {
            Field frameworkLogField = NLS.class.getDeclaredField("frameworkLog");
            frameworkLogField.setAccessible(true);
            frameworkLogField.set(null, new MyFrameworkLog());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSkipTimestampCheck() {
        return this.skipTimestampCheck;
    }

    public void setSkipTimestampCheck(boolean skipTimestampCheck) {
        this.skipTimestampCheck = skipTimestampCheck;
    }

    public void execute() throws BuildException {
        this.checkAntDebugOption();
        File manifestFile = this.validateManifest();
        try {
            this.readManifestFile(manifestFile);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        if (!this.isSkipAccessCheck()) {
            this.executeNativeCode();
        }
    }

    private void readManifestFile(File f) throws TransformerFactoryConfigurationError, Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(f);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        DOMSource source = new DOMSource(document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(source, result);
        String xmlString = outputStream.toString("UTF-8");
        PromotionInfo pi = PromotionInfoUtil.parsePromotionInfo((String)xmlString);
        Map map = pi.getPromotableResources();
        ArrayList<String> hfsFiles = new ArrayList<String>();
        Set keys = map.keySet();
        for (String key : keys) {
            List files;
            IPromotableResource res = (IPromotableResource)map.get(key);
            String sourceRes = res.getSourceResource();
            String targetRes = res.getTargetResource();
            this.log("source: " + sourceRes, 4);
            this.log("target: " + targetRes, 4);
            Boolean isSequential = false;
            int numHFSPromotableFiles = 0;
            for (IPromotableFile promotableFile : res.getFiles()) {
                if (promotableFile.getType().equalsIgnoreCase("sequential")) {
                    isSequential = true;
                    String member = promotableFile.getName();
                    if (member != null && member.length() > 0) {
                        this.getInputs().add(String.valueOf(sourceRes) + "." + member);
                        this.getOutputs().add(String.valueOf(targetRes) + "." + member);
                        continue;
                    }
                    this.getInputs().add(sourceRes);
                    this.getOutputs().add(targetRes);
                    continue;
                }
                if (!"file".equalsIgnoreCase(promotableFile.getType())) continue;
                ++numHFSPromotableFiles;
                StringBuilder relativePath = new StringBuilder(100);
                relativePath.append(sourceRes);
                if (!sourceRes.isEmpty() && !sourceRes.endsWith(File.separator)) {
                    relativePath.append(File.separator);
                }
                relativePath.append(promotableFile.getName());
                if (promotableFile.getName().equals("**")) {
                    String[] resolvedFiles;
                    if (!sourceRes.isEmpty()) {
                        hfsFiles.add(sourceRes);
                    }
                    FileSet hfsFileSet = new FileSet();
                    hfsFileSet.setDir(this.getSrcDir());
                    hfsFileSet.setProject(this.getProject());
                    hfsFileSet.createInclude().setName(relativePath.toString());
                    String[] stringArray = resolvedFiles = hfsFileSet.getDirectoryScanner().getIncludedFiles();
                    int n = resolvedFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String relativeFile = stringArray[n2];
                        hfsFiles.add(relativeFile);
                        ++n2;
                    }
                    continue;
                }
                hfsFiles.add(relativePath.toString());
            }
            if (!isSequential.booleanValue() && numHFSPromotableFiles < res.getFiles().size()) {
                this.getInputs().add(sourceRes);
                this.getOutputs().add(targetRes);
            }
            if (this.isSkipTimestampCheck() || (files = res.getFiles()) == null) continue;
            String srcDirString = null;
            for (IPromotableFile file : files) {
                String memberName = file.getName();
                String type = file.getType();
                if ("file".equalsIgnoreCase(type)) {
                    long timestamp;
                    if (srcDirString == null) {
                        srcDirString = this.getSrcDir().getAbsolutePath();
                    }
                    StringBuilder fullName = new StringBuilder();
                    fullName.append(sourceRes);
                    if (!"**".equals(memberName)) {
                        if (fullName.length() > 0 && fullName.charAt(fullName.length() - 1) != File.separatorChar) {
                            fullName.append(File.separatorChar);
                        }
                        fullName.append(memberName);
                    }
                    if ((timestamp = file.getTimestamp()) != 0L) {
                        long actualTimestamp = CheckAccessUtil.lastModifiedHFS((File)new File(srcDirString, fullName.toString()));
                        this.log(fullName + ": timestamp(manifest)=" + timestamp + " timestamp(ISPF Stats/SSI)=" + actualTimestamp, 4);
                        if (timestamp == actualTimestamp) continue;
                        String errorMessage = NLS.bind((String)Messages.TIMESTAMPS_DO_NOT_MATCH_HFS, (Object[])new String[]{fullName.toString(), Long.toString(timestamp), Long.toString(actualTimestamp)});
                        String additionalDetails = this.getAdditionalErrorDetail(files, file, res);
                        if (additionalDetails != null) {
                            errorMessage = String.valueOf(errorMessage) + "   " + additionalDetails;
                        }
                        throw new BuildException(errorMessage);
                    }
                    throw new BuildException(NLS.bind((String)Messages.TIMESTAMP_NOT_FOUND_IN_MANIFEST, (Object)fullName.toString()));
                }
                if (type.equalsIgnoreCase("sequential")) continue;
                String fullDsName = String.valueOf(sourceRes) + "(" + memberName + ")";
                long timestamp = file.getTimestamp();
                if (timestamp != 0L) {
                    long statsTimestamp = 0L;
                    ISPFStatistics stats = null;
                    try {
                        stats = new ISPFStatistics(sourceRes, memberName);
                        statsTimestamp = stats.getModificationDate().getTime();
                    }
                    catch (UndefinedRecordFormatException ure) {
                        SSISupport ssi = new SSISupport(sourceRes, memberName);
                        statsTimestamp = ssi.getTimestamp();
                        if (statsTimestamp == 0L) {
                            this.log(NLS.bind((String)Messages.SSI_NOT_FOUND, (Object)fullDsName), 2);
                        }
                    }
                    catch (Exception ure) {
                        // empty catch block
                    }
                    if (statsTimestamp == 0L) {
                        throw new BuildException(NLS.bind((String)Messages.TIMESTAMP_NOT_FOUND_IN_ISPF_STATS_OR_SSI, (Object)fullDsName));
                    }
                    this.log(String.valueOf(fullDsName) + ": timestamp(manifest)=" + timestamp + " timestamp(ISPF Stats/SSI)=" + statsTimestamp, 4);
                    if (statsTimestamp / 1000L == timestamp / 1000L) continue;
                    String errorMessage = NLS.bind((String)Messages.TIMESTAMPS_DO_NOT_MATCH, (Object[])new String[]{fullDsName, Long.toString(timestamp), Long.toString(statsTimestamp)});
                    String additionalDetails = this.getAdditionalErrorDetail(files, file, res);
                    if (additionalDetails != null) {
                        errorMessage = String.valueOf(errorMessage) + "   " + additionalDetails;
                    }
                    throw new BuildException(errorMessage);
                }
                throw new BuildException(NLS.bind((String)Messages.TIMESTAMP_NOT_FOUND_IN_MANIFEST, (Object)fullDsName));
            }
        }
        if (!hfsFiles.isEmpty()) {
            String srcDirString = this.getSrcDir().getAbsolutePath();
            String targetDirString = this.getTargetDir().getAbsolutePath();
            if (!srcDirString.endsWith(File.separator)) {
                srcDirString = String.valueOf(srcDirString) + File.separator;
            }
            if (!targetDirString.endsWith(File.separator)) {
                targetDirString = String.valueOf(targetDirString) + File.separator;
            }
            for (String relativeFile : hfsFiles) {
                this.log("Adding " + relativeFile + " to HFS outputs list", 4);
                this.getHFSInputs().add(String.valueOf(srcDirString) + relativeFile);
                this.getHFSOutputs().add(String.valueOf(targetDirString) + relativeFile);
            }
        }
    }

    private File getSrcDir() {
        if (this.srcDir == null) {
            String srcDirString = this.getProject().getProperty("team.enterprise.promotion.hfs.outputdir.source");
            if (srcDirString == null) {
                throw new BuildException(Messages.PromoteHFSFilesTask_SOURCE_DIR_NOT_SPECIFIED);
            }
            this.srcDir = new File(srcDirString);
            if (!this.srcDir.exists()) {
                throw new BuildException(NLS.bind((String)Messages.PromoteHFSFilesTask_DIR_DOES_NOT_EXIST, (Object)srcDirString));
            }
        }
        return this.srcDir;
    }

    private File getTargetDir() {
        if (this.targetDir == null) {
            String targetDirString = this.getProject().getProperty("team.enterprise.promotion.hfs.outputdir.target");
            if (targetDirString == null) {
                throw new BuildException(Messages.PromoteHFSFilesTask_TARGET_DIR_NOT_SPECIFIED);
            }
            this.targetDir = new File(targetDirString);
        }
        return this.targetDir;
    }

    private String getAdditionalErrorDetail(List<IPromotableFile> files, IPromotableFile aFile, IPromotableResource resource) {
        if (files.size() < 2 || aFile == null || aFile.getName() == null || aFile.getName().isEmpty()) {
            return null;
        }
        ArrayList<IPromotableFile> conflictFiles = new ArrayList<IPromotableFile>(3);
        for (IPromotableFile file : files) {
            if (!aFile.getName().equals(file.getName())) continue;
            conflictFiles.add(file);
        }
        if (conflictFiles.size() < 2) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Iterator iterator = conflictFiles.iterator();
        while (iterator.hasNext()) {
            buffer.append(((IPromotableFile)iterator.next()).getScmLocation());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return NLS.bind((String)Messages.ERROR_PROMOTION_DUPLICATE_OUTPUT, (Object[])new String[]{buffer.toString(), aFile.getName(), resource.getSourceResource()});
    }
}

