/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.tasks.zos;

import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.tasks.zos.AbstractCheckAccess;
import com.ibm.teamz.build.ant.tasks.zos.MyFrameworkLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CheckAccessForDeployment
extends AbstractCheckAccess {
    private static final String MANIFEST_TAG = "manifest";
    private static final String CONTAINER_TAG = "container";
    private static final String DELETED_TAG = "deleted";
    private static final String RESOURCE_TAG = "resource";
    private static final String NAME_ATTR = "name";
    private static final String TYPE_ATTR = "type";
    private static final String PDS_TYPE = "PDS";
    private static final String DIRECTORY_TYPE = "directory";
    private static final String MAPS_TAG = "maps";
    private static final String MAP_TAG = "map";
    private static final String SOURCE_CONTAINER_TAG = "sourceContainer";
    private static final String TARGET_CONTAINER_TAG = "targetContainer";
    private static final String DEPLOY_DEF_VERION_PROPERTY = "team.deploy.common.definition.version";
    private File mappingFile = null;
    private File targetDir;

    static {
        try {
            Field frameworkLogField = NLS.class.getDeclaredField("frameworkLog");
            frameworkLogField.setAccessible(true);
            frameworkLogField.set(null, new MyFrameworkLog());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(String mappingFilePath) {
        if (mappingFilePath != null && mappingFilePath.trim().length() > 0) {
            this.mappingFile = new File(mappingFilePath);
        }
    }

    protected File validateMappingFile() {
        if (this.mappingFile != null && !this.mappingFile.canRead()) {
            throw new BuildException(NLS.bind((String)Messages.CANNOT_READ_FILE, (Object)this.mappingFile));
        }
        return this.mappingFile;
    }

    public void execute() throws BuildException {
        this.checkAntDebugOption();
        if (!this.isSkipAccessCheck() && this.getProject().getProperty(DEPLOY_DEF_VERION_PROPERTY) != null && this.getProject().getProperty(DEPLOY_DEF_VERION_PROPERTY).compareTo("3.0.0") > 0) {
            File manifestFile = this.validateManifest();
            File mappingFile = this.validateMappingFile();
            try {
                this.readManifestFile(manifestFile, mappingFile);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            this.executeNativeCode();
        }
    }

    private void readManifestFile(File manifestFile, File mappingFile) throws TransformerFactoryConfigurationError, Exception {
        Map<String, List<String>> containerNames = this.getPDSContainersAndHFSFiles(manifestFile);
        Properties containerMappingProperties = this.getContainerMappingProperties(mappingFile);
        this.log("Mapping continer names...", 4);
        for (String containerName : containerNames.get(PDS_TYPE)) {
            String mappedContainerName = containerMappingProperties.getProperty(containerName);
            if (mappedContainerName == null) {
                mappedContainerName = containerName;
                this.log("Mapping was not found for " + containerName, 4);
            } else {
                this.log("Mapped " + containerName + " to " + mappedContainerName, 4);
            }
            this.getOutputs().add(mappedContainerName);
        }
        List<String> hfsFiles = containerNames.get(DIRECTORY_TYPE);
        if (hfsFiles != null && !hfsFiles.isEmpty()) {
            String targetDirString = this.getTargetDir().getAbsolutePath();
            if (!targetDirString.endsWith(File.separator)) {
                targetDirString = String.valueOf(targetDirString) + File.separator;
            }
            for (String hfsFile : hfsFiles) {
                this.log("Adding HFS file " + hfsFile, 4);
                this.getHFSOutputs().add(String.valueOf(targetDirString) + hfsFile);
            }
        }
        this.log("Done.", 4);
    }

    private File getTargetDir() {
        if (this.targetDir == null) {
            String targetDirString = this.getProject().getProperty("team.enterprise.deployment.hfs.runtimeRoot.dir");
            if (targetDirString == null || targetDirString.isEmpty()) {
                throw new BuildException(Messages.PromoteHFSFilesTask_TARGET_DIR_NOT_SPECIFIED);
            }
            this.targetDir = new File(targetDirString);
        }
        return this.targetDir;
    }

    private Map<String, List<String>> getPDSContainersAndHFSFiles(File f) throws SAXException, IOException, ParserConfigurationException {
        this.log("Parsing the packaging manifest file: " + f.getCanonicalPath(), 4);
        Document document = this.parseXMLFile(f);
        NodeList manifestElements = document.getElementsByTagName(MANIFEST_TAG);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> pdsContainerNames = new ArrayList<String>();
        ArrayList<String> hfsFiles = new ArrayList<String>();
        if (manifestElements != null && manifestElements.getLength() > 0) {
            Element manifestElement = (Element)manifestElements.item(0);
            NodeList containerElements = manifestElement.getElementsByTagName(CONTAINER_TAG);
            this.processContainers(containerElements, pdsContainerNames, hfsFiles);
            NodeList deletedElements = manifestElement.getElementsByTagName(DELETED_TAG);
            if (deletedElements != null) {
                int i = 0;
                while (i < deletedElements.getLength()) {
                    Element deletedElement = (Element)deletedElements.item(i);
                    NodeList deletedContainerElements = deletedElement.getElementsByTagName(CONTAINER_TAG);
                    this.processContainers(deletedContainerElements, pdsContainerNames, hfsFiles);
                    ++i;
                }
            }
        }
        map.put(PDS_TYPE, pdsContainerNames);
        map.put(DIRECTORY_TYPE, hfsFiles);
        this.log("Done.", 4);
        return map;
    }

    private void processContainers(NodeList containerElements, List<String> pdsContainerNames, List<String> hfsFiles) {
        if (containerElements != null) {
            int len = containerElements.getLength();
            int i = 0;
            while (i < len) {
                Element containerElement = (Element)containerElements.item(i);
                String type = containerElement.getAttribute(TYPE_ATTR);
                if (PDS_TYPE.equals(type)) {
                    String name = containerElement.getAttribute(NAME_ATTR);
                    pdsContainerNames.add(name);
                    this.log("Found a container name: " + name, 4);
                } else if (DIRECTORY_TYPE.equals(type)) {
                    String containerName = containerElement.getAttribute(NAME_ATTR);
                    this.log("Found an HFS container name: " + containerName, 4);
                    NodeList resources = containerElement.getElementsByTagName(RESOURCE_TAG);
                    if (resources != null && resources.getLength() > 0) {
                        if (!containerName.endsWith(File.separator)) {
                            containerName = String.valueOf(containerName) + File.separator;
                        }
                        int j = 0;
                        while (j < resources.getLength()) {
                            Element resourceElement = (Element)resources.item(j);
                            String resourceName = resourceElement.getAttribute(NAME_ATTR);
                            hfsFiles.add(String.valueOf(containerName) + resourceName);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private Properties getContainerMappingProperties(File f) throws SAXException, IOException, ParserConfigurationException {
        Properties containerMappingProperties = new Properties();
        if (f != null) {
            Element mapsElement;
            NodeList mapElements;
            this.log("Parsing the container mapping file: " + f.getCanonicalPath(), 4);
            Document document = this.parseXMLFile(f);
            NodeList mapsElements = document.getElementsByTagName(MAPS_TAG);
            if (mapsElements != null && mapsElements.getLength() > 0 && (mapElements = (mapsElement = (Element)mapsElements.item(0)).getElementsByTagName(MAP_TAG)) != null) {
                int len = mapElements.getLength();
                int i = 0;
                while (i < len) {
                    Element mapElement = (Element)mapElements.item(i);
                    String type = mapElement.getAttribute(TYPE_ATTR);
                    if (PDS_TYPE.equals(type)) {
                        NodeList sourceContainers = mapElement.getElementsByTagName(SOURCE_CONTAINER_TAG);
                        NodeList targetContainers = mapElement.getElementsByTagName(TARGET_CONTAINER_TAG);
                        if (sourceContainers != null && sourceContainers.getLength() > 0 && targetContainers != null && targetContainers.getLength() > 0) {
                            Element sourceContainer = (Element)sourceContainers.item(0);
                            Element targetContainer = (Element)targetContainers.item(0);
                            String sourceContainerName = sourceContainer.getAttribute(NAME_ATTR);
                            String targetContainerName = targetContainer.getAttribute(NAME_ATTR);
                            containerMappingProperties.setProperty(sourceContainerName, targetContainerName);
                            this.log("Found a container mapping: " + sourceContainerName + " ==> " + targetContainerName, 4);
                        }
                    }
                    ++i;
                }
            }
        }
        this.log("Done.", 4);
        return containerMappingProperties;
    }

    private Document parseXMLFile(File f) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        FileInputStream inputStream = new FileInputStream(f);
        InputStreamReader reader = new InputStreamReader(inputStream);
        InputSource is = new InputSource(reader);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(is);
        return document;
    }
}

