/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.tasks.zos;

import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.internal.utils.TaskLog;
import com.ibm.teamz.build.ant.tasks.zos.AbstractRTCzTask;
import com.ibm.teamz.build.ant.zos.utils.CheckAccessUtil;
import com.ibm.teamz.build.ant.zos.utils.ILoggingInterface;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractCheckAccess
extends AbstractRTCzTask {
    private static final String DEBUG_OPTION_STRING = " -debug ";
    private static final String ENV_IBM_JAVA_COMMAND_LINE = "env.IBM_JAVA_COMMAND_LINE";
    protected static final int DEFAULT_BUFFER_SIZE = 4096;
    protected static final String UTF_8 = "UTF-8";
    protected static final String CHECK_ACCESS = "checkaccess";
    protected static final String BLD_TOOLKIT = "BLD_TOOLKIT";
    private File manifest;
    private boolean debug;
    private final Set<String> inputs = new HashSet<String>();
    private final Set<String> outputs = new HashSet<String>();
    private final Set<String> hfsInputs = new HashSet<String>();
    private final Set<String> hfsOutputs = new HashSet<String>();

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public File getManifest() {
        return this.manifest;
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public Set<String> getInputs() {
        return this.inputs;
    }

    public Set<String> getOutputs() {
        return this.outputs;
    }

    public Set<String> getHFSInputs() {
        return this.hfsInputs;
    }

    public Set<String> getHFSOutputs() {
        return this.hfsOutputs;
    }

    protected boolean isSkipAccessCheck() {
        boolean b = Boolean.valueOf(this.getProject().getProperty("team.automation.zos.skipAccessCheck"));
        if (b) {
            this.log(Messages.SKIP_ACCESS_CHECK, 2);
        }
        return b;
    }

    protected File validateManifest() {
        if (this.getManifest() == null) {
            throw new BuildException(Messages.MANIFEST_NOT_SPECIFIED);
        }
        if (!this.getManifest().canRead()) {
            throw new BuildException(NLS.bind((String)Messages.CANNOT_READ_FILE, (Object)this.getManifest()));
        }
        return this.getManifest();
    }

    protected void executeNativeCode() {
        File listFile = null;
        try {
            try {
                listFile = File.createTempFile("datasets", ".list");
                CheckAccessUtil.generateDataSetList(this.getInputs(), this.getOutputs(), (File)listFile, (ILoggingInterface)new TaskLog(this));
                this.executeCheckAccess(listFile);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            if (listFile != null) {
                listFile.delete();
            }
        }
        this.checkHFSFiles();
    }

    protected void checkHFSFiles() {
        for (String input : this.getHFSInputs()) {
            if (CheckAccessUtil.canReadHFS((String)input)) continue;
            throw new BuildException(NLS.bind((String)Messages.HFS_FILE_NOT_READABLE, (Object)input));
        }
        for (String output : this.getHFSOutputs()) {
            if (CheckAccessUtil.canWriteHFS((String)output)) continue;
            throw new BuildException(NLS.bind((String)Messages.HFS_FILE_NOT_WRITEABLE, (Object)output));
        }
    }

    protected void checkAntDebugOption() {
        String cmdline = this.getProject().getProperty(ENV_IBM_JAVA_COMMAND_LINE);
        if (cmdline != null && cmdline.contains(DEBUG_OPTION_STRING)) {
            this.setDebug(true);
        }
    }

    private void executeCheckAccess(File listFile) throws IOException {
        ExecTask execTask = new ExecTask((Task)this);
        execTask.setFailonerror(true);
        String buildToolkitDirectory = System.getenv(BLD_TOOLKIT);
        if (buildToolkitDirectory == null) {
            buildToolkitDirectory = "";
        }
        String executable = String.valueOf(buildToolkitDirectory) + File.separator + CHECK_ACCESS;
        execTask.setExecutable(executable);
        Commandline.Argument arg = execTask.createArg();
        String line = "";
        if (this.isDebug()) {
            line = String.valueOf(line) + "-d ";
        }
        line = String.valueOf(line) + listFile.getCanonicalPath();
        arg.setLine(line);
        execTask.execute();
    }
}

