/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.internal.utils;

import com.ibm.jzos.FileFactory;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.teamz.build.ant.internal.messages.Messages;
import com.ibm.teamz.build.ant.zos.exceptions.ZosException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class ZOS {
    private static final String SPACE = " ";
    private static final String READ_ONLY = "r";
    private static final String TWO_AMPERSANDS = "&&";
    private static final String TWO_SLASHES = "//";
    private static final String APOSTROPHE = "'";
    private static final String COLON_WITH_SPACES = " : ";
    private static final String FREE = "free";
    private static final boolean LOG_ENABLED = true;

    public static void bpxwdyn(ProjectComponent projectComponent, String cmd) throws RcException {
        String command = cmd;
        String options = projectComponent.getProject().getProperty("teamz.build.ant.bpxwdyn.options");
        if (options != null) {
            command = String.valueOf(command) + SPACE + options;
        }
        ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_BPXWDYN, (Object)command), 3);
        try {
            ZFile.bpxwdyn((String)command);
        }
        catch (RcException e) {
            int rc = e.getRc();
            if (rc != 70778880 || !command.toLowerCase().trim().startsWith(FREE)) {
                ZOS.log(projectComponent, NLS.bind((String)Messages.ERROR_IN_BPXWDYN, (Object)command), 0);
                ZOS.logException(projectComponent, Messages.ZOS_RCEXCEPTION_THROWN, e);
            }
            throw e;
        }
    }

    public static void free(Task task, String ddname) throws ZFileException, RcException {
        if (ZOS.ddExists((ProjectComponent)task, ddname)) {
            ZOS.bpxwdyn((ProjectComponent)task, "free dd(" + ddname + ")");
        }
    }

    private static boolean ddExists(ProjectComponent projectComponent, String dd) throws ZFileException {
        boolean b = ZFile.ddExists((String)dd);
        ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_DD_EXISTS, (Object)dd, (Object)b), 4);
        return b;
    }

    private static String buildSingleQuotedDsName(String dsname) {
        if (dsname == null || dsname.startsWith(TWO_AMPERSANDS)) {
            return dsname;
        }
        return APOSTROPHE + dsname + APOSTROPHE;
    }

    public static boolean datasetExists(ProjectComponent projectComponent, String dsname) throws ZosException {
        boolean isExist = false;
        String singleQuotedDsName = ZOS.buildSingleQuotedDsName(dsname);
        try {
            ZFile f = null;
            try {
                try {
                    f = new ZFile(TWO_SLASHES + singleQuotedDsName, READ_ONLY);
                    isExist = true;
                }
                catch (ZFileException e1) {
                    ZOS.log(projectComponent, e1.getMessage(), 4);
                    ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_DS_EXISTS, (Object)singleQuotedDsName, (Object)isExist), 4);
                    if (f != null) {
                        f.close();
                    }
                }
            }
            finally {
                ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_DS_EXISTS, (Object)singleQuotedDsName, (Object)isExist), 4);
                if (f != null) {
                    f.close();
                }
            }
        }
        catch (ZFileException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
            throw new ZosException((Throwable)e);
        }
        return isExist;
    }

    public static boolean ddnameExists(ProjectComponent projectComponent, String ddname) throws ZosException {
        try {
            return ZOS.ddExists(projectComponent, ddname);
        }
        catch (ZFileException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
            throw new ZosException((Throwable)e);
        }
    }

    public static OutputStream getOutputStream(String dsname) throws IOException {
        return FileFactory.newBufferedOutputStream((String)(TWO_SLASHES + ZOS.buildSingleQuotedDsName(dsname)));
    }

    public static void removeDataset(ProjectComponent projectComponent, String dsname) throws ZosException {
        try {
            ZFile.remove((String)(TWO_SLASHES + ZOS.buildSingleQuotedDsName(dsname)));
        }
        catch (ZFileException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
            throw new ZosException((Throwable)e);
        }
    }

    public static ZFile saveLines(Task task, String dsname, List<String> lines) throws Exception {
        String output = TWO_SLASHES + ZOS.buildSingleQuotedDsName(dsname);
        ZFile zFileOut = new ZFile(output, "wb,type=record,recfm=fb,lrecl=80,noseek");
        int lrecl = zFileOut.getLrecl();
        byte[] recBuf = new byte[lrecl];
        for (String line : lines) {
            byte[] b = line.getBytes(ZUtil.getDefaultPlatformEncoding());
            int len = b.length > lrecl ? lrecl : b.length;
            System.arraycopy(b, 0, recBuf, 0, len);
            int i = len;
            while (i < lrecl) {
                recBuf[i] = 64;
                ++i;
            }
            zFileOut.write(recBuf, 0, lrecl);
        }
        zFileOut.flush();
        if (!dsname.startsWith(TWO_AMPERSANDS)) {
            zFileOut.close();
        }
        return zFileOut;
    }

    public static void close(ZFile file) throws ZFileException {
        file.close();
    }

    public static void log(ProjectComponent projectComponent, String s, int msgLevel) {
        if (projectComponent != null) {
            projectComponent.log(s, msgLevel);
        } else {
            System.out.println(s);
        }
    }

    private static void logException(ProjectComponent projectComponent, String s, Throwable t) {
        if (projectComponent != null && projectComponent instanceof Task) {
            ((Task)projectComponent).log(s, t, 0);
        } else {
            System.out.println(String.valueOf(s) + COLON_WITH_SPACES + t);
        }
    }

    public static String fileToString(File file, String fileEncoding) throws IOException, IllegalArgumentException {
        StringBuffer fileContents = new StringBuffer();
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                fileContents.append(new String(buffer, 0, bytesRead, fileEncoding));
                bytesRead = inputStream.read(buffer);
            }
        }
        return fileContents.toString();
    }
}

